;---------------------------------------------------------------------------;
; macros from the original Microsoft code                                   ;
;---------------------------------------------------------------------------;

; Macro to convert from XMS success/fail to
; a form more acceptable for C.  IE.
;
; AX == 1 becomes DX:AX = 0
; AX != 1 becomes DX:AX = BL << 24 | (AX - 1)
;
; Since Error Codes returned in BL have the top bit
; set, C will interpret the return as negative.
;
SuccessFail macro
            local   Success
            xor     dx, dx
            dec     ax
            jz      Success
            mov     dh, bl
Success:
            endm

; Macro to convert from XMS return value in AX
; a form more acceptable for C.  IE.
;
; AX != 0 becomes DX:AX = AX
; AX == 0 becomes DX:AX = BL << 24 | AX
;
; Since Error Codes returned in BL have the top bit
; set, C will interpret the return as negative.
; XMS returns of this type return BL == 0 on success.
;
SuccessFailAX   macro
            local   Success
            xor     dx, dx
            or      ax, ax
            jnz     Success
            mov     dh, bl
Success:
            endm

; Macro to convert from XMS return value in DX
; a form more acceptable for C.  IE.
;
; AX != 0 becomes DX:AX = DX
; AX == 0 becomes DX:AX = BL << 24 | DX
;
; Since Error Codes returned in BL have the top bit
; set, C will interpret the return as negative.
; XMS returns of this type return BL == 0 on success.
;
SuccessFailDX   macro
            local   Success
            or      ax, ax
            mov     ax, dx
            mov     dx, 0                       ; Preserves Flags
            jnz     Success
            mov     dh, bl
Success:
            endm

