/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invB(int n)
{
fraction det;
int x;

double pbA    [MXR][MXC*TWOCOL];  matrix mA    = {MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbinvA [MXR][MXC*TWOCOL];  matrix minvA = {MXR,MXC*TWOCOL,&pbinvA[0][0]};
double pbu    [MXR][MXC*TWOCOL];  matrix mu    = {MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbTu   [MXR][MXC*TWOCOL];  matrix mTu   = {MXR,MXC*TWOCOL,&pbTu  [0][0]};
double pbinvTu  [MXR][MXC*TWOCOL];  matrix minvTu  = {MXR,MXC*TWOCOL,&pbinvTu [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                  minvA.rows=n;                minvA.cols=n*TWOCOL;
                     mu.rows=n;                   mu.cols=1*TWOCOL;
                    mTu.rows=n;                  mTu.cols=1*TWOCOL;
                   minvTu.rows=n;                 minvTu.cols=1*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   6;
 if(n<3){x = 100;}

  do
  {
               rndmI(&mA,x);
          det = detF(&mA);
  }while(!det.numer);

  rndmI(&mu,x);

  clrscrn();

  printf(" T :R**n->R**n      T(u) = Au\n");
  printf("                                                               A  :");
  printmI(&mA);
  printf("                                                               u  :");
  printmI(&mu);
  multmF(&mA,&mu,&mTu);
  printf("                                                        T(u) = Au :");
  printmI(&mTu);

  inverseF(&mA,&minvA);
  printf("                                                            invA  :");
  printmF(&minvA);
  multmF( &minvA,&mTu,&minvTu);
  printf("                                          invT(u) = invA T(u) = u :");
  printmI(            &minvTu);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n      T(u) is the multiplication by             \n");
  printf("\n         an invertible  matrix A :              \n");
  printf("\n        invT(T(v)) = invT(w) = v                \n");
  printf("\n        ************************                \n");
  printf("\n The size of mA : 1x1 ... 3x3.                  \n");
  printf("\n           ex : \"inv.exe\"                     \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"inv.exe 2\" -> mA 2x2           ");
  printf("\n                \"inv.exe 3\" -> mA 3x3           ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 3){n=3;}}
else
 {  n = rndpI(3);}
if( n < 1){n=1;}


  invB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



