/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction InnerProduct_uplsv_w;
fraction InnerProduct_uw;
fraction InnerProduct_vw;
fraction InnerProduct_uwplsvw;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};
double pbw    [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbw    [0][0]};
double pbuplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&pbuplsv[0][0]};

if     (vectrow)
  {
           mu.rows = 1;           mu.cols = n*TWOCOL;
           mv.rows = 1;           mv.cols = n*TWOCOL;
           mw.rows = 1;           mw.cols = n*TWOCOL;
       muplsv.rows = 1;       muplsv.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
           mu.rows = n;           mu.cols = 1*TWOCOL;
           mv.rows = n;           mv.cols = 1*TWOCOL;
           mw.rows = n;           mw.cols = 1*TWOCOL;
       muplsv.rows = n;       muplsv.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmI(&mu,5);
  rndmI(&mv,5);
  rndmI(&mw,5);

  clrscrn();
  printf("                                 u");
  printmI4(&mu);
  printf("                                 v");
  printmI4(&mv);
  printf("                                 w");
  printmI4(&mw);
  getchar();

  clrscrn();
  printf("                                 u");
  printmI4(&mu);
  printf("                                 v");
  printmI4(&mv);

  printf("\n\n                             u + v");
  addmF(&mu,&mv,&muplsv);
  printmI4(     &muplsv);

  InnerProduct_uplsv_w = innerprod(&muplsv,&mw);
  printf("\n\n (u + v).w =  %6.0lf\n\n",
            InnerProduct_uplsv_w.numer);
  getchar();

  clrscrn();
  InnerProduct_uw = innerprod(&mu,&mw);
  printf("       u.w =  %6.0lf \n\n",
            InnerProduct_uw.numer);

  InnerProduct_vw = innerprod(&mv,&mw);
  printf("       v.w =  %6.0lf \n\n",
            InnerProduct_vw.numer);

  InnerProduct_uwplsvw = addF(InnerProduct_uw,InnerProduct_vw);
  printf(" u.w + v.w =  %6.0lf \n\n",
              InnerProduct_uwplsvw.numer);
  getchar();

  clrscrn();
  printf("\n  Properties of Euclidian inner product in R**n\n\n");
  printf("\n          (u + v).w  =  u.w + v.w              \n\n");
  printf(" (u + v).w =  %6.0lf \n\n",
            InnerProduct_uplsv_w.numer);

  printf(" u.w + v.w =  %6.0lf \n\n",
              InnerProduct_uwplsvw.numer);

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of Euclidian inner product in R**n   ");
  printf("\n                                                  ");
  printf("\n          (u + v).w  =  u.w + v.w                 ");
  printf("\n          ***********************                 ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"euinprdbCI.exe\"                    \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"euinprdbCI.exe 2\" -> 2x1             ");
  printf("\n          \"euinprdbCI.exe 4\" -> 4x1           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












