/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction Norm_u;
fraction Norm_v;
fraction Normu_Normv;
fraction InnerProduct;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};

if     (vectrow)
  {
   mu.rows = 1;           mu.cols = n*TWOCOL;
   mv.rows = 1;           mv.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
    mu.rows = n;           mu.cols = 1*TWOCOL;
    mv.rows = n;           mv.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmI(&mu,5);
  rndmI(&mv,5);

  clrscrn();
  printf("                                 u");
  printmI4(&mu);
  printf("                                 v");
  printmI4(&mv);

  Norm_u = normP2(&mu);                       /* It is the square of the norm.*/
  Norm_v = normP2(&mv);
  printf("\n\n\n         ||u|| = (%.0lf)**(1/2)\n",
            Norm_u.numer);

  printf("\n         ||v|| = (%.0lf)**(1/2)\n\n",
            Norm_v.numer);

  Normu_Normv = multF(Norm_u,Norm_v);
  printf("\n  ||u||  ||v|| = (%.0lf)**(1/2) \n\n",
            Normu_Normv.numer);
  getchar();


  clrscrn();
  InnerProduct = innerprod(&mu,&mv);
  printf("                  u.v =   %.0lf \n\n",
            InnerProduct.numer);

  printf("          ||u|| ||v|| =   (%.0lf)**(1/2) \n\n",
            Normu_Normv.numer);

  printf("\n\n         Cauchy-Schwarz inequality in R**n\n\n");
  printf("               |u.v|  =<  ||u|| ||v|| \n\n");

  printf("              |%.0lf|  =<  (%.0lf)**(1/2) \n\n",
            InnerProduct.numer,
             Normu_Normv.numer);

  printf("             |%.3lf|  =<  %.3lf \n\n",
            InnerProduct.numer,
        sqrt(Normu_Normv.numer));

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Cauchy-Schwarz inequality in R**n            ");
  printf("\n                                                  ");
  printf("\n          |u.v|  =<  ||u|| ||v||                   ");
  printf("\n          *********************                   ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 1x2 ... 1x4.                \n");
  printf("\n     ex : \"causchCI.exe\"                       \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"causchCI.exe 2\" -> 1x2                ");
  printf("\n          \"causchCI.exe 4\" -> 1x4              \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);



  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












