/* xpgnplt.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltvectrow2d(
   char filename[11],
pmatrix mA
)
{
FILE *fp;
  int j;
  int i;

   fp = fopen(filename,"w");

for (i=0; i < mA->rows; i++)
  {
   for (j = 0; j < mA->cols;j++,j++)
    {
     fprintf(fp,"  %.3lf ",
                 *(mA->pblock + i  *mA->cols + j    )/
                 *(mA->pblock + i  *mA->cols +(j+1)));
    }
     fprintf(fp,"\n");
  }
  fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltvectcol2d(
   char filename[11],
pmatrix mA
)
{
FILE *fp;
  int j;

   fp = fopen(filename,"w");

   for (j = 0; j < mA->cols;j++,j++)
    {
     fprintf(fp,"  %.3lf  %.3lf \n",
                 *(mA->pblock + 0 *mA->cols + j     )/
                 *(mA->pblock + 0 *mA->cols + j + 1 ),
                 *(mA->pblock + 1 *mA->cols + j     )/
                 *(mA->pblock + 1 *mA->cols + j + 1 ));
    }

  fclose(fp);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltconicresultis(
   char filename[11],
pmatrix mOut)
{
FILE *fp;
 int i;
 int p = mOut->rows;

   fp = fopen(filename,"w");

    fprintf(fp,"\n");
    fprintf(fp," f(x,y) = ");
    i = 0;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    fprintf(fp,"%+.0f./%.0f. * x**2 ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    fprintf(fp,"%+.0f./%.0f. * y**2 ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    fprintf(fp,"%+.0f./%.0f. * x ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    fprintf(fp,"%+.0f./%.0f. * y ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    fprintf(fp,"%+.0f./%.0f.\n",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    fprintf(fp,"\n\n");
   fprintf(fp," set contour base\n");
   fprintf(fp," set cntrparam levels discrete 0.0\n");
   fprintf(fp," set nosurface\n");
   fprintf(fp," set term table\n");
   fprintf(fp," set out 'curve.dat'\n");
   fprintf(fp," splot f(x,y)\n");
   fprintf(fp," set term windows\n\n");
   fprintf(fp," plot \"curve.dat\" with lines, \"points\" with points\n");
   fprintf(fp," reset\n");

    fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltpolyresultis(
   char filename[11],
pmatrix mOut)
{
FILE *fp;
 int i;
 int p = mOut->rows;

  fp = fopen(filename,"w");

  fprintf(fp,"\n");
  fprintf(fp,"  f(x) = ");
  for (   i = 0 ; i < mOut->rows    ; i++)
   {
    fprintf(fp,"%+.0f./%.0f.*x**%d ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1),
            --p);
   }
   fprintf(fp,"  \n\n");
   fprintf(fp,"  plot f(x) with lines, \"points\" with points\n");
   fprintf(fp,"  reset\n");

   fclose(fp);
}

