/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n)
{
fraction k;
fraction l;
fraction kplsl;

double pbP    [MXR][MXC*TWOCOL];matrix mP    ={MXR,MXC*TWOCOL,&pbP    [0][0]};
double pbkP   [MXR][MXC*TWOCOL];matrix mkP   ={MXR,MXC*TWOCOL,&pbkP   [0][0]};
double pblP   [MXR][MXC*TWOCOL];matrix mlP   ={MXR,MXC*TWOCOL,&pblP   [0][0]};

double pkplsl_P[MXR][MXC*TWOCOL];matrix mkplsl_P={MXR,MXC*TWOCOL,&pkplsl_P[0][0]};
double pkPplslP[MXR][MXC*TWOCOL];matrix mkPplslP={MXR,MXC*TWOCOL,&pkPplslP[0][0]};

double pkPplslP_mns_kplsl_P[MXR][MXC*TWOCOL];
matrix mkPplslP_mns_kplsl_P={MXR,MXC*TWOCOL,&pkPplslP_mns_kplsl_P[0][0]};

           mP.rows = n;                   mP.cols = 1*TWOCOL;
          mkP.rows = n;                  mkP.cols = 1*TWOCOL;
          mlP.rows = n;                  mlP.cols = 1*TWOCOL;
     mkplsl_P.rows = n;             mkplsl_P.cols = 1*TWOCOL;
     mkPplslP.rows = n;             mkPplslP.cols = 1*TWOCOL;

     mkPplslP_mns_kplsl_P.rows = n;
     mkPplslP_mns_kplsl_P.cols = 1*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  k = rndFI (5);
  l = rndFI (5);

  rndmI(&mP,5);

  clrscrn();
  printf("\n          k = %3.0f\n", k.numer);
  printf("\n          l = %3.0f\n", l.numer);
  kplsl = addF(k,l);
  printf("\n      k + l = %3.0f\n", kplsl.numer);

  printf("\n          P = ");
  printpolyI(&mP);
  printf("\n  (k + l) P = ");
  smultmF(kplsl,&mP,&mkplsl_P);
  printpolyI(         &mkplsl_P);
  getchar();

  clrscrn();
  printf("\n          P = ");
  printpolyI(&mP);
  printf("\n         k  = %3.0f\n", k.numer);
  printf("\n         kP = ");
  smultmF(k,&mP,&mkP);
  printpolyI(     &mkP);
  printf("\n         l  = %3.0f\n", l.numer);
  printf("\n         lP = ");
  smultmF(l,&mP,&mlP);
  printpolyI(     &mlP);
  printf("\n    kP + lP = ");
  addmF(&mkP,&mlP,&mkPplslP);
  printpolyI(       &mkPplslP);
  getchar();

  clrscrn();
  printf("\n                 kP + lP = ");
  printpolyI(&mkPplslP);
  printf("\n               (k + l) P = ");
  printpolyI(&mkplsl_P);
  printf("\n [kP + lP] - [(k + l) P] = ");
  submF(&mkPplslP, &mkplsl_P,&mkPplslP_mns_kplsl_P);
  printpolyI(                &mkPplslP_mns_kplsl_P);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n            kP + lP = (k + l) P                   ");
  printf("\n            *******************                   ");
  printf("\n\n\n                                              ");
  printf("\n The degree of P, v : 2 ... 4.                  \n");
  printf("\n     ex : \"pfI.exe\"                           \n");
  printf("\n You can choose the degree :                    \n");
  printf("\n     ex : \"pfI.exe 2\"                           ");
  printf("\n          \"pfI.exe 4\"                         \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {    n=rndpI(4);}
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' RetPrn to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












