;DMA buffer alloc funcs

include src\qlib.inc

.code

;this will alloc upto a 64k DMA buffer and will not cross a 64k DMA boundry
dma_alloc64 proc,dmas:dword
  callp _alloc,dmas,64
  ret
dma_alloc64 endp

;this will alloc upto a 128k DMA buffer and will not cross a 128k DMA boundry
;and it will be WORD ALIGNED!
dma_alloc128 proc,dmas:dword
  callp _alloc,dmas,128
  ret
dma_alloc128 endp

_alloc proc private,dmas:dword,siz:byte
  ;use DOS
  pushad
  mov esi,dmas
  mov ebx,[esi].dma_s.siz
  .if siz==64
    mov eax,64*1024
  .else
    mov eax,128*1024
  .endif
  .if ( (ebx>eax) || (!ebx) )
    popad
    mov eax,ERROR
    ret
  .endif
  shl ebx,1                             ; alloc twice as much needed  (any better ideas?)
  shr ebx,4                             ; convert to paragraph size
  .if [esi].dma_s.siz & 0fh
    inc ebx
  .endif
  mov ax,100h                           ;alloc DOS ram
  int 31h
  .if carry?
bad:
    popad
    mov eax,ERROR
    ret
  .endif
  xor ecx,ecx
  mov cx,ax
  shl ecx,4
  ;ecx = linear addr
  mov [esi].dma_s.sel,dx
  
  mov eax,ecx
  mov ebx,ecx
  shr eax,16
  add ecx,[esi].dma_s.siz
  dec ecx                               ;check last byte in DMA buffer
  shr ecx,16
  .if cl!=al
    .if siz==128
      dec cl
      .if cl==al
        jmp ok
      .endif
    .endif
    shl ecx,16
    mov [esi].dma_s.phys,ecx            ;linear addr
  .else
ok:
    mov [esi].dma_s.phys,ebx            ;linear addr
    mov dx,[esi].dma_s.sel
    mov ebx,[esi].dma_s.siz
    shr ebx,4                           ;paragraph size
    .if [esi].dma_s.siz & 0fh
      inc ebx
    .endif
    mov ax,102h                         ;resize DOS block
    int 31h                             ;resize block
  .endif
  popad
  xor eax,eax
  ret
_alloc endp

dma_free proc,dmas:dword
  pushad
  mov esi,dmas
  mov ax,101h                           ;free DOS ram
  mov dx,[esi].dma_s.sel
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
dma_free endp

dma_setup proc,dmas:dword,bufstart:dword,bufsize:word,mode:byte
  local DMA_Channel:byte,DMAbaseAdd:word,DMAPageReg:word
  
  pushad
  mov eax,dmas
  mov bl,bptr[eax].dma_s.dmach
  mov DMA_Channel,bl
  .if bl==4
    mov DMAPageReg,08fh
    mov DMAbaseAdd,0c0h
  .elseif bl==5
    mov DMAPageReg,08bh
    mov DMAbaseAdd,0c4h
  .elseif bl==6
    mov DMAPageReg,089h
    mov DMAbaseAdd,0c8h
  .elseif bl==7
    mov DMAPageReg,08ah
    mov DMAbaseAdd,0cch
  .elseif bl==0
    mov DMAPageReg,087h
    mov DMAbaseAdd,0
  .elseif bl==1
    mov DMAPageReg,083h
    mov DMAbaseAdd,2
  .elseif bl==2
    mov DMAPageReg,081h
    mov DMAbaseAdd,4
  .elseif bl==3
    mov DMAPageReg,082h
    mov DMAbaseAdd,6
  .else
    jmp bad
  .endif
  
  mov ebx,[eax].dma_s.phys              ;get address
  add ebx,bufstart
  mov dh,mode
  mov ax,bx                             ;offset 0-15   (address)
  shr ebx,16
  mov dl,bl                             ;offset 23-16  (page)
  mov cx,bufsize
  
  ;
  ; This routine programs the DMAC for channels 0-7
  ;
  ; IN: [DMA_Channel], [DMAbaseAdd], [DMAPageReg] must be setup
  ;       [DMABaseAdd] =  Memory Address port
  ;
  ;     dh = mode
  ;     ax = address
  ;     cx = length  
  ;     dl = page
  ;
  mov bx,ax
  
  cmp [DMA_Channel],4
  jb @@DoDMA03
  
  mov al,[DMA_Channel]
  out 0D4h,al                           ; mask reg bit
  
  sub al,al
  out 0D8h,al                           ; clr byte ptr
  
  mov al,[DMA_Channel]
  sub al,4
  add al,dh
  out 0D6h,al                           ; set mode reg

  push dx
  
  mov dx,[DMAbaseAdd]
  mov al,bl
  out dx,al                             ; set base address low
  mov al,bh
  out dx,al                             ; set base address high
  
  add dl,2                              ;point to length
  mov al,cl
  out dx,al                             ; set length low
  mov al,ch
  out dx,al                             ; set length high
  
  pop dx
  
  mov al,dl
  mov dx,[DMAPageReg]
  out dx,al                             ; set DMA page reg
  
  mov al,[DMA_Channel]
  and al,00000011b
  out 0D4h,al                           ; unmask (activate) dma channel
  ret
  
@@DoDMA03:
  mov al,4
  add al,[DMA_Channel]
  out 0Ah,al                            ; mask reg bit
  
  sub al,al
  out 0Ch,al                            ; clr byte ptr
  
  mov al,dh
  add al,[DMA_Channel]
  out 0Bh,al                            ; set mode reg

  push dx

  mov dx,[DMAbaseAdd]
  mov al,bl
  out dx,al                             ; set base address low
  mov al,bh
  out dx,al                             ; set base address high
  
  inc dx                                ;point to length
  mov al,cl
  out dx,al                             ; set length low
  mov al,ch
  out dx,al                             ; set length high
  
  pop dx
  
  mov al,dl
  mov dx,[DMAPageReg]
  out dx,al                             ; set DMA page reg
  
  mov al,[DMA_Channel]
  out 0Ah,al                            ; unmask (activate) dma channel
done:
  popad
  xor eax,eax
  ret
bad:
  popad
  mov eax,ERROR
  ret
dma_setup endp

_endseg

end

