include src\qlib.inc
include signal.inc
include stdio.inc
include process.inc
include errno.inc
include dpmi.inc
include float.inc

doINT23cb equ 1   ;Ctrl+C
doINT1b equ 0     ;Ctrl+Brk
doINT1bcb equ 0   ;Ctrl+Brk

;INT 23h - works for WDOSX great but only does Ctrl+c for PMODe/W and DOS/4gw
;INT 1bh - does not work for PMODE/W or DOS/4GW
;        - not needed for WDOSX since INT 23h works for both

;___SIGNAL___ equ 0  ;This is used to force WLINK to include this file
;                    ;since this EQU is used in C0.ASM
; FIX : v2.11 Beta #5 : EQUs can crash WLINK, new method used in c0.asm

.data?
  _int23h_cb callstruct <?>
  _int23h_cb_addr rmPROCstruct <?>
;  _int1bh_cb callstruct <?>
;  _int1bh_cb_addr rmPROCstruct <?>
  _old_int0 df ?
  _old_int4 df ?
  _old_int5 df ?
  _old_int6 df ?
  _old_int7 df ?
  _old_int0eh df ?
;  _old_int1bh df ?
;  _old_int1bh_rm dd ?
  _old_int23h_rm dd ?
  _old_irq13 dd ?

.data
  pure_msg db 'Pure virtual function called',13,10,0
  abort_msg db 'Abnormal program termination',13,10,0
  break_msg db 'User program termination',13,10,0
  fpu_msg db 'Math error termination',13,10,0
  opcode_msg db 'Invalid opcode termination',13,10,0
  mem_msg db 'Invalid memory access termination',13,10,0
  
  SIG_MAX equ 19

ent struct
  _off_cur dd ?    ;current handler
  _off_def dd ?    ;default handler
  _act dd SIG_DFL  ;current action
  dd ?             ;alignment for speed!
ent ends

  align 4
  call_table label byte
   ent <offset def_pure_vir,offset def_pure_vir>      ;0 (QLIB/C++ only)
   ent <offset def_ctrl_break,offset def_ctrl_break>  ;1
   ent <offset def_bad_opcode,offset def_bad_opcode>  ;2
   ent <offset def_fpu,offset def_fpu>                ;3
   ent <offset def_mem,offset def_mem>                ;4
   ent <offset def_exit,offset def_exit>              ;5
   ent <offset def_abort,offset def_abort>            ;6
   ent <offset NULLPROC,offset NULLPROC>              ;7   (reserved)
   ent <offset NULLPROC,offset NULLPROC>              ;8 (User-defined)
   ent <offset NULLPROC,offset NULLPROC>              ;9 (User-defined)
   ent <offset NULLPROC,offset NULLPROC>              ;10 (User-defined)
   ent <offset NULLPROC,offset NULLPROC>              ;11 (User-defined)

.code

_exc struct
  ret_eip  dd ?
  ret_cs   dd ?
  _errcode dd ?
  _eip     dd ?
  _cs      dd ?
  _eflags  dd ?
  _esp     dd ?
  _ss      dd ?
_exc ends

push_regs macro
;BP, DI, SI, DS, ES, DX, CX, BX, AX, IP, CS, FLAGS , ESP , SS , FS , GS
;Note : Inside an exception handler
  push gs                      ;;-+
  push fs                      ;; |
  push [esp+2*4]._exc._ss      ;; |
  push [esp+3*4]._exc._esp     ;;QLIB extension
  push [esp+4*4]._exc._eflags
  push [esp+5*4]._exc._cs
  push [esp+6*4]._exc._eip
  push eax
  push ebx
  push ecx
  push edx
  push es
  push ds
  push ESI
  push EDI
  push EBP
endm

pop_regs macro
;BP, DI, SI, DS, ES, DX, CX, BX, AX, IP, CS, FLAGS , ESP , SS , FS , GS
;Note : Inside an exception handler
  pop EBP
  pop EDI
  pop ESI
  pop ds
  pop es
  pop edx
  pop ecx
  pop ebx
  mov eax,[esp+1*4]
  mov [esp+8*4]._exc._eip,eax
  mov eax,[esp+2*4]
  mov [esp+8*4]._exc._cs,eax
  mov eax,[esp+3*4]
  mov [esp+8*4]._exc._eflags,eax
  mov eax,[esp+4*4]               ;;QLIB extension
  mov [esp+8*4]._exc._esp,eax     ;; |
  mov eax,[esp+5*4]               ;; |
  mov [esp+8*4]._exc._ss,eax      ;; |
  pop eax
  add esp,5*4                     ;; |
  pop fs                          ;; |
  pop gs                          ;;-+
endm

_setup macro
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
endm

_init macro
  push ds
  push es
  push fs
  push gs
  pushad
  _setup
endm

_uninit macro
  popad
  pop gs
  pop fs
  pop es
  pop ds
endm

; Note : underscore added to these functions !!!
  public __wcpp_2_pure_error_    ;WC
  public __wcpp_4_pure_error_
  public _pure_error_            ;BC
  public _purecall               ;M$C

__wcpp_2_pure_error_:
__wcpp_4_pure_error_:
_pure_error_:
_purecall:
  push_regs
  _setup
  .if [call_table+SIGPV*16].ent._act==SIG_IGN
    mov [call_table+SIGPV*16].ent._act,SIG_DFL
  .endif
  push esp
  push SIGPV
  call [call_table+SIGPV*16].ent._off_cur
  add esp,8
  pop_regs
  ret

clean_up:
  _setup
  call _qlib_video_cleanup
  ret

def_pure_vir:
  call clean_up
  mov edx,offset pure_msg
  mov ebx,1  ;exit code
  jmp done

def_ctrl_break:
  call clean_up
  mov edx,offset break_msg
  mov ebx,1  ;exit code
  jmp done

def_bad_opcode:
  call clean_up
  mov edx,offset pure_msg
  mov ebx,1  ;exit code
  jmp done

def_fpu:
  call clean_up
  mov edx,offset pure_msg
  mov ebx,1  ;exit code
  jmp done

done:
  callp print,edx
  callp _exit,ebx

_int23h_rm:
  _init
  .if [call_table+SIGINT*16].ent._act==SIG_IGN
    mov [call_table+SIGINT*16].ent._act,SIG_DFL
  .endif
  push dptr SIGINT
  call [call_table + SIGINT*16].ent._off_cur
  add esp,4
  _uninit
  and bptr ds:[esi+4],0feh  ;clear carry on real mode stack (Ignore CTRL+BRK)
  jmp _DPMI_callback_retf   ;Although this is a INT handler the INT 23 handler
                            ;expects a 'RETF'

comment ~
_int1bh_rm:
  _init
  .if [call_table+SIGINT*16].ent._act==SIG_IGN
    mov [call_table+SIGINT*16].ent._act,SIG_DFL
  .endif
  push dptr SIGINT
  call [call_table + SIGINT*16].ent._off_cur
  add esp,4
  _uninit
  jmp _DPMI_callback_iret

_int1bh:
  _init
  mov bptr ds:[471h],80h    ;set DOS Ctrl+C flag
  _uninit
  sti
  iretd

_int1bh: ;this one crashes the system under PMODE/W
  _init
  .if [call_table+SIGINT*16].ent._act==SIG_IGN
    mov [call_table+SIGINT*16].ent._act,SIG_DFL
  .endif
  push dptr SIGINT
  call [call_table + SIGINT*16].ent._off_cur
  add esp,4
  _uninit
  sti
  iretd
~

_int6:
  push_regs
  _setup
  .if [call_table+SIGILL*16].ent._act==SIG_IGN
    mov [call_table+SIGILL*16].ent._act,SIG_DFL
  .endif
  cmp [call_table + SIGILL*16].ent._off_cur,def_bad_opcode
  je @f
  push esp
  push dptr ILL_EXECUTION
  push dptr SIGILL
  call [call_table + SIGILL*16].ent._off_cur
  add esp,12
  pop_regs
  retf
@@:
  pop_regs
  jmp cs:[_old_int6]

_int0:
  push_regs
  _setup
  .if [call_table+SIGFPE*16].ent._act==SIG_IGN
    mov [call_table+SIGFPE*16].ent._act,SIG_DFL
  .endif
  cmp [call_table + SIGFPE*16].ent._off_cur,def_fpu
  je @f
  push esp
  push dptr FPE_INTDIV0
  push dptr SIGFPE
  call [call_table + SIGFPE*16].ent._off_cur
  add esp,12
  pop_regs
  retf
@@:
  pop_regs
  jmp cs:[_old_int0]

_int4:
  push_regs
  _setup
  .if [call_table+SIGFPE*16].ent._act==SIG_IGN
    mov [call_table+SIGFPE*16].ent._act,SIG_DFL
  .endif
  cmp [call_table + SIGFPE*16].ent._off_cur,def_fpu
  je @f
  push esp
  push dptr FPE_INTOVFLOW
  push dptr SIGFPE
  call [call_table + SIGFPE*16].ent._off_cur
  add esp,12
  pop_regs
  retf
@@:
  pop_regs
  jmp cs:[_old_int4]

_int7: ;No FPU available
  push_regs
  _setup
  .if [call_table+SIGFPE*16].ent._act==SIG_IGN
    mov [call_table+SIGFPE*16].ent._act,SIG_DFL
  .endif
  cmp [call_table + SIGFPE*16].ent._off_cur,def_fpu
  je @f
  push esp
  push dptr FPE_NOFPU
  push dptr SIGFPE
  call [call_table + SIGFPE*16].ent._off_cur
  add esp,12
  pop_regs
  retf
@@:
  pop_regs
  jmp cs:[_old_int7]

_irq13:  ;FPU error
  sti
  _init
  mov al,20h   
  out 0a0h,al  ;Reset slave PIC
  jmp $+2
  nop
  jmp $+2
  nop
  out 020h,al  ;Reset master PIC
  .if [call_table+SIGFPE*16].ent._act==SIG_IGN
    mov [call_table+SIGFPE*16].ent._act,SIG_DFL
  .endif
  fstsw AX
  fclex   ;clear exception flags(6-0)/busy bit(15)/error-status bit(7)
  cmp [call_table + SIGFPE*16].ent._off_cur,def_fpu
  je @f
  ;Push FPE_... based on value in AX
  and al,7fh  ;mask only bits that are relavent!
  .if     al==00001h
    push dptr FPE_INVALID
  .elseif al==00002h
    push dptr FPE_DENORMAL
  .elseif al==00004h
    push dptr FPE_ZERODIVIDE
  .elseif al==00008h
    push dptr FPE_OVERFLOW
  .elseif al==00010h
    push dptr FPE_UNDERFLOW
  .elseif al==00020h
    push dptr FPE_INEXACT
  .elseif al==00040h
    push dptr FPE_STACKFAULT
  .else
    push dptr FPE_UNKNOWN
  .endif
  push dptr SIGFPE
  call [call_table + SIGFPE*16].ent._off_cur
  add esp,8
@@:
  _uninit
  sti
  iretd

def_mem:
  call clean_up
  mov edx,offset mem_msg
  mov ebx,1  ;exit code
  jmp done
  ret

_int5:  ;BOUNDs check failed
  push_regs
  _setup
  .if [call_table+SIGSEGV*16].ent._act==SIG_IGN
    mov [call_table+SIGSEGV*16].ent._act,SIG_DFL
  .endif
  cmp [call_table + SIGSEGV*16].ent._off_cur,def_mem
  je @f
  push esp
  push dptr SEGV_BOUND
  push dptr SIGSEGV
  call [call_table + SIGSEGV*16].ent._off_cur
  add esp,12
  pop_regs
  retf
@@:
  pop_regs
  jmp cs:[_old_int5]

_int0eh:
  push_regs
  _setup
  .if [call_table+SIGSEGV*16].ent._act==SIG_IGN
    mov [call_table+SIGSEGV*16].ent._act,SIG_DFL
  .endif
  cmp [call_table + SIGSEGV*16].ent._off_cur,def_mem
  je @f
  push esp
  push dptr SEGV_PAGEFAULT
  push dptr SIGSEGV
  call [call_table + SIGSEGV*16].ent._off_cur
  add esp,12
  pop_regs
  retf
@@:
  pop_regs
  jmp cs:[_old_int0eh]

def_abort:
  call clean_up
  mov edx,offset abort_msg
  mov ebx,3  ;exit code
  jmp done

abort proc
  .if [call_table+SIGABRT*16].ent._act==SIG_IGN
    mov [call_table+SIGABRT*16].ent._act,SIG_DFL
  .endif
  push dptr SIGABRT
  call [call_table + SIGABRT*16].ent._off_cur
  add esp,4
@@:
  ret
abort endp

def_exit:
  call clean_up
  callp _exit,1

signal proc uses ebx edx,sig:dword,sighand:dword
  mov ebx,sig
  .if ebx>SIG_MAX
    mov eax,SIG_ERR
    mov errno,EINVAL
    ret
  .endif
  shl ebx,4
  add ebx,offset call_table
  mov eax,sighand
  mov edx,[ebx].ent._off_cur
  cli
  .if eax==SIG_DFL       ;set default handler
    mov [ebx].ent._act,eax
    mov eax,[ebx].ent._off_def
    mov [ebx].ent._off_cur,eax
  .elseif eax==SIG_IGN   ;disable handler
    mov [ebx].ent._act,eax
  .else
    ;Setup User handler
    mov [ebx].ent._off_cur,eax
    mov [ebx].ent._act,SIG_DFL
  .endif
  sti
  mov eax,edx
  ret
signal endp

raise proc,sig:dword
  push ebx
  mov ebx,sig
  .if ebx>22
    mov eax,ERROR
    pop ebx
    ret
  .endif
  .if ebx==SIGFPE
    push FPE_EXPLICITGEN
  .elseif ebx==SIGSEGV
    push SEGV_EXPLICITGEN
  .elseif ebx==SIGILL
    push ILL_EXPLICITGEN
  .elseif ebx==SIGTERM
    push EAX   ;Error code
  .else
    push dptr 0
  .endif
  shl ebx,4
  mov ebx,[ebx].ent._off_cur
  xchg ebx,[esp+4]
  call dptr[esp+4]
  add esp,8
  xor eax,eax
  ret
raise endp

_setupexcbak macro v:REQ,new:REQ,old:REQ
  callp _DPMI_getexc,v,esp
  mov ax,[esp].pmPROCstruct._sel
  mov wptr[old+4],ax
  mov eax,[esp].pmPROCstruct._off
  mov dptr[old],eax
  mov [esp].pmPROCstruct._sel,cs
  mov [esp].pmPROCstruct._off,offset new
  callp _DPMI_setexc,v,esp
endm

_setupintbak macro v:REQ,new:REQ,old:REQ
  callp _DPMI_getpmint,v,esp
  mov ax,[esp].pmPROCstruct._sel
  mov wptr[old+4],ax
  mov eax,[esp].pmPROCstruct._off
  mov dptr[old],eax
  mov [esp].pmPROCstruct._sel,cs
  mov [esp].pmPROCstruct._off,offset new
  callp _DPMI_setpmint,v,esp
endm

_setupirq_slavebak macro v:REQ,new:REQ,old:REQ
  mov bx,_pic_slave
  add bx,(v-8)
  callp _DPMI_getpmint,bx,esp
  mov ax,[esp].pmPROCstruct._sel
  mov wptr[old+4],ax
  mov eax,[esp].pmPROCstruct._off
  mov dptr[old],eax
  mov [esp].pmPROCstruct._sel,cs
  mov [esp].pmPROCstruct._off,offset new
  callp _DPMI_setpmint,bx,esp
endm

_setupcallback macro v:REQ,new_addr:REQ,cb:REQ,old_vect:REQ,cb_addr:REQ
;setup callback (in case we are in V86/rmode)
  mov ebx,offset cb_addr
  mov ecx,esp

  callp _DPMI_getrmint,v,ebx
  mov ax,[ebx].rmPROCstruct._seg
  mov wptr[old_vect+2],ax
  mov ax,[ebx].rmPROCstruct._off
  mov wptr[old_vect],ax

  mov [ecx].pmPROCstruct._sel,cs
  mov [ecx].pmPROCstruct._off,offset new_addr
  ;EBX = buffer for rmode seg:off
  ;ECX = pmode proc to call during callback
  ;cb = callstruct to use during callback
  callp _DPMI_callback_alloc,ebx,ecx,offset cb
  test eax,eax
  je @f
  callp printf,"QLIB Warning : Callback for Ctrl+Brk not available\n"
@@:
  callp _DPMI_setrmint,v,ebx
endm

_setupexc macro v:REQ,old:REQ
  mov ax,wptr[old+4]
  mov [esp].pmPROCstruct._sel,ax
  mov eax,dptr[old]
  mov [esp].pmPROCstruct._off,eax
  callp _DPMI_setexc,v,esp
endm

_setupint macro v:REQ,old:REQ
  mov ax,wptr[old+4]
  mov [esp].pmPROCstruct._sel,ax
  mov eax,dptr[old]
  mov [esp].pmPROCstruct._off,eax
  callp _DPMI_setpmint,v,esp
endm

_setupirq_slave macro v:REQ,old:REQ
  mov bx,_pic_slave
  add bx,(v-8)
  mov ax,wptr[old+4]
  mov [esp].pmPROCstruct._sel,ax
  mov eax,dptr[old]
  mov [esp].pmPROCstruct._off,eax
  callp _DPMI_setpmint,bx,esp
endm

_freecallback macro v:REQ,old_vect:REQ,cb_addr:REQ
  mov ebx,esp

  mov ax,wptr[old_vect+2]
  mov [ebx].rmPROCstruct._seg,ax
  mov ax,wptr[old_vect]
  mov [ebx].rmPROCstruct._off,ax
  callp _DPMI_setrmint,v,ebx

  callp _DPMI_callback_free,offset cb_addr
endm

_INIT_ segment word public use32 'INITDATA'
  db 0
  db 0
  dd offset signal_init
_INIT_ ends

_EXIT_ segment word public use32 'EXITDATA'
  db 0
  db 0
  dd offset signal_uninit
_EXIT_ ends

signal_init proc private
  ;This must be called during startup  (see c0.asm)
  ;Placing it into _INIT_ segment will not guarantee it will be done
  ; because this OBJ can be "removed" if there are no extern references.

  ;This routine will setup CPU exception handlers for the different
  ; signals that can occur.  Note : This only works under perfect DOS
  ; extenders (the closest being WDOSX).
  ;This code may crash under PMODE/W and/or DOS/4GW or not work as expected.

  sub esp,sizeof pmPROCstruct + sizeof rmPROCstruct

  _setupexcbak 0,_int0,_old_int0        ;INT 0 (divide by zero)
  _setupexcbak 4,_int4,_old_int4        ;INT 4 (into)
  _setupexcbak 5,_int5,_old_int5        ;INT 5 (Bounds check)
  _setupexcbak 6,_int6,_old_int6        ;INT 6 (invalid opcode)
  .if _fpu
    _setupexcbak 7,_int7,_old_int7        ;INT 7 (no FPU)
    _setupirq_slavebak 13,_irq13,_old_irq13     ;IRQ 13 (FPU error)
    callp irq_enable,13
  .endif
  _setupexcbak 0eh,_int0eh,_old_int0eh  ;INT 0eh (page fault)

if doINT1b
  _setupintbak 1bh,_int1bh,_old_int1bh  ;INT 1bh (ctrl+break)
endif
if doINT1bcb
  _setupcallback 1bh,_int1bh_rm,_int1bh_cb,_old_int1bh_rm,_int1bh_cb_addr ;INT 1bh (ctrl+break)
endif
if doINT23cb
  _setupcallback 23h,_int23h_rm,_int23h_cb,_old_int23h_rm,_int23h_cb_addr ;INT 23h (ctrl+c)
endif

  add esp,sizeof rmPROCstruct + sizeof pmPROCstruct

  ret
signal_init endp

signal_uninit proc private
  sub esp,sizeof pmPROCstruct + sizeof rmPROCstruct

  _setupexc 0,_old_int0        ;INT 0 (divide by zero)
  _setupexc 4,_old_int4        ;INT 4 (into)
  _setupexc 5,_old_int5        ;INT 5 (Bounds check)
  _setupexc 6,_old_int6        ;INT 6 (invalid opcode)
  .if _fpu
    _setupexc 7,_old_int7             ;INT 7 (no FPU)
    callp irq_disable,13
    _setupirq_slave 13,_old_irq13     ;IRQ 13 (FPU error)
  .endif
  _setupexc 0eh,_old_int0eh             ;INT 0eh (page fault)

if doINT1b
  _setupint 1bh,_old_int1bh  ;INT 1bh (ctrl+break)
endif
if doINT1bcb
  _freecallback 1bh,_int1bh_cb_addr,_old_int1bh_rm ;INT 1bh (ctrl+break)
endif
if doINT23cb
  _freecallback 23h,_int23h_cb_addr,_old_int23h_rm ;INT 23h (ctrl+c)
endif

  add esp,sizeof rmPROCstruct + sizeof pmPROCstruct
  ret
signal_uninit endp

;Cantgetcb:
;  jmp [__qlib_errors + ERROR_Cantgetcb]

_endseg

end
