include vesa.inc

ifndef __VIDEO_H__
__VIDEO_H__ equ 0

.code
g_getmode proto :word,:word,:byte
g_setmode proto
g_alloc proto

t_setmode proto :byte,:byte
t_savestate proto
t_restorestate proto :dword
t_box1 proto x1:word,y1:word,x2:word,y2:word,clr:byte
t_box2 proto x1:word,y1:word,x2:word,y2:word,clr:byte
t_boxfill proto x1:word,y1:word,x2:word,y2:word,_char:word
t_backboxfill proto x1:word,y1:word,x2:word,y2:word,clr:byte
t_printxy proto x:word,y:word,:dword
t_printf proto x:word,y:word,:dword,:vararg

g_copy   proto                   ;copy temp area to actual screen
g_copyblk proto x1:dword,y1:dword,x2:dword,y2:dword
g_copybuf proto buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_setbuf proto o:dword           ;sets temp area used by grafic functions
g_getbuf proto                   ;returns above buffer
g_setpal proto pal:dword         ;768 byte array
g_setcol proto n:byte,r:byte,g:byte,b:byte
g_getpal proto pal:dword         ;768 byte array
g_getcol proto n:byte,r:dword,g:dword,b:dword
g_get    proto buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_put    proto src:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_put0   proto src:dword,x1:dword,y1:dword,x2:dword,y2:dword
g_putb0  proto src:dword,x1:dword,y1:dword,x2:dword,y2:dword,clr:dword
g_waitvsync proto
g_line   proto x1:dword,y1:dword,x2:dword,y2:dword,clr:dword
g_putpixel proto x:dword,y:dword,clr:dword
g_getpixel proto x:dword,y:dword

;direct video in/output
gd_get    proto buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
gd_put    proto src:dword,x1:dword,y1:dword,x2:dword,y2:dword
gd_put0   proto src:dword,x1:dword,y1:dword,x2:dword,y2:dword
gd_putb0  proto src:dword,x1:dword,y1:dword,x2:dword,y2:dword,clr:dword

mouse_init      proto
mouse_uninit    proto
mouse_setcursor proto _cur:dword
mouse_loadcursor proto :dword
mouse_setcolor  proto :dword
mouse_getcolor  proto
mouse_setspd    proto xr:byte,yr:byte  ; (1-4 , 1-4)
mouse_setwin    proto x1:dword,y1:dword,x2:dword,y2:dword
mouse_on        proto
mouse_off       proto
mouse_setuser   proto func:dword,ustruct:dword
mouse_setpos    proto x:dword,y:dword

mouse_user struct
  x dw ?
  y dw ?
  but dw ?
mouse_user ends

g_setfnt   proto fbuf:dword
g_getfnt   proto
g_loadfnt  proto nam:dword
g_setfntcolor proto col:dword
g_putch    proto x:dword,y:dword,char:byte
g_printxy  proto x:dword,y:dword,s:dword
g_printf   proto x:dword,y:dword,str1:dword,argv:vararg

g_hline proto x:dword,y:dword,l:dword,col:dword
g_vline proto x:dword,y:dword,l:dword,col:dword
g_box proto x1:dword,y1:dword,x2:dword,y2:dword,col:dword
g_boxfill proto x1:dword,y1:dword,x2:dword,y2:dword,col:dword
g_cls proto

;vesa
vesa_init proto
vesa_func06 proto   ;FIX : v2.11 B4 : was func6
vesa_setstart proto :dword,:dword
vesa_firstmode proto
vesa_nextmode proto

.data             
externdef vesa_info:vesa_infoblock
externdef vesa_modeinfo:vesa_modeinfoblock

externdef _v_buffer:dword
externdef _v_linear:dword
externdef _v_debug:byte

;mouse ptr header (QLIB v2.06)
g_mousehead struct
  head db 'PTR',26
  x dw ?
  y dw ?
  hx dw ?
  hy dw ?
  bpp db ?   ;bits / pixel  (ignored)
  bypp db ?  ;bytes / pixel
  flg db ?   ;(bit 0=mono-colored pointer -> g_setmousecolor())
             ;(bit 1=bitpacked pointer -> g_setfntcolor())  (NEW:v2.10)
g_mousehead ends

;Font header     (QLIB v1.1)
g_fnthead struct
  head db 'FNT',26
  x dw ?
  y dw ?
  bpp db ?   ;bits / pixel  (ignored)
  bypp db ?  ;bytes / pixel
  flg db ?   ;(bit 0=mono-colored font -> g_setfntcolor())
             ;(bit 1=bitpacked font -> g_setfntcolor())
g_fnthead ends

;_v_curmode
G_TEXT equ 1
G_VGA equ 2
G_VESA equ 3
G_MODEX equ 4

externdef _v_x:dword
externdef _v_xb:dword
externdef _v_y:dword
externdef _v_bpsl:dword
externdef _v_bpp:dword
externdef _v_bypp:dword
externdef _v_xbpsl:dword

endif
