/***********************************************************/
/* File Id.                  Wexplode.C                    */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/13/88.                     */
/*                                                         */
/*          (c) Copyright 1989-90 by Stan Milam            */
/*                                                         */
/* Comments: This module will save (wpush), color(wfill),  */
/* frame (wbox) with the current border type & color, a    */
/* single window.                                          */
/*                                                         */
/* Modifications: 10/06/89: Made major modifications to    */
/* speed up the process of exploding the window on CGA     */
/* monitors.  We expand the window 4 rows & cols when      */
/* possible.                                               */
/***********************************************************/

#include <stdio.h>
#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"
extern int CheckSnow;


WNDPTR *wexplode(int ur,int uc,int lr,int lc,int fclr,int bclr) {

     WNDPTR *temp;
     int    r1,c1,r2,c2;
     int    rows, cols, attr;
     int    page, pagesize;
     int    far *scrnptr;
     unsigned offset,scrnseg;

     if ((temp = wpush(ur,uc,lr,lc)) == (WNDPTR *) NULL)
        return (NULL);

     scrnseg = getscrnseg();
     page    = getpage();
     pagesize= getpagesize();
     attr    = MK_ATTR(fclr,bclr) | 32;

     c1 = ((temp->ucol + temp->lcol) / 2) - 1;
     c2 = ((temp->ucol + temp->lcol) / 2) + 1;
     r1 = ((temp->urow + temp->lrow) / 2) - 1;
     r2 = ((temp->urow + temp->lrow) / 2) + 1;
     rows = (r2 - r1) + 1;
     cols = (c2 - c1) + 1;
     offset = MK_SCRNOFF(r1, c1);
     scrnptr= (int far *)MK_FP(scrnseg,offset);
     TextFill(rows, cols, scrnptr, attr);
     while (((c1 != temp->ucol) || (r1 != temp->urow)) ||
     ((c2 != temp->lcol) || (r2 != temp->lrow))) {
        if (_adaptor == CGA) {
           if (c1 != uc)
              if (uc <= (c1 - 2)) c1 -= 2; else c1--;
           if (c2 != lc)
               if (lc >= (c2 + 2)) c2 += 2; else c2++;
           if (r1 != ur)
              if (ur <= (r1 - 2)) r1 -= 2; else r1--;
           if (r2 != lr)
              if (lr >= (r2 + 2)) r2 += 2; else r2++;
        }
        else {
           if (c1 != uc) c1--;
           if (c2 != lc) c2++;
           if (r1 != ur) r1--;
           if (r2 != lr) r2++;
           _delay(5);
        }
        rows = (r2 - r1) + 1;
        cols = (c2 - c1) + 1;
        offset = MK_SCRNOFF(r1, c1);
        scrnptr= (int far *)MK_FP(scrnseg,offset);
        TextFill(rows, cols, scrnptr, attr);
     }
     qbox (temp->urow,temp->ucol,temp->lrow,temp->lcol);
     temp->attr = (char) ((bclr << 4) + fclr);
     set_cursor_pos(ur+1,uc+1);
     return(temp);
}
