/***********************************************************/
/* File Id.                  Wshow.C                       */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/14/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/*            (c) Copyright 1989-90 by Stan Milam          */
/*                                                         */
/* Comments: This module will show a window that has been  */
/* hidden with whide().  It will first copy the contents of*/
/* the screen where this window will be in case the screen */
/* has changed since the window was hidden.  Then the win- */
/* dow will be restored from the *wsave buffer.            */
/***********************************************************/

#include "pcw.i"
#include "pcwproto.h"

#define NULL 0

static int mx_rows, mx_cols;

int wshow(WNDPTR *wnd)  {

   if (!wnd) return(0);
   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);
   re_order(wnd, SHOW);
   return(1);
}

/***********************************************************/
/* File Id.                  Whide.C                       */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/14/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/* Comments: This function will hide a window.  First it   */
/* will save the current contents of the window in *wsave  */
/* then restore the original screen block from *wbuffer.   */
/***********************************************************/

int whide(WNDPTR *wnd) {

    if (!wnd) return(0);
    if (!chk_video_state(&mx_rows,&mx_cols)) return(0);

    re_order(wnd, HIDE);
    return(1);
}
