/*
 *                              CTRL_BRK.C
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 */

#include "dependnt.h"

#if (defined (DLC))
int 
brk_handler ()
{
	return (1);
}
#else
int     cb_happened = 0;
void    (interrupt far * brk_save_vec) (void);
void interrupt far 
brk_handler (void)
{
    cb_happened = 1;
}
#endif

static int ctrl_brk_blocked =  0;
void 
trap_ctrl_break (void)
{
	if (ctrl_brk_blocked)
		return;
	ctrl_brk_blocked = 1;
#if (defined (DLC))
    int_intercept (0x23, &brk_handler, 128);
#else
    brk_save_vec = getvect (0x23);
    setvect (0x23, brk_handler);
#endif
}

void 
release_ctrl_break (void)
{
	if (!ctrl_brk_blocked)
		return;
	ctrl_brk_blocked = 0;
#if (defined (DLC))
    int_restore (0x23);
#else
    setvect (0x23, brk_save_vec);
#endif
}

