/*
 *  Borland C like Conio library for Metaware HighC/C++ 3+.
 *  by Gisle Vanem 17.Apr-97
 */

#ifndef __metaware_conio_h_
#define __metaware_conio_h_

#ifdef __HIGHC__
  #pragma Global_aliasing_convention("_%r")
  extern int main();
  #pragma Alias(main,"main")
  #pragma push_align_members(64);
  #pragma Off(Align_members)
#endif

#if defined(__cplusplus) || defined(__CPLUSPLUS__)
extern "C" {
#endif

extern int _directvideo,  directvideo;
extern int _directcursor, directcursor;
extern int _wscroll;

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2

struct text_info {
       unsigned char winleft;
       unsigned char wintop;
       unsigned char winright;
       unsigned char winbottom;
       unsigned char attribute;
       unsigned char normattr;
       unsigned char currmode;
       unsigned char screenheight;
       unsigned char screenwidth;
       unsigned char curx;
       unsigned char cury;
     };
#ifdef __HIGHC__
#pragma Pop(Align_members)
#endif

enum text_modes { LASTMODE=-1, BW40=0, C40, BW80, C80, MONO=7, C4350=64 };

enum COLORS {
     /*  dark colors */
     BLACK,
     BLUE,
     GREEN,
     CYAN,
     RED,
     MAGENTA,
     BROWN,
     LIGHTGRAY,
     /*  light colors */
     DARKGRAY,
     LIGHTBLUE,
     LIGHTGREEN,
     LIGHTCYAN,
     LIGHTRED,
     LIGHTMAGENTA,
     YELLOW,
     WHITE
   };

#define BLINK   0x80    /*  blink bit */

int      outp (unsigned int port, int value);
unsigned outpw(unsigned int port, unsigned int value);
int      inp  (unsigned int port);
unsigned inpw (unsigned int port);

int      outportb(unsigned int port, int value);
unsigned outport (unsigned int port, unsigned int value);
int      inportb (unsigned int port);
unsigned inport  (unsigned int port);

char *cgets   (char *buf);
int   cprintf (char *format, ...);
int   cputs   (char *buf);
int   cscanf  (char *format, ...);

void  clreol  (void);
void  clrscr  (void);
void  delline (void);
int   putch   (int c);
int   getch   (void);
int   getche  (void);
int   ungetch (int);

void  highvideo (void);
void  insline   (void);
void  lowvideo  (void);
void  normvideo (void);

void  textattr      (int attr);
void  textbackground(int color);
void  textcolor     (int color);
void  textmode      (int mode);
void  gettextinfo   (struct text_info *ti);

void  gotoxy   (int x, int y);
int   wherex   (void);
int   wherey   (void);
void  window   (int x1, int y1, int x2, int y2);

int   gettext  (int x1, int y1, int x2, int y2, void *dest);
int   puttext  (int x1, int y1, int x2, int y2, void *src);
int   movetext (int x1, int y1, int x2, int y2, int dx, int dy);

void _setcursortype (int type);

/* normally defined in <dos.h> */
void delay (unsigned int time);
void sound (unsigned int freq);
#define nosound() sound(0)

int  _mw_kbhit (void);
#define kbhit() _mw_kbhit()

#if defined(__cplusplus) || defined(__CPLUSPLUS__)
}
#endif

#endif /* !__metaware_conio_h_ */
