/* myfmop.h                     freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mIn1 + mIn2          */
/* -------------------------------------------------------------------------- */
int addmF(
pmatrix mA,
pmatrix mB,
pmatrix mAplsB)
{

     int i;
     int j;
fraction f;

  if (mA->rows != mB->rows || mA->cols != mB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mA->rows!=mAplsB->rows||mA->cols!=mAplsB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mA->rows ; i++)
    for ( j = 0; j < mA->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mA->pblock + i *mA->cols + j) *   \
                 *(mB->pblock + i *mB->cols + j + 1))
                                    + \
                 *(mB->pblock + i *mB->cols + j)  *   \
                 *(mA->pblock + i *mA->cols + j + 1);

                                                f.denom = \

                *(mA->pblock + i *mA->cols + j + 1) * \
                *(mB->pblock + i *mB->cols + j + 1);

                 f = fminiFnotZero(f);

                *(mAplsB->pblock + i *mAplsB->cols + j)       = f.numer;
                *(mAplsB->pblock + i *mAplsB->cols + j + 1)   = f.denom;
         }
  return(0);
}


/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mA + mIn2          */
/* -------------------------------------------------------------------------- */
int submF(
pmatrix mA,
pmatrix mB,
pmatrix mAsubB)
{

     int i;
     int j;
fraction f;

  if (mA->rows != mB->rows || mA->cols != mB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mA->rows!=mAsubB->rows||mA->cols!=mAsubB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mA->rows ; i++)
    for ( j = 0; j < mA->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mA->pblock + i *mA->cols + j) *   \
                 *(mB->pblock + i *mB->cols + j + 1))
                                    - \
                 *(mB->pblock + i *mB->cols + j)  *   \
                 *(mA->pblock + i *mA->cols + j + 1);

                                                f.denom = \

                *(mA->pblock + i *mA->cols + j + 1) * \
                *(mB->pblock + i *mB->cols + j + 1);

                 f = fminiFnotZero(f);

                *(mAsubB->pblock + i *mAsubB->cols + j)       = f.numer;
                *(mAsubB->pblock + i *mAsubB->cols + j + 1)   = f.denom;
         }

  return(0);
}


/* ------------------------------ FUNCTION -------------------------- multm() */
/*    mutiply two matrices giving a third matrix    mAB = mA * mB        */
/* -------------------------------------------------------------------------- */
void multmF(
pmatrix mA,
pmatrix mB,
pmatrix mAB)
{
     int i;
     int j;
     int k;
fraction fm;
fraction fa;

              for(k= 0; k < mA->rows; k++)
               {
                  for(j= 0; j < mB->cols; j++,j++)
                   { fa.numer = 0;
                     fa.denom = 1;
                    for(i= 0; i < mA->cols; i++,i++)
                    {
                    fm.numer = *(mA->pblock +  k   *(mA->cols) + i )  * \
                               *(mB->pblock + i/2  *(mB->cols) + j ) ;

                    fm.denom = *(mA->pblock +  k   *(mA->cols) + i + 1) * \
                               *(mB->pblock + i/2  *(mB->cols) + j + 1);

                    fa = addF(fa,fm);
                    }
                     *(mAB->pblock +  k   *(mAB->cols) + j    ) = fa.numer;
                     *(mAB->pblock +  k   *(mAB->cols) + j + 1) = fa.denom;
                   }
               }
}


/* ------------------------------ FUNCTION ------------------------ smultmF() */
/*         m = scalaire * m                                                   */
/* -------------------------------------------------------------------------- */
int smultmF(
fraction s,
pmatrix mA,
pmatrix msA)
{
     int i;
     int j;
fraction f;

  for (   i = 0; i < mA->rows ; i++)
    for ( j = 0; j < mA->cols ; j++, j++)
         {
          f.numer = (*(mA->pblock + i *mA->cols + j    )) * s.numer;
          f.denom = (*(mA->pblock + i *mA->cols + j + 1)) * s.denom;

                f = fminiFnotZero(f);

         (*(msA->pblock + i *msA->cols + j    )) = f.numer;
         (*(msA->pblock + i *msA->cols + j + 1)) = f.denom;
         }

  return(0);
}




/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mTrnspo = m + msA          */
/* -------------------------------------------------------------------------- */
fraction traceF(
pmatrix m)
{
     int i;
fraction f;
fraction fT;

  if ((m->rows * TWOCOL) !=  m->cols)
    {
     printf("\n trF() error - Square matrix, please");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    f.numer = 0;
    f.denom = 1;

  for(   i = 0; i < m->rows ; i++)
     {
      fT.numer = (*(m->pblock + i *m->cols + i * TWOCOL    ));
      fT.denom = (*(m->pblock + i *m->cols + i * TWOCOL + 1));

             f = addF(f,fT);
     }

  return(f);
}

