/* conic01.c                       freeware                    xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */
#include "mypoly.h"      /* mofpoly, resultis, calculate_y                    */
#include "myconic.h"     /* mofconic, conicresultis, calculate_conic          */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{
fraction fx;
fraction fy;

double pbpxy[4][2*TWOCOL]=
{
   1,1,     2,1,
   2,1,    -8,1,
   3,1,    -8,1,
   4,1,    -3,1,
};
matrix mpxy={4,2*TWOCOL,&pbpxy[0][0]};

double pblock[5][6*TWOCOL];
matrix m={5,6*TWOCOL,&pblock[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\n");
  printf(" Find the coefficients a, b, c, d, e, of the curve        \n\n");
  printf("     ax**2 + by**2 + cx + dy + e  = 0 \n\n");
  printf(" that passes through these four points.                   \n\n");

  printf("     x            y \n");
  printmF(&mpxy);

  printf("\n");
  printf(" Using the given points, we obtain this matrix.\n");
  printf("  (e = 1/1. This is my choice)\n\n");
  printf("  (a)x**2      (b)y**2      (c)x         ");
  printf("(d)y           (e)              \n");
  mofconicE(&mpxy,&m);
  printmF(      &m);
  getchar();

  printf("The Gauss Jordan process will reduce this matrix to : \n");
  gaussjordanF(&m);
  printmF(&m);
  getchar();

  printf("\n\n");
  printf(" The coefficients a, b, c, d, e, of the curve are :  \n\n");
  conicresultis(&m);
  getchar();

   printf("     x            y   The given point.\n");
   printmF(&mpxy);
   printf("\n\n");

  printf(" If you have changed the value of x,y.            \n");
  printf(" You must write here, the good value by hand.   \n\n");

fx.numer = 1;fx.denom = 1; fy.numer =  2;fy.denom = 1;calculate_conic(&m,fx,fy);
fx.numer = 2;fx.denom = 1; fy.numer = -8;fy.denom = 1;calculate_conic(&m,fx,fy);
fx.numer = 3;fx.denom = 1; fy.numer = -8;fy.denom = 1;calculate_conic(&m,fx,fy);
fx.numer = 4;fx.denom = 1; fy.numer = -3;fy.denom = 1;calculate_conic(&m,fx,fy);

  printf("\n\n Press a key to continue");
  getchar();
}



