/* equ01.c                          freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */

/* ------------------------------ FUNCTION ------------------------- () */
/*               */
/* -------------------------------------------------------------------------- */
void wequ(
pmatrix m
)
{
     int i;
     int j;
     int k = 3;
    char c = 'a';
fraction f;

  j = m->cols -2;

  printf("\n");
  printf(" The value of the coefficients of the equation :\n\n");
  printf("   a LiBH[4] + b BF[3] -> c B[2]H[6] + d LiBF[4]\n\n");

  for(i = 0; i< m->rows ; i++)
  {
  f.numer = *(m->pblock + i *m->cols + j   );
  f.denom = *(m->pblock + i *m->cols + j + 1);
        f =   fminiF(f);
  printf(" %c = %.0lf/%.0lf,",c++,f.numer,f.denom);
  }

  printf("\n\n Eliminate the denominators, and write the equation.\n\n");

  f.numer =  k *  (*(m->pblock + 0 *m->cols + j  ));
  f.denom =        *(m->pblock + 0 *m->cols + j+1);
        f = fminiF(f);
  printf("  %.0lf LiBH[4] +",   f.numer);

  f.numer =  k *  (*(m->pblock + 1 *m->cols + j  ));
  f.denom =        *(m->pblock + 1 *m->cols + j+1);
        f = fminiF(f);
  printf("  %.0lf BF[3] ->",   f.numer);

  f.numer =  k *  (*(m->pblock + 2 *m->cols + j  ));
  f.denom =        *(m->pblock + 2 *m->cols + j+1);
        f = fminiF(f);
  printf("  %.0lf B[2]H[6]",   f.numer);

  f.numer =  k *  (*(m->pblock + 3 *m->cols + j  ));
  f.denom =        *(m->pblock + 3 *m->cols + j+1);
        f = fminiF(f);
  printf("  %.0lf LiBF[4]",   f.numer);

  printf("\n");
}


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{
double pblock[4][5*TWOCOL]=
{
           1,1,  0,1,  0,1,  0,1,  1,1,
           1,1,  1,1, -2,1, -1,1,  0,1,
           4,1,  0,1, -6,1,  0,1,  0,1,
           0,1,  3,1,  0,1, -4,1,  0,1, 
};
matrix m={4,5*TWOCOL,&pblock[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */

  printf("\n");
  printf(" Find the coefficients of the equation :\n\n");
  printf("   a LiBH[4] + b BF[3] -> c B[2]H[6] + d LiBF[4]\n\n");

  printf("\n The matrix is : \n");
  printmF3(&m);

  printf("\n  Apply the Gauss Jordan function :\n");
  gaussjordanF(&m);
  printmF3(&m);
  getchar();

  wequ(&m);

 printf("\n Press a key to continue");
 getchar();
}



