/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
double pbA   [MXR][MXC*TWOCOL];matrix mA   ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbInvA[MXR][MXC*TWOCOL];matrix mInvA={MXR,MXC*TWOCOL,&pbInvA[0][0]};
double pbb1  [MXR][    TWOCOL];matrix mb1  ={MXR,    TWOCOL,&pbb1  [0][0]};
double pbb2  [MXR][    TWOCOL];matrix mb2  ={MXR,    TWOCOL,&pbb2  [0][0]};
double pbb3  [MXR][    TWOCOL];matrix mb3  ={MXR,    TWOCOL,&pbb3  [0][0]};
double pbTb1 [MXR][    TWOCOL];matrix mTb1 ={MXR,    TWOCOL,&pbTb1 [0][0]};
double pbTb2 [MXR][    TWOCOL];matrix mTb2 ={MXR,    TWOCOL,&pbTb2 [0][0]};
double pbTb3 [MXR][    TWOCOL];matrix mTb3 ={MXR,    TWOCOL,&pbTb3 [0][0]};
double pbA_b1[MXR][MXC*TWOCOL];matrix mA_b1={MXR,MXC*TWOCOL,&pbA_b1[0][0]};
double pbA_b2[MXR][MXC*TWOCOL];matrix mA_b2={MXR,MXC*TWOCOL,&pbA_b2[0][0]};
double pbA_b3[MXR][MXC*TWOCOL];matrix mA_b3={MXR,MXC*TWOCOL,&pbA_b3[0][0]};

                     mA.rows=n;                   mA.cols=n    *TWOCOL;
                  mInvA.rows=n;                mInvA.cols=n    *TWOCOL;
                    mb1.rows=n;                  mb1.cols=      TWOCOL;
                    mb2.rows=n;                  mb2.cols=      TWOCOL;
                    mb3.rows=n;                  mb3.cols=      TWOCOL;
                   mTb1.rows=n;                 mTb1.cols=      TWOCOL;
                   mTb2.rows=n;                 mTb2.cols=      TWOCOL;
                   mTb3.rows=n;                 mTb3.cols=      TWOCOL;
                  mA_b1.rows=n;                mA_b1.cols=(n+1)*TWOCOL;
                  mA_b2.rows=n;                mA_b2.cols=(n+1)*TWOCOL;
                  mA_b3.rows=n;                mA_b3.cols=(n+1)*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 25;}

  rndmI(&mA, x);  rndmI(&mb1,x);  rndmI(&mb2,x);  rndmI(&mb3,x);

  copymF(  &mA,   &mA_b1  );  copycolF(&mb1,0,&mA_b1,n);
  copymF(  &mA,   &mA_b2  );  copycolF(&mb2,0,&mA_b2,n);
  copymF(  &mA,   &mA_b3  );  copycolF(&mb3,0,&mA_b3,n);

  clrscrn();
  printf("\n Solving linear systems by matrix inversion : Ax = b1\n");
  printf("                                              Ax = b2\n");
  printf("                                              Ax = b3\n");
  printf("\n A :\n");
  printmI(&mA);
  getchar();

  clrscrn();
  printf("\n b1 :\n");
  printmI(&mb1);
  printf("\n b2 :\n");
  printmI(&mb2);
  printf("\n b3 :\n");
  printmI(&mb3);
  getchar();

  clrscrn();
  printf("\n                                 Inv(A) :\n");
  inverseF(&mA,&mInvA);
  printmF (    &mInvA);
  printf("\n                                     b1 :\n");
  printmI(&mb1);
  printf("\n             Ax = b1  =>  x = Inv(A)*b1 :\n");
  multmF(&mInvA,&mb1,&mTb1);
  printmF(           &mTb1);
  getchar();

  clrscrn();
  printf("\n                                 Inv(A) :\n");
  printmF (              &mInvA);
  printf("\n                                     b2 :\n");
  printmI(&mb2);
  printf("\n             Ax = b2  =>  x = Inv(A)*b2 :\n");
  multmF(&mInvA,&mb2,&mTb2);
  printmF(           &mTb2);
  getchar();

  clrscrn();
  printf("\n                                 Inv(A) :\n");
  printmF (              &mInvA);
  printf("\n                                     b3 :\n");
  printmI(&mb3);
  printf("\n             Ax = b3  =>  x = Inv(A)*b3 :\n");
  multmF(&mInvA,&mb3,&mTb3);
  printmF(           &mTb3);
  getchar();

  clrscrn();
  printf("\n                          x = Inv(A)*b1 :\n");
  printmF(&mTb1);
  printf("\n                                   A|b1 :\n");
  printmI(&mA_b1);
  gaussjordanF(&mA_b1);
  printf("\n        Verify with GaussJordan on A|b1 :\n");
  printmIF(&mA_b1);
  getchar();

  clrscrn();
  printf("\n                          x = Inv(A)*b2 :\n");
  printmF(&mTb2);
  printf("\n                                   A|b2 :\n");
  printmI(&mA_b2);
  gaussjordanF(&mA_b2);
  printf("\n        Verify with GaussJordan on A|b2 :\n");
  printmIF(&mA_b2);
  getchar();

  clrscrn();
  printf("\n                          x = Inv(A)*b3 :\n");
  printmF(&mTb3);
  printf("\n                                   A|b3 :\n");
  printmI(&mA_b3);
  gaussjordanF(&mA_b3);
  printf("\n        Verify with GaussJordan on A|b3 :\n");
  printmIF(&mA_b3);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            Ax = b1 => x = Inv(A)*b1              ");
  printf("\n            Ax = b2 => x = Inv(A)*b2              ");
  printf("\n            Ax = b3 => x = Inv(A)*b3              ");
  printf("\n            ************************            \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"invx3i.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invx3i.exe 2\" -> mA 2x2        ");
  printf("\n                \"invx3i.exe 3\" -> mA 3x3        ");
  printf("\n                \"invx3i.exe 4\" -> mA 4x4        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;} }
else
 {    n=rndpI(4);  }
   if(n<2){n=2;}


  invb(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

