/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * X Version Copyright (C) 1996 Henrik Schmidt
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>

static UBYTE __jlib_kb_initted=0;


/* basic map for key defs to X key syms */
/* NOT well suited for MIT keyboard layouts */

static KeySym __jlib_keynum2keysym_tab[128] = {
  0,XK_Escape,XK_1,XK_2,XK_3,XK_4,XK_5,XK_6,XK_7,XK_8,XK_9,XK_0,
  XK_minus,XK_equal,XK_BackSpace,XK_Tab,XK_q,XK_w,XK_e,XK_r,XK_t,
  XK_y,XK_u,XK_i,XK_o,XK_p,XK_bracketleft,XK_bracketright,XK_Return,
  XK_Control_L,XK_a,XK_s,XK_d,XK_f,XK_g,XK_h,XK_j,XK_k,XK_l,XK_colon,
  XK_quoteleft,XK_asciitilde,XK_Shift_L,0,XK_z,XK_x,XK_c,XK_v,XK_b,
  XK_n,XK_m,XK_comma,XK_period,XK_slash,XK_Shift_R,XK_asterisk,XK_Alt_L,
  XK_space,XK_Caps_Lock,XK_F1,XK_F2,XK_F3,XK_F4,XK_F5,XK_F6,XK_F7,XK_F8,
  XK_F9,XK_F10,XK_Num_Lock,XK_Scroll_Lock,XK_Home,XK_Up,XK_Prior,0,
  XK_Left,0,XK_Right,0,XK_End,XK_Down,XK_Next,XK_Insert,XK_Delete,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0 };



/* check for extended keys ( alt,shift,control,meta and cursor ) */
Bool IsExtKey( Display *mydisplay, XEvent *myevent, char *myargs)
{
KeySym mykey;
char buff; 


  if ( myevent->type == KeyPress )
	{
	  XLookupString((XKeyEvent*)myevent,&buff,1,&mykey,0);
	  if ( IsModifierKey(mykey) || IsCursorKey(mykey)  )
		return True;
	}
  return False;
}


/* check for non extended keys */
Bool IsNotExtKey( Display *mydisplay, XEvent *myevent, char *myargs)
{
KeySym mykey;
char buff; 


  if ( myevent->type == KeyPress )
	{
	  XLookupString((XKeyEvent*)myevent,&buff,1,&mykey,0);
	  if ( !IsModifierKey(mykey) && !IsCursorKey(mykey)  )
		return True;
	}
  return False;
}


/*+------------------------------------------------------------------------+ */
/*| Initialise the keyboard.                                               | */
/*+------------------------------------------------------------------------+ */
void kb_init(void)
{

  if(__jlib_kb_initted){
     return;
  }
 
  if ( jxdisplay == NULL || !jxwindow )
    return; 

  jxmask |= KeyPressMask;
  XSelectInput(jxdisplay,jxwindow,jxmask);

  __jlib_kb_initted= 1;
}


/*+------------------------------------------------------------------------+ */
/*| Clear the key buffer.                                                  | */
/*+------------------------------------------------------------------------+ */
void kb_clear(void)
{
XEvent myevent;

  if(__jlib_kb_initted){
     return;
  } 

  do {
  } while ( XCheckTypedWindowEvent(jxdisplay,jxwindow,KeyPress,&myevent) );

} 


/*+------------------------------------------------------------------------+ */
/*| Shut down the keyboard.                                                | */
/*+------------------------------------------------------------------------+ */
void kb_closedown(void)
{
} 


/*+------------------------------------------------------------------------+ */
/*| Indicate if a given key is currently being pressed.                    | */
/*+------------------------------------------------------------------------+ */
int kb_keydown(int key)
{
KeySym sym;
char key_vector[32];
KeyCode code;
int keybit;
unsigned int byteindex;
unsigned int bitindex;

  if(!__jlib_kb_initted){
    return;
  }

  /* key in __jlib_keynum2keysym_tab */
  if ( key < 128 && __jlib_keynum2keysym_tab[key] )
	sym = __jlib_keynum2keysym_tab[key];
  /* key treated as X keysym */
  else
	sym = (KeySym)key;


  code = XKeysymToKeycode(jxdisplay,sym);
  if ( code == NoSymbol ) 
	return 0 ;

  byteindex = code / 8;
  bitindex = code & 7;
  XQueryKeymap(jxdisplay,key_vector);
  keybit = ( 1 & (key_vector[byteindex] >> bitindex) );
  return keybit;

}


/*+------------------------------------------------------------------------+ */
/*| Indicate if there are any keys waiting in the key buffer.              | */
/*+------------------------------------------------------------------------+ */
int kb_key_hit(void)
{
XEvent myevent;
KeySym mykey;
char buff; 

  if(!__jlib_kb_initted){
    return;
  }

  if ( XCheckIfEvent(jxdisplay,&myevent,IsNotExtKey,NULL) )
	{
	  XPutBackEvent(jxdisplay,&myevent);
	  return 1;
	}
  
  return 0;

}


/*+------------------------------------------------------------------------+ */
/*| Indicate if there are any extended keys waiting in the key buffer.     | */
/*+------------------------------------------------------------------------+ */
int kb_ext_key_hit(void)
{
XEvent myevent;
KeySym mykey;
char buff;

  if(!__jlib_kb_initted){
    return;
  }

  if ( XCheckTypedWindowEvent(jxdisplay,jxwindow,KeyPress,&myevent) )
	{
	  XPutBackEvent(jxdisplay,&myevent);
	  return 1;
	}

  return 0;
}


/*+------------------------------------------------------------------------+ */
/*| Get the next key from the key buffer.                                  | */
/*+------------------------------------------------------------------------+ */
char kb_get_next_key(void)
{
KeySym mykey;
char buff; 
XEvent myevent;

  if(!__jlib_kb_initted){
	return;
  }

  do  
	{
	  if ( XCheckIfEvent(jxdisplay,&myevent,IsNotExtKey,NULL) )
		{
		  XLookupString((XKeyEvent*)&myevent,&buff,1,&mykey,0);
		  return buff;
		}
	} while ( 1 );

}


/*+------------------------------------------------------------------------+ */
/*| Get the next extended key from the key buffer.                         | */
/*+------------------------------------------------------------------------+ */
USHORT kb_get_next_ext_key(void)
{
KeySym mykey;
char buff; 
XEvent myevent;
USHORT ret=0;

  if(!__jlib_kb_initted){
    return;
  }

  do  
	{
	  if ( XCheckIfEvent(jxdisplay,&myevent,IsExtKey,NULL) )
		{
		  XLookupString((XKeyEvent*)&myevent,&buff,1,&mykey,0);
		  switch(mykey)
			{
			case XK_Shift_L :     
			case XK_Shift_R :
			  ret |= EXT_SHIFT;
			  break;
			case XK_Control_L :
			case XK_Control_R : 
			  ret |= EXT_CTRL;
			  break;
			case XK_Alt_L :
			case XK_Alt_R : 
			  ret |= EXT_ALT;
			  break;
			case XK_Up:
			  ret |= EXT_UP;
			  return ret;
			case XK_Down:
			  ret |= EXT_DOWN;
			  return ret;
			case XK_Left:
			  ret |= EXT_LEFT;
			  return ret;
			case XK_Right:
			  ret |= EXT_RIGHT;
			  return ret;
			}
		}
	  if ( XCheckIfEvent(jxdisplay,&myevent,IsNotExtKey,NULL) != 0  )
		{
		  XLookupString((XKeyEvent*)&myevent,&buff,1,&mykey,0);
		  ret |= buff;
		  break;
		}
	  
	} while ( 1 ); 

  return ret;
}



/*+------------------------------------------------------------------------+ */
/*| Get the next code from the key buffer.                                 | */
/*+------------------------------------------------------------------------+ */
USHORT kb_get_next_code(void)
{
KeySym mykey;
char buff; 
XEvent myevent;

  if (!__jlib_kb_initted){
	return 0;
  }

  if ( XCheckTypedWindowEvent(jxdisplay,jxwindow,KeyPress,&myevent) )
	{
	  XLookupString((XKeyEvent*)&myevent,&buff,1,&mykey,0);
      return (USHORT)buff;
	}

  return 0;

}
