/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <dos.h>
#include <i86.h>
#include <jlib.h>

static int __jlib_mouse_initted=0;
static int __jlib_mouse_visible=0;

/*+-----------------------------------------------------------------------+ */
/*|check for the presence of a mouse & init it.                           | */
/*+-----------------------------------------------------------------------+ */
int mouse_present (void)
{
   union REGS r;
      
   if(!__jlib_mouse_initted){
      __jlib_mouse_initted=1;

      r.x.eax=0;
      int386(0x33, &r, &r);

      if(r.x.eax != 0xffff){
         return MOUSE_ABSENT;
      }
      mouse_show_pointer();   
   }

   return MOUSE_PRESENT;
}


/*+-----------------------------------------------------------------------+ */
/*|show the pointer.                                                      | */
/*+-----------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
   union REGS r;

   if((__jlib_mouse_initted)&&(!__jlib_mouse_visible)){
      r.x.eax = 0x0001;
      int386 (0x33, &r, &r);
   
      __jlib_mouse_visible=1;
   }
}


/*+-----------------------------------------------------------------------+ */
/*|hide the pointer.                                                      | */
/*+-----------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
   union REGS r;

   if((__jlib_mouse_initted)&&(__jlib_mouse_visible)){
      r.x.eax = 0x0002;
      int386 (0x33, &r, &r);
   
      __jlib_mouse_visible=0;
   }
}

/*+-----------------------------------------------------------------------+ */
/*|read pointer coordinates.                                              | */
/*+-----------------------------------------------------------------------+ */
void mouse_get_status (int *x_pos, int *y_pos, int *b_status)
{
   union REGS r;

   if(__jlib_mouse_initted){
      r.x.eax = 0x0003;

      int386 (0x33, &r, &r);
      *x_pos = (int)(((USHORT)r.x.ecx >> 1)&0xffff); /* halve returned coordinate */
      *y_pos = (int)((USHORT)r.x.edx & 0xffff);
      *b_status = (int)(USHORT)r.x.ebx;
   }
}


/*+-----------------------------------------------------------------------+ */
/*|change pointer coordinates.                                            | */
/*+-----------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{
   union REGS r;

   if(__jlib_mouse_initted){
      r.x.eax = 0x0004;
      r.x.ecx = x;
      r.x.edx = y;

      int386 (0x33, &r, &r);
   }
}


/*+-----------------------------------------------------------------------+ */
/*|shut down the mouse.                                                   | */
/*+-----------------------------------------------------------------------+ */
void mouse_closedown (void)
{
   if(__jlib_mouse_initted){
      mouse_hide_pointer();

      __jlib_mouse_initted = 0;
   }
}

