INCLUDE CLIBC_16.INC

;strchr() -- Search string for char
;char __near *	__near strchr(const char __near * const,const int);

; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
;   MSC 7.0 assumes p_str offset from ds

_TEXT SEGMENT
strchr PROC NEAR16 C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:
	    dec si
	    mov ax, si
	    ret
strchr	ENDP

; __fastcall
;   bx	    p_str, offset from ds
;   ax	    chr
;char __near *	__fastcall __near strchr(const char __near * const,const int);
@strchr PROC NEAR16 USES si
	    mov si, bx	    ;ds:si = p_str
	    xchg ah, al	    ;ah = chr

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
@strchr ENDP

;strchr_sss() -- Search string for char
;char __near *	__near strchr_sss(const char __near * const,const int);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
;   MSC 7.0 assumes p_str offset from ds
strchr_sss PROC NEAR16 C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
strchr_sss	ENDP

; __fastcall
;   bx	    p_str, offset from ss
;   ax	    chr
;char __near *	__fastcall __near strchr_sss(const char __near * const,const int);
@strchr_sss PROC NEAR16 USES ds si bx
	    mov si, bx	    ;ds:si = p_str
	    xchg ah, al	    ;ah = chr
	    mov bx, ss
	    mov ds, bx

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
@strchr_sss ENDP
_TEXT ENDS
END
