INCLUDE CLIBC_16.INC

; skiptosp
; char __near * __near skiptosp(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character

_TEXT SEGMENT
skiptosp PROC NEAR16 C USES si, p_str:NEAR16 PTR BYTE
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp ENDP

; __fastcall
;   bx	    p_str, offset from ds
; char __near * __fastcall __near skiptosp(const char __near * const);
@skiptosp PROC NEAR16 USES si
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
@skiptosp ENDP

; skiptosp_sss
; char __near * __near skiptosp_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character

skiptosp_sss PROC NEAR16 C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp_sss ENDP

; __fastcall
;   bx	    p_str, offset from ss
; char __near * __fastcall __near skiptosp_sss(const char __near * const);
@skiptosp_sss PROC NEAR16 USES si
    mov si, bx
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
@skiptosp_sss ENDP
_TEXT ENDS
END
