INCLUDE CLIBC_16.INC

;strcpy() -- Copies string 2 to string 1, including null term char
;char __near * __near strcpy(char const __near *, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ss
;   p_str2	near pointer, offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ss (p_str1)
; NOTES:
;   only ASSEMBLY FARSTACK models will be concerned with ss!=ds issues

_TEXT SEGMENT
strcpy PROC NEAR16 C USES si di es, p_str1:NEAR PTR BYTE, p_str2:NEAR PTR BYTE
	    mov ax, ss
	    mov es, ax

	    mov di, [p_str1]	    ;es:DI = p_str1 = destination
	    mov si, [p_str2]	    ;ds:SI = p_str2 = source

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
strcpy ENDP

; __fastcall
; GIVEN:
;   BX		p_str1
;   AX		p_str2
; RETURNS:
;   AX		p_str1
;char __near * __fastcall __near strcpy(char const __near *, const char __near * const);
@strcpy PROC NEAR16 USES bx si di es
	    mov di, bx	    ;es:DI = p_str1 = destination
	    mov si, ax	    ;ds:SI = p_str2 = source

	    mov ax, ss
	    mov es, ax
	    mov bx, ds

	    cmp ax, bx	    ; check to see if ds==ss/es
	    jne @@cont
	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy ENDP
_TEXT ENDS
END
