INCLUDE CLIBC_16.INC

; skipspr
; char __near * __near skipspr(const char __near * const);
; GIVEN:
;   p_str	near pointer, offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		to the last non white space character in the string
;		if no more non white space characters in the string,
;		   then points to terminating '\0'
; NOTES:
; see isspace for the definition of a white space character

_TEXT SEGMENT
skipspr PROC NEAR16 C USES es di, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov es, ax

    mov di, [p_str] ; es/ss:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; strlen(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = strlen(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
skipspr ENDP

; __fastcall
;   bx	    p_str
; char __near * __fastcall __near skipspr(const char __near * const);
@skipspr PROC NEAR16 USES es di dx cx bx
    mov ax, ss
    mov es, ax

    mov di, bx ; es/ss:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; strlen(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = strlen(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
@skipspr ENDP
_TEXT ENDS
END
