INCLUDE CLIBC_16.INC

; skipspr
; char __near * __near skipspr(const char __near * const);
; GIVEN:
;   p_str	near pointer, offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		to the last non white space character in the string
;		if no more non white space characters in the string,
;		   then points to terminating '\0'
; NOTES:
; see isspace for the definition of a white space character

_TEXT SEGMENT
skipspr PROC NEAR16 C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax

    mov si, [p_str] ; ds/ss:si = p_str
    xor dx, dx	; zero out dx
    dec dx	; dx = -1
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jg @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
	mov si, dx
@@:
    dec si
    mov ax, si
    ret
skipspr ENDP

; __fastcall
;   bx	    p_str
; char __near * __fastcall __near skipspr(const char __near * const);
@skipspr PROC NEAR16 USES ds si dx
    mov ax, ss
    mov ds, ax

    mov si, bx ; ds/ss:si = p_str
    xor dx, dx	; zero out dx
    dec dx	; dx = -1
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jg @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
	mov si, dx
@@:
    dec si
    mov ax, si
    ret
@skipspr ENDP
_TEXT ENDS
END
