INCLUDE CLIB_16.INC

; stricmp() -- Compare strings, case insensitive
;int __far stricmp(const char __far * const, const char __far * const);

;GIVEN:
;   p_str1	pointer to string1
;   p_str2	pointer to string2
; RETURNS:
;   <0		string1 < string2
;   0		string1 = string2
;   >0		string1 > string2
_TEXT SEGMENT
stricmp PROC FAR16 C USES ds es si di, p_str1:FAR16 PTR BYTE, p_str2:FAR16 PTR BYTE

	    lds si,[p_str1]	    ;ds:SI = source
	    les di,[p_str2]	    ;es:DI = destination
	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;Load char 1
	    mov ah, es:[di]	     ;Load char 2
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@setAH
	    cmp al,'Z'
	    ja @@setAH
	    or al, 00100000b

@@setAH:    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@comp
	    cmp ah,'Z'
	    ja @@comp
	    or ah, 00100000b

@@comp:	    cmp ah,al		   ;Equal?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    mov ax, -1
	    jmp @@exit
@@less:
	    mov ax, 1
@@exit:
	    ret
stricmp ENDP
_TEXT ENDS
END
