/*
 * PESTUB.CPP - Stub program for dllPower applications.
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Copyright (c) 1996, Tony Toole
 *
 * Patch (1) October, 20-22, 1996 - Solved a problem with a dllPower application
 * not being able to run on a read only device, ie CD-ROM. Cause was that
 * DOS4GW's virual memory configuration file was being written in the current
 * directory, erroring if unable to write. This file is now created in the TEMP
 * directory. The placement of the virtual memory swap file had the same
 * problem, it too has been moved to the TEMP directory, you no longer control
 * where it is placed.
 *
 * Patch (2) October, 22, 1996 - Fixed a bug that caused the contents of
 * argv[0] to be nulled out. Bug apeared when dllPower.exe was in the same path
 * as the host application.
 */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <errno.h>
#include <string.h>
#include <io.h>

/* Add environment strings to be searched here */
struct ExeStub
{
  char ID[6];
  char DLLPath[128];
  char VirtualSet;
  long VirtualMin;
  long VirtualMax;
  long VirtualSwapMin;
  long VirtualSwapInc;
  long VirtualSize;
} Stub = {"dllstb", ".\\", 1, 512, 32768, 0, 1024, 32768};

char *paths_to_check[] =
{
  "DLLPOWER",
  "PATH"
};

char FullName[_MAX_PATH];

char *peloader_path()
{
  static char fullpath[PATH_MAX];
  char *peloaderpath;
  int i;

  if (peloaderpath = getenv("DLLPOWER"))
  {
    strlwr (strcpy (fullpath, peloaderpath));
    if     (strstr (fullpath, ".exe")) return (fullpath);
  }
  for( i = 0; i < sizeof( paths_to_check    ) /
                  sizeof( paths_to_check[0] ); i++ )
  {
    _searchenv( "dllpower.exe", paths_to_check[i], fullpath );
    if( fullpath[0] ) return( &fullpath );
  }
  return( "dllpower.exe" );
}

char Path[PATH_MAX];
char tempPath[PATH_MAX];
void Init()
{
  FILE *ap;
  char *ExistPath;
  char *temp;
  char tempVMM[PATH_MAX];
  temp = getenv("TEMP");
  if (!temp) temp = getenv("TMP");
  if (!temp)
     {
     printf("STUB Error: Unable to locate temarary directory!\n");
     printf("            Please set TEMP or TMP environment variables.\n");
     exit(-1);
     }
  strcpy(tempPath, temp);
  strcat(tempPath, "\\VMMSET.VMC");
  strcpy(tempVMM, temp);
  strcat(tempVMM, "\\VIRTMEM.SWP");
  putenv("DOS4G=QUIET");

  ExistPath = getenv("DLLPATH");
  if(ExistPath != NULL) sprintf(Path, "DLLPATH=%s;%s", ExistPath, Stub.DLLPath);
  else                  sprintf(Path, "DLLPATH=%s", Stub.DLLPath);
  putenv(Path);
  if(Stub.VirtualSet)
  {
    if((ap = fopen(tempPath, "wt")) == NULL)
    {
      printf("STUB Error: Can't create configuration file %s\n", tempPath);
      exit(1);
    }
    fprintf(ap, "deleteswap\n");
    fprintf(ap, "maxmem      = %ld\n", Stub.VirtualMax);
    fprintf(ap, "minmem      = %ld\n", Stub.VirtualMin);
    fprintf(ap, "swapmin     = %ld\n", Stub.VirtualSwapMin);
    fprintf(ap, "swapinc     = %ld\n", Stub.VirtualSwapInc);
    fprintf(ap, "virtualsize = %ld\n", Stub.VirtualSize);
    fprintf(ap, "swapname    = %s\n",  tempVMM);
    fclose(ap);
    sprintf(tempVMM, "DOS4GVM=@%s", tempPath);
    putenv(tempVMM);
    _fullpath(FullName, tempPath, _MAX_PATH);
  }
}
void UnInit()
{
  if(Stub.VirtualSet)
  {
    unlink(FullName);
  }
}
int main( int argc, char *argv[] )
{
  char *av[4];
  auto char cmdline[PATH_MAX];
  int ret;

  av[1] = argv[0];
  av[2] = getcmd( cmdline );
  av[0] = peloader_path();
  av[3] = NULL;

  Init();
  if((ret = spawnvp(P_WAIT, av[0], av )) == -1)
  {
    printf("STUB Error, unable to execute DOS Extender [%s]\n", av[0]);
    printf("Reason: %s", strerror(errno));
    UnInit();
    exit( 1 );
  }
  UnInit();
  return ret;
}
