/* example 3: show how to use the 32-bit file access functions to copy a
   file
   Not really useful.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../flat.h"

/* Instead of seperately compiling and linking this file with alloc32.c and
   file32.c we simply #include them. Not pretty, but it works in an example
   program ;-)
 */
#include "../src/c/alloc32.c"
#include "../src/c/file32.c"

long flen (FILE * f);
void errexit (const char *,...);

char *errmsg[] =
{
  NULL,
  "80386 or better CPU not detected",
  "CPU is in V86-mode",
  "Extended memory couldn't be allocated",
  "Unable to lock extended memory"
};

int
main (int argc, char **argv)
{
  int foo;
  FILE *in, *out;
  long len, retval;
  flatptr p;
  void *vp;

  foo = init_flat ();

  if (foo)
    errexit (errmsg[foo]);

  /* make the program name lower case, just an optical improvement */
  strlwr (*argv);

  /* abort if arguments are missing */
  if (3 > argc)
    errexit ("usage: %s source target", *argv);

  /* try allocate memory for the transfer buffer
     In small data models, malloc should return a near pointer. Thus, we
     explicitly cast the returned value into a far one.
     fbuf_ptr *must* reside within the data segment in small data models!
   */
  vp = malloc (fbuf_size);
  if (!vp)
    errexit ("not enough conventional memory available");
  fbuf_ptr = (void far *) vp;

  /* use ordinary FILE functions to open and close files */
  in = fopen (argv[1], "rb");
  if (NULL == in)
    errexit ("cannot open %s for reading", argv[1]);

  out = fopen (argv[2], "wb");
  if (NULL == out)
    errexit ("cannot open %s for writing", argv[2]);

  /* read length of file */
  len = flen (in);

  /* try to allocate extended memory for the data */
  p = malloc32 (len);
  if (0L == p)
    errexit ("not enough extended memory available to load file %s",
             argv[1]);

  /* try to read the entire file */
  retval = fread32 (p, len, in);
  if (-1 == retval)
    errexit ("error occured while trying to read from %s", argv[1]);

  /* write everything read into the stream out */
  retval = fwrite32 (p, retval, out);
  if (-1 == retval)
    errexit ("error occured while trying to write to file %s", argv[2]);

  /* free extended memory, not necessary, as exit_flat returns it to the
     system, but should be done it real programs
   */
  free32 (p);

  /* close files, also not necessary here, but nice */
  fclose (in);
  fclose (out);

  exit_flat ();
  return (0);
}

void
errexit (const char *fmt,...)
{
  va_list v;
  char s[513];
  va_start (v, fmt);

  vsprintf (s, fmt, v);
  fprintf (stderr, "%s\n", s);
  exit_flat ();
  exit (1);
}

/* flen -- quite portable file length calculation function */
long
flen (FILE * f)
{
  long ret, cur;

  cur = ftell (f);
  fseek (f, 0, SEEK_END);
  ret = ftell (f);
  fseek (f, cur, SEEK_SET);
  return (ret);
}
