/* 
   ASCIIFunctions.h

   Declarations for all the Win32 ASCII Functions

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNU_H_WINDOWS32_ASCIIFUNCTIONS
#define _GNU_H_WINDOWS32_ASCIIFUNCTIONS


/* This keeps all this stuff from bugging the resource compiler. */
#ifndef	RC_INVOKED

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern WINBOOL
 PASCAL GetBinaryTypeA(
	       LPCSTR lpApplicationName,
	       LPDWORD lpBinaryType
	       );

extern DWORD
 PASCAL GetShortPathNameA(
		  LPCSTR lpszLongPath,
		  LPSTR  lpszShortPath,
		  DWORD    cchBuffer
		  );

extern LPSTR
 PASCAL GetEnvironmentStringsA(
		       VOID
		       );

extern WINBOOL
 PASCAL FreeEnvironmentStringsA(
			LPSTR
			);

extern DWORD
 PASCAL FormatMessageA(
	       DWORD dwFlags,
	       LPCVOID lpSource,
	       DWORD dwMessageId,
	       DWORD dwLanguageId,
	       LPSTR lpBuffer,
	       DWORD nSize,
	       va_list *Arguments
	       );

extern HANDLE
 PASCAL CreateMailslotA(
		LPCSTR lpName,
		DWORD nMaxMessageSize,
		DWORD lReadTimeout,
		LPSECURITY_ATTRIBUTES lpSecurityAttributes
		);

extern int
 PASCAL lstrcmpA(
	 LPCSTR lpString1,
	 LPCSTR lpString2
	 );

extern int
 PASCAL lstrcmpiA(
	  LPCSTR lpString1,
	  LPCSTR lpString2
	  );

extern LPSTR
 PASCAL lstrcpynA(
	  LPSTR lpString1,
	  LPCSTR lpString2,
	  int iMaxLength
	  );

extern LPSTR
 PASCAL lstrcpyA(
	 LPSTR lpString1,
	 LPCSTR lpString2
	 );

extern LPSTR
 PASCAL lstrcatA(
	 LPSTR lpString1,
	 LPCSTR lpString2
	 );

extern int
 PASCAL lstrlenA(
	 LPCSTR lpString
	 );

extern HANDLE
 PASCAL CreateMutexA(
	     LPSECURITY_ATTRIBUTES lpMutexAttributes,
	     WINBOOL bInitialOwner,
	     LPCSTR lpName
	     );

extern HANDLE
 PASCAL OpenMutexA(
	   DWORD dwDesiredAccess,
	   WINBOOL bInheritHandle,
	   LPCSTR lpName
	   );

extern HANDLE
 PASCAL CreateEventA(
	     LPSECURITY_ATTRIBUTES lpEventAttributes,
	     WINBOOL bManualReset,
	     WINBOOL bInitialState,
	     LPCSTR lpName
	     );

extern HANDLE
 PASCAL OpenEventA(
	   DWORD dwDesiredAccess,
	   WINBOOL bInheritHandle,
	   LPCSTR lpName
	   );

extern HANDLE
 PASCAL CreateSemaphoreA(
		 LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,
		 LONG lInitialCount,
		 LONG lMaximumCount,
		 LPCSTR lpName
		 );

extern HANDLE
 PASCAL OpenSemaphoreA(
	       DWORD dwDesiredAccess,
	       WINBOOL bInheritHandle,
	       LPCSTR lpName
	       );

extern HANDLE
 PASCAL CreateFileMappingA(
		   HANDLE hFile,
		   LPSECURITY_ATTRIBUTES lpFileMappingAttributes,
		   DWORD flProtect,
		   DWORD dwMaximumSizeHigh,
		   DWORD dwMaximumSizeLow,
		   LPCSTR lpName
		   );

extern HANDLE
 PASCAL OpenFileMappingA(
		 DWORD dwDesiredAccess,
		 WINBOOL bInheritHandle,
		 LPCSTR lpName
		 );

extern DWORD
 PASCAL GetLogicalDriveStringsA(
			DWORD nBufferLength,
			LPSTR lpBuffer
			);

extern HINSTANCE
 PASCAL LoadLibraryA(
	     LPCSTR lpLibFileName
	     );

extern HINSTANCE
 PASCAL LoadLibraryExA(
	       LPCSTR lpLibFileName,
	       HANDLE hFile,
	       DWORD dwFlags
	       );

extern DWORD
 PASCAL GetModuleFileNameA(
		   HINSTANCE hModule,
		   LPSTR lpFilename,
		   DWORD nSize
		   );

extern HMODULE
 PASCAL GetModuleHandleA(
		 LPCSTR lpModuleName
		 );

extern VOID
 PASCAL FatalAppExitA(
	      UINT uAction,
	      LPCSTR lpMessageText
	      );

extern LPSTR
 PASCAL GetCommandLineA(
		VOID
		);

extern DWORD
 PASCAL GetEnvironmentVariableA(
			LPCSTR lpName,
			LPSTR lpBuffer,
			DWORD nSize
			);

extern WINBOOL
 PASCAL SetEnvironmentVariableA(
			LPCSTR lpName,
			LPCSTR lpValue
			);

extern DWORD
 PASCAL ExpandEnvironmentStringsA(
			  LPCSTR lpSrc,
			  LPSTR lpDst,
			  DWORD nSize
			  );

extern VOID
 PASCAL OutputDebugStringA(
		   LPCSTR lpOutputString
		   );

extern HRSRC
 PASCAL FindResourceA(
	      HINSTANCE hModule,
	      LPCSTR lpName,
	      LPCSTR lpType
	      );

extern HRSRC
 PASCAL FindResourceExA(
		HINSTANCE hModule,
		LPCSTR lpType,
		LPCSTR lpName,
		WORD    wLanguage
		);

extern WINBOOL
 PASCAL EnumResourceTypesA(
		   HINSTANCE hModule,
		   ENUMRESTYPEPROC lpEnumFunc,
		   LONG lParam
		   );

extern WINBOOL
 PASCAL EnumResourceNamesA(
		   HINSTANCE hModule,
		   LPCSTR lpType,
		   ENUMRESNAMEPROC lpEnumFunc,
		   LONG lParam
		   );

extern WINBOOL
 PASCAL EnumResourceLanguagesA(
		       HINSTANCE hModule,
		       LPCSTR lpType,
		       LPCSTR lpName,
		       ENUMRESLANGPROC lpEnumFunc,
		       LONG lParam
		       );

extern HANDLE
 PASCAL BeginUpdateResourceA(
		     LPCSTR pFileName,
		     WINBOOL bDeleteExistingResources
		     );

extern WINBOOL
 PASCAL UpdateResourceA(
		HANDLE      hUpdate,
		LPCSTR     lpType,
		LPCSTR     lpName,
		WORD        wLanguage,
		LPVOID      lpData,
		DWORD       cbData
		);

extern WINBOOL
 PASCAL EndUpdateResourceA(
		   HANDLE      hUpdate,
		   WINBOOL        fDiscard
		   );

extern ATOM
 PASCAL GlobalAddAtomA(
	       LPCSTR lpString
	       );

extern ATOM
 PASCAL GlobalFindAtomA(
		LPCSTR lpString
		);

extern UINT
 PASCAL GlobalGetAtomNameA(
		   ATOM nAtom,
		   LPSTR lpBuffer,
		   int nSize
		   );

extern ATOM
 PASCAL AddAtomA(
	 LPCSTR lpString
	 );

extern ATOM
 PASCAL FindAtomA(
	  LPCSTR lpString
	  );

extern UINT
 PASCAL GetAtomNameA(
	     ATOM nAtom,
	     LPSTR lpBuffer,
	     int nSize
	     );

extern UINT
 PASCAL GetProfileIntA(
	       LPCSTR lpAppName,
	       LPCSTR lpKeyName,
	       INT nDefault
	       );

extern DWORD
 PASCAL GetProfileStringA(
		  LPCSTR lpAppName,
		  LPCSTR lpKeyName,
		  LPCSTR lpDefault,
		  LPSTR lpReturnedString,
		  DWORD nSize
		  );

extern WINBOOL
 PASCAL WriteProfileStringA(
    LPCSTR lpAppName,
    LPCSTR lpKeyName,
    LPCSTR lpString
    );

extern DWORD
 PASCAL GetProfileSectionA(
    LPCSTR lpAppName,
    LPSTR lpReturnedString,
    DWORD nSize
    );

extern WINBOOL
 PASCAL WriteProfileSectionA(
    LPCSTR lpAppName,
    LPCSTR lpString
    );

extern UINT
 PASCAL GetPrivateProfileIntA(
    LPCSTR lpAppName,
    LPCSTR lpKeyName,
    INT nDefault,
    LPCSTR lpFileName
    );

extern DWORD
 PASCAL GetPrivateProfileStringA(
    LPCSTR lpAppName,
    LPCSTR lpKeyName,
    LPCSTR lpDefault,
    LPSTR lpReturnedString,
    DWORD nSize,
    LPCSTR lpFileName
    );

extern WINBOOL
 PASCAL WritePrivateProfileStringA(
    LPCSTR lpAppName,
    LPCSTR lpKeyName,
    LPCSTR lpString,
    LPCSTR lpFileName
    );

extern DWORD
 PASCAL GetPrivateProfileSectionA(
    LPCSTR lpAppName,
    LPSTR lpReturnedString,
    DWORD nSize,
    LPCSTR lpFileName
    );

extern WINBOOL
 PASCAL WritePrivateProfileSectionA(
    LPCSTR lpAppName,
    LPCSTR lpString,
    LPCSTR lpFileName
    );

extern UINT
 PASCAL GetDriveTypeA(
    LPCSTR lpRootPathName
    );

extern UINT
 PASCAL GetSystemDirectoryA(
    LPSTR lpBuffer,
    UINT uSize
    );

extern DWORD
 PASCAL GetTempPathA(
    DWORD nBufferLength,
    LPSTR lpBuffer
    );

extern UINT
 PASCAL GetTempFileNameA(
    LPCSTR lpPathName,
    LPCSTR lpPrefixString,
    UINT uUnique,
    LPSTR lpTempFileName
    );

extern UINT
 PASCAL GetWindowsDirectoryA(
    LPSTR lpBuffer,
    UINT uSize
    );

extern WINBOOL
 PASCAL SetCurrentDirectoryA(
    LPCSTR lpPathName
    );

extern DWORD
 PASCAL GetCurrentDirectoryA(
    DWORD nBufferLength,
    LPSTR lpBuffer
    );

extern WINBOOL
 PASCAL GetDiskFreeSpaceA(
    LPCSTR lpRootPathName,
    LPDWORD lpSectorsPerCluster,
    LPDWORD lpBytesPerSector,
    LPDWORD lpNumberOfFreeClusters,
    LPDWORD lpTotalNumberOfClusters
    );

extern WINBOOL
 PASCAL CreateDirectoryA(
    LPCSTR lpPathName,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern WINBOOL
 PASCAL CreateDirectoryExA(
    LPCSTR lpTemplateDirectory,
    LPCSTR lpNewDirectory,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern WINBOOL
 PASCAL RemoveDirectoryA(
    LPCSTR lpPathName
    );

extern DWORD
 PASCAL GetFullPathNameA(
    LPCSTR lpFileName,
    DWORD nBufferLength,
    LPSTR lpBuffer,
    LPSTR *lpFilePart
    );

extern WINBOOL
 PASCAL DefineDosDeviceA(
    DWORD dwFlags,
    LPCSTR lpDeviceName,
    LPCSTR lpTargetPath
    );

extern DWORD
 PASCAL QueryDosDeviceA(
    LPCSTR lpDeviceName,
    LPSTR lpTargetPath,
    DWORD ucchMax
    );

extern HANDLE
 PASCAL CreateFileA(
    LPCSTR lpFileName,
    DWORD dwDesiredAccess,
    DWORD dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD dwCreationDisposition,
    DWORD dwFlagsAndAttributes,
    HANDLE hTemplateFile
    );

extern WINBOOL
 PASCAL SetFileAttributesA(
    LPCSTR lpFileName,
    DWORD dwFileAttributes
    );

extern DWORD
 PASCAL GetFileAttributesA(
    LPCSTR lpFileName
    );

extern DWORD
 PASCAL GetCompressedFileSizeA(
    LPCSTR lpFileName,
    LPDWORD lpFileSizeHigh
    );

extern WINBOOL
 PASCAL DeleteFileA(
    LPCSTR lpFileName
    );

extern DWORD
 PASCAL SearchPathA(
	    LPCSTR lpPath,
    LPCSTR lpFileName,
    LPCSTR lpExtension,
    DWORD nBufferLength,
    LPSTR lpBuffer,
    LPSTR *lpFilePart
    );

extern WINBOOL
 PASCAL CopyFileA(
    LPCSTR lpExistingFileName,
    LPCSTR lpNewFileName,
    WINBOOL bFailIfExists
    );

extern WINBOOL
 PASCAL MoveFileA(
    LPCSTR lpExistingFileName,
    LPCSTR lpNewFileName
    );

extern WINBOOL
 PASCAL MoveFileExA(
    LPCSTR lpExistingFileName,
    LPCSTR lpNewFileName,
    DWORD dwFlags
    );

extern HANDLE
 PASCAL CreateNamedPipeA(
    LPCSTR lpName,
    DWORD dwOpenMode,
    DWORD dwPipeMode,
    DWORD nMaxInstances,
    DWORD nOutBufferSize,
    DWORD nInBufferSize,
    DWORD nDefaultTimeOut,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern WINBOOL
 PASCAL GetNamedPipeHandleStateA(
    HANDLE hNamedPipe,
    LPDWORD lpState,
    LPDWORD lpCurInstances,
    LPDWORD lpMaxCollectionCount,
    LPDWORD lpCollectDataTimeout,
    LPSTR lpUserName,
    DWORD nMaxUserNameSize
    );

extern WINBOOL
 PASCAL CallNamedPipeA(
    LPCSTR lpNamedPipeName,
    LPVOID lpInBuffer,
    DWORD nInBufferSize,
    LPVOID lpOutBuffer,
    DWORD nOutBufferSize,
    LPDWORD lpBytesRead,
    DWORD nTimeOut
    );

extern WINBOOL
 PASCAL WaitNamedPipeA(
    LPCSTR lpNamedPipeName,
    DWORD nTimeOut
    );

extern WINBOOL
 PASCAL SetVolumeLabelA(
    LPCSTR lpRootPathName,
    LPCSTR lpVolumeName
    );

extern WINBOOL
 PASCAL GetVolumeInformationA(
    LPCSTR lpRootPathName,
    LPSTR lpVolumeNameBuffer,
    DWORD nVolumeNameSize,
    LPDWORD lpVolumeSerialNumber,
    LPDWORD lpMaximumComponentLength,
    LPDWORD lpFileSystemFlags,
    LPSTR lpFileSystemNameBuffer,
    DWORD nFileSystemNameSize
    );

extern WINBOOL
 PASCAL ClearEventLogA(
    HANDLE hEventLog,
    LPCSTR lpBackupFileName
    );

extern WINBOOL
 PASCAL BackupEventLogA(
    HANDLE hEventLog,
    LPCSTR lpBackupFileName
    );

extern HANDLE
 PASCAL OpenEventLogA(
    LPCSTR lpUNCServerName,
    LPCSTR lpSourceName
    );

extern HANDLE
 PASCAL RegisterEventSourceA(
    LPCSTR lpUNCServerName,
    LPCSTR lpSourceName
    );

extern HANDLE
 PASCAL OpenBackupEventLogA(
    LPCSTR lpUNCServerName,
    LPCSTR lpFileName
    );

extern WINBOOL
 PASCAL ReadEventLogA(
     HANDLE     hEventLog,
     DWORD      dwReadFlags,
     DWORD      dwRecordOffset,
     LPVOID     lpBuffer,
     DWORD      nNumberOfBytesToRead,
     DWORD      *pnBytesRead,
     DWORD      *pnMinNumberOfBytesNeeded
    );

extern WINBOOL
 PASCAL ReportEventA(
     HANDLE     hEventLog,
     WORD       wType,
     WORD       wCategory,
     DWORD      dwEventID,
     PSID       lpUserSid,
     WORD       wNumStrings,
     DWORD      dwDataSize,
     LPCSTR   *lpStrings,
     LPVOID     lpRawData
    );

extern WINBOOL
 PASCAL AccessCheckAndAuditAlarmA(
    LPCSTR SubsystemName,
    LPVOID HandleId,
    LPSTR ObjectTypeName,
    LPSTR ObjectName,
    PSECURITY_DESCRIPTOR SecurityDescriptor,
    DWORD DesiredAccess,
    PGENERIC_MAPPING GenericMapping,
    WINBOOL ObjectCreation,
    LPDWORD GrantedAccess,
    LPBOOL AccessStatus,
    LPBOOL pfGenerateOnClose
    );

extern WINBOOL
 PASCAL ObjectOpenAuditAlarmA(
    LPCSTR SubsystemName,
    LPVOID HandleId,
    LPSTR ObjectTypeName,
    LPSTR ObjectName,
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    HANDLE ClientToken,
    DWORD DesiredAccess,
    DWORD GrantedAccess,
    PPRIVILEGE_SET Privileges,
    WINBOOL ObjectCreation,
    WINBOOL AccessGranted,
    LPBOOL GenerateOnClose
    );

extern WINBOOL
 PASCAL ObjectPrivilegeAuditAlarmA(
    LPCSTR SubsystemName,
    LPVOID HandleId,
    HANDLE ClientToken,
    DWORD DesiredAccess,
    PPRIVILEGE_SET Privileges,
    WINBOOL AccessGranted
    );

extern WINBOOL
 PASCAL ObjectCloseAuditAlarmA(
    LPCSTR SubsystemName,
    LPVOID HandleId,
    WINBOOL GenerateOnClose
    );

extern WINBOOL
 PASCAL PrivilegedServiceAuditAlarmA(
    LPCSTR SubsystemName,
    LPCSTR ServiceName,
    HANDLE ClientToken,
    PPRIVILEGE_SET Privileges,
    WINBOOL AccessGranted
    );

extern WINBOOL
 PASCAL SetFileSecurityA(
    LPCSTR lpFileName,
    SECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR pSecurityDescriptor
    );

extern WINBOOL
 PASCAL GetFileSecurityA(
    LPCSTR lpFileName,
    SECURITY_INFORMATION RequestedInformation,
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    DWORD nLength,
    LPDWORD lpnLengthNeeded
    );

extern HANDLE
 PASCAL FindFirstChangeNotificationA(
    LPCSTR lpPathName,
    WINBOOL bWatchSubtree,
    DWORD dwNotifyFilter
    );

extern WINBOOL
 PASCAL IsBadStringPtrA(
    LPCSTR lpsz,
    UINT ucchMax
    );

extern WINBOOL
 PASCAL LookupAccountSidA(
    LPCSTR lpSystemName,
    PSID Sid,
    LPSTR Name,
    LPDWORD cbName,
    LPSTR ReferencedDomainName,
    LPDWORD cbReferencedDomainName,
    PSID_NAME_USE peUse
    );

extern WINBOOL
 PASCAL LookupAccountNameA(
    LPCSTR lpSystemName,
    LPCSTR lpAccountName,
    PSID Sid,
    LPDWORD cbSid,
    LPSTR ReferencedDomainName,
    LPDWORD cbReferencedDomainName,
    PSID_NAME_USE peUse
    );

extern WINBOOL
 PASCAL LookupPrivilegeValueA(
    LPCSTR lpSystemName,
    LPCSTR lpName,
    PLUID   lpLuid
    );

extern WINBOOL
 PASCAL LookupPrivilegeNameA(
    LPCSTR lpSystemName,
    PLUID   lpLuid,
    LPSTR lpName,
    LPDWORD cbName
    );

extern WINBOOL
 PASCAL LookupPrivilegeDisplayNameA(
    LPCSTR lpSystemName,
    LPCSTR lpName,
    LPSTR lpDisplayName,
    LPDWORD cbDisplayName,
    LPDWORD lpLanguageId
    );

extern WINBOOL
 PASCAL BuildCommDCBA(
    LPCSTR lpDef,
    LPDCB lpDCB
    );

extern WINBOOL
 PASCAL BuildCommDCBAndTimeoutsA(
    LPCSTR lpDef,
    LPDCB lpDCB,
    LPCOMMTIMEOUTS lpCommTimeouts
    );

extern WINBOOL
 PASCAL CommConfigDialogA(
    LPCSTR lpszName,
    HWND hWnd,
    LPCOMMCONFIG lpCC
    );

extern WINBOOL
 PASCAL GetDefaultCommConfigA(
    LPCSTR lpszName,
    LPCOMMCONFIG lpCC,
    LPDWORD lpdwSize
    );

extern WINBOOL
 PASCAL SetDefaultCommConfigA(
    LPCSTR lpszName,
    LPCOMMCONFIG lpCC,
    DWORD dwSize
    );

extern WINBOOL
 PASCAL GetComputerNameA(
    LPSTR lpBuffer,
    LPDWORD nSize
    );

extern WINBOOL
 PASCAL SetComputerNameA(
    LPCSTR lpComputerName
    );

extern WINBOOL
 PASCAL GetUserNameA(
    LPSTR lpBuffer,
    LPDWORD nSize
    );

extern int
 PASCAL wvsprintfA(
    LPSTR,
    LPCSTR,
    va_list arglist);
 
extern int
wsprintfA(LPSTR, LPCSTR, ...);

extern HKL
 PASCAL LoadKeyboardLayoutA(
    LPCSTR pwszKLID,
    UINT Flags);
 
extern WINBOOL
 PASCAL GetKeyboardLayoutNameA(
    LPSTR pwszKLID);
 
extern HDESK
 PASCAL CreateDesktopA(
    LPSTR lpszDesktop,
    LPSTR lpszDevice,
    LPDEVMODE pDevmode,
    DWORD dwFlags,
    DWORD dwDesiredAccess,
    LPSECURITY_ATTRIBUTES lpsa);
 
extern HDESK
 PASCAL OpenDesktopA(
    LPSTR lpszDesktop,
    DWORD dwFlags,
    WINBOOL fInherit,
    DWORD dwDesiredAccess);
 
extern WINBOOL
 PASCAL EnumDesktopsA(
    HWINSTA hwinsta,
    DESKTOPENUMPROC lpEnumFunc,
    LPARAM lParam);
 
extern HWINSTA
 PASCAL CreateWindowStationA(
    LPSTR lpwinsta,
    DWORD dwReserved,
    DWORD dwDesiredAccess,
    LPSECURITY_ATTRIBUTES lpsa);
 
extern HWINSTA
 PASCAL OpenWindowStationA(
    LPSTR lpszWinSta,
    WINBOOL fInherit,
    DWORD dwDesiredAccess);
 
extern WINBOOL
 PASCAL EnumWindowStationsA(
    ENUMWINDOWSTATIONPROC lpEnumFunc,
    LPARAM lParam);
 
extern WINBOOL
 PASCAL GetUserObjectInformationA(
    HANDLE hObj,
    int nIndex,
    PVOID pvInfo,
    DWORD nLength,
    LPDWORD lpnLengthNeeded);
 
extern WINBOOL
 PASCAL SetUserObjectInformationA(
    HANDLE hObj,
    int nIndex,
    PVOID pvInfo,
    DWORD nLength);
 
extern UINT
 PASCAL RegisterWindowMessageA(
    LPCSTR lpString);
 
extern WINBOOL
 PASCAL GetMessageA(
    LPMSG lpMsg,
    HWND hWnd ,
    UINT wMsgFilterMin,
    UINT wMsgFilterMax);
 
extern LONG
 PASCAL DispatchMessageA(
    CONST MSG *lpMsg);
 
extern WINBOOL
 PASCAL PeekMessageA(
    LPMSG lpMsg,
    HWND hWnd ,
    UINT wMsgFilterMin,
    UINT wMsgFilterMax,
    UINT wRemoveMsg);
 
extern LRESULT
 PASCAL SendMessageA(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern LRESULT
 PASCAL SendMessageTimeoutA(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam,
    UINT fuFlags,
    UINT uTimeout,
    LPDWORD lpdwResult);
 
extern WINBOOL
 PASCAL SendNotifyMessageA(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern WINBOOL
 PASCAL SendMessageCallbackA(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam,
    SENDASYNCPROC lpResultCallBack,
    DWORD dwData);
 
extern WINBOOL
 PASCAL PostMessageA(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern WINBOOL
 PASCAL PostThreadMessageA(
    DWORD idThread,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern LRESULT
 PASCAL DefWindowProcA(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern LRESULT
 PASCAL CallWindowProcA(
    WNDPROC lpPrevWndFunc,
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern ATOM
 PASCAL RegisterClassA(
    CONST WNDCLASS *lpWndClass);
 
extern WINBOOL
 PASCAL UnregisterClassA(
    LPCSTR lpClassName,
    HINSTANCE hInstance);
 
extern WINBOOL
 PASCAL GetClassInfoA(
    HINSTANCE hInstance ,
    LPCSTR lpClassName,
    LPWNDCLASS lpWndClass);
 
extern ATOM
 PASCAL RegisterClassExA(CONST WNDCLASSEX *);
 
extern WINBOOL
 PASCAL GetClassInfoExA(HINSTANCE, LPCSTR, LPWNDCLASSEX);
 
extern HWND
 PASCAL CreateWindowExA(
    DWORD dwExStyle,
    LPCSTR lpClassName,
    LPCSTR lpWindowName,
    DWORD dwStyle,
    int X,
    int Y,
    int nWidth,
    int nHeight,
    HWND hWndParent ,
    HMENU hMenu,
    HINSTANCE hInstance,
    LPVOID lpParam);
 
extern HWND
 PASCAL CreateDialogParamA(
    HINSTANCE hInstance,
    LPCSTR lpTemplateName,
    HWND hWndParent ,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);
 
extern HWND
 PASCAL CreateDialogIndirectParamA(
    HINSTANCE hInstance,
    LPCDLGTEMPLATE lpTemplate,
    HWND hWndParent,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);
 
extern int
 PASCAL DialogBoxParamA(
    HINSTANCE hInstance,
    LPCSTR lpTemplateName,
    HWND hWndParent ,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);
 
extern int
 PASCAL DialogBoxIndirectParamA(
    HINSTANCE hInstance,
    LPCDLGTEMPLATE hDialogTemplate,
    HWND hWndParent ,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);
 
extern WINBOOL
 PASCAL SetDlgItemTextA(
    HWND hDlg,
    int nIDDlgItem,
    LPCSTR lpString);
 
extern UINT
 PASCAL GetDlgItemTextA(
    HWND hDlg,
    int nIDDlgItem,
    LPSTR lpString,
    int nMaxCount);
 
extern LONG
 PASCAL SendDlgItemMessageA(
    HWND hDlg,
    int nIDDlgItem,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern LRESULT
 PASCAL DefDlgProcA(
    HWND hDlg,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);
 
extern WINBOOL
 PASCAL CallMsgFilterA(
    LPMSG lpMsg,
    int nCode);
 
extern UINT
 PASCAL RegisterClipboardFormatA(
    LPCSTR lpszFormat);
 
extern int
 PASCAL GetClipboardFormatNameA(
    UINT format,
    LPSTR lpszFormatName,
    int cchMaxCount);
 
extern WINBOOL
 PASCAL CharToOemA(
    LPCSTR lpszSrc,
    LPSTR lpszDst);
 
extern WINBOOL
 PASCAL OemToCharA(
    LPCSTR lpszSrc,
    LPSTR lpszDst);
 
extern WINBOOL
 PASCAL CharToOemBuffA(
    LPCSTR lpszSrc,
    LPSTR lpszDst,
    DWORD cchDstLength);
 
extern WINBOOL
 PASCAL OemToCharBuffA(
    LPCSTR lpszSrc,
    LPSTR lpszDst,
    DWORD cchDstLength);
 
extern LPSTR
 PASCAL CharUpperA(
    LPSTR lpsz);
 
extern DWORD
 PASCAL CharUpperBuffA(
    LPSTR lpsz,
    DWORD cchLength);
 
extern LPSTR
 PASCAL CharLowerA(
    LPSTR lpsz);
 
extern DWORD
 PASCAL CharLowerBuffA(
    LPSTR lpsz,
    DWORD cchLength);
 
extern LPSTR
 PASCAL CharNextA(
    LPCSTR lpsz);
 
extern LPSTR
 PASCAL CharPrevA(
    LPCSTR lpszStart,
    LPCSTR lpszCurrent);
 
extern WINBOOL
 PASCAL IsCharAlphaA(
    CHAR ch);
 
extern WINBOOL
 PASCAL IsCharAlphaNumericA(
    CHAR ch);
 
extern WINBOOL
 PASCAL IsCharUpperA(
    CHAR ch);
 
extern WINBOOL
 PASCAL IsCharLowerA(
    CHAR ch);
 
extern int
 PASCAL GetKeyNameTextA(
    LONG lParam,
    LPSTR lpString,
    int nSize
    );
 
extern SHORT
 PASCAL VkKeyScanA(
    CHAR ch);
 
extern SHORT
 PASCAL VkKeyScanExA(
    CHAR  ch,
    HKL   dwhkl);
 
extern UINT
 PASCAL MapVirtualKeyA(
    UINT uCode,
    UINT uMapType);
 
extern UINT
 PASCAL MapVirtualKeyExA(
    UINT uCode,
    UINT uMapType,
    HKL dwhkl);
 
extern HACCEL
 PASCAL LoadAcceleratorsA(
    HINSTANCE hInstance,
    LPCSTR lpTableName);
 
extern HACCEL
 PASCAL CreateAcceleratorTableA(
    LPACCEL, int);
 
extern int
 PASCAL CopyAcceleratorTableA(
    HACCEL hAccelSrc,
    LPACCEL lpAccelDst,
    int cAccelEntries);
 
extern int
 PASCAL TranslateAcceleratorA(
    HWND hWnd,
    HACCEL hAccTable,
    LPMSG lpMsg);
 
extern HMENU
 PASCAL LoadMenuA(
    HINSTANCE hInstance,
    LPCSTR lpMenuName);
 
extern HMENU
 PASCAL LoadMenuIndirectA(
    CONST MENUTEMPLATE *lpMenuTemplate);
 
extern WINBOOL
 PASCAL ChangeMenuA(
    HMENU hMenu,
    UINT cmd,
    LPCSTR lpszNewItem,
    UINT cmdInsert,
    UINT flags);
 
extern int
 PASCAL GetMenuStringA(
    HMENU hMenu,
    UINT uIDItem,
    LPSTR lpString,
    int nMaxCount,
    UINT uFlag);
 
extern WINBOOL
 PASCAL InsertMenuA(
    HMENU hMenu,
    UINT uPosition,
    UINT uFlags,
    UINT uIDNewItem,
    LPCSTR lpNewItem
    );
 
extern WINBOOL
 PASCAL AppendMenuA(
    HMENU hMenu,
    UINT uFlags,
    UINT uIDNewItem,
    LPCSTR lpNewItem
    );
 
extern WINBOOL
 PASCAL ModifyMenuA(
    HMENU hMnu,
    UINT uPosition,
    UINT uFlags,
    UINT uIDNewItem,
    LPCSTR lpNewItem
    );
 
extern WINBOOL
 PASCAL InsertMenuItemA(
    HMENU,
    UINT,
    WINBOOL,
    LPCMENUITEMINFO
    );
 
extern WINBOOL
 PASCAL GetMenuItemInfoA(
    HMENU,
    UINT,
    WINBOOL,
    LPMENUITEMINFO
    );
 
extern WINBOOL
 PASCAL SetMenuItemInfoA(
    HMENU,
    UINT,
    WINBOOL,
    LPCMENUITEMINFO
    );
 
extern int
 PASCAL DrawTextA(
    HDC hDC,
    LPCSTR lpString,
    int nCount,
    LPRECT lpRect,
    UINT uFormat);
 
extern int
 PASCAL DrawTextExA(HDC, LPSTR, int, LPRECT, UINT, LPDRAWTEXTPARAMS);
 
extern WINBOOL
 PASCAL GrayStringA(
    HDC hDC,
    HBRUSH hBrush,
    GRAYSTRINGPROC lpOutputFunc,
    LPARAM lpData,
    int nCount,
    int X,
    int Y,
    int nWidth,
    int nHeight);
 
extern WINBOOL
 PASCAL DrawStateA(HDC, HBRUSH, DRAWSTATEPROC, LPARAM, WPARAM, int, int, int, int, UINT);

extern LONG
 PASCAL TabbedTextOutA(
    HDC hDC,
    int X,
    int Y,
    LPCSTR lpString,
    int nCount,
    int nTabPositions,
    LPINT lpnTabStopPositions,
    int nTabOrigin);
 
extern DWORD
 PASCAL GetTabbedTextExtentA(
    HDC hDC,
    LPCSTR lpString,
    int nCount,
    int nTabPositions,
    LPINT lpnTabStopPositions);
 
extern WINBOOL
 PASCAL SetPropA(
    HWND hWnd,
    LPCSTR lpString,
    HANDLE hData);
 
extern HANDLE
 PASCAL GetPropA(
    HWND hWnd,
    LPCSTR lpString);
 
extern HANDLE
 PASCAL RemovePropA(
    HWND hWnd,
    LPCSTR lpString);
 
extern int
 PASCAL EnumPropsExA(
    HWND hWnd,
    PROPENUMPROCEX lpEnumFunc,
    LPARAM lParam);
 
extern int
 PASCAL EnumPropsA(
    HWND hWnd,
    PROPENUMPROC lpEnumFunc);
 
extern WINBOOL
 PASCAL SetWindowTextA(
    HWND hWnd,
    LPCSTR lpString);
 
extern int
 PASCAL GetWindowTextA(
    HWND hWnd,
    LPSTR lpString,
    int nMaxCount);
 
extern int
 PASCAL GetWindowTextLengthA(
    HWND hWnd);
 
extern int
PASCAL MessageBoxA(
    HWND hWnd ,
    LPCSTR lpText,
    LPCSTR lpCaption,
    UINT uType);
 
extern int
 PASCAL MessageBoxExA(
    HWND hWnd ,
    LPCSTR lpText,
    LPCSTR lpCaption,
    UINT uType,
    WORD wLanguageId);
 
extern int
 PASCAL MessageBoxIndirectA(LPMSGBOXPARAMS);

extern LONG
 PASCAL GetWindowLongA(
    HWND hWnd,
    int nIndex);
 
extern LONG
 PASCAL SetWindowLongA(
    HWND hWnd,
    int nIndex,
    LONG dwNewLong);
 
extern DWORD
 PASCAL GetClassLongA(
    HWND hWnd,
    int nIndex);
 
extern DWORD
 PASCAL SetClassLongA(
    HWND hWnd,
    int nIndex,
    LONG dwNewLong);
 
extern HWND
 PASCAL FindWindowA(
    LPCSTR lpClassName ,
    LPCSTR lpWindowName);
 
extern HWND
 PASCAL FindWindowExA(HWND, HWND, LPCSTR, LPCSTR);

extern int
 PASCAL GetClassNameA(
    HWND hWnd,
    LPSTR lpClassName,
    int nMaxCount);
 
extern HHOOK
 PASCAL SetWindowsHookExA(
    int idHook,
    HOOKPROC lpfn,
    HINSTANCE hmod,
    DWORD dwThreadId);
 
extern HBITMAP
 PASCAL LoadBitmapA(
    HINSTANCE hInstance,
    LPCSTR lpBitmapName);
 
extern HCURSOR
 PASCAL LoadCursorA(
    HINSTANCE hInstance,
    LPCSTR lpCursorName);
 
extern HCURSOR
 PASCAL LoadCursorFromFileA(
    LPCSTR    lpFileName);
 
extern HICON
 PASCAL LoadIconA(
    HINSTANCE hInstance,
    LPCSTR lpIconName);
 
extern HANDLE
 PASCAL LoadImageA(
    HINSTANCE,
    LPCSTR,
    UINT,
    int,
    int,
    UINT);
 
extern int
 PASCAL LoadStringA(
    HINSTANCE hInstance,
    UINT uID,
    LPSTR lpBuffer,
    int nBufferMax);
 
extern WINBOOL
 PASCAL IsDialogMessageA(
    HWND hDlg,
    LPMSG lpMsg);
 
extern int
 PASCAL DlgDirListA(
    HWND hDlg,
    LPSTR lpPathSpec,
    int nIDListBox,
    int nIDStaticPath,
    UINT uFileType);
 
extern WINBOOL
 PASCAL DlgDirSelectExA(
    HWND hDlg,
    LPSTR lpString,
    int nCount,
    int nIDListBox);
 
extern int
 PASCAL DlgDirListComboBoxA(
    HWND hDlg,
    LPSTR lpPathSpec,
    int nIDComboBox,
    int nIDStaticPath,
    UINT uFiletype);
 
extern WINBOOL
 PASCAL DlgDirSelectComboBoxExA(
    HWND hDlg,
    LPSTR lpString,
    int nCount,
    int nIDComboBox);
 
extern LRESULT
 PASCAL DefFrameProcA(
    HWND hWnd,
    HWND hWndMDIClient ,
    UINT uMsg,
    WPARAM wParam,
    LPARAM lParam);
 
extern LRESULT
 PASCAL DefMDIChildProcA(
    HWND hWnd,
    UINT uMsg,
    WPARAM wParam,
    LPARAM lParam);
 
extern HWND
 PASCAL CreateMDIWindowA(
    LPSTR lpClassName,
    LPSTR lpWindowName,
    DWORD dwStyle,
    int X,
    int Y,
    int nWidth,
    int nHeight,
    HWND hWndParent,
    HINSTANCE hInstance,
    LPARAM lParam
    );
 
extern WINBOOL
 PASCAL WinHelpA(
    HWND hWndMain,
    LPCSTR lpszHelp,
    UINT uCommand,
    DWORD dwData
    );
 
extern LONG
 PASCAL ChangeDisplaySettingsA(
    LPDEVMODE lpDevMode,
    DWORD dwFlags);
 
extern WINBOOL
 PASCAL EnumDisplaySettingsA(
    LPCSTR lpszDeviceName,
    DWORD iModeNum,
    LPDEVMODE lpDevMode);
 
extern WINBOOL
 PASCAL SystemParametersInfoA(
    UINT uiAction,
    UINT uiParam,
    PVOID pvParam,
    UINT fWinIni);
 
extern int
 PASCAL AddFontResourceA(LPCSTR);

extern HMETAFILE
 PASCAL CopyMetaFileA(HMETAFILE, LPCSTR);

extern HFONT
 PASCAL CreateFontIndirectA(CONST LOGFONT *);

extern HDC
 PASCAL CreateICA(LPCSTR, LPCSTR , LPCSTR , CONST DEVMODE *);

extern HDC
 PASCAL CreateMetaFileA(LPCSTR);

extern WINBOOL
 PASCAL CreateScalableFontResourceA(DWORD, LPCSTR, LPCSTR, LPCSTR);

extern int
 PASCAL DeviceCapabilitiesA(LPCSTR, LPCSTR, WORD,
                                LPSTR, CONST DEVMODE *);

extern int
 PASCAL EnumFontFamiliesExA(HDC, LPLOGFONT, FONTENUMEXPROC, LPARAM,DWORD);

extern int
 PASCAL EnumFontFamiliesA(HDC, LPCSTR, FONTENUMPROC, LPARAM);

extern int
 PASCAL EnumFontsA(HDC, LPCSTR,  ENUMFONTSPROC, LPARAM);

extern WINBOOL
 PASCAL GetCharWidthA(HDC, UINT, UINT, LPINT);

extern WINBOOL
 PASCAL GetCharWidth32A(HDC, UINT, UINT, LPINT);

extern WINBOOL
 PASCAL GetCharWidthFloatA(HDC, UINT, UINT, PFLOAT);

extern WINBOOL
 PASCAL GetCharABCWidthsA(HDC, UINT, UINT, LPABC);

extern WINBOOL
 PASCAL GetCharABCWidthsFloatA(HDC, UINT, UINT, LPABCFLOAT);
extern DWORD
 PASCAL GetGlyphOutlineA(HDC, UINT, UINT, LPGLYPHMETRICS, DWORD, LPVOID, CONST MAT2 *);

extern HMETAFILE
 PASCAL GetMetaFileA(LPCSTR);

extern UINT
 PASCAL GetOutlineTextMetricsA(HDC, UINT, LPOUTLINETEXTMETRIC);

extern WINBOOL
 PASCAL GetTextExtentPointA(
                    HDC,
                    LPCSTR,
                    int,
                    LPSIZE
                    );

extern WINBOOL
 PASCAL GetTextExtentPoint32A(
                    HDC,
                    LPCSTR,
                    int,
                    LPSIZE
                    );

extern WINBOOL
 PASCAL GetTextExtentExPointA(
                    HDC,
                    LPCSTR,
                    int,
                    int,
                    LPINT,
                    LPINT,
                    LPSIZE
                    );

extern DWORD
 PASCAL GetCharacterPlacementA(HDC, LPCSTR, int, int, LPGCP_RESULTS, DWORD);

extern HDC
 PASCAL ResetDCA(HDC, CONST DEVMODE *);

extern WINBOOL
 PASCAL RemoveFontResourceA(LPCSTR);

extern HENHMETAFILE
 PASCAL CopyEnhMetaFileA(HENHMETAFILE, LPCSTR);

extern HDC
 PASCAL CreateEnhMetaFileA(HDC, LPCSTR, CONST RECT *, LPCSTR);

extern HENHMETAFILE
 PASCAL GetEnhMetaFileA(LPCSTR);

extern UINT
 PASCAL GetEnhMetaFileDescriptionA(HENHMETAFILE, UINT, LPSTR );

extern WINBOOL
 PASCAL GetTextMetricsA(HDC, LPTEXTMETRIC);

extern int
 PASCAL StartDocA(HDC, CONST DOCINFO *);

extern int
 PASCAL GetObjectA(HGDIOBJ, int, LPVOID);

extern WINBOOL
 PASCAL TextOutA(HDC, int, int, LPCSTR, int);

extern WINBOOL
 PASCAL ExtTextOutA(HDC, int, int, UINT, CONST RECT *,LPCSTR, UINT, CONST INT *);

extern WINBOOL
 PASCAL PolyTextOutA(HDC, CONST POLYTEXT *, int); 

extern int
 PASCAL GetTextFaceA(HDC, int, LPSTR);

extern DWORD
 PASCAL GetKerningPairsA(HDC, DWORD, LPKERNINGPAIR);

extern HCOLORSPACE
 PASCAL CreateColorSpaceA(LPLOGCOLORSPACE);

extern WINBOOL
 PASCAL GetLogColorSpaceA(HCOLORSPACE,LPLOGCOLORSPACE,DWORD);

extern WINBOOL
 PASCAL GetICMProfileA(HDC,DWORD,LPSTR);

extern WINBOOL
 PASCAL SetICMProfileA(HDC,LPSTR);

extern WINBOOL
 PASCAL UpdateICMRegKeyA(DWORD, DWORD, LPSTR, UINT);

extern int
 PASCAL EnumICMProfilesA(HDC,ICMENUMPROC,LPARAM);

extern int
 PASCAL PropertySheetA(LPCPROPSHEETHEADER lppsph);

extern HIMAGELIST
 PASCAL ImageList_LoadImageA(HINSTANCE hi, LPCSTR lpbmp, int cx, int cGrow, COLORREF crMask, UINT uType, UINT uFlags);

extern HWND
 PASCAL CreateStatusWindowA(LONG style, LPCSTR lpszText, HWND hwndParent, UINT wID);

extern void
 PASCAL DrawStatusTextA(HDC hDC, LPRECT lprc, LPCSTR pszText, UINT uFlags);

extern WINBOOL
 PASCAL GetOpenFileNameA(LPOPENFILENAME);

extern WINBOOL
 PASCAL GetSaveFileNameA(LPOPENFILENAME);

extern short
 PASCAL GetFileTitleA(LPCSTR, LPSTR, WORD);

extern WINBOOL
 PASCAL ChooseColorA(LPCHOOSECOLOR);

extern HWND
 PASCAL FindTextA(LPFINDREPLACE);

extern HWND
 PASCAL ReplaceTextA(LPFINDREPLACE);

extern WINBOOL
 PASCAL ChooseFontA(LPCHOOSEFONT);

extern WINBOOL
 PASCAL PrintDlgA(LPPRINTDLG);

extern WINBOOL
 PASCAL PageSetupDlgA( LPPAGESETUPDLG );

extern WINBOOL
 PASCAL CreateProcessA(
    LPCSTR lpApplicationName,
    LPSTR lpCommandLine,
    LPSECURITY_ATTRIBUTES lpProcessAttributes,
    LPSECURITY_ATTRIBUTES lpThreadAttributes,
    WINBOOL bInheritHandles,
    DWORD dwCreationFlags,
    LPVOID lpEnvironment,
    LPCSTR lpCurrentDirectory,
    LPSTARTUPINFO lpStartupInfo,
    LPPROCESS_INFORMATION lpProcessInformation
    );

extern VOID
 PASCAL GetStartupInfoA(
    LPSTARTUPINFO lpStartupInfo
    );

extern HANDLE
 PASCAL FindFirstFileA(
    LPCSTR lpFileName,
    LPWIN32_FIND_DATA lpFindFileData
    );

extern WINBOOL
 PASCAL FindNextFileA(
    HANDLE hFindFile,
    LPWIN32_FIND_DATA lpFindFileData
    );

extern WINBOOL
 PASCAL GetVersionExA(
    LPOSVERSIONINFO lpVersionInformation
    );

#define CreateWindowA(lpClassName, lpWindowName, dwStyle, x, y,\
nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam)\
CreateWindowExA(0L, lpClassName, lpWindowName, dwStyle, x, y,\
nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam)

#define CreateDialogA(hInstance, lpName, hWndParent, lpDialogFunc) \
CreateDialogParamA(hInstance, lpName, hWndParent, lpDialogFunc, 0L)

#define CreateDialogIndirectA(hInstance, lpTemplate, hWndParent, lpDialogFunc) \
CreateDialogIndirectParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)

#define DialogBoxA(hInstance, lpTemplate, hWndParent, lpDialogFunc) \
DialogBoxParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)

#define DialogBoxIndirectA(hInstance, lpTemplate, hWndParent, lpDialogFunc) \
DialogBoxIndirectParamA(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)

extern HDC
 PASCAL CreateDCA(LPCSTR, LPCSTR , LPCSTR , CONST DEVMODE *);

extern DWORD
 PASCAL VerInstallFileA(
        DWORD uFlags,
        LPSTR szSrcFileName,
        LPSTR szDestFileName,
        LPSTR szSrcDir,
        LPSTR szDestDir,
        LPSTR szCurDir,
        LPSTR szTmpFile,
        PUINT lpuTmpFileLen
        );

extern DWORD
 PASCAL GetFileVersionInfoSizeA(
        LPSTR lptstrFilename,
        LPDWORD lpdwHandle
        );

extern WINBOOL
 PASCAL GetFileVersionInfoA(
        LPSTR lptstrFilename,
        DWORD dwHandle,
        DWORD dwLen,
        LPVOID lpData
        );

extern DWORD
 PASCAL VerLanguageNameA(
        DWORD wLang,
        LPSTR szLang,
        DWORD nSize
        );

extern WINBOOL
 PASCAL VerQueryValueA(
        const LPVOID pBlock,
        LPSTR lpSubBlock,
        LPVOID * lplpBuffer,
        PUINT puLen
        );

extern DWORD
 PASCAL VerFindFileA(
        DWORD uFlags,
        LPSTR szFileName,
        LPSTR szWinDir,
        LPSTR szAppDir,
        LPSTR szCurDir,
        PUINT lpuCurDirLen,
        LPSTR szDestDir,
        PUINT lpuDestDirLen
        );

extern LONG
 PASCAL RegConnectRegistryA(
    LPSTR lpMachineName,
    HKEY hKey,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegCreateKeyA(
    HKEY hKey,
    LPCSTR lpSubKey,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegCreateKeyExA(
    HKEY hKey,
    LPCSTR lpSubKey,
    DWORD Reserved,
    LPSTR lpClass,
    DWORD dwOptions,
    REGSAM samDesired,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    PHKEY phkResult,
    LPDWORD lpdwDisposition
    );

extern LONG
 PASCAL RegDeleteKeyA(
    HKEY hKey,
    LPCSTR lpSubKey
    );

extern LONG
 PASCAL RegDeleteValueA(
    HKEY hKey,
    LPCSTR lpValueName
    );

extern LONG
 PASCAL RegEnumKeyA(
    HKEY hKey,
    DWORD dwIndex,
    LPSTR lpName,
    DWORD cbName
    );

extern LONG
 PASCAL RegEnumKeyExA(
    HKEY hKey,
    DWORD dwIndex,
    LPSTR lpName,
    LPDWORD lpcbName,
    LPDWORD lpReserved,
    LPSTR lpClass,
    LPDWORD lpcbClass,
    PFILETIME lpftLastWriteTime
    );

extern LONG
 PASCAL RegEnumValueA(
    HKEY hKey,
    DWORD dwIndex,
    LPSTR lpValueName,
    LPDWORD lpcbValueName,
    LPDWORD lpReserved,
    LPDWORD lpType,
    LPBYTE lpData,
    LPDWORD lpcbData
    );

extern LONG
 PASCAL RegLoadKeyA(
    HKEY    hKey,
    LPCSTR  lpSubKey,
    LPCSTR  lpFile
    );

extern LONG
 PASCAL RegOpenKeyA(
    HKEY hKey,
    LPCSTR lpSubKey,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegOpenKeyExA(
    HKEY hKey,
    LPCSTR lpSubKey,
    DWORD ulOptions,
    REGSAM samDesired,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegQueryInfoKeyA(
    HKEY hKey,
    LPSTR lpClass,
    LPDWORD lpcbClass,
    LPDWORD lpReserved,
    LPDWORD lpcSubKeys,
    LPDWORD lpcbMaxSubKeyLen,
    LPDWORD lpcbMaxClassLen,
    LPDWORD lpcValues,
    LPDWORD lpcbMaxValueNameLen,
    LPDWORD lpcbMaxValueLen,
    LPDWORD lpcbSecurityDescriptor,
    PFILETIME lpftLastWriteTime
    );

extern LONG
 PASCAL RegQueryValueA(
    HKEY hKey,
    LPCSTR lpSubKey,
    LPSTR lpValue,
    PLONG   lpcbValue
    );

extern LONG
 PASCAL RegQueryMultipleValuesA(
    HKEY hKey,
    PVALENT val_list,
    DWORD num_vals,
    LPSTR lpValueBuf,
    LPDWORD ldwTotsize
    );

extern LONG
 PASCAL RegQueryValueExA(
    HKEY hKey,
    LPCSTR lpValueName,
    LPDWORD lpReserved,
    LPDWORD lpType,
    LPBYTE lpData,
    LPDWORD lpcbData
    );

extern LONG
 PASCAL RegReplaceKeyA(
    HKEY     hKey,
    LPCSTR  lpSubKey,
    LPCSTR  lpNewFile,
    LPCSTR  lpOldFile
    );

extern LONG
 PASCAL RegRestoreKeyA(
    HKEY hKey,
    LPCSTR lpFile,
    DWORD   dwFlags
    );

extern LONG
 PASCAL RegSaveKeyA(
    HKEY hKey,
    LPCSTR lpFile,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern LONG
 PASCAL RegSetValueA(
    HKEY hKey,
    LPCSTR lpSubKey,
    DWORD dwType,
    LPCSTR lpData,
    DWORD cbData
    );

extern LONG
 PASCAL RegSetValueExA(
    HKEY hKey,
    LPCSTR lpValueName,
    DWORD Reserved,
    DWORD dwType,
    CONST BYTE* lpData,
    DWORD cbData
    );

extern LONG
 PASCAL RegUnLoadKeyA(
    HKEY    hKey,
    LPCSTR lpSubKey
    );

extern WINBOOL
 PASCAL InitiateSystemShutdownA(
    LPSTR lpMachineName,
    LPSTR lpMessage,
    DWORD dwTimeout,
    WINBOOL bForceAppsClosed,
    WINBOOL bRebootAfterShutdown
    );

extern WINBOOL
 PASCAL AbortSystemShutdownA(
    LPSTR lpMachineName
    );

extern int
 PASCAL CompareStringA(
    LCID     Locale,
    DWORD    dwCmpFlags,
    LPCSTR lpString1,
    int      cchCount1,
    LPCSTR lpString2,
    int      cchCount2);

extern int
 PASCAL LCMapStringA(
    LCID     Locale,
    DWORD    dwMapFlags,
    LPCSTR lpSrcStr,
    int      cchSrc,
    LPSTR  lpDestStr,
    int      cchDest);

extern int
 PASCAL GetLocaleInfoA(
    LCID     Locale,
    LCTYPE   LCType,
    LPSTR  lpLCData,
    int      cchData);

extern WINBOOL
 PASCAL SetLocaleInfoA(
    LCID     Locale,
    LCTYPE   LCType,
    LPCSTR lpLCData);

extern int
 PASCAL GetTimeFormatA(
    LCID     Locale,
    DWORD    dwFlags,
    CONST SYSTEMTIME *lpTime,
    LPCSTR lpFormat,
    LPSTR  lpTimeStr,
    int      cchTime);

extern int
 PASCAL GetDateFormatA(
    LCID     Locale,
    DWORD    dwFlags,
    CONST SYSTEMTIME *lpDate,
    LPCSTR lpFormat,
    LPSTR  lpDateStr,
    int      cchDate);

extern int
 PASCAL GetNumberFormatA(
    LCID     Locale,
    DWORD    dwFlags,
    LPCSTR lpValue,
    CONST NUMBERFMT *lpFormat,
    LPSTR  lpNumberStr,
    int      cchNumber);

extern int
 PASCAL GetCurrencyFormatA(
    LCID     Locale,
    DWORD    dwFlags,
    LPCSTR lpValue,
    CONST CURRENCYFMT *lpFormat,
    LPSTR  lpCurrencyStr,
    int      cchCurrency);

extern WINBOOL
 PASCAL EnumCalendarInfoA(
    CALINFO_ENUMPROC lpCalInfoEnumProc,
    LCID              Locale,
    CALID             Calendar,
    CALTYPE           CalType);

extern WINBOOL
 PASCAL EnumTimeFormatsA(
    TIMEFMT_ENUMPROC lpTimeFmtEnumProc,
    LCID              Locale,
    DWORD             dwFlags);

extern WINBOOL
 PASCAL EnumDateFormatsA(
    DATEFMT_ENUMPROC lpDateFmtEnumProc,
    LCID              Locale,
    DWORD             dwFlags);

extern WINBOOL
 PASCAL GetStringTypeExA(
    LCID     Locale,
    DWORD    dwInfoType,
    LPCSTR lpSrcStr,
    int      cchSrc,
    LPWORD   lpCharType);

extern WINBOOL
 PASCAL GetStringTypeA(
    LCID     Locale,
    DWORD    dwInfoType,
    LPCSTR   lpSrcStr,
    int      cchSrc,
    LPWORD   lpCharType);


extern int
 PASCAL FoldStringA(
    DWORD    dwMapFlags,
    LPCSTR lpSrcStr,
    int      cchSrc,
    LPSTR  lpDestStr,
    int      cchDest);

extern WINBOOL
 PASCAL EnumSystemLocalesA(
    LOCALE_ENUMPROC lpLocaleEnumProc,
    DWORD            dwFlags);

extern WINBOOL
 PASCAL EnumSystemCodePagesA(
    CODEPAGE_ENUMPROC lpCodePageEnumProc,
    DWORD              dwFlags);

extern WINBOOL
 PASCAL PeekConsoleInputA(
    HANDLE hConsoleInput,
    PINPUT_RECORD lpBuffer,
    DWORD nLength,
    LPDWORD lpNumberOfEventsRead
    );

extern WINBOOL
 PASCAL ReadConsoleInputA(
    HANDLE hConsoleInput,
    PINPUT_RECORD lpBuffer,
    DWORD nLength,
    LPDWORD lpNumberOfEventsRead
    );

extern WINBOOL
 PASCAL WriteConsoleInputA(
    HANDLE hConsoleInput,
    CONST INPUT_RECORD *lpBuffer,
    DWORD nLength,
    LPDWORD lpNumberOfEventsWritten
    );

extern WINBOOL
 PASCAL ReadConsoleOutputA(
    HANDLE hConsoleOutput,
    PCHAR_INFO lpBuffer,
    COORD dwBufferSize,
    COORD dwBufferCoord,
    PSMALL_RECT lpReadRegion
    );

extern WINBOOL
 PASCAL WriteConsoleOutputA(
    HANDLE hConsoleOutput,
    CONST CHAR_INFO *lpBuffer,
    COORD dwBufferSize,
    COORD dwBufferCoord,
    PSMALL_RECT lpWriteRegion
    );

extern WINBOOL
 PASCAL ReadConsoleOutputCharacterA(
    HANDLE hConsoleOutput,
    LPSTR lpCharacter,
    DWORD nLength,
    COORD dwReadCoord,
    LPDWORD lpNumberOfCharsRead
    );

extern WINBOOL
 PASCAL WriteConsoleOutputCharacterA(
    HANDLE hConsoleOutput,
    LPCSTR lpCharacter,
    DWORD nLength,
    COORD dwWriteCoord,
    LPDWORD lpNumberOfCharsWritten
    );

extern WINBOOL
 PASCAL FillConsoleOutputCharacterA(
    HANDLE hConsoleOutput,
    CHAR  cCharacter,
    DWORD  nLength,
    COORD  dwWriteCoord,
    LPDWORD lpNumberOfCharsWritten
    );

extern WINBOOL
 PASCAL ScrollConsoleScreenBufferA(
    HANDLE hConsoleOutput,
    CONST SMALL_RECT *lpScrollRectangle,
    CONST SMALL_RECT *lpClipRectangle,
    COORD dwDestinationOrigin,
    CONST CHAR_INFO *lpFill
    );

extern DWORD
 PASCAL GetConsoleTitleA(
    LPSTR lpConsoleTitle,
    DWORD nSize
    );

extern WINBOOL
 PASCAL SetConsoleTitleA(
    LPCSTR lpConsoleTitle
    );

extern WINBOOL
 PASCAL ReadConsoleA(
    HANDLE hConsoleInput,
    LPVOID lpBuffer,
    DWORD nNumberOfCharsToRead,
    LPDWORD lpNumberOfCharsRead,
    LPVOID lpReserved
    );

extern WINBOOL
 PASCAL WriteConsoleA(
    HANDLE hConsoleOutput,
    CONST VOID *lpBuffer,
    DWORD nNumberOfCharsToWrite,
    LPDWORD lpNumberOfCharsWritten,
    LPVOID lpReserved
    );

extern DWORD  PASCAL WNetAddConnectionA(
     LPCSTR   lpRemoteName,
     LPCSTR   lpPassword,
     LPCSTR   lpLocalName
    );

extern DWORD  PASCAL WNetAddConnection2A(
     LPNETRESOURCE lpNetResource,
     LPCSTR       lpPassword,
     LPCSTR       lpUserName,
     DWORD          dwFlags
    );

extern DWORD  PASCAL WNetAddConnection3A(
     HWND           hwndOwner,
     LPNETRESOURCE lpNetResource,
     LPCSTR       lpPassword,
     LPCSTR       lpUserName,
     DWORD          dwFlags
    );

extern DWORD  PASCAL WNetCancelConnectionA(
     LPCSTR lpName,
     WINBOOL     fForce
    );

extern DWORD  PASCAL WNetCancelConnection2A(
     LPCSTR lpName,
     DWORD    dwFlags,
     WINBOOL     fForce
    );

extern DWORD  PASCAL WNetGetConnectionA(
     LPCSTR lpLocalName,
     LPSTR  lpRemoteName,
     LPDWORD  lpnLength
    );

extern DWORD  PASCAL WNetUseConnectionA(
    HWND            hwndOwner,
    LPNETRESOURCE  lpNetResource,
    LPCSTR        lpUserID,
    LPCSTR        lpPassword,
    DWORD           dwFlags,
    LPSTR         lpAccessName,
    LPDWORD         lpBufferSize,
    LPDWORD         lpResult
    );

extern DWORD  PASCAL WNetSetConnectionA(
    LPCSTR    lpName,
    DWORD       dwProperties,
    LPVOID      pvValues
    );

extern DWORD  PASCAL WNetConnectionDialog1A(
    LPCONNECTDLGSTRUCT lpConnDlgStruct
    );

extern DWORD  PASCAL WNetDisconnectDialog1A(
    LPDISCDLGSTRUCT lpConnDlgStruct
    );

extern DWORD  PASCAL WNetOpenEnumA(
     DWORD          dwScope,
     DWORD          dwType,
     DWORD          dwUsage,
     LPNETRESOURCE lpNetResource,
     LPHANDLE       lphEnum
    );

extern DWORD  PASCAL WNetEnumResourceA(
     HANDLE  hEnum,
     LPDWORD lpcCount,
     LPVOID  lpBuffer,
     LPDWORD lpBufferSize
    );

extern DWORD  PASCAL WNetGetUniversalNameA(
     LPCSTR lpLocalPath,
     DWORD    dwInfoLevel,
     LPVOID   lpBuffer,
     LPDWORD  lpBufferSize
     );

extern DWORD  PASCAL WNetGetUserA(
     LPCSTR  lpName,
     LPSTR   lpUserName,
     LPDWORD   lpnLength
    );

extern DWORD  PASCAL WNetGetProviderNameA(
    DWORD   dwNetType,
    LPSTR lpProviderName,
    LPDWORD lpBufferSize
    );

extern DWORD  PASCAL WNetGetNetworkInformationA(
    LPCSTR          lpProvider,
    LPNETINFOSTRUCT   lpNetInfoStruct
    );

extern DWORD  PASCAL WNetGetLastErrorA(
     LPDWORD    lpError,
     LPSTR    lpErrorBuf,
     DWORD      nErrorBufSize,
     LPSTR    lpNameBuf,
     DWORD      nNameBufSize
    );

extern DWORD  PASCAL MultinetGetConnectionPerformanceA(
        LPNETRESOURCE lpNetResource,
        LPNETCONNECTINFOSTRUCT lpNetConnectInfoStruct
        );

extern WINBOOL
 PASCAL ChangeServiceConfigA(
    SC_HANDLE    hService,
    DWORD        dwServiceType,
    DWORD        dwStartType,
    DWORD        dwErrorControl,
    LPCSTR     lpBinaryPathName,
    LPCSTR     lpLoadOrderGroup,
    LPDWORD      lpdwTagId,
    LPCSTR     lpDependencies,
    LPCSTR     lpServiceStartName,
    LPCSTR     lpPassword,
    LPCSTR     lpDisplayName
    );

extern SC_HANDLE
 PASCAL CreateServiceA(
    SC_HANDLE    hSCManager,
    LPCSTR     lpServiceName,
    LPCSTR     lpDisplayName,
    DWORD        dwDesiredAccess,
    DWORD        dwServiceType,
    DWORD        dwStartType,
    DWORD        dwErrorControl,
    LPCSTR     lpBinaryPathName,
    LPCSTR     lpLoadOrderGroup,
    LPDWORD      lpdwTagId,
    LPCSTR     lpDependencies,
    LPCSTR     lpServiceStartName,
    LPCSTR     lpPassword
    );

extern WINBOOL
 PASCAL EnumDependentServicesA(
    SC_HANDLE               hService,
    DWORD                   dwServiceState,
    LPENUM_SERVICE_STATUS  lpServices,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded,
    LPDWORD                 lpServicesReturned
    );

extern WINBOOL
 PASCAL EnumServicesStatusA(
    SC_HANDLE               hSCManager,
    DWORD                   dwServiceType,
    DWORD                   dwServiceState,
    LPENUM_SERVICE_STATUS  lpServices,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded,
    LPDWORD                 lpServicesReturned,
    LPDWORD                 lpResumeHandle
    );

extern WINBOOL
 PASCAL GetServiceKeyNameA(
    SC_HANDLE               hSCManager,
    LPCSTR                lpDisplayName,
    LPSTR                 lpServiceName,
    LPDWORD                 lpcchBuffer
    );

extern WINBOOL
 PASCAL GetServiceDisplayNameA(
    SC_HANDLE               hSCManager,
    LPCSTR                lpServiceName,
    LPSTR                 lpDisplayName,
    LPDWORD                 lpcchBuffer
    );

extern SC_HANDLE
 PASCAL OpenSCManagerA(
    LPCSTR lpMachineName,
    LPCSTR lpDatabaseName,
    DWORD   dwDesiredAccess
    );

extern SC_HANDLE
 PASCAL OpenServiceA(
    SC_HANDLE   hSCManager,
    LPCSTR    lpServiceName,
    DWORD       dwDesiredAccess
    );

extern WINBOOL
 PASCAL QueryServiceConfigA(
    SC_HANDLE               hService,
    LPQUERY_SERVICE_CONFIG lpServiceConfig,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded
    );

extern WINBOOL
 PASCAL QueryServiceLockStatusA(
    SC_HANDLE                       hSCManager,
    LPQUERY_SERVICE_LOCK_STATUS    lpLockStatus,
    DWORD                           cbBufSize,
    LPDWORD                         pcbBytesNeeded
    );

extern SERVICE_STATUS_HANDLE
 PASCAL RegisterServiceCtrlHandlerA(
    LPCSTR             lpServiceName,
    LPHANDLER_FUNCTION   lpHandlerProc
    );

extern WINBOOL
 PASCAL StartServiceCtrlDispatcherA(
			    LPSERVICE_TABLE_ENTRY    lpServiceStartTable
			    );

extern WINBOOL
 PASCAL StartServiceA(
	      SC_HANDLE            hService,
	      DWORD                dwNumServiceArgs,
	      LPCSTR             *lpServiceArgVectors
	      );

/* Extensions to OpenGL */

extern WINBOOL  PASCAL wglUseFontBitmapsA(HDC, DWORD, DWORD, DWORD);

extern WINBOOL  PASCAL wglUseFontOutlinesA(HDC, DWORD, DWORD, DWORD, FLOAT,
		    FLOAT, int, LPGLYPHMETRICSFLOAT);

/* ------------------------------------- */
/* From shellapi.h in old Cygnus headers */

extern unsigned int  PASCAL DragQueryFileA(HDROP, unsigned int, char *, unsigned int);

extern HICON  PASCAL ExtractAssociatedIconA(HINSTANCE, char *, WORD *);

extern HICON  PASCAL ExtractIconA(HINSTANCE, const char *, unsigned int);

extern HINSTANCE  PASCAL FindExecutableA(const char *, const char *, char *);

extern int  PASCAL ShellAboutA(HWND, const char *, const char *, HICON);

extern HINSTANCE  PASCAL ShellExecuteA(HWND, const char *, const char *, char *, const char *, int);

/* end of stuff from shellapi.h in old Cygnus headers */
/* -------------------------------------------------- */
/* From ddeml.h in old Cygnus headers */

extern HSZ  PASCAL DdeCreateStringHandleA(DWORD, char *, int);

extern UINT  PASCAL DdeInitializeA(DWORD *, CALLB, DWORD, DWORD);

extern DWORD  PASCAL DdeQueryStringA(DWORD, HSZ, char *, DWORD, int);

/* end of stuff from ddeml.h in old Cygnus headers */
/* ----------------------------------------------- */

extern WINBOOL  PASCAL LogonUserA(LPSTR, LPSTR, LPSTR, DWORD, DWORD, HANDLE *);
extern WINBOOL  PASCAL CreateProcessAsUserA(HANDLE, LPCTSTR, LPTSTR,
	SECURITY_ATTRIBUTES*, SECURITY_ATTRIBUTES*, WINBOOL, DWORD, LPVOID,
	LPCTSTR, STARTUPINFO*, PROCESS_INFORMATION*);

extern WINBOOL  PASCAL PlaySoundA(LPCSTR pszSound, HMODULE hmod, DWORD fdwSound);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* RC_INVOKED */

#endif /* _GNU_H_WINDOWS32_ASCIIFUNCTIONS */
