#include <stdio.h>
#include <stdlib.h>
int setvbuf(FILE *stream, char *buf, int mode, size_t size)
{
	if (stream->token != FILTOK)
		return 1;
	switch (mode) {
		case _IOFBF:
		case _IOLBF:
		case _IONBF:
			break;
		default:
			return 1;
	}
	if (fflush(stream))
		return 1;
	if (stream->flags & _F_BUF)
		free(stream->buffer);
	stream->flags &= ~(_F_BUF | _F_LBUF);
	stream->buffer = buf;
	stream->bsize = size;
	stream->level = 0;
	switch (mode) {
		case _IOFBF:
			break;
		case _IOLBF:
			stream->flags |= _F_LBUF;
			break;
		case _IONBF:
			stream->buffer = 0;
			stream->bsize = 0;
			break;
		default:
			return 1;
	}
	return 0;
	
}