#if !defined(__CONIO_H)
#define __CONIO_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2

struct text_info {
    unsigned char winleft;
    unsigned char wintop;
    unsigned char winright;
    unsigned char winbottom;
    unsigned char attribute;
    unsigned char normattr;
    unsigned char currmode;
    unsigned char screenheight;
    unsigned char screenwidth;
    unsigned char curx;
    unsigned char cury;
};

enum COLORS {
    BLACK,          /* dark colors */
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,       /* light colors */
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};

#define BLINK       128 /* blink bit */

enum text_modes {  LASTMODE=-1,
                   BW40=0,
                   C40,
                   BW80,
                   C80,
                   MONO=7,
                   C4350=64 };

#ifdef __cplusplus
extern "C" {
#endif

void         RTL_NORM clreol( void );
void         RTL_NORM clrscr( void );
void         RTL_NORM gotoxy( int __x, int __y );
int          RTL_NORM getch( void );
int          RTL_NORM getche( void );
int          RTL_NORM kbhit( void );
int          RTL_NORM putch( int __c );
int          RTL_NORM wherex( void );
int          RTL_NORM wherey( void );

unsigned char    RTL_INTRINS inportb( unsigned __portid );
unsigned         RTL_INTRINS inport ( unsigned __portid );
int              RTL_INTRINS inp( unsigned __portid );
unsigned         RTL_INTRINS inpw( unsigned __portid );
void             RTL_INTRINS outportb( unsigned __portid, unsigned char __value );
void             RTL_INTRINS outport ( unsigned __portid, unsigned __value );
int              RTL_INTRINS outp( unsigned __portid, int __value );
unsigned         RTL_INTRINS outpw( unsigned __portid, unsigned __value );

void         RTL_NORM delline( void );
int          RTL_NORM gettext( int __left, int __top,
                           int __right, int __bottom,
                           void *__destin);
void         RTL_NORM gettextinfo (struct text_info *__r );
void         RTL_NORM highvideo( void );
void         RTL_NORM insline( void );
void         RTL_NORM lowvideo( void );
int          RTL_NORM movetext( int __left, int __top,
                            int __right, int __bottom,
                            int __destleft, int __desttop );
void         RTL_NORM normvideo( void );
int          RTL_NORM puttext( int __left, int __top,
                           int __right, int __bottom,
                           void *__source );
void         RTL_NORM textattr( int __newattr );
void         RTL_NORM textbackground( int __newcolor );
void         RTL_NORM textcolor( int __newcolor );
void         RTL_NORM textmode( int __newmode );
void         RTL_NORM window( int __left, int __top, int __right, int __bottom);

void         RTL_NORM _setcursortype( int __cur_t );
char *       RTL_NORM cgets( char *__str );
int          RTL_NORM cprintf( const char *__format, ... );
int          RTL_NORM cputs( const char *__str );
int          RTL_NORM cscanf( const char *__format, ... );
char *       RTL_NORM getpass( const char *__prompt );
int          RTL_NORM ungetch( int __ch );

#ifdef __cplusplus
}
#endif

#endif  /* __CONIO_H */