/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1996, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and sources are distributed along with any executables derived from them.
 *
 * The author is not responsible for damages, either direct or consequential,
 * that may arise from use of this software.
 *
 * V2.05 June 2002
 * David Lindauer, gclind01@starbase.spd.louisville.edu
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
/*
 * iopt.h
 *
 * icode optimization structures
 */
/*
 * basic blocks are kept in this type of structure
 * and marked with an i_block inn the icode
 */
typedef struct _blocklist {
	struct _blocklist *link;
	struct _block {
		short blocknum;
		struct _blocklist *flowfwd,*flowback;
		BYTE *p_in,*p_out,*p_gen,*p_kill;
		QUAD *head,*tail;
	} *block;
} BLOCKLIST;

typedef struct _block BLOCK;
/*
 * common code elimination uses this to track
 * all the gotos branching to a given label
 */
typedef struct _comgo {
	char size;
	QUAD *head, *tail;
} COMGOREC;
/*
 * DAG structures
 */

typedef struct _daglist {
	struct _daglist *link;
	BYTE *key;
	BYTE *rv;
} DAGLIST;
#include "iopt.p"