/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_frmget - Get (read) data entry form
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "windows.h"                    /* standard stuff */

/*
*************
* wn_frmget *
*************
*/

/*
** wn_frmget(frm)
**
**    int     nfields - number of fields in form.
**
** RETURNS:
**
**    TRUE  - indicating all fields of the form in question have been
**            fetched and verified (where required).
**
**    ESC_CODE - indicating ESCape was pressed and form processing
**            was terminated.
**
**      or
**
**    Never Returns!!
**
** NOTES:
**
**    This code can be used as is or can be customized to suite each
**    applications need.  The section to customize is at the tail end
**    of this file.  As distributed, logic diplays all prompts and
**    display fields, positions to the first field, performs data
**    entry on a field by field basis from the first to the last 
**    (allowing editing along the way), asks for a confirmation to
**    accept the fields on the form after the last field is entered,
**    either accepts the form or drops into edit mode for all the
**    fields on the form starting at the first field.
**
**    wn_frmget will not return until all data has been entered and
**    verified (where required).
**    
**    This routine must be called after wn_frmopn, and before wn_frmcls.
**
*/

/*
*************
* wn_frmget *
*************
*/

#define FLD frm[indx]                   /* some shorthand */

wn_frmget(frm)                          /* input form processor */
WIFORM frm;                             /* array of field pointers */
{
int indx;                               /* input field index */
int rv;                                 /* wn_g???'s return value */
int c;                                  /* scratch */
WINDOWPTR wn;                           /* my OWN window */

static char *msg = "[Press ENTER to Accept, any other key to Edit]";

  wni_frmflg = TRUE;                    /* set initial state */
                                        /* to display only */

begin:
  indx = 0;                             /* reset index */
  while(TRUE) {                         /* fetch input fields */
    if(!FLD->fcode) break;              /* all done */
    switch (FLD->fcode) {               /* based on function code */
      case GDATE:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GDATE");
        rv = wn_gdate(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vip, FLD->v2.vip, 
                      FLD->v3.vip, FLD->v4.vcp,
                      FLD->v5.vcp,FLD->v6.vcp);
        break;
      case GTIME:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GTIME");
        rv = wn_gtime(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vip, FLD->v2.vip, 
                      FLD->v3.vip, FLD->v4.vcp,
                      FLD->v5.vcp,FLD->v6.vcp);
        break;
      case GINT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GINT");
        rv = wn_gint(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                     FLD->col, FLD->prmpt, 
                     FLD->atrib, FLD->fill, FLD->v1.vip, FLD->v2.vi, 
                     FLD->v3.vi, FLD->v4.vi, FLD->v5.vcp,
                     FLD->v6.vcp,FLD->v7.vcp);
        break;
      case GUINT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GUINT");
        rv = wn_guint(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vuip, FLD->v2.vi, 
                      FLD->v3.vui, FLD->v4.vui, FLD->v5.vcp,
                      FLD->v6.vcp,FLD->v7.vcp);
        break;
      case GLONG:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GLONG");
        rv = wn_glong(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vlp, FLD->v2.vi, 
                      FLD->v3.vl, FLD->v4.vl, FLD->v5.vcp,
                      FLD->v6.vcp,FLD->v7.vcp);
        break;
      case GULONG:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GULONG");
        rv = wn_gulong(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vulp, FLD->v2.vi, 
                      FLD->v3.vul, FLD->v4.vul, FLD->v5.vcp,
                      FLD->v6.vcp,FLD->v7.vcp);
        break;
      case GFLOAT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GFLOAT");
        rv = wn_gfloat(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                       FLD->col, FLD->prmpt, 
                       FLD->atrib, FLD->fill, FLD->v1.vfp, FLD->v2.vi, 
                       FLD->v3.vi, FLD->v4.vf, FLD->v5.vf, FLD->v6.vcp,
                       FLD->v7.vcp,FLD->v8.vcp);
        break;
      case GDOUBL:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GDOUBL");
        rv = wn_gdouble(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                       FLD->col, FLD->prmpt, 
                       FLD->atrib, FLD->fill, FLD->v1.vdp, FLD->v2.vi, 
                       FLD->v3.vi, FLD->v4.vd, FLD->v5.vd, FLD->v6.vcp,
                       FLD->v7.vcp,FLD->v8.vcp);
        break;
      case GPHONE:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GPHONE");
        rv = wn_gphone(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                       FLD->col, FLD->prmpt, 
                       FLD->atrib, FLD->fill, FLD->v1.vip, FLD->v2.vip, 
                       FLD->v3.vip, FLD->v4.vcp,
                       FLD->v5.vcp,FLD->v6.vcp);
        break;
      case GTEXT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GTEXT");
        rv = wn_gtext(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vi, FLD->v2.vcp,
                      FLD->v3.vcp,FLD->v4.vcp);
        break;
      case GUTEXT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GUTEXT");
        rv = wn_gutext(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vi, FLD->v2.vcp,
                      FLD->v3.vcp,FLD->v4.vcp);
        break;
      case GLTEXT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GLTEXT");
        rv = wn_gltext(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vi, FLD->v2.vcp,
                      FLD->v3.vcp,FLD->v4.vcp);
        break;
      case GATEXT:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GATEXT");
        rv = wn_gatext(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vi, FLD->v2.vucp,
                      FLD->v3.vucp,FLD->v4.vucp);
        break;
      case GBOOL:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GBOOL");
        rv = wn_gbool(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vip, FLD->v2.vcp,
                      FLD->v3.vcp,FLD->v4.vcp);
        break;
      case DTEXT:                       /* display text */
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@DTEXT");
        rv = wn_dtext(XEQ,NFRM,NFLD,FLD->wn, FLD->row, FLD->col, FLD->prmpt);
        break;
      case GPWORD:
        if(FLD->pself != (char *)FLD)   /* corrupted memory check */
          wns_ierr("wm_frmget@GPWORD");
        rv = wn_gpword(XEQ,NFRM,NFLD,FLD->wn, FLD->row,
                      FLD->col, FLD->prmpt, 
                      FLD->atrib, FLD->fill, FLD->v1.vi, FLD->v2.vcp,
                      FLD->v3.vcp,FLD->v4.vcp);
        break;
    }                                   /* end switch(frm.code) */
    if(rv != BKTAB && rv != UARROW)     /* previous field ?? */
      indx++;                           /* no, just bump index */
    else {                              /* previous field request */
      indx--;                           /* decrement index */
      if(indx <= 0) indx = 0;           /* but dont be stupid! */
    }
    if(rv == ESC)                       /* Escape backout - ESC.001 */
      return(ESC_CODE);                 /* Escape backout - ESC.001 */
  }

  if(wni_frmflg) {                      /* first pass thru */
    wni_frmflg = FALSE;                 /* displays prompts & data */
    goto begin;                         /* now, lets *really* read */
  }

/*************************************************************************
*                                                                        *
*                  CUSTOMIZE THE SECTION BELOW ONLY                      *
*                                                                        *
**************************************************************************/

                                        /* PRESS Return Stuff */
  wn=wn_open(1000,(wni_mxrows-1),0,(int)strlen(msg),1,(RVIDEO),NVIDEO);
  if(!wn) exit(1);
  wn_puts(wn,0,0,msg);                  /* display message */
  c = v_getch() & 0xff;                 /* fetch response */
  wn_close(wn);                         /* make message go away */
  if(c == CR)                           /* ENTER ?? */
    return(TRUE);                       /* return if so */
  if(c == ESC)                          /* Escape Backout - ESC.001 */
    return(ESC_CODE);                   /* Escape Backout - ESC.001 */
  else                                  /* else edit the */
    goto begin;                         /* form ! */
}     

/* End */
