

/* this is a temporary release sample to read "any" DBF, or at least describe the
 * concept -- use the included ACPART.DBF as test input (command line arg) since
 * it is small and everything fits on screen
 *
 * this source is being done in OS/2, so remove/add headers as required 
 * also, you should be able to use your current bullet.h, though you may
 * want to modify/adapt to the one included with this temporary release
 * -- see #include "bullet2.h"  and  #define BULLET BULLET32  below
 * -- (you will need to remove the #define BULLET BULLET32)
 */

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* if 16-bit program, use:                                        
 *   #define __Bullet16
 *   #include "bullet2.h
 * otherwise (32-bit), do as below
 */

#include "bullet2.h"
#define BULLET BULLET32   /* if 32-bit main(), go through BULLET32 */

#define ITOA itoa          /* non-standard */

/* b2_xvue.c:
  1) viewing any DBF by building field list on-the-fly
  2) extended limits (255 fields, 8KB records, binary fields)

 */

#pragma pack(1)

struct InitPack IP;
struct ExitPack EP;
struct FieldDescType fieldList;
struct DescriptorPack DP;
struct CreateDataPack CDP;
struct CreateKeyPack CKP;
struct OpenPack OP;
struct HandlePack HP;
struct StatDataPack SDP;
struct AccessPack AP;
struct DosFilePack DFP;
 
char  dataRec[8192];       /* unknown record layout since reading "any" DBF */
char  *Ptmp2;              /* point into data record, start of fields */

/* any Bullet-used structures should be within the pack(1)/pack() pragmas */
/* these vars are up above main() only because I didn't care? move/adapt as you want */

#pragma pack()

int     rez;
int     rez2;

typedef struct _DATADESC {
   char fieldName[11];     /* our program is using this structure to copy the DBF */
   char fieldType;         /* field descriptors to -- could also use FieldDescType, */
   BYTE fieldLen;          /* but since this is only being used by our program, the */
   BYTE fieldDC;           /* 14 bytes is less than half the size of FieldDescType */
} DATADESC;
typedef DATADESC *PDATADESC;  /* short descriptor data structure */
/* not directly accessed by Bullet, so need not be in above pack(1)/pack() */

PDATADESC  PdataDesc;   /* pointer to field descriptor base (the first one) */
PDATADESC  Ptmp;        /* as above but varies, locating to any field's descriptor */
 
char     userDBF[260];  /* pathname of DBF */
char     fmt[32];       /* printf() fmt string */
char     tmpBuff[32];   /* misc buffer for itoa() amd other string builds */
USHORT   handleData;    /* handle of DBF */
LONG     recNo;         /* loop counter */
BYTE     fldNo;         /* loop counter */
USHORT   offset;        /* index into record of field */


int main(int argc,char *argv[]) {

setbuf(stdout,NULL);

if (argc < 2) {
   puts("gimme something to access...");
   return(1);  /* for now */
}

/* init/open existing DBF as passed on command line */

IP.func = INITXB;
IP.JFTmode = 0;
rez = BULLET(&IP);
if (rez!=0) {
   printf("InitXB failed: %u\n",rez);
   return(1);
}

OP.func = OPENDXB;
OP.filenamePtr = argv[1];
OP.asMode = READWRITE | DENYNONE;
rez = BULLET(&OP);
if (rez==0) {

   handleData = OP.handle;
   SDP.func = STATDXB;
   SDP.handle = handleData;
   rez = BULLET(&SDP);
   if (rez==0) {

      /* allocate field descriptors used by program 
       * -- not full 32 bytes per descriptor, but only 14 bytes per desc
       * -- use calloc() since want 0-filled storage
       */

      PdataDesc = calloc(SDP.fields,sizeof(DATADESC));

      if (PdataDesc!=NULL) {
         Ptmp = PdataDesc;

         /* read each field descriptor from Bullet, storing to our program */
         /* show each for educatoinal reasons */

         /*    1234567890-123456789-123456789- */
         puts("FLD#   FIELDNAME  T  LEN.DEC");

         DP.func = GETDESCRIPTORXB;
         DP.handle = handleData;
         for (fldNo=1;fldNo <= SDP.fields;fldNo++) {
 
            DP.fieldNumber = fldNo;
            rez = BULLET(&DP);
            if (rez==0) {
 
               strcpy(Ptmp->fieldName,DP.FD.fieldName);
               Ptmp->fieldType = DP.FD.fieldType;
               Ptmp->fieldLen = DP.FD.fieldLen;
               Ptmp->fieldDC = DP.FD.fieldDC;
               printf("%3u   %10s  %c  %3u.%1u\n",
                  fldNo,
                  Ptmp->fieldName,
                  Ptmp->fieldType,
                  Ptmp->fieldLen,
                  Ptmp->fieldDC);
               Ptmp++;
            }
            else
               break;
         }
      
         /* okay, have all we need to know about the DBF fields */
         /* grab the first few records and spit them out, by field */

         if (SDP.recs != 0) {

            AP.func = GETRECORDXB;  /* no index involved in this example - going */
            AP.handle = handleData; /* directly to the DBF by recno to show one way */
            AP.recPtr = &dataRec;   /* of processing a DBF file on-the-fly */

            for (recNo=1;recNo <= 10; recNo++) {

               printf("\nrecNo %u: ",recNo);

               AP.recNo = recNo;      /* get this record number (to dataRec) */
               rez = BULLET(&AP);
               if (rez==0) {

                  Ptmp = PdataDesc;  /* start at first field descriptor */
                  offset = 1;         /* index of first field, skipping tag for now */

                  for (fldNo=1;fldNo <= SDP.fields;fldNo++) {

                     switch (Ptmp->fieldType) {
                        case 'B':                     /* special Bullet binary */
                           printf("% 10.10u",(int *) Ptmp2);/* assume int, 32-bit */
                           break;                     /* I think (int *) is correct? */
                        case 'C':                     /* text */
                        case 'D':                     /* date, show as-is */
                        case 'L':                     /* logical, show as-is */
                        case 'M':                     /* memo field (offset in ASCII) */
                        case 'N':                     /* numeric (ASCII) */
                        /* you probably want to replace this with sprintf() */
                           strcpy(fmt," %");          /* first build format string */
                           ITOA(Ptmp->fieldLen,tmpBuff,10); /* xx */
                           strcat(fmt,tmpBuff);       /* %xx */
                           strcat(fmt,".");           /* %xx. */
                           strcat(fmt,tmpBuff);       /* %xx.xx */
                           strcat(fmt,"s");           /* %xx.xxs */

                           Ptmp2 = &dataRec;                       
                           Ptmp2 += offset;  /* locate to field */
                           printf(fmt,Ptmp2);
                           break;
                        default:
                           printf("\nUnknown field type found: %c\n",Ptmp->fieldType);
                     } /* switch */

                     offset += Ptmp->fieldLen;  /* next field's data start */
                     Ptmp += 1;                 /* next field descriptor */

                  } /* for fields */
               } /* if record read */

               else {
                  printf(" - failed GetRecordXB, stat: %u (1224=no more records)\n",rez);
                  break;  /* error probably just EOF (i.e., access attempt beyond last rec) */
               }

            } /* for records */
            puts("\nThat's all folks!"); /* all FOR recs printed, do new line/okay */
         }
         else
            puts("No records in file");

         free(PdataDesc);
      }
      else
         puts("calloc failed!");
   }
   else
      printf("StatDXB failed: %u\n",rez);
}
else
   printf("OpenXB failed: %u\n",rez);

EP.func = EXITXB;
rez2=BULLET(&EP);    /* return main rez, not the rather uninteresting ExitXB */

printf("\nPress ENTER...");
getchar();

return(!rez==0);
}


