/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <dos.h>


/***
 *
 *  Function   :    getdiskfree
 *
 *  Topics     :    Returns the number of bytes free of a disk.
 *
 *  Parameters :    in    int disk         0 = A:, 1 = B:
 *
 *  Return code:    number of bytes free
 *                  -1 if invalid drive
 ***/

long getdiskfree( int disk )

{ struct diskfree_t free;

  if ( _dos_getdiskfree(disk + 1, &free) ) return -1;

  return (long) free.avail_clusters *
         (long) free.bytes_per_sector *
         (long) free.sectors_per_cluster;
}
