/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*           Global symbols          */
/*                                   */
/*        Zortech C/C++ 3.0 r4       */
/*          MICROSOFT C 6.00         */
/*          Visual C/C++ 1.0         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/

/* version tags	*/

#define VERSION "release 2.08"
#define FILE_VERSION "version 2.08\n"

/* numerical symbols */

#define INFINITY 1.0e+308              /* largest double                 */

/* several limits */

#define PWIDTH 150                     /* width of pathnames             */
/* whenever changes are made to NAME_L be sure to change the formating
   strings in: IOTOP.C, (GETALL.C)
   to NAME_L - 1
*/
#define NAME_L 21                      /* max. length of metab. names    */
#define MAX_MET 45                     /* maximal number of metabolites  */
#define MAX_STEP 45                    /* maximal number of enzymes      */
#define MAX_MOL 20					   /* maximal molecularity			 */
#define STEP_LIM MAX_STEP+1            /* (for programming purposes)     */
#define MAX_VRS 9                      /* maximal number of variables    */
#define MAX_PRM 6                      /* maximal number of parameters   */
#define MAX_FIL 30                     /* maximal number of run files    */
#define MAX_TYP 35                     /* maximal reaction types         */

/* include symbols for emergency default values */
#include "default.h"

/* symbols for the kinetic models */

#define NOT  0
#define I01  1						   /* -> B (zeroth order)			 */
#define I10	 2	 					   /* A -> (zeroth order)			 */
#define I11  3                         /* A  -> B                        */
#define R11  4                         /* A <-> B                        */
#define I21  5                         /* A + B  -> C                    */
#define R21  6                         /* A + B <-> C                    */
#define I12  7                         /* A  -> B + C                    */
#define R12  8                         /* A <-> B + C                    */
#define I31  9                         /* A + B + C  -> D                */
#define R31 10                         /* A + B + C <-> D                */
#define I13 11                         /* A  -> B + C + D                */
#define R13 12                         /* A <-> B + C + D                */
#define I22 13                         /* A + B  -> C + D                */
#define R22 14                         /* A + B <-> C + D                */
#define I32 15                         /* A + B + C  -> D + E            */
#define R32 16                         /* A + B + C <-> D + E            */
#define I23 17                         /* A + B  -> C + D + E            */
#define R23 18                         /* A + B <-> C + D + E            */
#define I33 19                         /* A + B + C  -> D + E + F        */
#define R33 20                         /* A + B + C <-> D + E + F        */
#define IMM 21                         /* irrev. Henri-Michaelis-Menten  */
#define RMM 22                         /* rev. Henri-Michaelis-Menten    */
#define PSI 23                         /* pure specific inhibition       */
#define PCI 24                         /* pure catalytic inhibition      */
#define MXI 25                         /* mixed inhibitor                */
#define PSA 26                         /* pure specific activation       */
#define PCA 27                         /* pure catalytic activation      */
#define MXA 28                         /* mixed activator                */
#define GOM 29                         /* general one-modifier HMM       */
#define HIL 30                         /* cooperative bind. of S and P   */
#define UBS 31                         /* A = P + Q sequential (UNIBISA) */
#define UBM 32                         /* A = 2P sequential (UNIBISIM)   */
#define RHL 33						   /* reversible hill mechanism		 */
#define ALI 34						   /* alosteric inhibition           */

/* typedefs */

typedef double * PDBL;
typedef int	BOOL;

/* boolean values */

#define FALSE       0
#define TRUE        1
