/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*            This module was originally written by Bob Hartman             */
/*                                                                          */
/*                            BinkleyTerm Data                              */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

unsigned int BINK_MAJVERSION = PRDCT_MAJOR;
unsigned int BINK_MINVERSION = PRDCT_MINOR;

#ifdef PRIVATE_IDAHO
#define ALPHA_DATE      ""
#else
#define ALPHA_DATE      ""
#endif

#ifdef DOS16
char *ANNOUNCE = PRDCT_PRTY " Version " PRDCT_VRSN ALPHA_DATE;
char *xfer_id = PRD_SH_PRTY " " PRDCT_VRSN;
#endif

#ifdef OS_2
char *ANNOUNCE = "BinkleyTerm-OS/2 Ver. " PRDCT_VRSN ALPHA_DATE;
char *xfer_id = "BinkOS2 " PRDCT_VRSN;
#endif

#ifdef _WIN32
char *ANNOUNCE = "BinkleyTerm/Win32 Ver. " PRDCT_VRSN ALPHA_DATE;
char *xfer_id = "BinkW32 " PRDCT_VRSN;
#endif

short SB_COLS_M_1 = 0;

short SB_ROW_HOLD = 6;
short SB_ROW_STATUS = 0;
short SB_ROWS_M_1 = 0;
short SB_ROWS_M_2 = 0;
short SB_ROWS_M_15 = 0;

struct _key_fnc_hdr TrmnlKeyFncHdr;
struct _key_fnc_hdr UnattendedKeyFncHdr;

char **msgtxt;
struct _lang_hdr *LangHdr = NULL;

char *mtext[] =
{
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

struct baud_str btypes[] =
{
#ifdef BAUD_150
	{150, BAUD_150},
#endif
	{300, BAUD_300},
#ifdef BAUD_600
	{600, BAUD_600},
#endif
	{1200, BAUD_1200},
	{2400, BAUD_2400},
	{4800, BAUD_4800},
	{9600, BAUD_9600},
	{19200, BAUD_19200},
	{38400, BAUD_38400},
#ifdef BAUD_57600
	{57600, BAUD_57600},
#endif
#ifdef BAUD_115200
	{115200, BAUD_115200},
#endif
	{0, 0}
};

#ifdef EXTENDED_BAUDRATES

int extend_rates = 0;

struct baud_str exttypes[] =
{
#ifdef BAUD_EXT_150
	{150, BAUD_EXT_150},
#endif
#ifdef BAUD_EXT_300
	{300, BAUD_EXT_300},
#endif
#ifdef BAUD_EXT_600
	{600, BAUD_EXT_600},
#endif
#ifdef BAUD_EXT_1200
	{1200, BAUD_EXT_1200},
#endif
#ifdef BAUD_EXT_2400
	{2400, BAUD_EXT_2400},
#endif
#ifdef BAUD_EXT_4800
	{4800, BAUD_EXT_4800},
#endif
#ifdef BAUD_EXT_9600
	{9600, BAUD_EXT_9600},
#endif
#ifdef BAUD_EXT_19200
	{19200, BAUD_EXT_19200},
#endif
#ifdef BAUD_EXT_38400
	{38400, BAUD_EXT_38400},
#endif
#ifdef BAUD_EXT_57600
	{57600, BAUD_EXT_57600},
#endif
#ifdef BAUD_EXT_76800
	{76800, BAUD_EXT_76800},
#endif
#ifdef BAUD_EXT_115200
	{115200, BAUD_EXT_115200},
#endif
	{0, 0}
};
#endif	/* EXTENDED_BAUDRATES */

struct baud_str max_baud = {2400, BAUD_2400};		/* Max baud value */

struct baud_str *pbtypes = btypes;

struct parse_list far DOS_commands[] =
{
	{7, "noforce"},
	{4, "mail"},
	{5, "share"},
	{5, "dynam"},
	{10, "unattended"},
	{6, "config"},
	{4, "poll"},
	{0, ""}
};

int locate_x, locate_y, port_ptr, original_port;

int TaskNumber = 0;				/* unique user-specified id   */
int share = SHARE_DEFAULT;		/* if 1, don't uninit FOSSIL  */
int no_sharing = 0;				/* if 1, no File Sharing calls*/
int no_size = 0;
int first_block;				/* 1 = first block/Matrix packet */

int serial = -1;				/* -1 is unregistered         */
int fstblklen = 0;				/* Start Zmodem packet size   */
int net_params = 0;
int un_attended = 0;
int command_line_un;
int overwrite = 0;
int redo_dynam = 0;
int fullscreen = 1;
int do_screen_blank = 0;
int screen_blank = 0;
int blank_on_key = 1;
unsigned int blank_time = 6000;
unsigned BBStimeout = 2000;
int loglevel = 6;
int debugging_log = 0;
int gong_allowed = 0;
int MAXport = 2;
int pvtnet = -1;
int poll_tries = 500;			/* How many tries in a poll? */

int ring_tries = 4;				/* How many rings before fail   */
int ring_wait = 1;				/* Incoming rings before answer */

int com_port = 0;				/* Default com port = COM1   */
int buftmo = 6000;				/* 60 second timeout         */
unsigned int comm_bits = BITS_8;/* Default data bits = 8     */
unsigned int parity = NO_PARITY;/* Default parity = NONE     */
unsigned int stop_bits = STOP_1;/* Default stop bits = 1     */
unsigned int carrier_mask = 0x80;	/* Default carrier bit = 80H */
unsigned int handshake_mask = USE_XON | USE_CTS;	/* Force CTS/RTS flow control*/

int baud;						/* Index to baud table       */
struct baud_str cur_baud;		/* Current baud rate         */
int fax_baud = -1;				/* Index of baud for faxes   */

char *modem_init = NULL;		/* Used to init modem        */
char *term_init = NULL;			/* Used to init modem in terminal mode */
char *modem_busy = NULL;		/* Take modem offhook        */
char *modem_aftercall = NULL;	/* Send to modem after call  *//* MB 93-12-12  AFTERCALL */
int lines_aftercall = 0;
char *predial = NULL;			/* Pre-dial setup            */
char *postdial = NULL;			/* Post-dial cleanup         */
char *normprefix;
char *normsuffix;
char *dial_setup;
char *init_setup;

char *emsistr[] =
{
	"**EMSI_REQA77E",
	"**EMSI_DAT",
	"**EMSI_HBTEAEE",
	"**EMSI_NAKEEC3",
	"**EMSI_ACKA490",
	"**EMSI_INQC816",
	"**EMSI_CLIFA8C"
};

unsigned int matrix_mask = TAKE_REQ;	/* Netmail session abilities */
char *system_name = NULL;		/* Name of system to send    */
char *sysop = NULL;				/* Name of sysop for yoohoo  */
char *location = "Somewhere";	/* Name of location for EMSI */
char *myphone = "-Unpublished-";/* Own phonenumber for EMSI  */
char *myflags = "";				/* Nodelistflags for EMSI    */
char *mymaxbaud = "";			/* Max. baudrate for EMSI    */
char *netmail = NULL;			/* Net Mail directory        */
char *net_info = NULL;			/* Location of nodelist, etc */
char *hold_area = NULL;			/* Path to outbound dir      */
char *flag_dir = NULL;			/* Where to find INMAIL.$$$  */
char *fax_in = NULL;			/* Where to store inbound fax*/
char *domain_area = NULL;		/* Where to put domain name  */
char *domain_loc = NULL;		/* Where to put domain name  */
ADDR alias[ALIAS_CNT];			/* List of alias addresses   */
int num_addrs = 0;				/* How many we're using      */
int assumed = 0;				/* Alias we're now assuming  */

ADDR boss_addr;					/* Bossnode address */
ADDR my_addr;					/* Our address      */

struct secure CURRENT;			/* Current path, quotas, etc */

struct secure DEFAULT;			/* Default paths, etc        */
struct secure KNOWN;			/* Sec for KNOWN address     */
struct secure PROT;				/* Sec for PW-PR address     */

struct req_accum freq_accum;	/* Accumulator for freq stats*/

char *domain_name[50];			/* Known domain names        */
char *domain_abbrev[50];		/* Known domain name abbrev  */
char *domain_nodelist[50];		/* Known domain nodelists    */

DOMAINKLUDGE *domainkludge;		/* Pointer to domain kludges */
int num_domain_kludge = 0;		/* Number of domain kludges  */
int size_domain_kludge = 0;		/* Current size of kludge    */

byte *Txbuf;					/* Pointer to xmit buffer    */
byte *Secbuf;					/* Pointer to recv buffer    */
byte *popbuf;					/* Pointer to popup buffer   */

char *native_protocols = "XZTS";/* Protocols we support      */
char *extern_protocols = NULL;	/* Protocols we can call     */
char *protocols[MAX_EXTERN];	/* external file protocol    */
int extern_index = 0;			/* external proto index      */
struct prototable protos[MAX_EXTERN]; /* Table for execution */

char *ext_mail_string[16];		/* String for UUCP, etc.     */
int lev_ext_mail[16];			/* Errorlevel for extmail    */
int num_ext_mail;				/* Number of ext mails       */

char *BBSopt = NULL;			/* BBS command options       */
char *BBSbanner = NULL;			/* BBS banner                */
char *BBSreader = NULL;			/* Message reader            */
char *BOSSphone = NULL;			/* Phone number for boss     */
char *BOSSpwd = NULL;			/* Password for boss         */
char *download_path = "";		/* Default download path     */
char *BBSnote = NULL;			/* Tell user BBS loading     */
char *MAILnote = NULL;			/* Say same for ext mail     */
char *EXTopt = NULL;			/* External mailer options   */

#ifdef BINKLEY_SOUNDS
char *fnBBSSound = NULL;
char *fnEXTSound = NULL;
char *fnMailSound = NULL;
char *fnFileSound = NULL;
char *fnStartSound = NULL;
char *fnFAXSound = NULL;
#endif

void (_cdecl * mtask_idle) (void);
char *mtask_name = NULL;
char *BINKpath = "";
char capturename[100];
char *log_name = NULL;
char *config_name = PRDCT_PRFX ".Cfg";
char *swapdir = NULL;
char *saved_TZ = NULL;

#ifdef Snoop
char pipename[80];
#endif

char *scan_list[10];
int set_loaded = 0;

byte user_exits[6];

char junk[256];
int happy_compiler;
REGIONP wholewin;
REGIONP settingswin;
REGIONP historywin;
REGIONP holdwin;
REGIONP callwin;
REGIONP filewin;

int scrllines = 0;

PN_TRNS *pn = NULL;
MDM_TRNS *mm = NULL;

int resp_count = 0;
int max_resp_count = 0;
struct resp_str *mdm_resps = NULL;

/* Default modem response strings. Used when the user
   doesn't take advantage of the new config verbs. */

int def_resp_count = 15;		/* Change to match def_mdm_resps */
struct resp_str def_mdm_resps[] =
{
	{"RINGING", IGNORE},
	{"RING RESPONSE", IGNORE},
	{"RING", RINGING},
	{"CONNECT", CONNECTED},
	{"RRING", IGNORE},
	{"BUSY", DIALRETRY},		/* Was FAILURE before dial retry */
	{"VOICE", FAILURE},
	{"ERROR", FAILURE},
	{"OK", FAILURE},
	{"NO CARRIER", FAILURE},
	{"NO DIAL", INCOMING},		/* "NO DIAL TONE" or "NO DIALTONE" */
	{"DIALING", IGNORE},
	{"NO ANSWER", FAILURE},
	{"DIAL TONE", IGNORE},
	{"+FCO", FAX},
};

FILE *cost_log = NULL;
char *cost_log_name = NULL;
int cost_unit = 1;
int eurocost = 0;

FILE *status_log = NULL;
short boxtype = 0;
int modemring = 0;				/* Modem doesn't differ for RING and RINGING */
int no_collide = 0;				/* No collision detect */
int cursor_col = 79;
int cursor_row = 22;
int leave_dtr_high = 0;
char *ans_str = NULL;
char *keys[9];
char *shells[9];
char *errlvlshell[255];

struct parse_list far rspverbs[] =
{
	{4, "text"},
	{4, "date"},
	{4, "time"},
	{4, "bink"},
	{5, "mynode"},
	{6, "system"},
	{5, "sysop"},
	{6, "yrnode"},
	{7, "request"},
	{6, "status"},
	{5, "abort"},
	{4, "exit"},
	{4, "line"},
	{0, ""}
};

struct parse_list far config_lines[] =
{
	{8, "SameRing"},
	{11, "NewNodeList"},
	{13, "QuickNodeList"},
	{10, "Answerback"},
	{5, "Macro"},
	{5, "Shell"},
	{4, "Dial"},
	{5, "Event"},
	{4, "Zone"},
	{6, "MaxReq"},
	{8, "LogLevel"},
	{4, "Baud"},
	{7, "MaxPort"},
	{4, "Port"},
	{7, "Carrier"},
	{9, "StatusLog"},
	{6, "Reader"},
	{9, "BossPhone"},
	{7, "BossPwd"},
	{8, "Protocol"},
	{6, "System"},
	{5, "Sysop"},
	{4, "Boss"},
	{5, "Point"},
	{3, "Aka"},
	{4, "Hold"},
	{9, "DownLoads"},
	{7, "NetFile"},
	{4, "Init"},
	{4, "Busy"},
	{6, "Prefix"},
	{8, "NodeList"},
	{5, "Avail"},
	{6, "OKFile"},
	{5, "About"},
	{8, "MailNote"},
	{6, "Banner"},
	{10, "UnAttended"},
	{9, "OverWrite"},
	{4, "Rev3"},
	{7, "ReqOnUs"},
	{8, "LockBaud"},
	{7, "TimeOut"},
	{5, "NoSLO"},
	{9, "SlowModem"},
	{11, "SmallWindow"},
	{8, "NoPickup"},
	{10, "NoRequests"},
	{7, "NetMail"},
	{6, "Suffix"},
	{12, "NoFullScreen"},
	{8, "AutoBaud"},
	{4, "Gong"},
	{9, "NoCollide"},
	{8, "TBBSList"},
	{8, "TaskView"},
	{7, "TopView"},
	{9, "ExtrnMail"},
	{7, "BBSNote"},
	{3, "BBS"},
	{10, "ScriptPath"},
	{7, "BoxType"},
	{9, "MultiLink"},
	{7, "Include"},
	{11, "CaptureFile"},
	{9, "CursorCol"},
	{9, "CursorRow"},
	{9, "DoingMail"},
	{8, "EnterBBS"},
	{10, "PrivateNet"},
	{6, "Packer"},
	{7, "Cleanup"},
	{9, "AfterMail"},
	{6, "Colors"},
	{9, "JanusBaud"},
	{11, "ReqTemplate"},
	{10, "KnownAvail"},
	{12, "KnownReqList"},
	{10, "KnownAbout"},
	{12, "KnownInbound"},
	{11, "KnownReqLim"},
	{11, "KnownReqTpl"},
	{9, "ProtAvail"},
	{11, "ProtReqList"},
	{9, "ProtAbout"},
	{11, "ProtInbound"},
	{10, "ProtReqLim"},
	{10, "ProtReqTpl"},
	{11, "Application"},
	{7, "NoZones"},
	{6, "Answer"},
	{9, "PollTries"},
	{7, "SwapDir"},
	{7, "Address"},
	{10, "CurMudgeon"},
	{7, "NoWaZOO"},
	{11, "ScreenBlank"},
	{10, "Mark_Kromm"},
	{6, "Server"},
	{10, "ModemTrans"},
	{7, "PreDial"},
	{7, "PreInit"},
	{7, "DTRHigh"},
	{5, "Debug"},
	{8, "NoZedZap"},
	{8, "NoResync"},
	{9, "NoSEAlink"},
	{8, "FTS-0001"},
	{10, "LineUpdate"},
	{7, "JanusOK"},
	{8, "TermInit"},
	{12, "DomainKludge"},
	{5, "Snoop"},
	{5, "Flags"},
	{10, "TaskNumber"},
	{8, "MaxBytes"},
	{13, "KnownMaxBytes"},
	{12, "ProtMaxBytes"},
	{11, "StartBlkLen"},
	{7, "MaxTime"},
	{12, "KnownMaxTime"},
	{11, "ProtMaxTime"},
	{9, "RingTries"},
	{9, "NoSharing"},
	{8, "Version7"},
	{9, "BlankWait"},
	{6, "Serial"},
	{10, "NoDietIfna"},
	{8, "Version6"},
	{8, "WinSlice"},
	{6, "NoSize"},
	{8, "ForcExit"},
	{6, "Extern"},
	{6, "NoEMSI"},
	{10, "MyLocation"},
	{7, "MyPhone"},
	{11, "MyListFlags"},
	{9, "MyMaxbaud"},
	{9, "PickUpAll"},
	{7, "FileSec"},
	{8, "KnownSec"},
	{7, "ProtSec"},
	{8, "MaxAreas"},
	{6, "Domain"},
	{9, "MailSound"},
	{9, "FileSound"},
	{8, "BBSSound"},
	{8, "EXTSound"},
	{10, "StartSound"},
	{8, "FaxSound"},
	{8, "FaxInDir"},
	{12, "ModemFailure"},
	{11, "ModemIgnore"},
	{12, "ModemConnect"},
	{12, "ModemRinging"},
	{13, "ModemIncoming"},
	{8,  "ModemFax"},
	{7,  "Costlog"},
	{8,  "CostUnit"},
	{8,  "EuroCost"},
	{8,  "NoFilter"},
	{6,  "BiDiOK"},
	{8,  "BiDiBaud"},
	{7,  "NoHydra"},
	{7,  "NoJanus"},
	{12, "ExtBaudRates"},
	{9,  "AfterCall"},
	{6,  "PktRsp"},
	{10, "ExtSession"},
	{7,  "FaxBaud"},
	{13, "ErrLevelShell"},
	{9,  "AltNumber"},
	{10, "ModemRetry"},
	{19, "RecentActivityLines"},
	{8,  "RingWait"},
	{9,  "WinFOSSIL"},
	{0, ""}
};

int Netmail_Session;
HISTORY start_hist;
int isOriginator = 0;			/* Global logical "I'm the caller"   */
int got_arcmail;
int got_packet;
int got_mail;
int got_fax;
int mail_finished;
int sent_mail;
int made_request;				/* WaZOO file request flag */
int net_problems;				/* This should be external */

ADDR remote_addr;
unsigned short remote_capabilities;
unsigned short my_capabilities;
ADDR remote_akas[ALIAS_CNT + 1];/* List of alias addresses of remote */
int num_rakas = 0;				/* How many he's using (EMSI)        */
int remote_pickup = 0;			/* Does the remote want his mail ?   */

ADDR next_addr;

char *remote_password;
char *BBSesc = "\rPress <Escape> to enter BBS.\r";
char *noBBS = "\r\rProcessing Mail. Please hang up.\r\r";
int no_pickup = 0;
int pickup_all = 0;
int no_WaZOO = 0;
int no_WaZOO_Session = 0;
int no_EMSI = 0;
int no_EMSI_Session = 0;

word ExtMailMask = 0;
char *ExtMailAgent = NULL;

char *request_template = "%s%s.R%02x";

char *ext_flags = "ODCH";		/* Change to whatever, and */

struct _lang_hdr *PrdctHdr;
char **PrdctTbl;				/* The New Order */

struct _lang_hdr *AnsiHdr;
char *AnsiTbl;

#ifdef HAVE_HYDRA
ULONG hydra_options  = 0x0L;
long hydra_txwindow = 0L;
long hydra_rxwindow = 0L;
#endif

int no_hydra = 0;
int no_janus = 0;
int no_zapzed = 0;
int no_dietifna = 0;
int on_our_nickel = 0;

#ifdef _WIN32
int use_winfossil = 0;
#endif

char fossil_buffer[128];
char out_buffer[128];
char *fossil_fetch_pointer = fossil_buffer;
char *out_send_pointer = out_buffer;
int fossil_count = 0;
int out_count = 0;
int old_fossil = 1;
int rev3 = 0;
char ctrlc_ctr;
FOSINFO fossil_info =
{
	0, 0, 0, 0L, 0, 0, 0, 0, 0, 0, 0
};

char no_requests = 0;
int who_is_he = 0;

int curmudgeon = 0;				/* 1 = Randy Bush           */
int small_window = 0;
int no_overdrive = 0;
int no_resync = 0;
int no_sealink = 0;
int immed_update = 0;

unsigned long janus_baud = 0;

ADDR called_addr;
int mail_only = 0;
int caller;
int more_mail;
int doing_poll;

char far BBSwelcome[WELCOME_LEN + 1];	/* was 1024 */
char *aftermail = NULL;

struct FILEINFO dta_str = {0};
int slowmodem = 0;

PN_TRNS *pn_head = NULL;
ANUMS	*anum_head = NULL;
MDM_TRNS *mm_head = NULL;

unsigned have_windows = 0;
unsigned have_mos = 0;
unsigned have_dv = 0;
unsigned have_ddos = 0;
unsigned have_tv = 0;
unsigned have_ml = 0;
unsigned winslice = 0;
unsigned long lock_baud = 0;

/* Ideally we'd merge the ARQ and MNP stuff and have a new
   config verb that defined the strings and one that said lock
   on ARQ */

int ARQ_lock = 0;				/* If 1, baudrate is locked  */
int ARQs = 0;					/* Number of ARQ strings     */
char *ARQ[16];					/* Pointers to ARQ strings   */

int cMNP = 0;					/* Number of MNP strings     */
char *pchMNP[16];				/* Pointers to MNP strings   */

char e_input[255];

char *IDUNNO_msg = " ???";
char *local_CEOL = "\033[K";

char *wkday[] =
{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

char *nodelist_name = NULL;		/* Name of our nodelist      */
char *nodelist_base = NULL;		/* Name of current nodelist  */
char *max_areadat = NULL;

#ifdef V5_LIST
int newnodelist = 0;			/* if 1, use new nodelist.   */
#else
int newnodelist = 1;			/* if 1, use new nodelist.   */
#endif
int version7 = 0;				/* Support new V7 nodelist   */

int autobaud = 0;					/* Use highest baudrate when calling out */

unsigned short found_zone = 0;/* What zone found node is in*/
unsigned short found_net = 0;	/* What net found node is in */
struct _newnode newnodedes;	/* structure in new list     */

char far *node_index = (char far *) NULL;	/* pointer to node array     */

HISTORY hist;
BINK_EVENT far *e_ptrs;
int requests_ok = 1;
int num_events = 0;
int cur_event = -1;
int next_event = 0;
int got_sched = 0;
int noforce = 0;
int no_zones = 0;
int max_connects = 3;
int max_noconnects = 10000;
int server_mode = 0;
int forcexit = 0;				/* force exit errorlevel */
char *packer;
char *cleanup;
char *answerback;

time_t etm = (time_t) 0L;
long file_length = 0L;

long TX_FileSize;
long TX_StTime;
int TX_OldETA;

long RX_FileSize;
long RX_StTime;
int RX_OldETA;

char *XFER_str = " pos=        , len=    , ETA=     min.";
char *script_path;				/* Where the script files
                                                  * live */

char Rxhdr[4];					/* Received header           */
char Txhdr[4];					/* Transmitted header        */

#ifndef GENERIC
long *RXlong = (long *) &Rxhdr[0];
long *TXlong = (long *) &Txhdr[0];
#endif

long Rxpos;						/* Received file position    */
int Txfcs32;					/* TRUE means send binary
                                                  * frames with 32 bit FCS    */
int Crc32t;						/* Display flag indicating
                                                  * 32 bit CRC being sent */
int Crc32;						/* Display flag indicating
                                                  * 32 bit CRC being received */
int Znulls;						/* # of nulls to send at
                                                  * beginning of ZDATA hdr     */

int Rxtimeout;					/* Tenths of seconds to wait
                                                  * for something          */
int Rxframeind;					/* ZBIN ZBIN32,ZHEX type of
                                                  * frame received */

char *Filename;					/* Name of the file being
                                                  * up/downloaded             */

word z_size = 0;

byte Resume_WaZOO;				/* Flags resumption of
                                                  * aborted WaZOO xfer  */
char Resume_name[13];			/* "Real" name of file being
                                                  * received      */
char Resume_info[48];			/* File size&time info for
                                                  * rx file         */
char Abortlog_name[PATHLEN];	/* Path of WaZOO aborted
                                                  * xfer log      */

nfunc nodefunc = opusfind;		/* Nodelist function to use */
ufunc userfunc = fidouser;		/* Userlist function to use */

SB_COLORS colors = {7, 7, 7, 7, 7, 7, 112, 7};

#ifdef DOS16
struct vfossil_hooks vfossil_funcs;
#endif

int vfossil_installed = 0;
VIOMODEINFO vfos_mode;
char far blanks[264];

char *logptr;

MAILP mail_top;
MAILP next_mail;
long next_rescan = 0L;
long waitfor_line = 0L;			/* Used to limit collision*/

/* logic                  */

J_TYPESP j_top;
J_TYPESP j_next;
int janus_OK;
char saved_response[80];
char mdm_reliable[80];

/* First, the polynomial itself and its table of feedback terms.  The  */
/* polynomial is                                                       */
/* X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0 */
/* Note that we take it "backwards" and put the highest-order term in  */
/* the lowest-order bit.  The X^32 term is "implied"; the LSB is the   */
/* X^31 term, etc.  The X^0 term (usually shown as "+1") results in    */
/* the MSB being 1.                                                    */

/* Note that the usual hardware shift register implementation, which   */
/* is what we're using (we're merely optimizing it by doing eight-bit  */
/* chunks at a time) shifts bits into the lowest-order term.  In our   */
/* implementation, that means shifting towards the right.  Why do we   */
/* do it this way?  Because the calculated CRC must be transmitted in  */
/* order from highest-order term to lowest-order term.  UARTs transmit */
/* characters in order from LSB to MSB.  By storing the CRC this way,  */
/* we hand it to the UART in the order low-byte to high-byte; the UART */
/* sends each low-bit to hight-bit; and the result is transmission bit */
/* by bit from highest- to lowest-order term without requiring any bit */
/* shuffling on our part.  Reception works similarly.                  */

/* The feedback terms table consists of 256, 32-bit entries.  Notes:   */
/*                                                                     */
/*     The table can be generated at runtime if desired; code to do so */
/*     is shown later.  It might not be obvious, but the feedback      */
/*     terms simply represent the results of eight shift/xor opera-    */
/*     tions for all combinations of data and CRC register values.     */
/*                                                                     */
/*     The values must be right-shifted by eight bits by the "updcrc"  */
/*     logic; the shift must be unsigned (bring in zeroes).  On some   */
/*     hardware you could probably optimize the shift in assembler by  */
/*     using byte-swap instructions.                                   */

unsigned long far cr3tab[] =
{								/* CRC polynomial 0xedb88320 */
	0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3,
	0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988, 0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91,
	0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de, 0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7,
	0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5,
	0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172, 0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
	0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940, 0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59,
	0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f,
	0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924, 0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d,
	0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433,
	0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
	0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, 0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457,
	0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65,
	0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2, 0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb,
	0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0, 0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9,
	0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
	0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad,
	0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a, 0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683,
	0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8, 0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1,
	0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7,
	0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc, 0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
	0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252, 0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b,
	0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79,
	0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236, 0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f,
	0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d,
	0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a, 0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
	0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, 0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21,
	0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777,
	0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c, 0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45,
	0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2, 0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db,
	0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
	0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf,
	0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94, 0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d
};

/*
 *
 * -rev 04-16-87  (abbreviated)
 *  The CRC-16 routines used by XMODEM, YMODEM, and ZMODEM
 *  are also in this file, a fast table driven macro version
 */

/* crctab calculated by Mark G. Mendel, Network Systems Corporation */
unsigned short far crctab[256] =
{
	0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
	0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
	0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
	0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
	0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
	0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
	0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
	0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
	0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
	0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
	0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
	0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
	0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
	0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
	0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
	0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
	0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
	0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
	0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
	0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
	0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
	0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
	0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
	0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
	0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
	0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
	0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
	0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
	0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
	0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
	0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
	0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0
};

short SB_ROWS;
short SB_COLS;
char *stat_str = "%c %02i:%02i:%02i %         ";
char *script_line = "Script Line %03d: %         ";
int need_update = 0;
char *ver_stuff = "Compiled on " __DATE__ " at " __TIME__ "\r\n\r\n";
char *BadChars = "\026\021\b\377\376\375\374";
int pktrsp = 0;					/* MB 93-12-12  PKTRSP */

