/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*               Video FOSSIL definitions used in BinkleyTerm               */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

typedef struct
{
	int vfossil_size;
	int vfossil_major;
	int vfossil_revision;
	int vfossil_highest;
} VFOSSIL, *VFOSSILP;

#ifndef OS_2

typedef struct
{
	int cur_start;
	int cur_end;
	int cur_wid;
	int cur_attr;
} CURSOR, *CURSORP;

typedef CURSOR far *PVIOCURSORINFO;

typedef struct _VIOCONFIGINFO
{								/* vioin */
	USHORT cb;
	USHORT adapter;
	USHORT display;
	unsigned long cbMemory;
} VIOCONFIGINFO;

typedef VIOCONFIGINFO far *PVIOCONFIGINFO;

typedef struct _VIOMODEINFO
{								/* viomi */
	USHORT cb;
	unsigned char fbType;
	unsigned char color;
	USHORT col;
	USHORT row;
	USHORT hres;
	USHORT vres;
	unsigned char fmt_ID;
	unsigned char attrib;
} VIOMODEINFO;

typedef VIOMODEINFO far *PVIOMODEINFO;

#endif /* !defined OS_2 */

#ifdef _WIN32					/* Subset Vio with console calls */

USHORT VioWrtTTY (PCH pchString, USHORT cbString, USHORT hvio);
USHORT VioWrtCellStr (PCH pchCellString, USHORT cbCellString, USHORT usRow, USHORT usColumn, USHORT hvio);

#endif

#ifdef DOS16					/* Vio using VFOSSIL */

struct vfossil_hooks
{								/* VFossil calls structure */
	USHORT (pascal far * GetMode) (PVIOMODEINFO, USHORT);
	USHORT (pascal far * SetMode) (PVIOMODEINFO, USHORT);
	USHORT (pascal far * GetConfig) (USHORT, PVIOCONFIGINFO, USHORT);
	USHORT (pascal far * WrtTTY) (PCH, USHORT, USHORT);
	USHORT (pascal far * GetAnsi) (USHORT far *, USHORT);
	USHORT (pascal far * SetAnsi) (USHORT, USHORT);
	USHORT (pascal far * GetCurPos) (USHORT far *, USHORT far *, USHORT);
	USHORT (pascal far * SetCurPos) (USHORT, USHORT, USHORT);
	USHORT (pascal far * GetCurType) (PVIOCURSORINFO, USHORT);
	USHORT (pascal far * SetCurType) (PVIOCURSORINFO, USHORT);
	USHORT (pascal far * ScrollUp) (USHORT, USHORT, USHORT, USHORT, USHORT, PCH, USHORT);
	USHORT (pascal far * ScrollDn) (USHORT, USHORT, USHORT, USHORT, USHORT, PCH, USHORT);
	USHORT (pascal far * ReadCellStr) (PCH, USHORT far *, USHORT, USHORT, USHORT);
	USHORT (pascal far * ReadCharStr) (PCH, USHORT far *, USHORT, USHORT, USHORT);
	USHORT (pascal far * WrtCellStr) (PCH, USHORT, USHORT, USHORT, USHORT);
	USHORT (pascal far * WrtCharStr) (PCH, USHORT, USHORT, USHORT, USHORT);
	USHORT (pascal far * WrtCharStrAtt) (PCH, USHORT, USHORT, USHORT, PCH, USHORT);
	USHORT (pascal far * WrtNAttr) (PCH, USHORT, USHORT, USHORT, USHORT);
	USHORT (pascal far * WrtNCell) (USHORT far *, USHORT, USHORT, USHORT, USHORT);
	USHORT (pascal far * WrtNChar) (PCH, USHORT, USHORT, USHORT, USHORT);
};

/* Now for readability (and portability) ... */

#define VioGetMode(a,b)            (*vfossil_funcs.GetMode)(a,b)
#define VioSetMode(a,b)            (*vfossil_funcs.SetMode)(a,b)
#define VioGetConfig(a,b,c)        (*vfossil_funcs.GetConfig)(a,b,c)
#define VioWrtTTY(a,b,c)           (*vfossil_funcs.WrtTTY)(a,b,c)
#define VioGetANSI(a,b)            (*vfossil_funcs.GetANSI)(a,b)
#define VioSetANSI(a,b)            (*vfossil_funcs.SetANSI)(a,b)
#define VioGetCurPos(a,b,c)        (*vfossil_funcs.GetCurPos)(a,b,c)
#define VioSetCurPos(a,b,c)        (*vfossil_funcs.SetCurPos)(a,b,c)
#define VioGetCurType(a,b)         (*vfossil_funcs.GetCurType)(a,b)
#define VioSetCurType(a,b)         (*vfossil_funcs.SetCurType)(a,b)
#define VioScrollUp(a,b,c,d,e,f,g) (*vfossil_funcs.ScrollUp)(a,b,c,d,e,f,g)
#define VioScrollDn(a,b,c,d,e,f,g) (*vfossil_funcs.ScrollDn)(a,b,c,d,e,f,g)
#define VioReadCellStr(a,b,c,d,e)  (*vfossil_funcs.ReadCellStr)(a,b,c,d,e)
#define VioReadCharStr(a,b,c,d,e)  (*vfossil_funcs.ReadCharStr)(a,b,c,d,e)
#define VioWrtCellStr(a,b,c,d,e)   (*vfossil_funcs.WrtCellStr)(a,b,c,d,e)
#define VioWrtCharStr(a,b,c,d,e)   (*vfossil_funcs.WrtCharStr)(a,b,c,d,e)
#define VioWrtCharStrAtt(a,b,c,d,e,f) (*vfossil_funcs.WrtCharStrAtt)(a,b,c,d,e,f)
#define VioWrtNAttr(a,b,c,d,e)     (*vfossil_funcs.WrtNAttr)(a,b,c,d,e)
#define VioWrtNCell(a,b,c,d,e)     (*vfossil_funcs.WrtNCell)(a,b,c,d,e)
#define VioWrtNChar(a,b,c,d,e)     (*vfossil_funcs.WrtNChar)(a,b,c,d,e)

#endif							/* DOS16 */

#ifdef OS_2

#define INCL_SUB
#define INCL_VIO
/* #include <bsesub.h> */
#define CURSOR VIOCURSORINFO
#define CURSORP PVIOCURSORINFO

#endif							/* ifdef OS_2 */

