	.XLIST
	.XCREF
	PAGE	84,127		;FOR MINI PRINT
	TITLE	BTCHROOM.ASM
COMMENT ~
 .LIST ;******************************************** BTCHROOM.ASM
;          MAKE ROOM FOR COMMAND.COM'S BATCH FILE BLOCKS        *
;****************************************************************
;
;                            12/15/90
;
   A program which remains resident with 512 bytes after creating a
file 'BTCHRLSE.COM' which when run releases 'BTCHROOM's resident
code for use by COMMAND.COM for it's 'BATCH Information Block'.
   When COMMAND.COM executes a batch file it 1) opens the file,
2) reads a line, 3) closes the file after recording the file's name
and location of the last line read and 4) then executes the line.
This information is kept in RAM in what I will call a 'Batch File
Information' block, part of the DOS memory chain which I will call
a 'Batch File Information Block'.
   When running any batch file COMMAND.COM uses the 1st open memory
block for it's 'Batch File Information Block' if there is no free room
it puts this block at the top of free ram.
   When running a batch file which releases TSR's from memory using
such programs as 'MARK/RELEASE', if this block is at the top of free
ram the release program kills this 'information' block causing
COMMAND.COM to hang when it can't find it's batch file information.
   Running 'BTCHROOM' in your AUTOEXEC.BAT file before the 1st release
point leaves it resident with a size of 512 bytes and creates the file
'BTCHRLSE.COM'.
   After all the TSR's are loaded, run the new file 'BTCHRLSE', again
from your AUTOEXEC.BAT, which will release 'BTCHROOM' leaving a 512K
'hole' for COMMAND.COM to use which will not be lost when a batch file
using the 'RELEASE' portion of 'MARK/RELEASE' is run and will erase
itself from the disk.
;
~ ; COMMENT
;****************************************************************
;
LF	EQU	0AH
CR	EQU	0DH
;
S0000	SEGMENT
	ASSUME DS:S0000, SS:S0000 ,CS:S0000 ,ES:S0000
	ORG	$+0100H
;
;****************************************************************
;
; START
;
L0100	PROC	NEAR
;
	MOV	BX,1000H		;FREE ALL BUT 64K
	MOV	AH,4AH
	INT	21H			;FREE ALLOCATED MEMORY
	MOV	AX,DS:[002CH]		;POINT TO OUR ENVIRONMENT
	MOV	WORD PTR BRENVT,AX	;FOR BTCHRLSE
	MOV	AX,CS			;GET OUR SEGMENT
	MOV	WORD PTR BRCODE,AX	;FOR BTCHRLSE
	MOV	SI,0081H
	MOV	CL,BYTE PTR [SI-1]	;GET COUNT
	XOR	CH,CH
	JCXZ	L0119			;NO INPUT, make BTCHRLSE
	MOV	DI,SI
	CLD
	MOV	AL,'?'
	REPNZ	SCASB
	JNZ	L0119
;
;	GIVE HELP
;
HELP:	MOV	DX,OFFSET HLPMSG
	MOV	AH,09
	INT	21H
	INT	20H
;
;----------------------------------------------------------------
;
HLPMSG	LABEL NEAR
 DB CR,LF,'BTCHROOM.COM              '
 DB 'Community Business Systems                   12/15/90'
 DB CR,LF,LF
 DB "Creates a 512 byte block of free ram for COMMAND.COM's "
 DB "batch file block so that"
 DB CR,LF
 DB "it will not 'loose itself' when releasing memory using "
 DB "a TSR release program.  Run 'BTCHROOM' before any 'RELEASE' "
 DB "programs in your"
 DB CR,LF
 DB "'AUTOEXEC.BAT' and then run 'BTCHRLSE' after all removable "
 DB "TSR's are loaded."
 DB CR,LF,'$'
;
;----------------------------------------------------------------
;
; PUT 'BTCHRLSE.COM' IN OUR ENVIRONMENT
;
L0119:	PUSH	ES
	 MOV	AX,CS:002CH		;POINT TO OUR ENVIRONMENT
	 MOV	ES,AX
	 MOV	CX,OFFSET BADFIL
	 MOV	SI,OFFSET FNTSTR
	 SUB	CX,SI			;LGT OF STR
	 XOR	DI,DI			;ES:DI->OUR ENVIRONMENT
	 MOV	AX,DI
	 STOSW				;STO 0000
	 INC	AX
	 STOSW				;STO 0001
	 REP	MOVSB			;PUT STRING IN ENVIRONMENT
	POP	ES	 
	MOV	DX,OFFSET FNTSTR
	MOV	AX,4300H		;GET FILE ATTR
	INT	21H
	TEST	CL,0110B		;HIDDEN OR SYSTEM FILE?
	JNZ	BADFIL			;YES
	MOV	AX,4301H		;NO, SET FILE ATTR
	MOV	CX,0000			;TO R/W
	INT	21H
	MOV	AH,3CH			;CREATE FILE @ DX
	MOV	CX,0020H		;ATTR
	INT	21H
	JB	L0152			;ERROR
	MOV	BX,AX
	MOV	AH,40H			;WRITE TO FILE
	MOV	DX,OFFSET RLSPGM		;POINT TO FILE
	MOV	CX,OFFSET ENDRLS-OFFSET RLSPGM	;LENGTH TO WRITE
	INT	21H				;WRITE IT
	MOV	AH,3EH			;CLOSE IT
	INT	21H
	MOV	DX,OFFSET INSTLMS
	MOV	AH,09
	INT	21H
	MOV	DX,0032			;RESERVE .5K
	MOV	AX,3100H
	INT	21H			; LEAVE BATCH FILE ROOM
;
;----------------------------------------------------------------
;
BDFLMS	DB CR,LF,"*** HIDDEN OR SYSTEM FILE, can't overwrite ***"
	DB CR,LF,'$'
INSTLMS	DB "*** BTCHROOM installed, run 'BTCHRLSE' ***",CR,LF,'$'
;
FNTSTR	DB 'BTCHRLSE.COM',00			; Name for file to create
;
;	HIDDEN OR SYSTEM FILE, NO CAN DO
;
BADFIL:	POP	DX
	MOV	DX,OFFSET BDFLMS
	MOV	AH,09
	INT	21H
;
;****************************************************************
;
; FILE ERROR, RING BELL
;
L0152:	MOV	AX,0E07H		;TTY OUT & BELL
	INT	10H
	INT	20H			;BACK TO DOS
;
L0100	ENDP
;
;****************************************************************
; USER SUPPLIED FN.T START, RUNS TO RELEASE MEMORY
;****************************************************************
;
RLSPGM	PROC	NEAR
;
	MOV	BX,1000H		;FREE ALL BUT 64K
	MOV	AH,4AH
	INT	21H			;FREE ALLOCATED MEMORY
BRENVT	EQU	$+1			;BTCHROOM's environment
	MOV	DX,0000			;Get BTCHROOM'S environmene segment
	MOV	ES,DX			;To ES
	MOV	AH,49H			;Free it
	INT	21H
BRCODE	EQU	$+1			;BTCHROOM's code
	MOV	DX,0000			;GET BTCHROOM'S code segment
	MOV	ES,DX
	MOV	AH,49H			;Free it
	INT	21H
; Now erase us
	MOV	ES,CS:[002CH]		;POINT TO OUR ENVIRONMENT
	CALL	FNDNAM			;FIND OUR NAME
	MOV	DX,DI
	PUSH	ES
	POP	DS			;DS:DX->OUR FN.T
	MOV	AX,4300H		;GET FILE ATTR
	INT	21H
	TEST	CL,0110B		;ARE WE HIDDEN OR SYSTEM?
	JNZ	NOKILL			;YES
	MOV	DX,DI
	MOV	AX,4301H		;NO, SET FILE ATTR
	MOV	CX,0000			;TO R/W
	INT	21H
	MOV	DX,DI
	MOV	AH,41H			;AND DELETE US
	INT	21H
;
;	WE ARE HIDDEN OR SYSTEM FOR SOME REASON, DON'T ERASE
;
NOKILL:	PUSH	CS
	POP	DS
	MOV	DX,OFFSET DONMSG+100H-OFFSET RLSPGM	;GET MSG OFST FRM START
	MOV	AH,09
	INT	21H
	INT	20H
;
;****************************************************************
;
;	POINT ES:DI->THE FILENAME IN THE ENVIRONMENT @ CS:
;
FNDNAM	PROC NEAR
;
	XOR	DI,DI
	MOV	AX,DI
	MOV	CX,0FFFFH
;
;	LOOP TO OUR NAME IN OUR ENVIRONMENT TO ERASE US
;
FNDNM1:	REPNZ	SCASB			;FIND A NULL
	SCASB				;2ND NULL?
	JNZ	FNDNM1			;NO
	ADD	DI,0002			;YES, ES:DI->OUR NAME IN ENVIRONMENT
	RET
FNDNAM	ENDP
;
;****************************************************************
;
DONMSG	DB CR,LF
	DB '           Removing: BTCHROOM',CR,LF
	DB '  *** .5K ROOM MADE FOR BATCH FILE BLOCKS ***',CR,LF,'$'
;
RLSPGM	ENDP
;
;****************************************************************
;
ENDRLS	EQU	$
	S0000	ENDS
	END	L0100
