;AUTOPURG function to automatically purge all unused blocks, layers, etc
;Created to work with RUN LISP, our drawing batch processing program.
;See RUNLISP.TXT for more details

;Released into the public domain the the author, Sierra Hermitage
;
;Sierra Hermitage
;Rod Young, programmer
;140 Mesa Vista Drive
;Bishop, CA  93514
;Phone 619-387-2479 (voice)   619-387-2488 (data/fax, seldom enabled)
;E-mail hermit1@ix.netcom.com

(defun AUTOPURG ()
        (command "purge" "a" )
        (while (= (getvar "CMDNAMES") "PURGE")
                (command "y" )
        );end while
		;save the changes - do this if your program makes changes
		;to the drawing - see comments below
        (command "qsave" )
)
;make this program 'load and go' by running itself
;Be sure to do this in all programs to be used with RUN LISP
(autopurg)

;Comments
;Unless changes to your drawing are saved, AutoCad automatically displays
;the Drawing Modification dialogue box.  RUN LISP does not respond to this
;dialogue box and you would therefor have to respond manually each time
;another drawing is opened.  If for any reason you do not want to save the
;changes made by your AutoLisp program, use copies of your drawing files
;in another directory and have your AutoLisp program save the changes to
;avoid having to respond to the Drawing Modification dialogue box manually.
;Also, please note that AutoCad considers even a zoom to be a change to
;the drawing.