; Partition Table Loader
;
; Originally by Wout Mertens, additions by Inbar Raz
;

.model small, pascal

.code

; Notice how I solve the org problem - I simply put it in its native order -
; BEFORE the org 07C00h

        org (600h + (offset here - offset start))       ; Inbar Raz

NewCode EQU $                                           ; Inbar Raz

        org 7c00h

part        proc    near

start:      ; Relocate to make room for boot sector
        cli             ; Disable interrupts
        xor ax,ax           ; Zero register
        mov ss,ax
        mov es,ax
        mov ds,ax
        mov sp,7C00h
        sti             ; Enable interrupts

        mov si,sp
        mov di,600h
        mov cx,100h
        cld             ; Clear direction
        repne   movsw           ; Move loader to 600h


; This JMP yield CS:[61D], and we don't need the square brackets. Also, your
; code is actually trying to issue JMP an IMMEDIATE value - can't do that in
; ASM sources. You need an offset to JMP to, and that's what I gave it.

;        jmp cs:(600h + (here - start)) ;btw, I don't think this is kosjer :)

        jmp cs:NewCode                                  ; Inbar Raz

;----------------------------------------------------------------------

; Here we erase the ORG. Since we know where this begins (for SI purposes on
; MOVSB), and we know where it's going (we've set DI on that MOVSB), we don't
; need any ORGing here. On the contrary - we need this code to be completely
; consecutive to the previous code.

;        org (600h + (here - start)) ;This kills off tasm 3.1   ; Inbar Raz

; Here you used an offset that, upon assembly, gets an offset with a base
; of 7C00h (remember the ORG?). You have to make the calculation, because you
; wrote this code KNOWINGLY it would be re-located to 600h.

;here:   mov si,offset LoadMsg
here:   mov si,offset LoadMsg - (7c00h - 600h)          ; Inbar Raz
        call    Print

Go:     mov dh,0
        mov si,7beh         ; Offset of new part.table
        mov bl,4

Find:       ; Find boot partition
        cmp byte ptr [si],80h
        je  Found
        cmp byte ptr [si],0
        jne BadTable

        add si,10h
        dec bl
        jnz Find            ; Loop through table

        int 18h         ; ROM basic (If any :] )

Found:  mov dx,[si]         ; dh=Head num, dl=80h (being the first hd)
        mov cx,[si+2]       ; cx=cyl&sect of boot
        mov bp,si

; Load boot sector

        mov di,5            ; Try 5 times
Retry:
        mov bx,7C00h
        mov ax,201h
        push    di
        int 13h         ; Disk  dl=drive ah=func 02h
                        ;  read sectors to memory es:bx
                        ;   al=#,ch=cyl,cl=sectr,dh=head

        pop di
        jnc Ok

        xor ax,ax           ; Zero register
        int 13h         ; Disk  dl=drive ah=func 00h
                        ;  reset disk, al=return status
        dec di
        jnz Retry

        jmp LoadErr

Ok:
        mov di,7DFEh        ; Boot sector ID
        cmp word ptr [di],0AA55h
        jne NoSys

        mov si,bp
;*      jmp far 0000:7C00       ; Jump to bootsector
        db  0EAh
        dw  7C00h, 0

BadTable:

        mov si, offset BadTableMsg
        jmp PErr

LoadErr:

        mov si, offset LoadErrMsg
        jmp PErr

NoSys:  mov si, offset NoSysMsg
PErr:   call    Print
LockUp: jmp LockUp

part        endp


Print   proc near

        mov bx,7
        mov ah,0Eh
Next:
        lodsb               ; String [si] to al
        cmp al,0
        je  EOS
        int 10h         ; Video display   ah=functn 0Eh
                        ;  write char al, teletype mode
        jmp Next

EOS:    ret

Print   endp

BadTableMsg db  'Bad partition table', 0
LoadErrMsg  db  'Error loading boot sector (disk bad?)', 0
NoSysMsg    db  'Missing operating system', 0
LoadMsg     db  'Loading MBR...', 0Dh, 0Ah, 0

; This is my partition table... of course, there should be I think 16 more
; 0s, 'cause my code is shorter :) And in fact, it shouldn't be here, but
; that's for later (loader)

; It it bad programing for all those DB DUPs. People who read the source find
; it often difficult to understand you. Not to mention that your count wasn't
; correct, and that led the partition information to start at the wrong
; offset. What's wrong in simply ORGing to the right offset?

;        db  173 dup (0)                ; Inbar Raz

        org     Start + 01BEh           ; Inbar Raz

        db   80h, 01h, 01h, 00h, 06h, 0Eh
        db   7Eh,0C0h, 3Eh, 00h, 00h, 00h
        db  0E4h, 5Eh, 06h, 00h, 00h, 00h
        db   41h,0C1h, 05h, 0Eh,0FEh, 81h
        db   22h, 5Fh, 06h, 00h, 22h, 5Fh
        db   06h

        ;db  33 dup (0)                 ; Inbar Raz - same comment

        org     Start + 01FEh           ; Inbar Raz - Same comment

; Marks a valid boot sector.

        db   55h,0AAh


end start
-----------------------------------

Ok, this works.
One last thing - when you REALLY intend to put it into a disk, drop the

        ORG     7C00h

Because this source must be compiled to a COM/BIN file with an IP of 0000h. This
means that the calculation of offsets remains, because the sector _IS_ loaded
into 7C00h, but the ORG must go.

