; From Robert Winter  - 16bit CRC
;This code snippit is from the electronic book ASM101 (registered)
;I strongly recommend this book to anyone who programs in ASM.

;------------------------------------------ 
; COMPUTE 16 BIT (XMODEM) CRC 
; 
; CALL WITH   DS:SI = PTR TO BUFFER 
;             CX    = BUFFER LEN 
; RETURN WITH AX    = CRC16 OF BUFFER 
;             CX    = 0 
;             SI    = PTR TO END OF BUFFER 
; 
XMODEM:  PUSH  BX                      ; PRESERVE REG 
 
                 ;    \/  \/  \/ 
                 ; FEDCBA9876543210B 
         MOV   BX,00001000000100001B   ; GET SDLC X.25 (XMODEM) 
                                       ; CRC MAGIC NUMBER 01021H 
         XOR   AX,AX              ; SET INITIAL CRC 
 
CRCLOP1: XOR   AH,[SI]            ; CRC := CRC xor AX 
         INC   SI                 ; MOVE TO NEXT BYTE IN TABLE 
 
         SHL   AX,1               ; AX << 2 
         JNC   CRC11 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC11:   SHL   AX,1               ; AX << 2 
         JNC   CRC12 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC12:   SHL   AX,1               ; AX << 2 
         JNC   CRC13 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC13:   SHL   AX,1               ; AX << 2 
         JNC   CRC14 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC14:   SHL   AX,1               ; AX << 2 
         JNC   CRC15 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC15:   SHL   AX,1               ; AX << 2 
         JNC   CRC16 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC16:   SHL   AX,1               ; AX << 2 
         JNC   CRC17 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
CRC17:   SHL   AX,1               ; AX << 2 
         JNC   CRC18 
         XOR   AX,BX              ; XOR IN MAGIC NUMBER 
 
CRC18:   LOOP  CRCLOP1            ; LOOP OF MORE CRC TO COMPUTE 
         POP   BX                 ; RESTORE REGS AND END 
         RET 

