;-------------------------
;     From: Craig Jackson
;  Subject: RANDOM NUMBERS
 
;    This is what I use, it's not the best statistically but it's small
;and fast.  If you want something better, I'd suggest looking at a copy
;of "Numerical Recipes in C: The Art of Scientific Computing" by Press,
;Flannery, Teukolsky, and Vetterling (ISBN 0-521-35465-X); it's truely
;a great book.  Sorry for the lack of comments in the source.
 
    ; Seed random number generator
    mov     ah,02Ch                 ;Get system time
    int     21h                     ;   Interrupt: DOS
    mov     wRandomSeed,dx          ;
 
;Generate random number
;  Arguments: BX = Random maximum + 1
;  Returns  : AX = Random number
;  Destroys : DX DI
Random  PROC
    mov     dx,106                  ;
    mov     ax,wRandomSeed          ;
    mul     dx                      ;
    add     ax,1283                 ;
    mov     di,6075                 ;
    adc     dx,0                    ;
    div     di                      ;
    mov     ax,dx                   ;
    mul     bx                      ;
    div     di                      ;
    mov     wRandomSeed,ax          ;
    ret                             ;
Random ENDP
 
