;--------------------------------
; PRINTHEX.ASM by CHAD WAGNER

PUBLIC  PrintHexNumber

CSEG            SEGMENT PUBLIC  'CODE'
                ASSUME  CS:CSEG,DS:CSEG

; Load the value to be printed in AX register, this routine will print the
; hexadecimal equivalent.
;
; Written by Chad Wagner, 1:369/11, Chad.Wagner@branch.fidonet.org

PrintHexNumber  PROC    FAR
                PUSH    AX
                PUSH    BX
                PUSH    CX
                PUSH    DX              ; Save all registers.
                MOV     BX,AX

                MOV     CL,04h
                SHR     AH,CL
                MOV     AL,AH
                CALL    PrintHexDigit   ; Display value for bits 12-16
                MOV     AX,BX

                MOV     AL,AH
                CALL    PrintHexDigit   ; Display value for bits 8-11
                MOV     AX,BX

                SHR     AL,CL
                CALL    PrintHexDigit   ; Display value for bits 4-7

                MOV     AX,BX
                CALL    PrintHexDigit   ; Display value for bits 0-3

                POP     DX
                POP     CX
                POP     BX
                POP     AX              ; Restore registers.
                RETF

PrintHexDigit:  PUSH    AX
                PUSH    DX              ; Save registers
                AND     AL,00Fh
                CMP     AL,009h         ; Is it greater than nine?
                JBE     Ok
                ADD     AL,007h         ; Yes, it's a letter then.
Ok:             ADD     AL,030h
                MOV     DL,AL
                MOV     AH,002h
                INT     021h            ; Print digit.

                POP     DX
                POP     AX              ; Restore registers.
                RETN
PrintHexNumber  ENDP
CSEG            ENDS
                END


