#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	intrflush

#ifdef PDCDEBUG
char *rcsid_intrflus = "$Header: C:\CURSES\portable\RCS\intrflus.c 2.1 1993/06/18 20:20:11 MH Rel MH $";
#endif




/*man-start*********************************************************************

  intrflush()	- enable flush on interrupt

  X/Open Description:
 	If this option is enabled (bf is TRUE), and an interrupt is
 	pressed on the keyboard (INTR, BREAK, or QUIT) all output in
 	the terminal driver queue will be flushed, giving the effect
 	of faster response to the interrupt but causing curses to have
 	the wrong idea of what is on the screen.  Disabling the option
 	prevents the flush.  The default for the option is inherited
 	from the terminal driver settings.  The window argument is
 	ignored.

  PDCurses Description:
 	No additional functionality.

  X/Open Return Value:
 	The intrflush() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int intrflush( WINDOW* win, bool bf );
 	X/Open Dec '88	int intrflush( WINDOW* win, bool bf );
 	BSD Curses	
 	SYS V Curses	

**man-end**********************************************************************/

int	intrflush( WINDOW *win, bool bf )
{
#ifdef	TC
#  pragma argsused
#endif
	int	y;
	int	maxy;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("intrflush() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	maxy = win->_maxy - 1;

	for (y = 0; y <= maxy; y++)
	{
		win->_firstch[y] = _NO_CHANGE;
	}
	return( OK );
}
