// Associated include file : ToolBox/Math/FFT.H

#include <math.h>
#include "ToolBox/Math/Complex.H"
#include "ToolBox/Math/FFT.H"

// Variables locales

int       tfN,tfP;
int      *NewI;
complex  *wAngle[2];

// Init/Done des TFs

int NewIndice(int n)
{ int r=0,j,mask,val;
  mask=1;
  val=1 << (tfP-1);
  for(j=0;j<tfP;j++)
  { if (n & mask) r+=val;
    mask<<=1;
    val>>=1;
  }
  return r;
}

void InitTF(int N, int P)
{ int   i;
  float Angle;
  tfP=P;
  tfN=N;
  NewI=new int[N];
  wAngle[0]=new complex[N];
  wAngle[1]=new complex[N];
  for(i=0;i<N;i++)
	 NewI[i]=NewIndice(i);
  Angle=M_PI;
  for(i=1;i<tfN;i<<=1)
  { wAngle[0][i]=complex(cos(-Angle),sin(-Angle));
	 wAngle[1][i]=complex(cos(+Angle),sin(+Angle));
    Angle/=2;
  }
}

void DoneTF(void)
{ delete NewI;
  delete wAngle[0];
  delete wAngle[1];
}

void TF1(complex *Src, complex *Dst)
{ int      i,NbTre,NbPap;
  int      NumTre;
  int      BasePap,OffsetPap;
  complex  w,wk,T;
  // Change l'ordre des donnes
  for(i=0;i<tfN;i++) Dst[NewI[i]]=Src[i]/tfN;
  //
  NbTre=tfN/2;
  for(NbPap=1;NbPap<tfN;NbPap<<=1)
  { w=wAngle[0][NbPap];
	 BasePap=0;
	 for(NumTre=0;NumTre<NbTre;NumTre++)
	 { wk.real()=1; wk.imag()=0;
		for(OffsetPap=BasePap;OffsetPap<BasePap+NbPap;OffsetPap++)
		{ T=Dst[OffsetPap+NbPap]*wk;
		  Dst[OffsetPap+NbPap]=Dst[OffsetPap]-T;
		  Dst[OffsetPap]+=T;
		  wk*=w;
      }
      BasePap+=NbPap << 1;
    }
    NbTre>>=1;
  }
}

void TF1i(complex *Src, complex *Dst)
{ int      i,NbTre,NbPap;
  int      NumTre;
  int      BasePap,OffsetPap;
  complex  w,wk,T;
  // Change l'ordre des donnes
  for(i=0;i<tfN;i++) Dst[NewI[i]]=Src[i];
  //
  NbTre=tfN/2;
  for(NbPap=1;NbPap<tfN;NbPap<<=1)
  { w=wAngle[1][NbPap];
    BasePap=0;
    for(NumTre=0;NumTre<NbTre;NumTre++)
    { wk.real()=1; wk.imag()=0;
      for(OffsetPap=BasePap;OffsetPap<BasePap+NbPap;OffsetPap++)
      { T=Dst[OffsetPap+NbPap]*wk;
        Dst[OffsetPap+NbPap]=Dst[OffsetPap]-T;
        Dst[OffsetPap]+=T;
        wk*=w;
      }
      BasePap+=NbPap*2;
    }
    NbTre>>=1;
  }
}