//*****************************************************************************
// PROGRAM NAME:: MXSYSINF.C, Version 1.0  REVISED DATE:: 8/29/2002.
//*****************************************************************************
// PROGRAM DESIGNED FOR MICRO-X Ver. 1.5.5 AS A PROGRAM FOR DISPLAYING
// OPERATOR SYSTEM INFORMATION.  
//*****************************************************************************
//
// ***********************************************
// [ Appendix: Terms Conditions and Aggreements ]
// ***********************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
//
//                       TERMS AND CONDITIONS
// ----------------------------------------------------------------------------
//
//                         NO WARRANTY
// BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                     END OF TERMS AND CONDITIONS
// ----------------------------------------------------------------------------
//
// *****************************************
// ----------------------------------------
// [ START OF MAIN PROGRAM FOR Mxsysinf.c ]
// ----------------------------------------
// *****************************************
// ----------------------------------------
// [ Header file include section ]
// ----------------------------------------
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <time.h>
#include <dpmi.h>
#include <go32.h>
#include <libc.h>
#include <dos.h>
#include <dir.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <errno.h>
#include <bios.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <process.h>

// Error handeler Function
int ER_FLG = 0;
void Set_screen(void);
void Err_Handler(int ER_FLG);
void Accs_time_date(void);

// Start Of Main Program Code ...
int main(int argc, char **argv)
{
   _go32_dpmi_registers r;
   int video_mode = 0;
   int LocalScrn_y = 0;
   int LocalScrn_x = 0;
   extern int ER_FLG;
   FILE *fp;
   unsigned *scrn_buf;
   signed int prg_rt_code;
   char mx_mainid[ ] = "60800MX155";
   char id_chk[11];
   int current_drive;
   int press_key = 0;
   extern char **environ;

   scrn_buf = (unsigned *)alloca(ScreenRows()*ScreenCols()*2);
   _fmode = O_BINARY;
   fflush(stdout);
   fflush(stdin);
//........
   if ((strlen(argv[1]) > 10) || (strlen(argv[1]) <= 0))
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG);
     exit(2);
   }
//........
   if (argc > 3)
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG);
     exit(2);
   }
// .......
   fp = fopen("accs.tmp", "w");
   if(fp == NULL)
   {
     ER_FLG = 1;
     Err_Handler(ER_FLG);
     exit(1);
   }
   fprintf(fp, "%s", argv[1]);
   fclose(fp);
   fp = fopen("accs.tmp", "r");
   fscanf(fp, "%s", id_chk);
   fclose(fp);
   remove("accs.tmp");
//........
   if (strcmp(mx_mainid, id_chk) != 0)
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG);
     exit(2);
   }

// Main program INI startup ...
   video_mode = ScreenMode();
   LocalScrn_y = wherey();
   LocalScrn_x = wherex();
   ScreenRetrieve(scrn_buf);
   textmode(C80);
   gppconio_init();
   ScreenClear();
   _setcursortype(_NOCURSOR);
   ScreenSetCursor(0, 0);
   Set_screen();

   while(press_key != K_Escape)
   {
     Accs_time_date();

     if(kbhit())
     {
       press_key = getkey();
     }
   }

// Code For Exit Routine
   press_key = 0;
   r.h.ah = 0x00;
   r.h.al = video_mode;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   if (LocalScrn_y >= 25)
   {
      LocalScrn_y -= 1;
   }
   if (LocalScrn_x >= 80)
   {
     LocalScrn_x -= 1;
   }
   ScreenUpdate(scrn_buf);
   _setcursortype(_NORMALCURSOR);
   ScreenSetCursor(LocalScrn_y, LocalScrn_x);
   return(0);
}

// Timer Handler Function ....
void Accs_time_date(void)
{
    time_t now;

    ScreenSetCursor(8, 43);
    time(&now);
    cprintf("%-26s", asctime(localtime(&now)));
    return;
}

// Screen setup Function ....
void Set_screen(void)
{
    _go32_dpmi_registers r;
    int ys = 0;
    int xs = 0;
    int y_scrn = 0;
    int x_scrn = 0;
    int t = 0;
    unsigned int physical_mem = 0;
    unsigned int virtual_mem = 0;
    unsigned phy_mem_mb = 0;
    unsigned virt_mem_mb = 0;
    char c = '\x0F';
    char Itm_8[38];
    char Itm_9[38];
    int cur_ybase;
    int cur_xbase;
    int itm_sbcrp;
    int clk_set;
    char *buf = (char*)alloca(MAXGETHOSTNAME);

    _go32_dpmi_meminfo info;
    _go32_dpmi_get_free_memory_information(&info);
//..................    
    textbackground(3);
    textcolor(0);
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xC9');
    x_scrn = 1;
    ScreenSetCursor(y_scrn, x_scrn);
    r.h.ah = 0x09;
    r.h.al = 0xCD;
    r.h.bh = 0x00;
    r.h.bl = 0x30;
    r.x.cx = 0x4F;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    x_scrn = 79;
    y_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xBB');
    y_scrn = 1;
    x_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xBA');
    x_scrn = 1;
    xs = 1;
    while (xs != 24)
    {
        ScreenSetCursor(y_scrn, x_scrn);
        r.h.ah = 0x09;
        r.h.al = 0xB0;
        r.h.bh = 0x00;
        r.h.bl = 0x0F;
        r.x.cx = 0x4F;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        x_scrn = 79;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xBA');
        ++y_scrn;
        x_scrn = 0;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xBA');
        x_scrn = 1;
        ++xs;
    }
    y_scrn = 24;
    x_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xC8');
    ++x_scrn;
    ScreenSetCursor(y_scrn, x_scrn);
    r.h.ah = 0x09;
    r.h.al = 0xCD;
    r.h.bh = 0x00;
    r.h.bl = 0x30;
    r.x.cx = 0x4F;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    x_scrn = 79;
    y_scrn = 24;
    ScreenSetCursor(y_scrn, x_scrn);
    ScreenPutChar('\xBC', (CYAN << 4) | BLACK, x_scrn, y_scrn);
    ScreenPutString(" Micro-x Ver. 1.5.5 ", (RED << 4) | WHITE, 29, 0);
    textbackground(1);
    textcolor(15);
    ScreenSetCursor(2, 7);
    cprintf("%c", '\xDA');
    ScreenSetCursor(2, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x1F;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(2, 72);
    cprintf("%c", '\xBF');
    ScreenSetCursor(3, 7);
    cprintf("%c ", '\xB3');
    ScreenSetCursor(3, 71);
    cprintf(" %c", '\xB3');
    ScreenSetCursor(4, 7);
    cprintf("%c", '\xC0');
    ScreenSetCursor(4, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x1F;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(4, 72);
    cprintf("%c", '\xD9');
    ScreenPutString("     M I C R O - X    S Y S T E M   I N F O R M A T I O N     ", (CYAN << 4) | BLACK, 9, 3);
    textbackground(0);
    textcolor(14);
    ScreenSetCursor(6, 7);
    cprintf("%c", '\xDA');
    ScreenSetCursor(6, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x0E;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(6, 72);
    cprintf("%c", '\xBF');
    ScreenSetCursor(7, 7);
    cprintf("%c", '\xB3');
    x_scrn = 8;
    y_scrn = 7;
    xs = 1;
    while (xs != 16)
    {
        ScreenSetCursor(y_scrn, x_scrn);
        r.h.ah = 0x09;
        r.h.al = 0x20;
        r.h.bh = 0x00;
        r.h.bl = 0x0E;
        r.x.cx = 0x40;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        x_scrn = 72;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xB3');
        ++y_scrn;
        x_scrn = 7;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xB3');
        x_scrn = 8;
        ++xs;
    }
    ScreenSetCursor(22, 7);
    cprintf("%c", '\xC0');
    ScreenSetCursor(22, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x0E;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(22, 72);
    cprintf("%c", '\xD9');
    if(clk_set == 1)
    {
     ScreenPutString("                            ", (RED << 4) | WHITE, 7, 20);
     textbackground(4);
     textcolor(15);
     ScreenSetCursor(20, 33);
     cprintf("%c", c);
    }
// ........
    textbackground(0);
    textcolor(15);
    ScreenSetCursor(6, 25);
    cprintf(" Current System Information ");

    textbackground(0);
    textcolor(15);
    ScreenSetCursor(8, 11);
    cprintf("Current Date And Current Time :");

    textbackground(0);
    textcolor(3);
    ScreenSetCursor(10, 29);
    cprintf("System Base Infromation");

    textbackground(0);
    textcolor(3);
    ScreenSetCursor(11, 9);
    gethostname(buf, MAXGETHOSTNAME);
    cprintf("Host Name = %-48s", buf);

    textbackground(0);
    textcolor(3);
    ScreenSetCursor(12, 9);
    cprintf("User's Group ID = %d", getgid());

    textbackground(0);
    textcolor(3);
    ScreenSetCursor(13, 9);
    cprintf("User's ID = %d", getuid());

    textbackground(0);
    textcolor(2);
    ScreenSetCursor(16, 27);
    cprintf("Available System's Memory");

    ScreenSetCursor(17, 9);
    physical_mem = _go32_dpmi_remaining_physical_memory();
    phy_mem_mb = physical_mem / 1024;
    phy_mem_mb = phy_mem_mb / 1024;
    cprintf("Physical Memory = %-8.0umb", phy_mem_mb);

    ScreenSetCursor(17, 42);
    cprintf("Number Of Pages = %-8.0u", info.available_physical_pages);

    ScreenSetCursor(18, 9);
    virtual_mem = _go32_dpmi_remaining_virtual_memory();
    virt_mem_mb = virtual_mem / 1024;
    virt_mem_mb = virt_mem_mb / 1024;
    cprintf("Virtual Memory = %-8.0umb", virt_mem_mb);

    ScreenSetCursor(18, 42);
    cprintf("Maximun Pages = %-8.0u", info.max_pages_in_paging_file);

    textbackground(0);
    textcolor(14);
    ScreenSetCursor(20, 26);
    cprintf("[  Press Escape To Exit  ]");

    textbackground(0);
    textcolor(14);
    return;
}
//
// Error Handeler Function...
void Err_Handler(int ER_FLG)
{
    int Err = 0;
    int presskey = 0;

    unsigned *saved_scrn = (unsigned *)alloca(ScreenRows()*ScreenCols()*2);
    Err= ER_FLG;

    if(Err == 1)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxsysinf Ver. 1.0. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("For Use With Micro-x Accessor System Version 1.5.5\n\r");
        cprintf("File Access  !! Error !!  in Mxsysinf.exe\n\r");
        cprintf("Check the Micro-x Files and Directory, and ensure they are correct.\n\r");
        cprintf("Read the Micro-x documentation files for more detailed information ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        ScreenUpdate(saved_scrn);
        return;
    }
//........
    if(Err == 2)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxsysinf Ver. 1.0. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("For Use With Micro-x Accessor System Version 1.5.5\n\r");
        cprintf("!! Error !! ... In Mxsysinf.exe, Infromation Display Program.\n\r");
        cprintf("Invalid Chain Link Id.  Use Mxloder.exe to run this Program.\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        ScreenUpdate(saved_scrn);
        return;
    }
//.........    
    ScreenUpdate(saved_scrn);
    return;
}
//
// *************************************************************
// [ End of program for Mxsysinf.c Information Display Program ]
// *************************************************************
