//**************************************************************************
// Program Name : Mxed.cc THE MICRO-X ACCESSOR SYSTEM EDITOR Ver. 2.2
//**************************************************************************
//
//**************************************************************************
// Date Revised : march 16, 2003
//**************************************************************************
//
//**************************************************************************
// [ Appendix: Terms Conditions and Aggreements ]
//**************************************************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// Author of The Micro-x Accessor System Editor : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address :  11-15 Port Richmond Av. Staten Island, NY 10302
//
//                       NO WARRANTY
// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                    END OF TERMS AND CONDITIONS
// --------------------------------------------------------------------------
//
//***************************************************************************
// ----------------------------------------------
// [ Mxed.cc's Header File Include Section ]
// ----------------------------------------------
//***************************************************************************
#include <allegro.h>
#include <degui.h>
#include <font.h>
#include <iostream.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <libc.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <dpmi.h>
#include <go32.h>
#include <dos.h>
using namespace std;
//
//---------------------------------------------------
// [ Mxed.cc's Global Variables and Object Section ]
//---------------------------------------------------
// Set Program Stack & Pointers for data and files
unsigned _stklen = 1048576;
DATAFILE *datafile;
PALETTE pal;
int op_file_load = FALSE;
int AutoCycleFlag = 0;
int Save_Flag = 0;
int ActItemNum = 0;
char *Help_hlptxt;
char *FileBuf;
char Pass_Word_Buf[9];
char c1str[2] = "1";
char c2str[38];
char c3str[127];
//
dialog mxed_dialog;
//
// Object definitions for Allegro and DEGUI 1.2 beta
button_object object_5("&Quit And Exit",'Q',false);

dialog cycle1_dialog;

panel_raised_object cycle1_panel;
edittext_object cycle1_edit(c1str,2);
button_object cycle1_ok_button("Ok",0,true);
button_object cycle1_cancel_button("Cancel",27,true);
centerd_text_object cycle1_txt1("Micro-x Edit Cycle #1");
centerd_text_object cycle1_txt2("Enter The Item Number");
centerd_text_object cycle1_txt3("Valid Entries 1 to 28");

dialog cycle2_dialog;

panel_raised_object cycle2_panel;
edittext_object cycle2_edit(c2str,37);
button_object cycle2_update("Up Date",0,true);
button_object cycle2_delete("Delete",0,true);
button_object cycle2_ok_button("Ok",0,true);
button_object cycle2_exit_button("Exit",27,true);
centerd_text_object cycle2_txt1("Micro-x Edit Cycle #2");
centerd_text_object cycle2_txt2("Enter The Window Name");
centerd_text_object cycle2_txt3("Text Only 37 Characters Max");

dialog cycle3_dialog;

panel_raised_object cycle3_panel;
edittext_object cycle3_edit(c3str,126);
button_object cycle3_update("Up Date",0,true);
button_object cycle3_delete("Delete",0,true);
button_object cycle3_exit_button("Exit",27,true);
button_object cycle3_disk_button("Disk",27,true);
centerd_text_object cycle3_txt1("Micro-x Edit Cycle #3");
centerd_text_object cycle3_txt2("Enter The Path Data");
centerd_text_object cycle3_txt3("Text Only 126 Characters Max");

dialog paswrd_dialog;

panel_raised_object paswrd_panel;
edittext_object paswrd_edit(Pass_Word_Buf,8);
button_object paswrd_save("Save",0,true);
button_object paswrd_cancel_button("Cancel",27,true);
centerd_text_object paswrd_txt1("Password Editing");
centerd_text_object paswrd_txt2("Enter The New Password");
centerd_text_object paswrd_txt3("Valid Entries 4 to 8 Characters");

dialog mxedAbout_dialog;

panel_raised_object mxedAbout_object_1;
button_object mxedAbout_button("OK",0,true);
text_object txt1a("Micro-x Accessor");
text_object txt2a("System Editor");
text_object txt3a("Version 2.2");
text_object txt4a("Custom Designed For");
text_object txt5a("Micro-x Accessor System");
text_object txt6a("Version 1.5.5 GXV");
text_object txt7a("For Mxloder Version 2.0");
text_object txt8a("Copyright (C) July 2002");
text_object txt9a("By John F. Clark Jr.");

dialog mxHelp_dialog;

panel_groove_object mxHelp_panel;
shadow_box_object mxHelp_box;
text_object help_title("Accessor System Editor's Help Information");
panel_sunken_object mxHelp_sunken_panel;
button_object mxHelp_button("EXIT",0,true);
textbox_object Help_text(Help_hlptxt,false,false);
//
//---------------------------------------------------
// [ Mxed.cc's Global Variables Declaration ]
//---------------------------------------------------
int handle = 0;
unsigned int result = 0;
int press_key = 0;
char Itm_1s[ ] = "####################################L";
char Itm_2s[ ] = "####################################P";
char *ar_ptr[56];
char c = '';
char *buf;
PACKFILE *pack_file_ptr;

char *Sta_ln_Info1 = "Active Operational File =";
char *Sta_ln_Info2 = "Active Item Number## =";
char stringA[30];
char OpFileName[16];

int retn = 0;
FONT *original_font;
int ERR_FLAG = 0;
//
//---------------------------------------------------
// [ Mxed.cc's Functions and Callbacks Declaration ]
//---------------------------------------------------
void Err_Handler(int);
void SetUpCycDial(void);
int mxed_calback1(void);
int mxed_calback2(void);
int mxed_calback3(void);
int mxed_calback4(void);
int mxed_calback5(void);
int mxed_calback6(void);
int mxed_calback7(void);
int mxed_calback8(void);
int mxed_calback9(void);
int mxed_calback10(void);
int mxed_calback11(void);
int mxed_calback12(void);
int mxed_calback12a(void);
int mxed_calback12b(void);
int mxed_calback12c(void);
int mxed_calback12d(void);
int mxed_calback12e(void);
int mxed_calback12f(void);
int test_close(void);
void pass_word_test(void);
//
//----------------------------
// load main op-file callback
//----------------------------
int mxed_calback1(void)
{
   int t, x;
   int retx = 0;
   int txt_bg = 0;
   char statis_update[36];
   extern int Save_Flag;
   extern char OpFileName[16];
   extern DATAFILE *datafile;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   if(Save_Flag != 0)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(240, 200, 0);
     degui_back_color = makecol(100, 100, 110);
     degui_select_color = makecol(0, 100, 0);
     degui_deselect_color = makecol(150, 0, 150);
     degui_light_shad_color = makecol(240, 200, 0);
     degui_dark_shad_color = makecol(240, 200, 0);
     retx = alert("Changes Have Been Detected In The Active",
     "Op-File, These Changes Have Not Been Saved To Disk",
     "( Save Active Op-File To Disk ? )", "   YES   ", "   NO   ", 'y', 27);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     font = (FONT*)original_font;
     if(retx == 1)
     {
       retx = mxed_calback5();
     }
     else
     {
       Save_Flag = 0;
     }
   }

   strcpy(OpFileName,"ACCMMAIN.CFF");

// File Opening Operation for main accessor op-file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("ACCMMAIN.CFF", F_READ_PACKED);
   if (!pack_file_ptr)
   {
     ERR_FLAG = 6;
     Err_Handler(ERR_FLAG);
     unload_datafile(datafile);
     allegro_exit();
     exit(6);
   }

// File Read Operation main accessor file
   if (!pack_fread(buf, 4800, pack_file_ptr))
   {
    ERR_FLAG = 4;
    Err_Handler(ERR_FLAG);
    unload_datafile(datafile);
    allegro_exit();
    pack_fclose(pack_file_ptr);
    exit(4);
   }
   pack_fclose(pack_file_ptr);

// Set Buffer Code For Reading
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
   
   sprintf(statis_update, "%s Main", Sta_ln_Info1);
   op_file_load = TRUE;
   font = (FONT*)datafile[brt_nce_15b].dat;
   text_mode(txt_bg);
   textout(screen, font, "##############################",
   40, 414, 0);
   textout(screen, font, statis_update, 40, 414, makecol(0, 255,255));
   
   font = (FONT*)datafile[brt_nce_22b].dat;

   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(180,180, 180);
   degui_select_color = makecol(150, 150, 150);
   degui_deselect_color = makecol(120, 120, 120);
   degui_light_shad_color = makecol(0, 200, 0);
   degui_dark_shad_color = makecol(0, 200, 0);
   
   degui_alert("The Operational File For The Main",
   "Accessor System Operation Has Been Loaded" , "( No Errors Detected )",
   "  OK  ", NULL, 0, 0);
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   
   return 0;
}
//
//-----------------------------
// Load sub#1 op-file callback
//-----------------------------
int mxed_calback2(void)
{
   int t, x;
   int retx = 0;
   int txt_bg = 0;
   char statis_update[36];
   extern int Save_Flag;
   extern char OpFileName[16];
   extern DATAFILE *datafile;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   if(Save_Flag != 0)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(240, 200, 0);
     degui_back_color = makecol(100, 100, 110);
     degui_select_color = makecol(0, 100, 0);
     degui_deselect_color = makecol(150, 0, 150);
     degui_light_shad_color = makecol(240, 200, 0);
     degui_dark_shad_color = makecol(240, 200, 0);
     retx = alert("Changes Have Been Detected In The Active",
     "Op-File, These Changes Have Not Been Saved To Disk",
     "( Save Active Op-File To Disk ? )", "   YES   ", "   NO   ", 'y', 27);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(retx == 1)
     {
       retx = mxed_calback5();
     }
     else
     {
       Save_Flag = 0;
     }
   }

   strcpy(OpFileName,"ACCMSUB1.CFF");
   
// File Opening Operation for sub#1 accessor op-file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("ACCMSUB1.CFF", F_READ_PACKED);
   if ( !pack_file_ptr)
   {
     ERR_FLAG = 6;
     Err_Handler(ERR_FLAG);
     unload_datafile(datafile);
     allegro_exit();
     exit(6);
   }

// File Read Operation sub#1 accessor file
   if (!pack_fread(buf, 4800, pack_file_ptr))
   {
    ERR_FLAG = 4;
    Err_Handler(ERR_FLAG);
    unload_datafile(datafile);
    allegro_exit();
    pack_fclose(pack_file_ptr);
    exit(4);
   }
   pack_fclose(pack_file_ptr);

// Set Buffer Code For Reading
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
   
   sprintf(statis_update, "%s Sub#1", Sta_ln_Info1);
   op_file_load = TRUE;
   font = (FONT*)datafile[brt_nce_15b].dat;
   text_mode(txt_bg);
   textout(screen, font, "##############################",
   40, 414, 0);
   textout(screen, font, statis_update, 40, 414, makecol(0, 255,255));
   
   font = (FONT*)datafile[brt_nce_22b].dat;
   
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(180,180, 180);
   degui_select_color = makecol(150, 150, 150);
   degui_deselect_color = makecol(120, 120, 120);
   degui_light_shad_color = makecol(0, 200, 0);
   degui_dark_shad_color = makecol(0, 200, 0);
   
   degui_alert("The Operational File For Sub #1 Accessor",
   "System Operation Has Been Loaded" , "( No Errors Detected )",
   "  OK  ", NULL, 0, 0);
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   
   return 0;
}
//
//-----------------------------
// Load sub#2 op-file callback
//-----------------------------
int mxed_calback3(void)
{
   int t, x;
   int retx = 0;
   int txt_bg = 0;
   extern int Save_Flag;
   extern char OpFileName[16];
   char statis_update[36];
   extern DATAFILE *datafile;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   if(Save_Flag != 0)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(240, 200, 0);
     degui_back_color = makecol(100, 100, 110);
     degui_select_color = makecol(0, 100, 0);
     degui_deselect_color = makecol(150, 0, 150);
     degui_light_shad_color = makecol(240, 200, 0);
     degui_dark_shad_color = makecol(240, 200, 0);
     retx = alert("Changes Have Been Detected In The Active",
     "Op-File, These Changes Have Not Been Saved To Disk",
     "( Save Active Op-File To Disk ? )", "   YES   ", "   NO   ", 'y', 27);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(retx == 1)
     {
       retx = mxed_calback5();
     }
     else
     {
       Save_Flag = 0;
     }
   }

   strcpy(OpFileName,"ACCMSUB2.CFF");
   
// File Opening Operation for sub#2 accessor op-file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("ACCMSUB2.CFF", F_READ_PACKED);
   if ( !pack_file_ptr)
   {
     ERR_FLAG = 6;
     Err_Handler(ERR_FLAG);
     unload_datafile(datafile);
     allegro_exit();
     exit(6);
   }

// File Read Operation sub#2 accessor file
   if (!pack_fread(buf, 4800, pack_file_ptr))
   {
    ERR_FLAG = 4;
    Err_Handler(ERR_FLAG);
    unload_datafile(datafile);
    allegro_exit();
    pack_fclose(pack_file_ptr);
    exit(4);
   }
   pack_fclose(pack_file_ptr);

// Set Buffer Code For Reading
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
   
   sprintf(statis_update, "%s Sub#2", Sta_ln_Info1);
   op_file_load = TRUE;
   font = (FONT*)datafile[brt_nce_15b].dat;
   text_mode(txt_bg);
   textout(screen, font, "##############################",
   40, 414, 0);
   textout(screen, font, statis_update, 40, 414, makecol(0, 255,255));
   
   font = (FONT*)datafile[brt_nce_22b].dat;
   
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(180,180, 180);
   degui_select_color = makecol(150, 150, 150);
   degui_deselect_color = makecol(120, 120, 120);
   degui_light_shad_color = makecol(0, 200, 0);
   degui_dark_shad_color = makecol(0, 200, 0);
   
   degui_alert("The Operational File For Sub #2",
   "Accessor System Operation Has Been Loaded" , "( No Errors Detected )",
   "  OK  ", NULL, 0, 0);
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   
   return 0;
}
//
//-----------------------------
// Load sub#3 op-file callback
//-----------------------------
int mxed_calback4(void)
{
   int t, x;
   int retx = 0;
   int txt_bg = 0;
   char statis_update[36];
   extern int Save_Flag;
   extern char OpFileName[16];
   extern DATAFILE *datafile;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   if(Save_Flag != 0)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(240, 200, 0);
     degui_back_color = makecol(100, 100, 110);
     degui_select_color = makecol(0, 100, 0);
     degui_deselect_color = makecol(150, 0, 150);
     degui_light_shad_color = makecol(240, 200, 0);
     degui_dark_shad_color = makecol(240, 200, 0);
     retx = alert("Changes Have Been Detected In The Active",
     "Op-File, These Changes Have Not Been Saved To Disk",
     "( Save Active Op-File To Disk ? )", "   YES   ", "   NO   ", 'y', 27);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(retx == 1)
     {
       retx = mxed_calback5();
     }
     else
     {
       Save_Flag = 0;
     }
   }

   strcpy(OpFileName,"ACCMSUB3.CFF");
   
// File Opening Operation for sub#3 accessor op-file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("ACCMSUB3.CFF", F_READ_PACKED);
   if ( !pack_file_ptr)
   {
     ERR_FLAG = 6;
     Err_Handler(ERR_FLAG);
     unload_datafile(datafile);
     allegro_exit();
     exit(6);
   }

// File Read Operation sub#3 accessor file
   if (!pack_fread(buf, 4800, pack_file_ptr))
   {
    ERR_FLAG = 4;
    Err_Handler(ERR_FLAG);
    unload_datafile(datafile);
    allegro_exit();
    pack_fclose(pack_file_ptr);
    exit(4);
   }
   pack_fclose(pack_file_ptr);

// Set Buffer Code For Reading
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
   
   sprintf(statis_update, "%s Sub#3", Sta_ln_Info1);
   op_file_load = TRUE;
   font = (FONT*)datafile[brt_nce_15b].dat;
   text_mode(txt_bg);
   textout(screen, font, "##############################",
   40, 414, 0);
   textout(screen, font, statis_update, 40, 414, makecol(0, 255,255));
   
   font = (FONT*)datafile[brt_nce_22b].dat;
  
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(180,180, 180);
   degui_select_color = makecol(150, 150, 150);
   degui_deselect_color = makecol(120, 120, 120);
   degui_light_shad_color = makecol(0, 250, 0);
   degui_dark_shad_color = makecol(0, 250, 0);
   
   degui_alert("The Operational File For Sub #3",
   "Accessor System Operation Has Been Loaded" , "( No Errors Detected )",
   "  OK  ", NULL, 0, 0);
   
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   return 0;
}
//
//---------------------------
// [ Save op-file callback ]
//---------------------------
int mxed_calback5(void)
{
   int t, x;
   extern int Save_Flag;
   extern char OpFileName[16];
   extern DATAFILE *datafile;

   if(Save_Flag == 0)
   {
    return 0;
   }

// Set Buffer Code For Write To Disk
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) -= c;
      }
      t += 1;
      x += 1;
   }
   
// File Opening Operation to save op-file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen(OpFileName, F_WRITE_PACKED);
   if ( !pack_file_ptr)
   {
     ERR_FLAG = 6;
     Err_Handler(ERR_FLAG);
     unload_datafile(datafile);
     allegro_exit();
     exit(6);
   }

// File write operation ..
   if (!pack_fwrite(buf, 4800, pack_file_ptr))
   {
    ERR_FLAG = 4;
    Err_Handler(ERR_FLAG);
    unload_datafile(datafile);
    allegro_exit();
    pack_fclose(pack_file_ptr);
    exit(4);
   }
   pack_fclose(pack_file_ptr);
   
// Set Buffer Code For Reading
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
   
   font = (FONT*)datafile[brt_nce_22b].dat;

   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(180,180, 180);
   degui_select_color = makecol(150, 150, 150);
   degui_deselect_color = makecol(120, 120, 120);
   degui_light_shad_color = makecol(0, 200, 0);
   degui_dark_shad_color = makecol(0, 200, 0);
   
   degui_alert("The Active Operational File Listed In The",
   "Status Line Below Has Been Saved To Disk" , "( No Errors Detected )",
   "  OK  ", NULL, 0, 0);
   
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   Save_Flag = 0;

   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   return 0;
}
//
//-----------------------------------------------
// [ Edit Cycle#1's Callback---set iten number ]
//-----------------------------------------------
int mxed_calback6(void)
{
   int lopcnt = 0;
   int txt_bg = 0;
   char statis_update[25];
   extern char *Sta_ln_Info2;
   extern char c1str[2];
   extern int op_file_load;
   extern int ActItemNum;
   extern int AutoCycleFlag;
   extern dialog mxed_dialog;
   extern dialog cycle1_dialog;
   extern DATAFILE *datafile;
   BITMAP *scrn_sav = create_bitmap(640,480);

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

// Check if op-file is loaded
   if(op_file_load == FALSE)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(180, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(150, 150, 150);
     degui_deselect_color = makecol(120, 120, 120);
     degui_light_shad_color = makecol(0, 200, 0);
     degui_dark_shad_color = makecol(0, 200, 0);
     degui_alert("Micro-x Accessor System Editor","Access ! Error !",
     "Active Operational File Not Loaded", "  OK  ", NULL, 0, 0);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return 0;
   }

   while(lopcnt != 9)
   {

     show_mouse(NULL);
     blit(screen,scrn_sav,0,0,0,0,640,480);
     show_mouse(screen);
   
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(0, 250, 0);
     degui_deselect_color = makecol(200, 200, 200);
     degui_light_shad_color = makecol(0, 0, 180);
     degui_dark_shad_color = makecol(0, 0, 180);
     
     mxed_dialog.add(cycle1_dialog);
     dialog_object *retn = cycle1_dialog.execute();
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     mxed_dialog.remove(cycle1_dialog);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     
// Action if the dialog was canceled
     if(retn == &cycle1_cancel_button)
     {
       show_mouse(NULL);
       blit(scrn_sav,screen,0,0,0,0,640,480);
       show_mouse(screen);
       destroy_bitmap(scrn_sav);

       if(AutoCycleFlag)
       {
         return(999);
       }
       else
       {
          return D_REDRAW;
       }
     }
   
// Action if the dialog was oked
     if(retn == &cycle1_ok_button)
     {
       ActItemNum = atoi(cycle1_edit.get_text());
       if((ActItemNum < 1) || (ActItemNum > 28))
       {
          font = (FONT*)datafile[brt_nce_22b].dat;

         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Edit Cycle #1",
         "Valid Entries Are Numeric Data Only Numbers 1 thur 28",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         show_mouse(NULL);
         blit(scrn_sav,screen,0,0,0,0,640,480);
         show_mouse(screen);
         ActItemNum = 0;
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         continue;
       }
       else
       {

         sprintf(statis_update, "Active Item Number## = %d",ActItemNum );
         font = (FONT*)datafile[brt_nce_15b].dat;
         show_mouse(NULL);
         blit(scrn_sav,screen,0,0,0,0,640,480);
         show_mouse(screen);
         destroy_bitmap(scrn_sav);
         text_mode(txt_bg);
         textout(screen, font, "##########################", 400, 414, 0);
         textout(screen, font, statis_update, 400, 414, makecol(0, 255,255));
         font = (FONT*)original_font;
         lopcnt = 9;
         
         if(AutoCycleFlag)
         {
           return(0);
         }
         else
         {
            return D_REDRAW;
         }
       }
     }
   }
   show_mouse(NULL);
   blit(scrn_sav,screen,0,0,0,0,640,480);
   show_mouse(screen);
   destroy_bitmap(scrn_sav);
   
   if(AutoCycleFlag)
   {
     return(999);
   }
   else
   {
     return D_REDRAW;
   }
}
//
//-------------------------------------------------
// [ Edit Cycle#2's Callback---enter window name ]
//-------------------------------------------------
int mxed_calback7(void)
{
   int lopcnt = 0;
   int x = 0;
   int err_flg = 0;
   int k_esc = 0;
   char statis_update[25];
   char win_name[38];
   extern char *Sta_ln_Info2;
   extern char Itm_1s[38];
   extern char *ar_ptr[56];
   extern char c2str[38];
   extern int Save_Flag;
   extern int op_file_load;
   extern int ActItemNum;
   extern dialog mxed_dialog;
   extern dialog cycle2_dialog;
   extern DATAFILE *datafile;
   BITMAP *scrn_sav = create_bitmap(640,480);

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

// Check if ActItemNum is Set
   if(ActItemNum == 0)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(180, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(150, 150, 150);
     degui_deselect_color = makecol(120, 120, 120);
     degui_light_shad_color = makecol(0, 200, 0);
     degui_dark_shad_color = makecol(0, 200, 0);
     degui_alert("Micro-x Accessor System Editor","Access ! Error !",
     "Active Item Number Has Not Been Set", "  OK  ", NULL, 0, 0);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return 0;
   }

   show_mouse(NULL);
   blit(screen,scrn_sav,0,0,0,0,640,480);
   show_mouse(screen);
   while(lopcnt != 9)
   {
     win_name[0] = NULL;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(0, 250, 0);
     degui_deselect_color = makecol(200, 200, 200);
     degui_light_shad_color = makecol(0, 0, 180);
     degui_dark_shad_color = makecol(0, 0, 180);
     
     k_esc = 0;
     mxed_dialog.add(cycle2_dialog);
     dialog_object *retn = cycle2_dialog.execute();
     k_esc = key[KEY_ESC];
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     mxed_dialog.remove(cycle2_dialog);
     set_default_object_colors(0,235,236,237,238,239,240,241);
   
// Action if the escape key was pressed in auto cycle
     if((AutoCycleFlag) && (k_esc))
     {
       show_mouse(NULL);
       blit(scrn_sav,screen,0,0,0,0,640,480);
       show_mouse(screen);
       destroy_bitmap(scrn_sav);
       if(AutoCycleFlag)
       {
         return(0);
       }
       else
       {
          return D_REDRAW;
       }
     }
// Action if the dialog was canceled
     if(retn == &cycle2_exit_button)
     {
       show_mouse(NULL);
       blit(scrn_sav,screen,0,0,0,0,640,480);
       show_mouse(screen);
       destroy_bitmap(scrn_sav);
       
       if(AutoCycleFlag)
       {
         return(999);
       }
       else
       {
          return D_REDRAW;
       }
     }
   
// Action if the dialog update was selected
     if(retn == &cycle2_update)
     {
       sprintf(win_name, "%s", cycle2_edit.get_text());
       if(strlen(win_name) == 0)
       {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Edit Cycle #2",
         "Valid Entries Are Text Data Only, 37 Characters Max",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         continue;
       }
       x = 0;
       while(win_name[x] != NULL)
       {
         if(x > 37)
         {
           err_flg = 99;
           break;
         }

         if((win_name[x] < '\x1F') || (win_name[x] > '\x7E'))
         {
           err_flg = 99;
           break;
         }
         ++x;
       }
       
       if(err_flg == 99)
       {
         err_flg = 0;
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Edit Cycle #2",
         "Valid Entries Are Text Data Only, 37 Characters Max",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         continue;
       }
       else
       {
         strcpy(*(ar_ptr + ActItemNum - 1), win_name);
         
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("The Window Name Data Has Been Up Dated. This",
         "Up Date Is Valid Only For The Active Op-File, And",
         "Item Number Thats Listed In The Status Line Below.",
         "  OK  ", NULL, 0, 0);
         
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         Save_Flag = 1;
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();

         if(AutoCycleFlag)
         {
           show_mouse(NULL);
           blit(scrn_sav,screen,0,0,0,0,640,480);
           show_mouse(screen);
           destroy_bitmap(scrn_sav);
           return(0);
         }
         else
         {
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           continue;
         }
       }
     }
     
     if(retn == &cycle2_delete)
     {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(200, 200, 0);
         degui_dark_shad_color = makecol(200, 200, 0);
         
         if(degui_alert("Delete The Current Window Name Data  ?",
         "","","   OK   ", " Cancel ", 0, 0) == 2)
         {
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           set_default_object_colors(0,235,236,237,238,239,240,241);
           font = (FONT*)original_font;

           if(AutoCycleFlag)
           {
             show_mouse(NULL);
             blit(scrn_sav,screen,0,0,0,0,640,480);
             show_mouse(screen);
             destroy_bitmap(scrn_sav);
             return(0);
           }
           else
           {
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             continue;
           }
         }
         else
         {
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           strcpy(*(ar_ptr + ActItemNum - 1), Itm_1s);
   
           degui_alert("The Window Name Data Has Been Deleted. This",
                       "Selection Deletes The Active Item Number In",
                       "The Active Op-File Listed In The Status Line Below.",
           "  OK  ", NULL, 0, 0);
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           set_default_object_colors(0,235,236,237,238,239,240,241);
           font = (FONT*)original_font;
         
           Save_Flag = 1;

            if(AutoCycleFlag)
            {
              show_mouse(NULL);
              blit(scrn_sav,screen,0,0,0,0,640,480);
              show_mouse(screen);
              destroy_bitmap(scrn_sav);
              return(0);
            }
            else
            {
              while(key[KEY_ENTER]){};
              while(key[KEY_ESC]){};
              clear_keybuf();
              continue;
            }
        }
      }

   }
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   show_mouse(NULL);
   blit(scrn_sav,screen,0,0,0,0,640,480);
   show_mouse(screen);
   destroy_bitmap(scrn_sav);
   
   if(AutoCycleFlag)
   {
     return(999);
   }
   else
   {
     return D_REDRAW;
   }
}
//
//-----------------------------------------------
// [ Edit Cycle#3's Callback---enter path data ]
//-----------------------------------------------
int mxed_calback8(void)
{
   int lopcnt = 0;
   int x = 0;
   int err_flg = 0;
   int fhandle = 0;
   int i_exe = 0;
   int file_sel = 0;
   int file_chk = 0;
   int k_esc = 0;
   char path_name[128];
   char path_true[128];
   extern char Itm_2s[38];
   extern char *ar_ptr[56];
   extern char c3str[127];
   extern int Save_Flag;
   extern int ActItemNum;
   extern dialog mxed_dialog;
   extern dialog cycle3_dialog;
   extern DATAFILE *datafile;
   BITMAP *scrn_sav = create_bitmap(640,480);

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   // Check if ActItemNum is Set
   if(ActItemNum == 0)
   {
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(180, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(150, 150, 150);
     degui_deselect_color = makecol(120, 120, 120);
     degui_light_shad_color = makecol(0, 200, 0);
     degui_dark_shad_color = makecol(0, 200, 0);
     degui_alert("Micro-x Accessor System Editor","Access ! Error !",
     "Active Item Number Has Not Been Set", "  OK  ", NULL, 0, 0);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return 0;
   }

   show_mouse(NULL);
   blit(screen,scrn_sav,0,0,0,0,640,480);
   show_mouse(screen);
   while(lopcnt != 9)
   {
     path_name[0] = NULL;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(10, 180, 10);
     degui_deselect_color = makecol(200, 200, 200);
     degui_light_shad_color = makecol(0, 0, 180);
     degui_dark_shad_color = makecol(0, 0, 180);
     
     k_esc = 0;
     mxed_dialog.add(cycle3_dialog);
     dialog_object *retn = cycle3_dialog.execute();
     k_esc = key[KEY_ESC];
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     mxed_dialog.remove(cycle3_dialog);
     set_default_object_colors(0,235,236,237,238,239,240,241);
   
// Action if the escape was pressed
     if(k_esc)
     {
       clear_keybuf();
       show_mouse(NULL);
       blit(scrn_sav,screen,0,0,0,0,640,480);
       show_mouse(screen);
       destroy_bitmap(scrn_sav);
       if(AutoCycleFlag)
       {
         return(0);
       }
       else
       {
          return D_REDRAW;
       }
     }
     
// Action if the dialog was canceled
     if(retn == &cycle3_exit_button)
     {
       clear_keybuf();
       show_mouse(NULL);
       blit(scrn_sav,screen,0,0,0,0,640,480);
       show_mouse(screen);
       destroy_bitmap(scrn_sav);
       
       if(AutoCycleFlag)
       {
         return(999);
       }
       else
       {
          return D_REDRAW;
       }
     }
   
// Action if the dialog update was selected
     if(retn == &cycle3_update)
     {
       sprintf(path_name, "%s", cycle3_edit.get_text());
       if(strlen(path_name) == 0)
       {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Edit Cycle #3",
         "Valid Entries Are Text Data Only, 126 Characters Max",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         continue;
       }
       x = 0;
       while(path_name[x] != NULL)
       {
         if(x > 126)
         {
           err_flg = 99;
           break;
         }

         if((path_name[x] < '\x1F') || (path_name[x] > '\x7E'))
         {
           err_flg = 99;
           break;
         }
         ++x;
       }
       
       if(err_flg == 99)
       {
         err_flg = 0;
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Edit Cycle #3",
         "Valid Entries Are Text Data Only, 126 Characters Max",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         continue;
       }
       else
       {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(200, 200, 0);
         degui_dark_shad_color = makecol(200, 200, 0);
   
         strcpy(path_true, path_name);
         x = 0;
         while(x != 126)
         {
           if(path_true[x] == '.')
           {
             path_true[x + 4] = NULL;
             break;
           }
           ++x;
         }
         
         fhandle = open(path_true, O_RDONLY);
         i_exe = _is_executable(path_true, fhandle, NULL);
         close(fhandle);

         file_chk = exists(path_true);
         
         if((i_exe == 0) || (file_chk == 0))
         {
           degui_alert("! Warning !  The Selected Path Data May Not",
           "Lead To An Executable Program ...","","   OK   ",NULL , 0, 0);
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
         }

         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
         if(degui_alert("Up Date The Path Data With This Selection  ?",
         "","","   OK   ", " Cancel ", 0, 0) == 1)
         {
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           strcpy(*(ar_ptr + (ActItemNum + 27)), path_name);
           degui_alert("The Path Data Has Been Up Dated. This Up Date",
           "Is Valid Only For The Active Op-File, And Item",
           "Number Thats Listed In The Status Line Below.",
           "  OK  ", NULL, 0, 0);
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           set_default_object_colors(0,235,236,237,238,239,240,241);
           font = (FONT*)original_font;
           show_mouse(NULL);
           blit(scrn_sav,screen,0,0,0,0,640,480);
           show_mouse(screen);

           Save_Flag = 1;

           if(AutoCycleFlag)
           {
             destroy_bitmap(scrn_sav);
             return(0);
           }
           else
           {
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             continue;
           }
         }
        set_default_object_colors(0,235,236,237,238,239,240,241);
        font = (FONT*)original_font;
        while(key[KEY_ENTER]){};
        while(key[KEY_ESC]){};
        clear_keybuf();
        continue;
      }
     }
     
// Action if the dialog Disk Acess was selected
     if(retn == &cycle3_disk_button)
     {
        font = (FONT*)original_font;
        degui_fore_color = makecol(0, 0, 100);
        degui_back_color = makecol(180,180, 180);
        degui_select_color = makecol(150, 150, 150);
        degui_deselect_color = makecol(120, 120, 120);
        degui_light_shad_color = makecol(0, 0, 200);
        degui_dark_shad_color = makecol(0, 0, 200);
        
        k_esc = 0;
        path_name[0] = NULL;
        file_sel = file_select("Disk Access",
        path_name, NULL);
        k_esc = key[KEY_ESC];
        while(key[KEY_ENTER]){};
        while(key[KEY_ESC]){};
        clear_keybuf();

        if((file_sel == 0) || (k_esc))
        {
          file_sel = 0;
          set_default_object_colors(0,235,236,237,238,239,240,241);
          while(key[KEY_ENTER]){};
          while(key[KEY_ESC]){};
          clear_keybuf();
          continue;
          
        }
        else
        {
           font = (FONT*)datafile[brt_nce_22b].dat;
           degui_fore_color = makecol(0, 0, 0);
           degui_back_color = makecol(180,180, 180);
           degui_select_color = makecol(150, 150, 150);
           degui_deselect_color = makecol(120, 120, 120);
           degui_light_shad_color = makecol(200, 200, 0);
           degui_dark_shad_color = makecol(200, 200, 0);
           
           x = 0;
           while(path_name[x] != NULL)
           {
             if(x > 126)
             {
               err_flg = 99;
               break;
             }

             if((path_name[x] < '\x1F') || (path_name[x] > '\x7E'))
             {
               err_flg = 99;
               break;
             }
             ++x;
           }
           
           if((err_flg == 99) || (strlen(path_name) == 0))
           {
             err_flg = 0;
             font = (FONT*)datafile[brt_nce_22b].dat;
             degui_fore_color = makecol(180, 0, 0);
             degui_back_color = makecol(180,180, 180);
             degui_select_color = makecol(150, 150, 150);
             degui_deselect_color = makecol(120, 120, 120);
             degui_light_shad_color = makecol(0, 200, 0);
             degui_dark_shad_color = makecol(0, 200, 0);
   
             degui_alert("Data Input ! Error ! In Edit Cycle #3",
             "Valid Entries Are Text Data Only, 126 Characters Max",
             "( This Edit Cycle Input Must Be Redone )",
             "  OK  ", NULL, 0, 0);
   
             set_default_object_colors(0,235,236,237,238,239,240,241);
             font = (FONT*)original_font;
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             continue;
           }
           
           strcpy(path_true, path_name);
           x = 0;
           while(x != 126)
           {
             if(path_true[x] == '.')
             {
               path_true[x + 4] = NULL;
               break;
             }
             ++x;
           }

           fhandle = open(path_true, O_RDONLY);
           i_exe = _is_executable(path_true, fhandle, NULL);
           close(fhandle);
         
           file_chk = exists(path_true);
          
           if((i_exe == 0) || (file_chk == 0))
           {
             degui_alert("! Warning !  The Selected Path Data May Not",
             "Lead To An Executable Program ...","","   OK   ",NULL , 0, 0);
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
           }

           degui_fore_color = makecol(0, 0, 0);
           degui_back_color = makecol(180,180, 180);
           degui_select_color = makecol(150, 150, 150);
           degui_deselect_color = makecol(120, 120, 120);
           degui_light_shad_color = makecol(0, 200, 0);
           degui_dark_shad_color = makecol(0, 200, 0);
           if(degui_alert("Up Date The Path Data With This Selection  ?",
           "","","   OK   ", " Cancel ", 0, 0) == 1)
           {
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             strcpy(*(ar_ptr + (ActItemNum + 27)), path_name);
             degui_alert("The Path Data Has Been Up Dated. This Up Date",
             "Is Valid Only For The Active Op-File, And Item",
             "Number Thats Listed In The Statis Line Below.",
             "  OK  ", NULL, 0, 0);
             set_default_object_colors(0,235,236,237,238,239,240,241);
             font = (FONT*)original_font;
             Save_Flag = 1;
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             show_mouse(NULL);
             blit(scrn_sav,screen,0,0,0,0,640,480);
             show_mouse(screen);
             if(AutoCycleFlag)
             {
               destroy_bitmap(scrn_sav);
               return(0);
             }
             else
             {
               while(key[KEY_ENTER]){};
               while(key[KEY_ESC]){};
               clear_keybuf();
               continue;
             }
           }
          set_default_object_colors(0,235,236,237,238,239,240,241);
          font = (FONT*)original_font;
          while(key[KEY_ENTER]){};
          while(key[KEY_ESC]){};
          clear_keybuf();
          continue;
        }
     }
     
// Action if the delete button is pressed
     if(retn == &cycle3_delete)
     {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(200, 200, 0);
         degui_dark_shad_color = makecol(200, 200, 0);
         
         if(degui_alert("Delete The Current Path Data  ?",
         "","","   OK   ", " Cancel ", 0, 0) == 2)
         {
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           set_default_object_colors(0,235,236,237,238,239,240,241);
           font = (FONT*)original_font;

           if(AutoCycleFlag)
           {
             show_mouse(NULL);
             blit(scrn_sav,screen,0,0,0,0,640,480);
             show_mouse(screen);
             destroy_bitmap(scrn_sav);
             return(0);
           }
           else
           {
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             continue;
           }
         }
         else
         {
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
           strcpy(*(ar_ptr + (ActItemNum + 27)), Itm_2s);
   
           degui_alert("The Path Data Has Been Deleted. This Selection",
                       "Deletes The Active Item Number In The Current",
                       "Op-File Listed In The Status Line Below.",
           "  OK  ", NULL, 0, 0);
           
           set_default_object_colors(0,235,236,237,238,239,240,241);
           font = (FONT*)original_font;
           while(key[KEY_ENTER]){};
           while(key[KEY_ESC]){};
           clear_keybuf();
         
           Save_Flag = 1;

           if(AutoCycleFlag)
           {
             show_mouse(NULL);
             blit(scrn_sav,screen,0,0,0,0,640,480);
             show_mouse(screen);
             destroy_bitmap(scrn_sav);
             return(0);
           }
           else
           {
             while(key[KEY_ENTER]){};
             while(key[KEY_ESC]){};
             clear_keybuf();
             continue;
           }
        }
      }

   }
   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)original_font;
   show_mouse(NULL);
   blit(scrn_sav,screen,0,0,0,0,640,480);
   show_mouse(screen);
   destroy_bitmap(scrn_sav);

   if(AutoCycleFlag)
   {
    return(999);
   }
   else
   {
     return D_REDRAW;
   }
}
//
//---------------------------
// [ Auto Cycle's Callback ]
//---------------------------
int mxed_calback9(void)
{
   int lopmain = 0;
   int txt_bg = 0;
   extern int op_file_load;
   extern int Save_Flag;
   extern int ActItemNum;
   extern int AutoCycleFlag;
   char statis_update[25];
   extern int op_file_load;
   extern char c1str[2];
   extern DATAFILE *datafile;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

// Check if op-file is loaded
   if(op_file_load == FALSE)
   {
     // change font & Set up dialog colors
     font = (FONT*)datafile[brt_nce_22b].dat;
     degui_fore_color = makecol(180, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(150, 150, 150);
     degui_deselect_color = makecol(120, 120, 120);
     degui_light_shad_color = makecol(0, 200, 0);
     degui_dark_shad_color = makecol(0, 200, 0);
     degui_alert("Micro-x Accessor System Editor","Access ! Error !",
     "Active Operational File Not Loaded", "  OK  ", NULL, 0, 0);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return 0;
   }

// Check if ActItemNum is Set
   if((ActItemNum <= 0) || (ActItemNum > 28))
   {
     ActItemNum = 1;
     sprintf(statis_update, "Active Item Number## = %d",ActItemNum );
     font = (FONT*)datafile[brt_nce_15b].dat;
     text_mode(txt_bg);
     textout(screen, font, "##########################", 400, 414, 0);
     textout(screen, font, statis_update, 400, 414, makecol(0, 255,255));
     font = (FONT*)original_font;
   }
   
   font = (FONT*)datafile[brt_nce_15b].dat;
   text_mode(txt_bg);
   textout(screen, font, "#####", 295, 414, makecol(0, 255,255));
   textout(screen, font, "AUTO", 295, 414, makecol(255, 0,0));
   font = (FONT*)original_font;

// Start of main loop
   AutoCycleFlag = 1;
   while(lopmain != 999)
   {
//****** START OF  LOPMAIN ******************
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     lopmain = mxed_calback6();
     if(lopmain == 999)
     {
       font = (FONT*)datafile[brt_nce_15b].dat;
       text_mode(txt_bg);
       textout(screen, font, "#####", 295, 414, makecol(0, 255,255));
       textout(screen, font, "****** ", 295, 414, makecol(0, 255,255));
       font = (FONT*)original_font;
       AutoCycleFlag = 0;
       return D_REDRAW;
     }
//----------------------------------
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     lopmain = mxed_calback7();
     if(lopmain == 999)
     {
       font = (FONT*)datafile[brt_nce_15b].dat;
       text_mode(txt_bg);
       textout(screen, font, "#####", 295, 414, makecol(0, 255,255));
       textout(screen, font, "****** ", 295, 414, makecol(0, 255,255));
       font = (FONT*)original_font;
       AutoCycleFlag = 0;
       return D_REDRAW;
     }
//----------------------------------------
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     lopmain = mxed_calback8();
     if(lopmain == 999)
     {
       font = (FONT*)datafile[brt_nce_15b].dat;
       text_mode(txt_bg);
       textout(screen, font, "#####", 295, 414, makecol(0, 255,255));
       textout(screen, font, "****** ", 295, 414, makecol(0, 255,255));
       font = (FONT*)original_font;
       AutoCycleFlag = 0;
       return D_REDRAW;
     }
   }
//******END BRACE FOR MAIN LOPMAIN*************
  font = (FONT*)datafile[brt_nce_15b].dat;
  text_mode(txt_bg);
  textout(screen, font, "#####", 295, 414, makecol(0, 255,255));
  textout(screen, font, "****** ", 295, 414, makecol(0, 255,255));
  font = (FONT*)original_font;
  AutoCycleFlag = 0;
  return D_REDRAW;
}
//
//----------------------------
// [ Password Edit Callback ]
//----------------------------
int mxed_calback10(void)
{
   int x = 0;
   int lopcnt = 0;
   int txt_bg = 0;
   extern char Pass_Word_Buf[9];
   extern dialog mxed_dialog;
   extern dialog paswrd_dialog;
   extern DATAFILE *datafile;
   BITMAP *scrn_sav = create_bitmap(640,480);

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   show_mouse(NULL);
   blit(screen,scrn_sav,0,0,0,0,640,480);
   show_mouse(screen);
   
   while(lopcnt != 9)
   {
     startup:

     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(0, 250, 0);
     degui_deselect_color = makecol(200, 200, 200);
     degui_light_shad_color = makecol(0, 0, 180);
     degui_dark_shad_color = makecol(0, 0, 180);
     
     mxed_dialog.add(paswrd_dialog);
     dialog_object *retn = paswrd_dialog.execute();
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     mxed_dialog.remove(paswrd_dialog);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     
// Action if the dialog was canceled
     if(retn == &paswrd_cancel_button)
     {
       show_mouse(NULL);
       blit(scrn_sav,screen,0,0,0,0,640,480);
       show_mouse(screen);
       destroy_bitmap(scrn_sav);
       return D_REDRAW;
     }
       
     sprintf(Pass_Word_Buf, "%s", paswrd_edit.get_text());
     x = 0;
     while(x != 8)
     {
       if(Pass_Word_Buf[x] == NULL)
       {
         break;
       }

       if((Pass_Word_Buf[x] < '\x1F') || (Pass_Word_Buf[x] > '\x7E'))
       {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Password Edit",
         "Valid Entries Are Text Data Only, 4 to 8 Characters",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         show_mouse(NULL);
         blit(scrn_sav,screen,0,0,0,0,640,480);
         show_mouse(screen);
         goto startup;
       }
       ++x;
     }

// Action if dialog save was selected
     if(retn == &paswrd_save)
     {
       if(strlen(Pass_Word_Buf) < 4)
       {
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(180, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("Data Input ! Error ! In Password Edit",
         "Valid Entries Are Text Data Only, 4 to 8 Characters",
         "( This Edit Cycle Input Must Be Redone )",
         "  OK  ", NULL, 0, 0);
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;
         show_mouse(NULL);
         blit(scrn_sav,screen,0,0,0,0,640,480);
         show_mouse(screen);
         goto startup;
       }
       else
       {
// Allocate File Buffer Space
         FileBuf = (char*) alloca(64);
         if (!FileBuf)
         {
            font = (FONT*)datafile[brt_nce_22b].dat;
            degui_fore_color = makecol(200, 0, 0);
            degui_back_color = makecol(180,180, 180);
            degui_select_color = makecol(0, 180, 0);
            degui_deselect_color = makecol(0, 0, 120);
            degui_light_shad_color = makecol(200, 0, 0);
            degui_dark_shad_color = makecol(200, 0, 0);
            degui_alert("Editor  File  Buffer   !!  E R R O R  !!",
            "Not Enough Memory To Open Configuration File.",
            "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
            while(key[KEY_ENTER]){};
            while(key[KEY_ESC]){};
            clear_keybuf();
            set_default_object_colors(0,235,236,237,238,239,240,241);
            font = (FONT*)original_font;
            show_mouse(NULL);
            blit(scrn_sav,screen,0,0,0,0,640,480);
            show_mouse(screen);
            goto startup;
         }
         
// Set Pointer To Buffer
         strcpy(FileBuf + 0, Pass_Word_Buf);

// Set Buffer Code For Write To Disk
         x = 0;
         while (x != 64)
         {
            if ((*(FileBuf + x) != NULL) && (*(FileBuf + x) != '\0'))
            {
               *(FileBuf + x) -= c;
            }
            x += 1;
         }
   
// File Opening Operation to save file
         pack_file_ptr = NULL;
         pack_file_ptr = pack_fopen("mxed.cfg", F_WRITE_PACKED);
         if ( !pack_file_ptr)
         {
            font = (FONT*)datafile[brt_nce_22b].dat;
            degui_fore_color = makecol(200, 0, 0);
            degui_back_color = makecol(180,180, 180);
            degui_select_color = makecol(0, 180, 0);
            degui_deselect_color = makecol(0, 0, 120);
            degui_light_shad_color = makecol(200, 0, 0);
            degui_dark_shad_color = makecol(200, 0, 0);
            degui_alert("Editor  File  Opening   !!  E R R O R  !!",
            "Cannot Open Configuration File. Check Your",
            "Micro-x Directory And Files.", "  OK  ", NULL, 0, 0);
            while(key[KEY_ENTER]){};
            while(key[KEY_ESC]){};
            clear_keybuf();
            set_default_object_colors(0,235,236,237,238,239,240,241);
            font = (FONT*)original_font;
            unload_datafile(datafile);
            destroy_bitmap(scrn_sav);
            allegro_exit();
            pack_fclose(pack_file_ptr);
            exit(6);
          }

// File write operation
         if (!pack_fwrite(FileBuf, 64, pack_file_ptr))
         {
            font = (FONT*)datafile[brt_nce_22b].dat;
            degui_fore_color = makecol(200, 0, 0);
            degui_back_color = makecol(180,180, 180);
            degui_select_color = makecol(0, 180, 0);
            degui_deselect_color = makecol(0, 0, 120);
            degui_light_shad_color = makecol(200, 0, 0);
            degui_dark_shad_color = makecol(200, 0, 0);
            degui_alert("Editor  File  Write   !!  E R R O R  !!",
            "Cannot Write To Configuration File. Check",
            "Your Micro-x Directory And Files.", "  OK  ", NULL, 0, 0);
            while(key[KEY_ENTER]){};
            while(key[KEY_ESC]){};
            clear_keybuf();
            set_default_object_colors(0,235,236,237,238,239,240,241);
            font = (FONT*)original_font;
            unload_datafile(datafile);
            destroy_bitmap(scrn_sav);
            allegro_exit();
            pack_fclose(pack_file_ptr);
            exit(4);
         }
         pack_fclose(pack_file_ptr);
         
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("The Password Data Has Been Saved To Disk.",
         "( No Errors Detected )" , "",
         "  OK  ", NULL, 0, 0);
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;

         show_mouse(NULL);
         blit(scrn_sav,screen,0,0,0,0,640,480);
         show_mouse(screen);
         return D_REDRAW;
       }
     }
   }
   show_mouse(NULL);
   blit(scrn_sav,screen,0,0,0,0,640,480);
   show_mouse(screen);
   destroy_bitmap(scrn_sav);
   return D_REDRAW;
}
//
//------------------------------
// [ Remove Password Callback ]
//------------------------------
int mxed_calback11(void)
{
   int retn = 0;
   int x = 0;
   int txt_bg = 0;
   char buf_pas[9];
   extern char Pass_Word_Buf[9];
   extern DATAFILE *datafile;
   BITMAP *scrn_sav = create_bitmap(640,480);

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   show_mouse(NULL);
   blit(screen,scrn_sav,0,0,0,0,640,480);
   show_mouse(screen);
   

   font = (FONT*)datafile[brt_nce_22b].dat;
   degui_fore_color = makecol(240, 200, 0);
   degui_back_color = makecol(100, 100, 110);
   degui_select_color = makecol(0, 100, 0);
   degui_deselect_color = makecol(150, 0, 150);
   degui_light_shad_color = makecol(240, 200, 0);
   degui_dark_shad_color = makecol(240, 200, 0);
   
   retn = alert("Remove The Editor's Password Protection  ?",
   "", "", "   YES   ", "   NO   ", 'y', 27);
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   if(retn == 2)
   {
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     show_mouse(NULL);
     blit(scrn_sav,screen,0,0,0,0,640,480);
     show_mouse(screen);
     destroy_bitmap(scrn_sav);
     return D_REDRAW;
   }
   else
   {
         // allocate file buffer space
         FileBuf = (char*) alloca(64);
         if (!FileBuf)
         {
            font = (FONT*)datafile[brt_nce_22b].dat;
            degui_fore_color = makecol(200, 0, 0);
            degui_back_color = makecol(180,180, 180);
            degui_select_color = makecol(0, 180, 0);
            degui_deselect_color = makecol(0, 0, 120);
            degui_light_shad_color = makecol(200, 0, 0);
            degui_dark_shad_color = makecol(200, 0, 0);
            degui_alert("Editor  File  Buffer   !!  E R R O R  !!",
            "Not Enough Memory To Open Configuration File.",
            "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
            while(key[KEY_ENTER]){};
            while(key[KEY_ESC]){};
            clear_keybuf();
            set_default_object_colors(0,235,236,237,238,239,240,241);
            font = (FONT*)original_font;
            show_mouse(NULL);
            blit(scrn_sav,screen,0,0,0,0,640,480);
            show_mouse(screen);
            return D_REDRAW;
         }
         
// Set Pointer To Buffer
         strcpy(buf_pas, "[NOPASS]");
         strcpy(FileBuf + 0, buf_pas);

// Set Buffer Code For Write To Disk
         x = 0;
         while (x != 64)
         {
            if ((*(FileBuf + x) != NULL) && (*(FileBuf + x) != '\0'))
            {
               *(FileBuf + x) -= c;
            }
            x += 1;
         }
   
// File Opening Operation to save file
         pack_file_ptr = NULL;
         pack_file_ptr = pack_fopen("mxed.cfg", F_WRITE_PACKED);
         if ( !pack_file_ptr)
         {
            font = (FONT*)datafile[brt_nce_22b].dat;
            degui_fore_color = makecol(200, 0, 0);
            degui_back_color = makecol(180,180, 180);
            degui_select_color = makecol(0, 180, 0);
            degui_deselect_color = makecol(0, 0, 120);
            degui_light_shad_color = makecol(200, 0, 0);
            degui_dark_shad_color = makecol(200, 0, 0);
            degui_alert("Editor  File  Opening   !!  E R R O R  !!",
            "Cannot Open Configuration File. Check Your",
            "Micro-x Directory And Files.", "  OK  ", NULL, 0, 0);
            while(key[KEY_ENTER]){};
            while(key[KEY_ESC]){};
            clear_keybuf();
            set_default_object_colors(0,235,236,237,238,239,240,241);
            font = (FONT*)original_font;
            unload_datafile(datafile);
            destroy_bitmap(scrn_sav);
            allegro_exit();
            pack_fclose(pack_file_ptr);
            exit(6);
          }

          // file write operation
         if (!pack_fwrite(FileBuf, 64, pack_file_ptr))
         {
            font = (FONT*)datafile[brt_nce_22b].dat;
            degui_fore_color = makecol(200, 0, 0);
            degui_back_color = makecol(180,180, 180);
            degui_select_color = makecol(0, 180, 0);
            degui_deselect_color = makecol(0, 0, 120);
            degui_light_shad_color = makecol(200, 0, 0);
            degui_dark_shad_color = makecol(200, 0, 0);
            degui_alert("Editor  File  Write   !!  E R R O R  !!",
            "Cannot Write To Configuration File. Check",
            "Your Micro-x Directory And Files.", "  OK  ", NULL, 0, 0);
            while(key[KEY_ENTER]){};
            while(key[KEY_ESC]){};
            clear_keybuf();
            set_default_object_colors(0,235,236,237,238,239,240,241);
            font = (FONT*)original_font;
            unload_datafile(datafile);
            destroy_bitmap(scrn_sav);
            allegro_exit();
            pack_fclose(pack_file_ptr);
            exit(4);
         }
         pack_fclose(pack_file_ptr);
         
         font = (FONT*)datafile[brt_nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(180,180, 180);
         degui_select_color = makecol(150, 150, 150);
         degui_deselect_color = makecol(120, 120, 120);
         degui_light_shad_color = makecol(0, 200, 0);
         degui_dark_shad_color = makecol(0, 200, 0);
   
         degui_alert("The Editor's Password Protection Has Been Removed.",
         "( No Errors Detected )" , "",
         "  OK  ", NULL, 0, 0);
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)original_font;

         return D_REDRAW;
   }
   show_mouse(NULL);
   blit(scrn_sav,screen,0,0,0,0,640,480);
   show_mouse(screen);
   destroy_bitmap(scrn_sav);
   return D_REDRAW;
}
//
//---------------------------------------
// [ Help System Text Display Function ]
//---------------------------------------
int mxed_calback12(void)
{
   extern dialog mxed_dialog;
   extern dialog mxHelp_dialog;
   extern textbox_object Help_text;
   extern char *Help_hlptxt;

   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   font = (FONT*)original_font;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(164, 164, 164);
   degui_select_color = makecol(0, 160, 0);
   degui_deselect_color = makecol(190, 190, 190);
   degui_light_shad_color = makecol(0, 0, 0);
   degui_dark_shad_color = makecol(0, 0, 0);

   mxed_dialog.add(mxHelp_dialog);
   mxHelp_dialog.popup();
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   mxed_dialog.remove(mxHelp_dialog);

   set_default_object_colors(0,235,236,237,238,239,240,241);
   return 0;
}
//
//---------------------------------------
// [ Help System Callback Introduction ]
//---------------------------------------
int mxed_calback12a(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

-----------------------------
[  I N T R O D U C T I O N  ]
-----------------------------

This program is the Micro-x Accessor System Editor

Version 2.2, custom designed for the  GXV  Version

1.5.5 Micro-x Accessor System. The Micro-x Accessor

System Editor is used to edit and change the data in

the operational files for the Accessor System, and

will not edit or change any other files.



The editor's screen consists of the main title heading

followed by the menu bar. The menu bar option titles

are File, Edit, Password, and Help. To the far right

on the menu bar is a Quit and Exit Button. Clicking or

Pressing this button will exit the editor program. The

area below the menu bar is the Dialog Work Area. This

is where most all of the work dialog windows are set

up and displayed. Just below the dialog work area near

the bottom of the screen is the Status Bar. The status

bar displays helpful information like the name of the

active operational file that is loaded, the active

item number that is set, and the editor's mode of

operation.



To operate the editor you may use the mouse are the

keyboard. To begin your editing session you must first

load an operational file. See the topic Loading and

Saving for more information. To select items with the

keyboard, use the tab key, and the arrow keys to move

the focus from one item to another. After selecting

the item you want, press the Enter Key to activate. To

select with the mouse move the mouse pointer on to the

desired item, and press the mouse button to activate.



When you have finished your editing session, you may

exit the editor by clicking or pressing the Quit And

Exit Button, located at the far right of the menu bar.

You may also exit the editor by pressing the escape

key. If you have not saved your active operational

file to disk, you will be prompted to do so before

the editor exit.
 
 
[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  mxed_calback12();

  return 0;
}
//
//---------------------------------------------
// [ Help System Callback Keyboard and Mouse ]
//---------------------------------------------
int mxed_calback12b(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
   Help_hlptxt = "
======================
= [ start of topic ] =
======================

-----------------------------------------
[  K E Y B O A R D   A N D   M O U S E  ]
-----------------------------------------

The Keyboard and Mouse Operations for the Micro-x

Accessor System Editor is connected to a GUI

interface to support dialogs, buttons, and window

operations. When the editor finishes start up, both

the mouse and the keyboard is made ready for usage.



To change the focus with the keyboard, use the Tab

Key, and the Arrow Keys. When you press the tab key,

the focus is usually set to the first item or object

on the screen. When an item or object has the focus,

a small dotted out line rectangle will appear on the

item or object. If you then press the enter key, this

item will be activated. After you press the tab key

to get the focus on the first item or object, you

should then use the arrow keys to change the focus to

other items or objects.


Using the mouse to get the focus is easy. Where ever

the mouse pointer lies, so does the focus. Just press

the mouse button with the mouse pointer on the item

or object to activate it.


Do not enter any of the special extended ASCII

character codes into any of the editor's input text

boxes. Enter the required text or numeric data only.

The Micro-x Accessor System Editor is not like a

regular text editor, or word processor, and is not

designed to take the special extended ASCII character

codes. See your Micro-x documentation files for more

detailed information.
 

[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  mxed_calback12();

   return 0;
}
//
//---------------------------------------------
// [ Help System Callback Loading and Saving ]
//---------------------------------------------
int mxed_calback12c(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

-----------------------------------------
[  L O A D I N G   A N D   S A V I N G  ]
-----------------------------------------

After the Micro-x Accessor System Editor program

finishes loading, it sets up the screen, the mouse

and the keyboard, and make them ready for usage. But

before you can begin your editing session, you must

first load one of the four operational files.


The Micro-x Accessor System Application Program is

made up of four operational parts. They are the Main

Accessor, Sub #1 Accessor, Sub #2 Accessor, and Sub #3

Accessor. Each Accessor System operational part has

it's own operational file to hold the configuration

data for all of the Accessor System items in it's

selection window. To load an operational file, select

the File option from the menu bar, then select one of

the four oprational files to load. If all goes well

the Accessor System Editor will display a confirmation

message to verify that the operational file has been

loaded and there were no errors. This file will now

become the active operational file, and it's name will

be listed in the status line below. All future edits

will apply to this operational file, until another one

is selected and loaded.



To save the active operational to disk, select the

File option from the menu bar, then select the Save

Op-File item. The active operational file listed in

the status line below will be saved to disk. If all

goes well, the Micro-x Accessor System Editor will

display a confirmation message to verify that the

operational file has been saved, and there were no

errors. During long edit sessions you should save the

active operational file at regular time peroids. If

you are in a dialog, are a window, you must exit that

dialog are window before you can save or load an

operational file.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  mxed_calback12();

  return 0;
}
//
//---------------------------------------
// [ Help System Callback Manual Cycle ]
//---------------------------------------
int mxed_calback12d(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

-----------------------------
[  M A N U A L   C Y C L E  ]
-----------------------------

The Micro-x Accessor System Editor has two modes of

operations. The Manual Cycle Mode of Operations, and

The Auto Cycle Mode of Operations. By default when

the editor finishes start up, the editor is placed in

the manual cycle mode. To begin your editing session,

you must first load an active operational file. See

the topic Loading And Saving. After loading an active

operational file, you can then start the first edit

cycle to begin installing items.


If you are new to the Micro-x Accessor System, or you

have only a few items to install then the manual cycle

mode of operations is the best way to do the job. To

begin operations in the manual cycle mode, select the

Edit menu option, then select Edit Cycle #1. In Edit

Cycle #1 you set the Active Item Number. You must set

the active item number before you can access or use

the other two Edit Cycles.


When you get the Edit Cycle #1 dialog window, the

input text box has a default value of one set in it.

Select the input text box, and clear out the text box,

then enter the desired item number, then click or

press the ok button to set the active item number.

This item number will be displayed in the status line

below. All future edits will apply to the active

Op-File, and the active item number listed in the

status line below. You exit Edit Cycle #1 dialog by

clicking on or pressing the cancel button. You may

also exit Edit Cycle #1 by pressing the escape key.

After completing Edit Cycle #1, you may then select

any one of the other two Edit Cycles.


Selecting Edit Cycle #2 from the Edit menu option will

open the dialog window for the Window Name Data. The

window name data is the name of the program item that

appears in the Accessor System's Main Selection

Window. Use a descripted name when making this input,

one that will be relative to the program item that

will be activated. Edit Cycle #2 has a Delete Button.

If you click on, or press the delete button, the

editor will prompt you to delete the window name data

in the active Op-File, under the active item number

that is listed in the status line below. The Up Date

Button will install the contents of the text box into

the active operational file as the new window name

data. To exit Edit Cycle #2, click or press the exit

button, or press the escape key.


Selecting Edit Cycle #3 from the Edit menu option,

will start the Path Data input dialog. The path data

must comply to Dos rules, meaning the complete path

to the program item, including the three character

extension. Click or press on the up date button to

install the contents in the text box. Edit Cycle #3

dialog also has a Delete Button. If you click on or

press the delete button, you will be prompt to delete

the path data in the active Op-File under the active

item number listed in the status line below.


Edit Cycle #3 dialog window has another button labeled

Disk. If you click or press on the disk button, this

will bring up a file list dialog window. The file list

dialog will allow you to browse the drives, and the

directories that is connected to your computer system,

and view file names in the directories. From this

window you may select, and make path data entries.

Select with the cursor bar, and press or click on the

ok button to install the selected path data. The

cursor bar selection is displayed at the top of the

file list dialog. You can make an entry directly on

this line, but you cannot enter command line

parameters with the path data on this line. If the

path data has to have command line parameters, then

you must use the text box at the path data dialog

window to make the entry. Click on the cancel button

to exit the file list dialog window if you want to

exit without making an entry, or press the escape key.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  mxed_calback12();

  return 0;
}
//
//-------------------------------------
// [ Help System Callback Auto Cycle ]
//-------------------------------------
int mxed_calback12e(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
   Help_hlptxt = "
======================
= [ start of topic ] =
======================

--------------------------
[  A U T O   C Y C L E   ]
--------------------------

The Micro-x Accessor System Editor has a 2nd mode of

operations, which is Mode #2 the Auto Cycle Mode of

Operations. By default when the editor finishes start

up, the editor is placed in the manual cycle mode. To

begin your editing session in the auto cycle mode you

must first load an active operational file. See the

topic Loading And Saving. After loading an active

operational file, you can then start your auto cycle

editing session to begin installing Accessor items.



To start auto cycle, select the Edit menu option,

then select the Auto Cycle item. When this is done

the first dialog window is open, and the status line

then turns on the AUTO sign. The editor is now in

the auto cycle mode. The manual cycle mode allows you

to access the edit cycles one at a time. When you are

finish with the open edit cycle, you must exit that

edit cycle in order to access the next edit cycle.



Auto cycle will also access the edit cycles one at a

time, but the difference is that, after you make an

up date entry, the auto cycle mode will move to the

next edit cycle. This allows faster data input into

the operational files. Auto cycle will continue to

move from one edit cycle to the next edit cycle after

each up date until you click on or press the exit

button. You may also exit auto cycle by pressing the

escape key at Edit Cycle #1. Pressing the escape key

at edit cycle #2, or at edit cycle #3 will cause auto

cycle to cycle to the next edit cycle. Use the Escape

Key with caution. When you exit auto cycle, the editor

is returned to the manual cycle mode, and the AUTO

cycle sign in the status line is set to a line of

stars. The line of stars mean that the editor is now

in the manual cycle mode.


The first dialog window that auto cycle opens is Edit

Cycle #1, set the item number. The next Edit Cycle

auto cycle opens, is Edit Cycle #2, and the next one

is Edit Cycle #3. After an up date at Edit Cycle #3,

auto cycle will then move back to Edit Cycle #1. This

action will continue until you click or press on the

exit button at any one of the Edit Cycle dialog

windows, or press the escape key at Edit Cycle #1. In

the auto cycle mode, the Edit Cycle's data input is

done the same way as it is in the manual cycle mode.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  mxed_calback12();

  return 0;
}
//
//-----------------------------------
// [ Help System Callback Password ]
//-----------------------------------
int mxed_calback12f(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

---------------------
[  P A S S W O R D  ]
---------------------

The Micro-x Accessor System Editor provides password

protection for the Editor only. The password data

format is made up of a 4 to 8 character data string.

The Micro-x Accessor System Editor will store, and

maintain access to the password data. When a password

is install, you cannot access the editor without the

valid password. If you install a password, and you

lose, or forget the password, the editor cannot give

any help to recover it. If this should happen, then

you must install the Micro-x Accessor System over

again from start.


To install password protection in the Micro-x Accessor

System Editor, select the Password menu option from

the menu bar, then select the Edit Password Item. When

the password dialog window opens, set the focus on the

text box, and enter the password data of 4 to 8

characters. When this is done, click on or press the

Save Button to save the password data and set password

protection in effect. You may exit the password dialog

window by clicking on or pressing the cancel button.

You may also exit by pressing the escape key.


To remove password protection from the editor, select

the Password menu option, then select the Remove

Password item. When this is done, you will be prompted

to remove the password protection from the editor.

Press or click on the ok button to remove password

protection.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  mxed_calback12();

  return 0;
}
//
//-----------------------------------------------
// [ Mxed.cc's About Dialog Call Back Function ]
//-----------------------------------------------
int mxed_calback13(void)
{
   extern dialog mxedAbout_dialog;
   extern dialog mxed_dialog;
   extern dialog mxedAbout_dialog;
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   font = (FONT*)original_font;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(175,175, 175);
   degui_select_color = makecol(0, 150, 0);
   degui_deselect_color = makecol(190, 190, 190);
   degui_light_shad_color = makecol(0, 0, 0);
   degui_dark_shad_color = makecol(0, 0, 0);

   mxed_dialog.add(mxedAbout_dialog);
   mxedAbout_dialog.popup();
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   mxed_dialog.remove(mxedAbout_dialog);

   set_default_object_colors(0,235,236,237,238,239,240,241);
   return D_REDRAW;
}
//
//--------------------------------------------------------------------------
//[ callback function for the escape key & button close operation buttons ]
//--------------------------------------------------------------------------
int prg_close(void)
{
   char bufa[ ] = "This Selection Will Exit The Micro-x";
   char bufb[ ] = "Accessor System Editor";
   char bufc[ ] = "( Exit The Accessor System Editor ? )";
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   font = (FONT*)datafile[brt_nce_22b].dat;
   degui_fore_color = makecol(240, 200, 0);
   degui_back_color = makecol(100, 100, 110);
   degui_select_color = makecol(0, 100, 0);
   degui_deselect_color = makecol(150, 0, 150);
   degui_light_shad_color = makecol(240, 200, 0);
   degui_dark_shad_color = makecol(240, 200, 0);
   
   retn = alert(bufa, bufb, bufc, "   &YES   ", "   NO   ", 'y', 27);
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   if(retn == 2)
   {

     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     retn = 100;
     return D_CLOSE;
   }
   int retx = 0;
   if(Save_Flag != 0)
   {
     retx = alert("Changes Have Been Detected In The Active",
     "Op-File, These Changes Have Not Been Saved To Disk",
     "( Save Active Op-File To Disk ? )", "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
   
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)original_font;
     if(retx == 1)
     {
       retx = mxed_calback5();
       retn = 99;
       return D_CLOSE;
     } 
   }
   retn = 99;
   return(retn);
}
//
//--------------------------------------
// [ Mxed.cc's Dialog Set Up Function ]
//--------------------------------------
void SetUpCycDial(void)
{
   extern dialog cycle1_dialog;
   extern dialog cycle2_dialog;
   extern dialog cycle3_dialog;
   extern dialog paswrd_dialog;
   extern dialog mxedAbout_dialog;
   extern window_object mxHelp_window;

// Add Objects to dialog #1
   cycle1_dialog.add(cycle1_panel,          159,    163,    310,  165);
   cycle1_dialog.add(cycle1_edit,           209,    260,    209,   14);
   cycle1_dialog.add(cycle1_ok_button,      174,    300,    71,    20);
   cycle1_dialog.add(cycle1_cancel_button,  383,    300,    70,    20);
   cycle1_dialog.add(cycle1_txt1,           310,    170,    84,     8);
   cycle1_dialog.add(cycle1_txt2,           310,    218,    84,     8);
   cycle1_dialog.add(cycle1_txt3,           310,    230,    84,     8);

// Add Objects to dialog #2
   cycle2_dialog.add(cycle2_panel,          159,    163,    310,  165);
   cycle2_dialog.add(cycle2_edit,           209,    260,    209,   14);
   cycle2_dialog.add(cycle2_update,         174,    300,    71,    20);
   cycle2_dialog.add(cycle2_delete,         279,    300,    71,    20);
   cycle2_dialog.add(cycle2_exit_button,    383,    300,    70,    20);
   cycle2_dialog.add(cycle2_txt1,           310,    170,    84,     8);
   cycle2_dialog.add(cycle2_txt2,           310,    218,    84,     8);
   cycle2_dialog.add(cycle2_txt3,           312,    230,    84,     8);

// Add Objects to dialog #3
   cycle3_dialog.add(cycle3_panel,          112,    163,    410,  165);
   cycle3_dialog.add(cycle3_edit,           165,    260,    300,   14);
   cycle3_dialog.add(cycle3_update,         132,    300,    71,    20);
   cycle3_dialog.add(cycle3_delete,         230,    300,    71,    20);
   cycle3_dialog.add(cycle3_disk_button,    331,    300,    70,    20);
   cycle3_dialog.add(cycle3_exit_button,    432,    300,    70,    20);
   cycle3_dialog.add(cycle3_txt1,           315,    170,    84,     8);
   cycle3_dialog.add(cycle3_txt2,           312,    218,    84,     8);
   cycle3_dialog.add(cycle3_txt3,           314,    230,    84,     8);

// Add Objects to paswrd_dialog
   paswrd_dialog.add(paswrd_panel,          159,    163,    310,  165);
   paswrd_dialog.add(paswrd_edit,           209,    260,    209,   14);
   paswrd_dialog.add(paswrd_save,           174,    300,    71,    20);
   paswrd_dialog.add(paswrd_cancel_button,  383,    300,    70,    20);
   paswrd_dialog.add(paswrd_txt1,           310,    170,    84,     8);
   paswrd_dialog.add(paswrd_txt2,           314,    218,    84,     8);
   paswrd_dialog.add(paswrd_txt3,           314,    230,    84,     8);

// Add Objects to About dialog
   mxedAbout_dialog.add(mxedAbout_object_1,199,130,228,228);
   mxedAbout_dialog.add(mxedAbout_button,269,320,89,23);
   mxedAbout_dialog.add(txt1a,251,141,128,8);
   mxedAbout_dialog.add(txt2a,261,156,104,8);
   mxedAbout_dialog.add(txt3a,269,172,88,8);
   mxedAbout_dialog.add(txt4a,239,206,152,8);
   mxedAbout_dialog.add(txt5a,222,217,184,8);
   mxedAbout_dialog.add(txt6a,243,230,136,8);
   mxedAbout_dialog.add(txt7a,222,242,184,8);
   mxedAbout_dialog.add(txt8a,223,270,184,8);
   mxedAbout_dialog.add(txt9a,236,282,160,8);

// Add Objects to mxHelp_dialog
   mxHelp_dialog.add(mxHelp_panel,90,22,461,444);
   mxHelp_dialog.add(mxHelp_box,104,32,434,29);
   mxHelp_dialog.add(help_title,155,44,328,8);
   mxHelp_dialog.add(mxHelp_sunken_panel,104,76,434,24);
   mxHelp_dialog.add(mxHelp_button,275,79,83,19);
   mxHelp_dialog.add(Help_text,95,106,451,353);
//..............................
   return;
}
//
//---------------------------------------------
// [ Mxed.cc's Password Protection Operation ]
//---------------------------------------------
void pass_word_test(void)
{
   int retn = 0;
   int x = 0;
   int x_es = 0;
   int y_es = 0;
   int x_e = 0;
   int y_e = 0;
   int ye = 0;
   int xe = 0;
   int presskey = 0;
   char buf_pas[9];
   char *user_pass;
   unsigned *scrn_buf = (unsigned *)alloca(ScreenRows()*ScreenCols()*2);
   extern char Pass_Word_Buf[9];
   extern char *FileBuf;

  _go32_dpmi_registers r;
   
// Set Up Text Mode
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   textbackground(0);
   textcolor(7);
   ScreenClear();
   ScreenSetCursor(2, 0);

// Allocate File Buffer Space
   FileBuf = (char*)alloca(64);
   if (!FileBuf)
   {
     cprintf("Editor  File  Buffer   !!  E R R O R  !!\n\r");
     cprintf("Not Enough Memory To Open Password Configuration File.\n\r");
     cprintf("Ckeck Your Micro-x Setup, and System Set Up.\n\r\n\r");
     cprintf("Press (ESCAPE) to continue......\n\r");

     while(presskey != K_Escape)
     {
      if (kbhit())
      {
       presskey = getkey();
      }
     }

     textbackground(0);
     textcolor(7);
     ScreenClear();
     exit(6);
   }

// File Opening Operation to save file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("mxed.cfg", F_READ_PACKED);
   if ( !pack_file_ptr)
   {
      cprintf("Editor  File  Opening   !!  E R R O R  !!\n\r");
      cprintf("Cannot Open Password Configuration File.\n\r");
      cprintf("Check Your Micro-x Directory And Files.\n\r\n\r");
      cprintf("Press (ESCAPE) to continue......\n\r");

      while(presskey != K_Escape)
      {
       if (kbhit())
       {
        presskey = getkey();
       }
      }

      textbackground(0);
      textcolor(7);
      ScreenClear();
      pack_fclose(pack_file_ptr);
      exit(6);
    }

// File Read Operation password cfg file
   if (!pack_fread(FileBuf, 64, pack_file_ptr))
   {
    cprintf("Editor  File  Read   !!  E R R O R  !!\n\r");
    cprintf("Cannot Read Password Configuration File.\n\r");
    cprintf("Check Your Micro-x Directory And Files.\n\r\n\r");
    cprintf("Press (ESCAPE) to continue......\n\r");

    while(presskey != K_Escape)
    {
     if (kbhit())
     {
      presskey = getkey();
     }
    }

    textbackground(0);
    textcolor(7);
    ScreenClear();
    pack_fclose(pack_file_ptr);
    exit(4);
   }
   pack_fclose(pack_file_ptr);

// Set Buffer Code For read
   x = 0;
   while (x != 64)
   {
      if ((*(FileBuf + x) != NULL) && (*(FileBuf + x) != '\0'))
      {
         *(FileBuf + x) += c;
      }
      x += 1;
   }

// Test For Password
   strcpy(buf_pas, (FileBuf + 0));

   if(strcmp(buf_pas, "[NOPASS]") == 0)
   {
     textbackground(0);
     textcolor(7);
     ScreenClear();
     return;
   }

   textbackground(0);
   textcolor(7);
   ScreenClear();
   textbackground(0);
   textcolor(2);
   ScreenSetCursor(4, 10);
   cprintf("%c", '\xDA');
   ScreenSetCursor(4, 11);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x70;
   r.x.cx = 0x3B;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(4, 69);
   cprintf("%c", '\xBF');
   ScreenSetCursor(5, 10);
   cprintf("%c", '\xB3');
   x_es = 11;
   y_es = 5;
   xe = 1;
   while (xe != 12)
   {
     ScreenSetCursor(y_es, x_es);
     r.h.ah = 0x09;
     r.h.al = 0x20;
     r.h.bh = 0x00;
     r.h.bl = 0x70;
     r.x.cx = 0x3B;
     r.x.ss = r.x.sp =0x00;
     _go32_dpmi_simulate_int(0x10, &r);
     x_es = 69;
     ScreenSetCursor(y_es, x_es);
     cprintf("%c", '\xB3');
     ++y_es;
     x_es =10;
     ScreenSetCursor(y_es, x_es);
     cprintf("%c", '\xB3');
     x_es = 11;
     ++xe;
   }
   ScreenSetCursor(16, 10);
   cprintf("%c", '\xC0');
   ScreenSetCursor(16, 11);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x70;
   r.x.cx = 0x3B;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(16, 69);
   cprintf("%c", '\xD9');
   textbackground(7);
   textcolor(1);
   ScreenSetCursor(6, 16);
   cprintf("Micro-x Accessor System Editor Password Request");
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(8, 13);
   cprintf("Password Protection Is In Effect. At The Prompt Below");
   ScreenSetCursor(9, 13);
   cprintf("[ Enter The Correct Micro-x Password And Press Enter ]");
   ScreenSetCursor(12, 13);
   x = 0;
   ye = 0;
   sound(440);
   delay(50);
   nosound();
   _setcursortype(_NORMALCURSOR);
   strcpy(buf_pas, (FileBuf + 0));
   ScreenRetrieve(scrn_buf);
   while (x != 999)
   {
     ++x;
     ScreenSetCursor(12, 13);
     user_pass = getpass("Enter Password : ->");
     if(strcmp(buf_pas, user_pass) == 0)
     {
       textbackground(0);
       textcolor(7);
       _setcursortype(_NOCURSOR);
       ScreenClear();
       ScreenSetCursor(11, 6);
       cprintf("Password Accepted ... Accessing The Micro-x Accessor System Editor.\n\r");
       return;
     }
     else
     {
       _setcursortype(_NOCURSOR);
       textbackground(4);
       textcolor(15);
       ScreenSetCursor(9, 24);
       cprintf("                              ");
       ScreenSetCursor(10, 24);
       cprintf("    Password   !! Error !!    ");
       ScreenSetCursor(11, 24);
       cprintf("   The Password Is Not Even   ");
       textbackground(4);
       textcolor(14);
       ScreenSetCursor(12, 24);
       cprintf("");
       textbackground(4);
       textcolor(15);
       ScreenSetCursor(13, 24);
       cprintf("      Press ESC To Abort      ");
       ScreenSetCursor(14, 24);
       cprintf("     Press F5 To Continue     ");
       ScreenSetCursor(15, 24);
       cprintf("                              ");

       while(x != 999)
       {
         if (kbhit())
         {
           presskey = getkey();
         }

         if ((presskey == K_Escape) || (x == 14))
         {
          textbackground(0);
          textcolor(7);
          ScreenClear();
          exit(0);
        }

        if (presskey == K_F5)
        {
          ScreenUpdate(scrn_buf);
          _setcursortype(_NORMALCURSOR);
          break;
        }
       }
     }
     presskey = 0;
   }
   textbackground(0);
   textcolor(7);
   ScreenClear();
   exit(0);
}
//
//---------------------------------------
// [ Mxed.cc's Error Handling Function ]
//---------------------------------------
void Err_Handler(int ERR_FLAG)
{
  int err = 0;
  int presskey = 0;
  char buf1a[80], buf2a[80], buf3a[80];
  extern char OpFileName[16];
  err = ERR_FLAG;

  switch (err)
  {
   case 1:
    ScreenClear();
    ScreenSetCursor(0,0);
    cprintf("!! Error in Accessor System Editor !!\n\r");
    cprintf("Missing Program Link To MxLoder.exe.\n\r");
    cprintf("Use MxLoder.exe only to Run this Program.\n\r\n\r");
    cprintf("Press (ESCAPE) to continue......\n\r");

    while(presskey != K_Escape)
    {
     if (kbhit())
     {
      presskey = getkey();
     }
    }
    presskey = 0;
    ERR_FLAG = 0;
    break;
   
   case 2:
    ScreenClear();
    ScreenSetCursor(0,0);
    cprintf("!! Error in Accessor System Editor !!\n\r");
    cprintf("Invalid Program Link ID.\n\r");
    cprintf("Use MxLoder.exe only to Run this Program.\n\r\n\r");
    cprintf("Press (ESCAPE) to continue......\n\r");

    while(presskey != K_Escape)
    {
     if (kbhit())
     {
      presskey = getkey();
     }
    }
    presskey = 0;
    ERR_FLAG = 0;
    break;
   
   case 3:
    cprintf("!!  E R R O R  !!  In The Micro-x Accessor System Editor.\n\r");
    cprintf("Cannot Load The Micro-x Data File.\n\r");
    cprintf("See Your Micro-x Doc Files For More Details.\n\r\n\r");
    cprintf("Press (ESCAPE) to continue......\n\r");

    while(!key[KEY_ESC])
    {
    }

    presskey = 0;
    ERR_FLAG = 0;
    break;
      
   case 4:
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();

    font = (FONT*)datafile[brt_nce_22b].dat;
    
    degui_fore_color = makecol(200, 0, 0);
    degui_back_color = makecol(180,180, 180);
    degui_select_color = makecol(0, 180, 0);
    degui_deselect_color = makecol(0, 0, 120);
    degui_light_shad_color = makecol(200, 0, 0);
    degui_dark_shad_color = makecol(200, 0, 0);
    
    sprintf(buf1a, "Editor File Access   !!  E R R O R  !!");
    sprintf(buf2a, "Cannot Read or Write to %s Operational File.", OpFileName);
    sprintf(buf3a, "Ckeck Your Micro-x Files and Directories.");
    degui_alert(buf1a, buf2a, buf3a, "  OK  ", NULL, 0, 0);
    set_default_object_colors(0,235,236,237,238,239,240,241);
    font = (FONT*)original_font;
    ERR_FLAG = 0;
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();
    break;
   
   case 5:
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();

    font = (FONT*)datafile[brt_nce_22b].dat;
    
    degui_fore_color = makecol(200, 0, 0);
    degui_back_color = makecol(180,180, 180);
    degui_select_color = makecol(0, 180, 0);
    degui_deselect_color = makecol(0, 0, 120);
    degui_light_shad_color = makecol(200, 0, 0);
    degui_dark_shad_color = makecol(200, 0, 0);
    
    sprintf(buf1a, "Editor  File  Buffer   !!  E R R O R  !!");
    sprintf(buf2a, "Not Enough Memory To Open Operational Files.");
    sprintf(buf3a, "Ckeck Your Micro-x Files, and System Set Up.");
    degui_alert(buf1a, buf2a, buf3a, "  OK  ", NULL, 0, 0);
    set_default_object_colors(0,235,236,237,238,239,240,241);
    font = (FONT*)original_font;
    ERR_FLAG = 0;
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();
    break;
   
   case 6:
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();

    font = (FONT*)datafile[brt_nce_22b].dat;
    
    degui_fore_color = makecol(200, 0, 0);
    degui_back_color = makecol(180,180, 180);
    degui_select_color = makecol(0, 180, 0);
    degui_deselect_color = makecol(0, 0, 180);
    degui_light_shad_color = makecol(200, 0, 0);
    degui_dark_shad_color = makecol(200, 0, 0);
    
    sprintf(buf1a, "Editor  File  Opening   !!  E R R O R  !!");
    sprintf(buf2a, "%s Operational File Fail To Open.", OpFileName);
    sprintf(buf3a, "See Your Micro-x Doc Files For More Details.");
    degui_alert(buf1a, buf2a, buf3a, "  OK  ", NULL, 0, 0);
    set_default_object_colors(0,235,236,237,238,239,240,241);
    font = (FONT*)original_font;
    ERR_FLAG = 0;
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();
    break;
   
   case 7:
    ScreenClear();
    ScreenSetCursor(0,0);
    cprintf("!! Error in Accessor System Editor !!\n\r");
    cprintf("Cannot Set Up Video Adapter.\n\r\n\r");
    cprintf("Press (ESCAPE) to continue......\n\r");
    
    while(presskey != K_Escape)
    {
     if (kbhit())
     {
      presskey = getkey();
     }
    }
    presskey = 0;
    ERR_FLAG = 0;
    break;
   
   default:
    allegro_exit();
    exit(9);
    break;
  }
  return;
}
//
//-------------------------------
// [ Save file helper function ]
//-------------------------------
int Save_File(void)
{
  mxed_calback12();
  return D_O_K;
}
//
//---------------------------------------
// [ Help text display helper function ]
//---------------------------------------
int Help_Display(void)
{
  mxed_calback5();
  return D_O_K;
}
//
//***************************************************************************
// **************************************************************************
// [ START OF MAIN PROGRAM FOR  MXED.CC  ACCESSOR SYSTEM EDITOR  Ver. 2.2 ]
// **************************************************************************
//***************************************************************************
int main(int argc, char **argv)
{
   int a, y, x;
   int t;
   int retx = 0;
   int presskey = 0;
   char com_line[ ] = "60799MX155";
   char buf1[11];
   extern int ERR_FLAG;
   extern int retn;
   extern char Itm_1s[38];
   extern char Itm_2s[38];
   extern char *ar_ptr[56];
   extern char *buf;
   extern char *Sta_ln_Info1;
   extern char *Sta_ln_Info2;
   extern dialog mxed_dialog;
   extern DATAFILE *datafile;
   extern PALETTE pal;
   FILE *fp;

// Check Chain Link With Mxloder
   _fmode = O_BINARY;
   fflush(stdout);
   fflush(stdin);
   if (strlen(argv[1]) > 10)
   {
     ERR_FLAG = 1;
     Err_Handler(ERR_FLAG);
     exit(1);
   }
   if (strlen(argv[1]) == NULL)
   {
     ERR_FLAG = 1;
     Err_Handler(ERR_FLAG);
     exit(1);
   }
  if ((argc >= 3) || (argc == 0))
  {
     ERR_FLAG = 1;
     Err_Handler(ERR_FLAG);
     exit(1);
   }
   fp = fopen("accs.tmp", "w");
   fprintf(fp, "%s", argv[1]);
   fclose(fp);
   fp = fopen("accs.tmp", "r");
   fscanf(fp, "%s", buf1);
   fclose(fp);
   remove("accs.tmp");
   if (strcmp(buf1, com_line) != 0)
   {
    ERR_FLAG = 2;
    Err_Handler(ERR_FLAG);
    exit(2);
   }

// Call Password Operation
   pass_word_test();

// Initialise Allegro & Degui
   set_config_file("mxsys.cfg");
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

// Stores default font & set default mouse focus
   original_font = (FONT*)font;
   gui_mouse_focus = FALSE;

// Load the attached datafile
   datafile = load_datafile("#");
   if (!datafile)
   {
      ERR_FLAG = 3;
      Err_Handler(ERR_FLAG);
      allegro_exit();
      exit(1);
   }
//
//-----------------------------------------------------
// [ Allocate Buffer and Set Buffer Code For Reading ]
//-----------------------------------------------------
// Allocate File Buffer Space
   buf = (char*) alloca(4800);
   if (!buf)
   {
     ERR_FLAG = 5;
     Err_Handler(ERR_FLAG);
     unload_datafile(datafile);
     allegro_exit();
     exit(5);
   }
// Set Pointers To Buffer
   t = 0;
   a = 0;
   x = 0;
   while (x != 28)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_1s);
      t += 1;
      x += 1;
      a = a + 38;
   }
   t = 28;
   a = 1064;
   x = 28;
   while (x != 56)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_2s);
      t += 1;
      x += 1;
      a = a + 128;
   }

// Set up the graphics mode
   if(set_gfx_mode(GFX_VESA1,640,480,0,0) < 0)
   {
    if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0) < 0)
    {
      ERR_FLAG = 7;
      Err_Handler(ERR_FLAG);
      allegro_exit();
      exit(7);
    }  
   }
   generate_332_palette(pal);
   set_palette(pal);
   text_mode(-1);
   
// Setup the Mxed menu
   menu File_menu;
   File_menu.add("Load &Main Op-File",mxed_calback1);
   File_menu.add("Load Sub#&1 Op-File",mxed_calback2);
   File_menu.add("Load Sub#&2 Op-File",mxed_calback3);
   File_menu.add("Load Sub#&3 Op-File",mxed_calback4);
   File_menu.add("");
   File_menu.add("&Save Op-File",mxed_calback5);
   
   menu Edit_menu;
   Edit_menu.add("Edit Cycle#&1",mxed_calback6);
   Edit_menu.add("Edit Cycle#&2",mxed_calback7);
   Edit_menu.add("Edit Cycle#&3",mxed_calback8);
   Edit_menu.add("");
   Edit_menu.add("&Auto Cycle",mxed_calback9);

   menu Password_menu;
   Password_menu.add("&Edit Password",mxed_calback10);
   Password_menu.add("&Remove Password",mxed_calback11);

   menu Topics_menu;
   Topics_menu.add("&Introduction",::mxed_calback12a);
   Topics_menu.add("&Keyboard And Mouse",::mxed_calback12b);
   Topics_menu.add("&Loading And Saving",::mxed_calback12c);
   Topics_menu.add("&Manual Cycle",::mxed_calback12d);
   Topics_menu.add("&Auto Cycle",::mxed_calback12e);
   Topics_menu.add("&Password",::mxed_calback12f);
   
   menu Help_menu;
   Help_menu.add("&Topics",Topics_menu);
   Help_menu.add("");
   Help_menu.add("&About",mxed_calback13);

   menu degui_menu;
   degui_menu.add("&File",File_menu);
   degui_menu.add("&Edit",Edit_menu);
   degui_menu.add("&Password",Password_menu);
   degui_menu.add("&Help",Help_menu);
   menu_object          menu(degui_menu);

// Declare the Mxed objects
   clear_screen_object  clear_obj;
   clear_to_color(screen, makecol(128, 128, 128));
   set_default_object_colors(0,235,236,237,238,239,240,241);

// Set Exit Button's Colors
   color_scheme new_colors5;
   new_colors5.set_fore(makecol(200, 0, 0));
   object_5.color = &new_colors5;
   
// Add Objects to the Mxed dialog
   mxed_dialog.add(menu,       24,    126,    22,  60);
   mxed_dialog.add(object_5,468,123,150,17);

// Set call_back functions ...
   object_5.set_key_callback(prg_close);
   object_5.set_click_callback(prg_close);

// Set up screen & background
   show_mouse(NULL);
   rect(screen, 0, 0, 639, 479, makecol(0, 150, 0));
   rect(screen, 3, 3, 637, 477, makecol(0, 150, 0));
   rect(screen, 3, 3, 638, 478, makecol(0, 200, 0));
   rect(screen, 6, 6, 634, 474, makecol(0, 0, 200));
   rect(screen, 7, 7, 633, 473, makecol(0, 0, 200));
   rectfill(screen, 11, 11, 629, 469, makecol(120, 120, 120));
   rect(screen, 16, 120, 624, 142, makecol(0, 0, 255));

   font = (FONT*)datafile[brt_helv_38b].dat;
   textout(screen, font, "Micro-x Accessor System Editor", 60, 15, makecol(0, 0,200));
   
   font = (FONT*)datafile[brt_nce_22b].dat;
   textout(screen, font, "Version 2.2  Copyright (C) July 2002  By John F. Clark Jr.", 50, 55, makecol(0, 200,200));
   
   font = (FONT*)datafile[brt_nce_15b].dat;
   textout(screen, font, "For Use With Micro-x Accessor System Version 1.5.5 GXV only", 105, 85, 0);
   textout(screen, font, "M  E  N  U     B  A  R", 290, 124, makecol(0,200,0));
   
// Status Line Set Up
   rect(screen, 16, 400, 624, 440, makecol(255, 255,0));
   rect(screen, 20, 405, 619, 435, makecol(0, 0, 255));
   rectfill(screen, 22, 406, 617, 433, 0);
   textout(screen, font, "Status Information", 255, 380, makecol(0,255,255));
   font = (FONT*)datafile[brt_nce_15b].dat;
   textout(screen, font, Sta_ln_Info1, 40, 414, makecol(0, 255,255));
   textout(screen, font, Sta_ln_Info2, 400, 414, makecol(0, 255,255));
   textout(screen, font, "****** ", 295, 414, makecol(0, 255,255));

   font = (FONT*)original_font;
   show_mouse(screen);

// Set up the edit cycle's dialog & objects
   SetUpCycDial();

// Start the Editor's Mxed dialog
   CYCLE:
   mxed_dialog.execute();

// Process Close Routine For Push Button Operation
   if(retn == 99)
   {
     goto MXED_EXIT;
   }
//---------------------   
   if(retn == 100)
   {
     retn = 0;
     goto CYCLE;
   }

// Process Close Routine For Escape Key Operation
   prg_close();
   if((key[KEY_ESC]) && (retn == 100))
   {
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(Save_Flag != 0)
     {
       font = (FONT*)datafile[brt_nce_22b].dat;
       degui_fore_color = makecol(240, 200, 0);
       degui_back_color = makecol(100, 100, 110);
       degui_select_color = makecol(0, 100, 0);
       degui_deselect_color = makecol(150, 0, 150);
       degui_light_shad_color = makecol(240, 200, 0);
       degui_dark_shad_color = makecol(240, 200, 0);
       
       retx = alert("Changes Have Been Detected In The Active",
       "Op-File, These Changes Have Not Been Saved To Disk",
       "( Save Active Op-File To Disk ? )", "   &YES   ", "   NO   ", 'y', 27);
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
   
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)original_font;
       if(retx == 1)
       {
         retx = mxed_calback5();
         goto MXED_EXIT;
       } 
     }
     retn = 99;
   }
   if(retn == 99)
   {
     goto MXED_EXIT;
   }
//---------------------   
   if(retn == 100)
   {
     retn = 0;
     goto CYCLE;
   }
//---------------------   
   MXED_EXIT:
   show_mouse(NULL);
   unload_datafile(datafile);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
}
//
// **************************************************************************
// **************************************************************************
// [ END OF PROGRAM FOR  MXED.CC  ACCESSOR SYSTEM EDITOR  Ver. 2.2 ]
// **************************************************************************
// **************************************************************************
