// ******************************************************************
// [ Program Name: MX155.CC Main Program For Micro-x ver. 1.5.5 GXV
// ******************************************************************
// Date Revised: march 15, 2003.
// Author's Name: John F. Clark Jr.
// *******************************************************************
//
// *******************************************************************
// [ Appendix: Terms Conditions and Aggreements ]
// ***********************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
//                       NO WARRANTY
// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                    END OF TERMS AND CONDITIONS
//***************************************************************************
//
//
//--------------------------------------------
// [ Mx155.cc's Header File Include Section ]
//--------------------------------------------
#include <allegro.h>
#include <degui.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <dpmi.h>
#include <go32.h>
#include <dos.h>
#include <sys/stat.h>
#include <string.h>
#include <strings.h>
#include <libc.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <mxacc.h>
using namespace std;
//
//--------------------------------------------
// [ Mx155.cc's Function Definition Section ]
//--------------------------------------------
void Err_Handler(int);
void setup_dialog_objects(void);
int close_exit(int);
int prg_close(void);
int acc_edit(void);
int set_cfm(void);
void upDateStat(void);
int change_op_file(void);
int mx_prompt(void);
int mx_info(void);
int select_prg_exit(void);
int call_back_main(void);
int call_back_m1(void);
int call_back_m2(void);
int call_back_m3(void);
int call_back_m4(void);
int call_back_m5(void);
int call_back_m6(void);
int call_back_m7(void);
//
//---------------------------------------------------------------
// [ Global System INIT & Global Variables Declaration Section ]
//---------------------------------------------------------------
int exit_flag = 0;
int LoadExeReady = 1;
int ER_FLAG = 0;
int main_exit = 0;
unsigned int result = 0;
int handle = 0;
char mx_main[ ] = "MX155.EXE 60795MX155";
char mx_mainid[ ] = "60795MX155";
char mx_lod_86[ ] = "MX155.EXE 60796MX155";
char mx_lod_86id[ ] = "60796MX155";
char mx_lod_87[ ] = "MX155.EXE 60797MX155";
char mx_lod_87id[ ] = "60797MX155";
char mx_lod_88[ ] = "MX155.EXE 60798MX1";
char mx_lod_88id[ ] = "60798MX155";
char mx_lod_exit[ ] = "MAINEXIT60795XMX155ACC";
char OpFileLoad[16];
char *cmd_pmt;
char *buf;
char *ar_ptr[56];
char *Help_hlptxt;
char ActiveOpFileName[8];
char ActiveOpFileId[11];
char SET_CFM[4];
char opl_str[2];
int default_fore = 0;
int default_back = 0;
int default_select = 0;
int default_deselect = 0;
int default_light_shad = 0;
int default_dark_shad = 0;
char c = '';

unsigned _stklen = 1048576;
//
//---------------------------------------
// [ Global Object Declaration Section ]
//---------------------------------------
FONT *original_font;
DATAFILE *datafile;
list_object *selection_list;
edittext_object *ld_ptr_edit;
button_object *ld_ptr_ok_button;
button_object *ld_ptr_cancel_button;

// Micro-x Accessor Dialog Object's Definition
dialog mx_acc_dialog;
dialog loadOpFile_dialog;
dialog mxHelp_dialog;
dialog mxAccAbout_dialog;
textbox_object Help_text(Help_hlptxt,false,false);
//
//-----------------------------------------------------------------
// [ Callback Function To Service The Micro-x Selections Listbox ]
//-----------------------------------------------------------------
char *listbox_service(int index, int *list_size)
{
   extern char *ar_ptr[56];

   if (index < 0)
   {
      *list_size = 28;
      return NULL;
   }
   else
   {
      return((char*) ar_ptr[index]);
   }
   return NULL;
}
//
//------------------------------------------------------
// [ Callback function for program selection list box ]
//------------------------------------------------------
int select_prg_exit(void)
{
   int x;
   int item_sel = 0;
   int rt = 0;
   int fhandle = 0;
   int i_exe = 0;
   int file_sel = 0;
   int file_chk = 0;
   char *sel_buf = (char*) alloca(200);
   char set_stat1[28];
   char set_stat2[28];
   char prg_name[38];
   char prg_path[128];
   extern int ER_FLAG;
   extern char ActiveOpFileId[11];
   extern char *ar_ptr[56];
   extern DATAFILE *datafile;
   extern int exit_flag;
   extern char ActiveOpFileId[11];
   extern char SET_CFM[4];
   extern list_object *selection_list;
   extern dialog mx_acc_dialog;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
// Get User Selection
   item_sel = (selection_list->selection());
   strcpy(prg_name, ar_ptr[item_sel]);
   strcpy(prg_path, ar_ptr[item_sel + 28]);

// Set True Path To Program,, and test path
   x = 0;
   while(x != 126)
   {
     if(prg_path[x] == '.')
     {
       prg_path[x + 4] = NULL;
       break;
     }
     ++x;
   }
   fhandle = open(prg_path, O_RDONLY);
   i_exe = _is_executable(prg_path, fhandle, NULL);
   close(fhandle);

   file_chk = exists(prg_path);
         
   if((i_exe == 0) || (file_chk == 0))
   {
     font = (FONT*)datafile[nce_22b].dat;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(160,160, 160);
   degui_select_color = makecol(0, 180, 0);
   degui_deselect_color = makecol(190, 190, 190);
   degui_light_shad_color = makecol(255, 0, 0);
   degui_dark_shad_color = makecol(255, 0, 0);
     degui_alert("! Access Error !  The Selected Program Item",
     prg_name,"May Not Be Install Or, Cannot Be Found In Storage",
     "   OK   ",NULL , 0, 0);
     font = (FONT*)datafile[nce_15b].dat;
     set_default_object_colors(0,235,236,237,238,239,240,241);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return(D_O_K);
   }

// Reload path data and test CFM setting
   strcpy(prg_path, ar_ptr[item_sel + 28]);

   if(strcmp(SET_CFM, "ON ") == 0)
   {
     font = (FONT*)datafile[nce_22b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(160,160, 160);
     degui_select_color = makecol(0, 180, 0);
     degui_deselect_color = makecol(190, 190, 190);
     degui_light_shad_color = makecol(0, 255, 0);
     degui_dark_shad_color = makecol(0, 255, 0);

     rt = alert("[ Micro-x Confirmation, For The Selected Item ]",
     prg_name, "[ Activate This Selection  ? ]", "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(rt == 2)
     {
       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       return(D_O_K);
     }
   }
   font = (FONT*)datafile[nce_15b].dat;
   set_default_object_colors(0,235,236,237,238,239,240,241);

   strcpy((sel_buf + 0), prg_path);
   strcpy((sel_buf + 180), ActiveOpFileId);
   PACKFILE *pack_file_ptr;
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("MX155LCH.CFG", F_WRITE_NOPACK);
   if ( !pack_file_ptr)
   {
     ER_FLAG = 9;
     Err_Handler(ER_FLAG);
     return(D_O_K);
   }
// File write operation
   if (!pack_fwrite(sel_buf, 200, pack_file_ptr))
   {
    pack_fclose(pack_file_ptr);
    ER_FLAG = 9;
    Err_Handler(ER_FLAG);
    return(D_O_K);
   }
   pack_fclose(pack_file_ptr);
   font = (FONT*)original_font;
   unload_datafile(datafile);
   allegro_exit();
   exit_flag = 0;
   exit(exit_flag);
}
//
//-------------------------------------------------
// [ Callback function for exit and close button ]
//-------------------------------------------------
int prg_close(void)
{
   extern int main_exit;
   extern int exit_flag;
   extern char SET_CFM[4];
   extern char *ar_ptr[56];
   extern DATAFILE *datafile;
   char bufa[ ] = "This Selection Will Close Down And Exit";
   char bufb[ ] = "The Micro-x Accessor System Program";
   char bufc[ ] = "( Close And Exit The Program ? )";
   int ret_code = 0;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
   if(strcmp(SET_CFM, "OFF") == 0)
   {
     exit_flag = 0;
     close_exit(exit_flag);
   }
   
   font = (FONT*)datafile[nce_22b].dat;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(160,160, 160);
   degui_select_color = makecol(0, 180, 0);
   degui_deselect_color = makecol(190, 190, 190);
   degui_light_shad_color = makecol(255, 255, 0);
   degui_dark_shad_color = makecol(255, 255, 0);
   
   ret_code = alert(bufa, bufb, bufc, "   &YES   ", "   NO   ", 'y', 27);
   if(key[KEY_ESC])
   {
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)datafile[nce_15b].dat;
     main_exit = 1;
     return(D_O_K);
   }
   if(ret_code == 2)
   {
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)datafile[nce_15b].dat;
     main_exit = 1;
     return(D_O_K);
   }
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   set_default_object_colors(0,235,236,237,238,239,240,241);
   exit_flag = 0;
   close_exit(exit_flag);
}
//
//-----------------------------------------------------------
// [ Callback To Access the Micro-x Accessor System Editor ]
//-----------------------------------------------------------
int acc_edit(void)
{
   extern DATAFILE *datafile;
   extern int exit_flag;
   extern char SET_CFM[4];
   extern char ActiveOpFileId[11];
   char *path_buf_exit = (char*) alloca(200);
   char bufa[ ] = "This Selection Will Access The";
   char bufb[ ] = "Micro-x Accessor System Editor";
   char bufc[ ] = "( Access The Editor Program ? )";
   int code_retn = 0;
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   exit_flag = 0;

   if(strcmp(SET_CFM, "ON ") == 0)
   {
     font = (FONT*)datafile[nce_22b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(160,160, 160);
     degui_select_color = makecol(0, 180, 0);
     degui_deselect_color = makecol(190, 190, 190);
     degui_light_shad_color = makecol(255, 255, 0);
     degui_dark_shad_color = makecol(255, 255, 0);
   
     code_retn = alert(bufa, bufb, bufc, "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(code_retn == 2)
     {

       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       return(0);
     }
     font = (FONT*)datafile[nce_15b].dat;
     set_default_object_colors(0,235,236,237,238,239,240,241);
   }
   strcpy((path_buf_exit + 0), "MXED.EXE 60799MX155");
   strcpy((path_buf_exit + 180), ActiveOpFileId);
   PACKFILE *pack_file_ptr;
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("MX155LCH.CFG", F_WRITE_NOPACK);
   if ( !pack_file_ptr)
   {
     ER_FLAG = 9;
     Err_Handler(ER_FLAG);
     return(0);
   }
// File write operation
   if (!pack_fwrite(path_buf_exit, 200, pack_file_ptr))
   {
    pack_fclose(pack_file_ptr);
    ER_FLAG = 9;
    Err_Handler(ER_FLAG);
    return(0);
   }
   pack_fclose(pack_file_ptr);
   font = (FONT*)original_font;
   unload_datafile(datafile);
   allegro_exit();
   exit_flag = 0;
   exit(exit_flag);
}
//
//-------------------------------
// [ Set Confirmation Callback ]
//-------------------------------
int set_cfm(void)
{
   extern DATAFILE *datafile;
   extern int exit_flag;
   extern char ActiveOpFileId[11];
   extern char SET_CFM[4];
   char set_stat[28];
   char *cfm_buf = (char*) alloca(200);
   int cfmSave = 0;
   int code_rt = 0;
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   exit_flag = 0;

   font = (FONT*)datafile[nce_22b].dat;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(160,160, 160);
   degui_select_color = makecol(0, 180, 0);
   degui_deselect_color = makecol(190, 190, 190);
   degui_light_shad_color = makecol(255, 255, 255);
   degui_dark_shad_color = makecol(255, 255,255);
   
   if(strcmp(SET_CFM, "ON ") == 0)
   {
      code_rt = alert("The Accessor System Confirmation",
     "Is Set To ( ON )", "Set Confirmaton To OFF  ?", "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(code_rt == 2)
     {

       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       return(0);
     }
     else
     {
        font = (FONT*)datafile[nce_15b].dat;
        set_default_object_colors(0,235,236,237,238,239,240,241);
        strcpy((SET_CFM), "OFF");
        strcpy((cfm_buf + 0), "OFF");
        sprintf(set_stat, "Set Confirmation = %s", SET_CFM);
        text_mode(0);
        textout((BITMAP*)datafile[mxstatus].dat, font, "######################",
        290, 5, makecol(0, 0, 0));
        textout((BITMAP*)datafile[mxstatus].dat, font, set_stat,
        290, 5, makecol(240, 240, 240));
        cfmSave = 99;
     }
   }
//------------------------
   else
   {
     code_rt = alert("The Accessor System Confirmation",
     "Is Set To ( OFF )", "Set Confirmaton To ON  ?", "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
    if(code_rt == 2)
     {

       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       return(0);
     }
     else
     {
        font = (FONT*)datafile[nce_15b].dat;
        set_default_object_colors(0,235,236,237,238,239,240,241);
        strcpy((SET_CFM), "ON ");
        strcpy((cfm_buf + 0), "ON ");
        sprintf(set_stat, "Set Confirmation = %s", SET_CFM);
        text_mode(0);
        textout((BITMAP*)datafile[mxstatus].dat, font, "######################",
        290, 5, makecol(0, 0, 0));
        textout((BITMAP*)datafile[mxstatus].dat, font, set_stat,
        290, 5, makecol(240, 240, 240));
        cfmSave = 99;
     }
   }
//---------------------
   if(cfmSave == 99)
   {
     cfmSave = 0;
     PACKFILE *pack_file_ptr;
     pack_file_ptr = NULL;
     pack_file_ptr = pack_fopen("MXCFG.CFG", F_WRITE);
     if ( !pack_file_ptr)
     {
       ER_FLAG = 10;
       Err_Handler(ER_FLAG);
       return(0);
     }

// File write operation ..
     if (!pack_fwrite(cfm_buf, 200, pack_file_ptr))
     {
       pack_fclose(pack_file_ptr);
       ER_FLAG = 10;
       Err_Handler(ER_FLAG);
       return(0);
     }
     pack_fclose(pack_file_ptr);
   }
  return(D_REDRAW);
}
//
//-----------------------------------------------
// [ Change Operational File Callback Function ]
//-----------------------------------------------
int change_op_file(void)
{
  int t,x;
  int opfSave = 0;
  int cde_rt = 0;
  int lopcnt = 0;
  char op_file_sel[2];
  char stat1[28];
  char stat2[28];
  extern char c;
  extern char *buf;
  extern int ER_FLAG;
  extern DATAFILE *datafile;
  extern char ActiveOpFileId[11];
  extern char SET_CFM[4];
  extern dialog mx_acc_dialog;
  extern dialog loadOpFile_dialog;
  extern edittext_object *ld_ptr_edit;
  extern button_object *ld_ptr_ok_button;
  extern button_object *ld_ptr_cancel_button;
  extern char opl_str[2];
  BITMAP *scrn_sav = create_bitmap(640,480);

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

// Mouse button release check   
   while(mouse_b){};

   while(lopcnt != 9)
   {
     show_mouse(NULL);
     blit(screen,scrn_sav,0,0,0,0,640,480);
     show_mouse(screen);

     set_default_object_colors(0,235,236,237,238,239,240,241);
     font = (FONT*)datafile[nce_15b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(180,180, 180);
     degui_select_color = makecol(10, 180, 10);
     degui_deselect_color = makecol(200, 200, 200);
     degui_light_shad_color = makecol(240, 240, 240);
     degui_dark_shad_color = makecol(240, 240, 240);
     
     mx_acc_dialog.add(loadOpFile_dialog);
     dialog_object *retn = loadOpFile_dialog.execute();
     while(key[KEY_ENTER]){};
     mx_acc_dialog.remove(loadOpFile_dialog);
     set_default_object_colors(0,235,236,237,238,239,240,241);
     show_mouse(NULL);
     blit(scrn_sav,screen,0,0,0,0,640,480);
     show_mouse(screen);
   
// Action if the escape key was pressed
     if(key[KEY_ESC])
     {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       destroy_bitmap(scrn_sav);
       return(D_O_K);
     }

// Action if the dialog was canceled
     if((retn == ld_ptr_cancel_button) || (key[KEY_ESC]))
     {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       destroy_bitmap(scrn_sav);
       return(D_O_K);
     }

// Action if the dialog ok button was selected
     if(retn == ld_ptr_ok_button)
     {
       strcpy(op_file_sel, strupr(ld_ptr_edit->get_text()));
       if((op_file_sel[0] < 'A') || (op_file_sel[0] > 'D'))
       {
         font = (FONT*)datafile[nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(160,160, 160);
         degui_select_color = makecol(0, 180, 0);
         degui_deselect_color = makecol(190, 190, 190);
         degui_light_shad_color = makecol(255, 0, 0);
         degui_dark_shad_color = makecol(255, 0, 0);
         degui_alert("Micro-x Data Input   !!  E R R O R  !!",
         "Valid Entries Are Character Data Only,",
         "Letters A to D", "  OK  ", NULL, 0, 0);
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)datafile[nce_15b].dat;
         op_file_sel[0] = NULL;
         continue;
       }

       if(strcmp(op_file_sel, "A") == 0)
       {
         strcpy(ActiveOpFileName, "Main");
         strcpy(OpFileLoad, "ACCMMAIN.CFF");
         strcpy(ActiveOpFileId, mx_mainid);
       }

       if(strcmp(op_file_sel, "B") == 0)
       {
         strcpy(ActiveOpFileName, "Sub #1");
         strcpy(OpFileLoad, "ACCMSUB1.CFF");
         strcpy(ActiveOpFileId, mx_lod_86id);
       }

       if(strcmp(op_file_sel, "C") == 0)
       {
         strcpy(ActiveOpFileName, "Sub #2");
         strcpy(OpFileLoad, "ACCMSUB2.CFF");
         strcpy(ActiveOpFileId, mx_lod_87id);
       }

       if(strcmp(op_file_sel, "D") ==  0)
       {
         strcpy(ActiveOpFileName, "Sub #3");
         strcpy(OpFileLoad, "ACCMSUB3.CFF");
         strcpy(ActiveOpFileId, mx_lod_88id);
       }

// File Opening Operation for active op-file
       PACKFILE *pack_file_ptr;
       pack_file_ptr = NULL;
       pack_file_ptr = pack_fopen(OpFileLoad, F_READ_PACKED);
       if (!pack_file_ptr)
       {
         ER_FLAG = 7;
         Err_Handler(ER_FLAG);
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)datafile[nce_15b].dat;
         destroy_bitmap(scrn_sav);
         return(D_O_K);
       }

// File Read Operation for active file
       if (!pack_fread(buf, 4800, pack_file_ptr))
       {
         pack_fclose(pack_file_ptr);
         ER_FLAG = 8;
         Err_Handler(ER_FLAG);
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)datafile[nce_15b].dat;
         destroy_bitmap(scrn_sav);
         return(D_O_K);
       }
       pack_fclose(pack_file_ptr);

// Set Buffer Code For Reading
       t = 0;
       x = 0;
       while (x != 4800)
       {
          if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
          {
             *(buf + t) += c;
          }
          t += 1;
          x += 1;
       }

// Update status bar and do exit routine
       sprintf(stat1, "Active Operational File = %s", ActiveOpFileName);
       sprintf(stat2, "Set Confirmation = %s", SET_CFM);
  
       text_mode(0);
       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       textout((BITMAP*)datafile[mxstatus].dat, font,
       "################################", 20, 5, makecol(0, 0, 0));
       textout((BITMAP*)datafile[mxstatus].dat, font,
       "######################", 290, 5, makecol(0, 0, 0));
       textout((BITMAP*)datafile[mxstatus].dat, font, stat1, 20, 5, makecol(240, 240, 240));
       textout((BITMAP*)datafile[mxstatus].dat, font, stat2, 290, 5, makecol(240, 240, 240));
       mx_acc_dialog.redraw();

       if(strcmp(SET_CFM, "ON ") == 0)
       {
         font = (FONT*)datafile[nce_22b].dat;
         degui_fore_color = makecol(0, 0, 0);
         degui_back_color = makecol(160,160, 160);
         degui_select_color = makecol(0, 180, 0);
         degui_deselect_color = makecol(190, 190, 190);
         degui_light_shad_color = makecol(0, 255, 0);
         degui_dark_shad_color = makecol(0, 255, 0);
   
         degui_alert("The Active Operational File Has Been Changed. Check",
                   "The Status Line Below For File Name Update When Exit",
         "( No Errors Detected )",
         "  OK  ", NULL, 0, 0);
         while(key[KEY_ENTER]){};
         while(key[KEY_ESC]){};
         clear_keybuf();
   
         set_default_object_colors(0,235,236,237,238,239,240,241);
         font = (FONT*)datafile[nce_15b].dat;
         destroy_bitmap(scrn_sav);
         lopcnt = 9;
         return(D_REDRAW);
       }
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)datafile[nce_15b].dat;
       destroy_bitmap(scrn_sav);
       lopcnt = 9;
       return(D_REDRAW);
     }
   }
  set_default_object_colors(0,235,236,237,238,239,240,241);
  font = (FONT*)datafile[nce_15b].dat;
  destroy_bitmap(scrn_sav);
  return(D_REDRAW);
}
//
//------------------------------------------
// [ Callback function for micro-x prompt ]
//------------------------------------------
int mx_prompt(void)
{
   int x = 0;
   int fhandle = 0;
   int i_exe = 0;
   int file_chk = 0;
   extern DATAFILE *datafile;
   extern int exit_flag;
   extern char SET_CFM[4];
   extern char ActiveOpFileId[11];
   extern char *cmd_pmt;
   char cmd_str[128];
   char *path_buf_exit = (char*) alloca(200);
   char bufa[ ] = "This Selection Will Access The Micro-x Prompt";
   char bufb[ ] = "Enter Exit To Return To The Accessor System";
   char bufc[ ] = "( Access The Micro-x Prompt ? )";
   int code_retn = 0;
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   exit_flag = 0;

   if(strcmp(SET_CFM, "ON ") == 0)
   {
     font = (FONT*)datafile[nce_22b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(160,160, 160);
     degui_select_color = makecol(0, 180, 0);
     degui_deselect_color = makecol(190, 190, 190);
     degui_light_shad_color = makecol(255, 255, 0);
     degui_dark_shad_color = makecol(255, 255, 0);
   
     code_retn = alert(bufa, bufb, bufc, "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(code_retn == 2)
     {

       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       return(0);
     }
     font = (FONT*)datafile[nce_15b].dat;
     set_default_object_colors(0,235,236,237,238,239,240,241);
   }
// Set True Path To Program,, and test path
   strcpy(cmd_str, cmd_pmt + 0);
      x = 0;
   while(x != 128)
   {
     if(cmd_str[x] == '.')
     {
       cmd_str[x + 4] = NULL;
       break;
     }
     ++x;
   }
   fhandle = open(cmd_str, O_RDONLY);
   i_exe = _is_executable(cmd_str, fhandle, NULL);
   close(fhandle);

   file_chk = exists(cmd_str);
         
   if((i_exe == 0) || (file_chk == 0))
   {
     font = (FONT*)datafile[nce_22b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(160,160, 160);
     degui_select_color = makecol(0, 180, 0);
     degui_deselect_color = makecol(190, 190, 190);
     degui_light_shad_color = makecol(255, 0, 0);
     degui_dark_shad_color = makecol(255, 0, 0);
     degui_alert("! Access Error !  Cannot Locate The Command",
     "Interpreter, To Set Up The Micro-x Prompt","",
     "   OK   ",NULL , 0, 0);
     font = (FONT*)datafile[nce_15b].dat;
     set_default_object_colors(0,235,236,237,238,239,240,241);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return(D_O_K);
   }
   strcpy(cmd_str, cmd_pmt + 0);
   strcpy((path_buf_exit + 0), cmd_str);
   strcpy((path_buf_exit + 180), ActiveOpFileId);
   PACKFILE *pack_file_ptr;
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("MX155LCH.CFG", F_WRITE_NOPACK);
   if ( !pack_file_ptr)
   {
     ER_FLAG = 9;
     Err_Handler(ER_FLAG);
     return(0);
   }

// File write operation
   if (!pack_fwrite(path_buf_exit, 200, pack_file_ptr))
   {
    pack_fclose(pack_file_ptr);
    ER_FLAG = 9;
    Err_Handler(ER_FLAG);
    return(0);
   }
   pack_fclose(pack_file_ptr);
   font = (FONT*)original_font;
   unload_datafile(datafile);
   allegro_exit();
   exit_flag = 0;
   exit(exit_flag);
}
//
//--------------------------------------------------------
// [ Callback To Access the Micro-x Information Display ]
//--------------------------------------------------------
int mx_info(void)
{
   extern DATAFILE *datafile;
   extern int exit_flag;
   extern char SET_CFM[4];
   extern char ActiveOpFileId[11];
   char *path_buf_exit = (char*) alloca(200);
   char bufa[ ] = "This Selection Will Access The";
   char bufb[ ] = "Micro-x Information Display Screen";
   char bufc[ ] = "( Access Micro-x Information Display  ? )";
   int code_retn = 0;
   int fhandle = 0;
   int i_exe = 0;
   int file_chk = 0;
   char cmd_str[ ] = "MXSYSINF.EXE";
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   exit_flag = 0;

   fhandle = open(cmd_str, O_RDONLY);
   i_exe = _is_executable(cmd_str, fhandle, NULL);
   close(fhandle);

   file_chk = exists(cmd_str);
         
   if((i_exe == 0) || (file_chk == 0))
   {
     font = (FONT*)datafile[nce_22b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(160,160, 160);
     degui_select_color = makecol(0, 180, 0);
     degui_deselect_color = makecol(190, 190, 190);
     degui_light_shad_color = makecol(255, 0, 0);
     degui_dark_shad_color = makecol(255, 0, 0);
     degui_alert("! Access Error !  Cannot Locate The Program",
     "Mxsysinf.exe, To Display Micro-x System Information","",
     "   OK   ",NULL , 0, 0);
     font = (FONT*)datafile[nce_15b].dat;
     set_default_object_colors(0,235,236,237,238,239,240,241);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     return(D_O_K);
   }

   if(strcmp(SET_CFM, "ON ") == 0)
   {
     font = (FONT*)datafile[nce_22b].dat;
     degui_fore_color = makecol(0, 0, 0);
     degui_back_color = makecol(160,160, 160);
     degui_select_color = makecol(0, 180, 0);
     degui_deselect_color = makecol(190, 190, 190);
     degui_light_shad_color = makecol(255, 255, 0);
     degui_dark_shad_color = makecol(255, 255, 0);
   
     code_retn = alert(bufa, bufb, bufc, "   &YES   ", "   NO   ", 'y', 27);
     while(key[KEY_ENTER]){};
     while(key[KEY_ESC]){};
     clear_keybuf();
     if(code_retn == 2)
     {

       font = (FONT*)datafile[nce_15b].dat;
       set_default_object_colors(0,235,236,237,238,239,240,241);
       return(0);
     }
     font = (FONT*)datafile[nce_15b].dat;
     set_default_object_colors(0,235,236,237,238,239,240,241);
   }
   strcpy((path_buf_exit + 0), "MXSYSINF.EXE 60800MX155");
   strcpy((path_buf_exit + 180), ActiveOpFileId);
   PACKFILE *pack_file_ptr;
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("MX155LCH.CFG", F_WRITE_NOPACK);
   if ( !pack_file_ptr)
   {
     ER_FLAG = 9;
     Err_Handler(ER_FLAG);
     return(0);
   }

// File write operation
   if (!pack_fwrite(path_buf_exit, 200, pack_file_ptr))
   {
    pack_fclose(pack_file_ptr);
    ER_FLAG = 9;
    Err_Handler(ER_FLAG);
    return(0);
   }
   pack_fclose(pack_file_ptr);
   font = (FONT*)original_font;
   unload_datafile(datafile);
   allegro_exit();
   exit_flag = 0;
   exit(exit_flag);
}
//
//---------------------------------------------------------
// [ Accessor System's Help System Text Display Function ]
//---------------------------------------------------------
int call_back_main(void)
{
   extern dialog mx_acc_dialog;
   extern dialog mxHelp_dialog;
   extern textbox_object Help_text;
   extern char *Help_hlptxt;

// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   font = (FONT*)original_font;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(155,155, 0);
   degui_select_color = makecol(0, 150, 0);
   degui_deselect_color = makecol(220, 220, 220);
   degui_light_shad_color = makecol(250, 250, 250);
   degui_dark_shad_color = makecol(0, 0, 0);

   mx_acc_dialog.add(mxHelp_dialog);
   mxHelp_dialog.popup();
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   mx_acc_dialog.remove(mxHelp_dialog);

   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)datafile[nce_15b].dat;
   return 0;
}
//
//---------------------------------------
// [ Help System Callback Introduction ]
//---------------------------------------
int call_back_m1(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

-----------------------------
[  I N T R O D U C T I O N  ]
-----------------------------

This program is the Micro-x Accessor System Version

1.5.5 GXV, designed to be used with Micro-x Accessor

System Editor Version 2.2, and Mxloder Version 2.0.

An Accessor System is an extended development of the

old Dos Menu Systems. The Accessor System is used to

access computer resources, run programs, and orginize

these accesses in a way so that they can be easily

found, edited, and changed to give to the user an

improved power of access. A menu system will allow

you to access and run programs, so does an Accessor

System, but an Accessor System is not a menu system,

or a shell program. When you are using an Acessor

System, you'er then getting your access in a new way

that is very much different from the later.


The Accessor System's main screen consists of the

main title heading, followed by the left side key bar

listings, the selections list window, and the right

side key bar listings. Just below this is the change

operational file button, and the quit and exit

button. Below this is the ststus line. At the top,

and at the bottom of the Accessor System's main

screen are information strips showing the available

amount of physical memory, and the available amount

of virtual memeory.


To start the Accessor System you must use the Mxloder

program that is ship with your version of Micro-x. To

operate the Accessor System you may use the mouse are

the keyboard. The keyboard operation for Micro-x

provides a lot of hot key short cuts for quick and

easy access to Accessor options. Check your Micro-x

documentation for a listing. The mouse operation for

Micro-x is a very simple point and click operation.

You just move the mouse pointer on to the item you

want, and press the mouse button. The selections

window requires a single mouse click to select, and a

double mouse click to activate.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  call_back_main();

  return 0;
}
//
//---------------------------------------------
// [ Help System Callback Keyboard and Mouse ]
//---------------------------------------------
int call_back_m2(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
   Help_hlptxt = "
======================
= [ start of topic ] =
======================

-----------------------------------------
[  K E Y B O A R D   A N D   M O U S E  ]
-----------------------------------------

The Keyboard and Mouse Operations for the Micro-x

Accessor System Version 1.5.5 GXV is connected to

a GUI interface to support dialogs, buttons, and

window operations. When the Accessor System finishes

start up, both the Mouse and the Keyboard is made

ready for usage.


To change the focus with the keyboard, use the Tab

Key, and the Arrow Keys. When you press the tab key,

the focus is usually set to the first item or object

on the screen. When an item or object has the focus

a small dotted out line rectangle will appear on the

item or object. If you then press the enter key, this

item will be activated. After you press the tab key

to get the focus on the first item, you should then

use the arrow keys to change the focus to other items

or objects.


Using the Mouse to get the focus is easy. Where ever

the mouse pointer lies, so does the focus. Just press

the mouse button with the mouse pointer on the item

or object to activate it. When in the selections

window, you must single click to select an item, and

double click to activate an item.


The Accessor System provides a number of hot keys to

quickly access an option. Many of the available hot

keys are mark with an under score in the name that is

printed on the item. If you use hot keys a lot, it is

a good idea to operate the Accessor System with

confirmation set to on. The status line located near

the bottom of the Accessor System's main screen shows

the current confirmation setting.
 

[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  call_back_main();

   return 0;
}
//
//------------------------------------------------
// [ Help System Callback Changing The Op-Files ]
//------------------------------------------------
int call_back_m3(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

----------------------------------------------
[  C H A N G I N G   T H E   O P - F I L E S ]
----------------------------------------------

The Micro-x Accessor System Application Program is

made up of four operational parts. They are the Main

Accessor, Sub #1 Accessor, Sub #2 Accessor, and Sub

#3 Accessor. Each Accessor System operational part

has it's own operational file to hold the

configuration data for all of the Accessor System's

items in it's selection window.


To load an operational file, select and activate the

change operational file button. When this is done,

you will get the load operational file dialog window.

In the text box enter an operational file to load.

(A) is for the Main operational file, (B) is for Sub

#1, (C) is for Sub #2,  and (D) is for Sub #3. After

you have completed your entry, press or click on the

ok button to load the operational file. The name of

the activate operational file will be printed in the

status line located near the bottom of the Accessor

System's main screen. To exit the change operational

file dialog window, press or click on the cancel

button. You may also exit the change operational file 

dialog window by pressing the escape key.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  call_back_main();

  return 0;
}
//
//----------------------------------------
// [ Help System Callback Key Bar Usage ]
//----------------------------------------
int call_back_m4(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

-------------------------------
[  K E Y   B A R   U S A G E  ]
-------------------------------

The Micro-x Accessor System has two Key Bar listings.

Left Key Bar listings, and Right Key Bar listings.

The left key bar listings holds a list of button

options that are considered to be relative with the

Accessor System's internal, and external usage. The

right key bar listings holds a list of button options

that are considered to be relative with the Accessor

System, and the operator system's usage. The number of

options that a key bar has depends on the version of

the Micro-x Accessor System you are using.


Micro-x Accessor System Version 1.5.5 GXV has only two

option buttons on the right key bar listing. These

option buttons or used to access the Micro-x Accessor

System's Prompt, and the System's Informatiom Display

Screen. The system's information display screen is

very useful for setting up and running the Accessor

System. The memory information displayed by Mxloder

can be very hard to understand if one does not have

good knowledge of system memory management, and

protected mode operations. The Micro-x information

display screen presents a much easier to understand

listing of memory information.


The left key bar listing holds mostly all of the

Accessor System's internal, and external options. All

of these options are mostly controll by the Accessor

System's own internal operations. Internal options

are built into Micro-x's program code, and is loaded

into memory with Micro-x when it loads. Micro-x can

access and run internal options very quickly. It

takes Micro-x longer to access and run external

options, because external options are sperate

programs. When Micro-x access an external option, it

must access the disk, and load the program for this

option into ram, and then run the program for this

option.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  call_back_main();

  return 0;
}
//
//------------------------------------------------
// [ Help System Callback Operations And Set Up ]
//------------------------------------------------
int call_back_m5(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
   Help_hlptxt = "
======================
= [ start of topic ] =
======================

----------------------------------------
[  O P E R A T I O N S  &  S E T  U P  ]
----------------------------------------

The Micro-x Accessor System Version 1.5.5 GXV is an

extended version of the Micro-x Accessor System

Version 1.5.1 a text base version. Version 1.5.5 is

the graphics version extended off of version 1.5.1.

Version 1.5.5 provides a GUI interface that makes

Micro-x more common to users, and easier to use.

Operations with the mouse is simple point and click.

The keyboard operations now provide a lot more hot

key access to make using options go faster and eaiser.

Hot keys are usually mark with an under score located

in the option's name. You can activate an option by

just pressing the hot key for that option. The window

in the middle of the Micro-x main screen titled

SELECEIONS, is where you select, and activate install

Accessor System items. To activate an item, select

the item with the keyboard tab, and arrow keys,

using the arrow keys move the cursor bar onto the

item you want, then press the enter key. To activate

an item with the mouse, move the mouse pointer on to

the item you want, then press the mouse button once

to select the item, then double click the mouse

button to activate the item. Confirmation is provided

when an item is activated if CFM is set to on.


In Micro-x Accessor System Version 1.5.1 there are

four operational parts, main, sub#1, sub#2, and sub#3.

Each operational part operates out of a seperate

program. Version 1.5.1 has a sub program for each of

it's operational parts. Version 1.5.5 has done away

with the sub programs. It has a new design that

combines all four operational parts into one program.


The Micro-x Accessor System Version 1.5.5 GXV is made

up also of four operational parts. Each operational

part has it's own operationl configuration file. There

are four operational files, they are the Main, Sub #1,

Sub #2, and Sub #3. In order for the Accessor System

to access an item in an operational file, that

operational file must be loaded into ram, and set

active.


To load an operational file, select and press the

change operational file button. When this is done

you will get the change operational file dialog

window. Enter your selection in the text box, and

press the ok button to load the selected operational

file. Available selections are (A) for Main, (B) for

Sub #1, (C) Sub #2, and (D) for Sub #3. The name of

the new operational file update is displayed in the

status line located near the bottom of the Main

Accessor System's screen. You may exit the change

operational file dialog window by pressing the escape

key, or by pressing the cancel button. The active

operational file that is loaded when you quit and

exit the Accessor System, will be the active

operational file that the Accessor System will load

the next time the Acessor System is started.


To use the other options provided by Micro-x, just

select and activate the item, then follow the on

screen instructions. For more detailed information

on how to set up and use the Micro-x Accessor System

Version 1.5.5 GXV, read the Micro-x documentation

files. These files are normally located in the Micro-x

home directory.



[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  call_back_main();

  return 0;
}
//
//-----------------------------------------------
// [ Help System Callback Accessing The Editor ]
//-----------------------------------------------
int call_back_m6(void)
{
   extern textbox_object Help_text;
   extern char *Help_hlptxt;
   
  Help_hlptxt = "
======================
= [ start of topic ] =
======================

---------------------------------------------
[  A C C E S S I N G   T H E   E D I T O R  ]
---------------------------------------------

You can change items, or you can install items into

the Micro-x Accessor System with the Micro-x Accessor

System Editor. To access the Micro-x Accessor System

Editor, select and activate the Edit option located on

the left key bar listings. When this is done Micro-x

will exit the Accessor System, and access the editor.

You will go directly into the editor that is if a

password is not install. If a password is install,

then you must enter the valid password before Micro-x

can access the editor.


In Micro-x Accessor System Version 1.5.5 GXV, the

Accessor System Editor is an external option, and must

be accessed from disk. The Accessor System Editor is

the only program that can be used to change or edit

the operational files for the Accessor System. There

are four operational files for the Accessor System.

Each operational file will hold 28 items. With four

operational files, this gives the Micro-x Accessor

System Version 1.5.5 GXV a total of 112 items.


The Micro-x Accessor System Editor Version 2.2 is

the only editor that can be used to edit the

operational files for Micro-x Accessor System Version

1.5.5 GXV. Each Version of the Accessor System has

it's own custom editor. The Micro-x Accessor System

Editor Version 2.2 has it's own help information

system. For more detailed information on the Micro-x

Accessor System Version 2.2 Editor, read the Micro-x

Accessor System documentation files. These files are

normally located in the Micro-x home directory.


[ end of topic ] ------------------";
  Help_text.set_text(Help_hlptxt);
  call_back_main();

  return 0;
}
//
//------------------------------------------------
// [ Mx155.cc's About Dialog Call Back Function ]
//------------------------------------------------
int call_back_m7(void)
{
   extern dialog mxAccAbout_dialog;
   extern dialog mx_acc_dialog;
   extern dialog mxAccAbout_dialog;
   
// Keyboard active check
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();

   font = (FONT*)original_font;
   degui_fore_color = makecol(0, 0, 0);
   degui_back_color = makecol(155,155, 0);
   degui_select_color = makecol(0, 150, 0);
   degui_deselect_color = makecol(220, 220, 220);
   degui_light_shad_color = makecol(250, 250, 250);
   degui_dark_shad_color = makecol(0, 0, 0);

   mx_acc_dialog.add(mxAccAbout_dialog);
   mxAccAbout_dialog.popup();
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   mx_acc_dialog.remove(mxAccAbout_dialog);

   set_default_object_colors(0,235,236,237,238,239,240,241);
   font = (FONT*)datafile[nce_15b].dat;
   return D_REDRAW;
}
//
//-------------------------------
// [ Add Objects to the dialog ]
//-------------------------------
void setup_dialog_objects(void)
{
  extern int main_exit;
  extern char ActiveOpFileName[8];
  extern char SET_CFM[4];
  char *cfm_buf = (char*) alloca(200);
  char set_stat1[28];
  char set_stat2[28];
  extern edittext_object *ld_ptr_edit;
  extern button_object *ld_ptr_ok_button;
  extern button_object *ld_ptr_cancel_button;
  extern char opl_str[2];
  extern list_object *selection_list;
  extern DATAFILE *datafile;
  extern dialog mx_acc_dialog;
  extern dialog loadOpFile_dialog;
  extern dialog mxHelp_dialog;
  extern dialog mxAccAbout_dialog;
  extern textbox_object Help_text;
  

// Object definitions - DEGUI 1.2 beta For Micro-x Accessor System
// Main Screen Objects
  shadow_box_object object_1;
  panel_ridge_object object_2;
  text_object mx_name("Version 1.5.5");
  text_object mx3_name("By John F. Clark Jr.");
  text_object mx2_name("Copyright  (C)  August  2002");
  list_object mx_list(listbox_service);
  panel_raised_object object_7;
  panel_raised_object object_8;
  shadow_box_object object_9;
  panel_sunken_object object_10;
  button_object object_11("&Edit",'E',false);
  button_object object_12("Set &CFM",'C',false);
  button_object object_13("&Prompt",'P',false);
  panel_sunken_object object_15;
  panel_sunken_object object_16;
  button_object object_18("&InFo",'I',false);
  button_object object_19("Change Operational &File",'f',false);
  button_object object_20("Close And E&xit",'x',false);
  panel_ridge_object object_21;
  panel_groove_object sepr_1;
  panel_groove_object sepr_2;
  
  selection_list = &mx_list;
  
  bitmap_object mx155_1((BITMAP*)datafile[main_title].dat);
  bitmap_object mx_status((BITMAP*)datafile[mxstatus].dat);
  bitmap_object mx_logo((BITMAP*)datafile[mxlogo].dat);
  bitmap_object mx_barl((BITMAP*)datafile[barlft].dat);
  bitmap_object mx_barr((BITMAP*)datafile[barrgh].dat);
  text_object mx_name4("MICRO-X ACCESSOR SYSTEM");

// Object definitions - DEGUI 1.2 beta For Micro-x Accessor System
// Load Op-File Screen Objects
//***********************************************
  panel_raised_object loadOpFile_panel;
  edittext_object loadOpFile_edit(opl_str,1);
  button_object loadOpFile_ok_button("Ok",0,true);
  button_object loadOpFile_cancel_button("Cancel",27,true);
  centerd_text_object loadOpFile_txt1("Micro-x  Change  Operational  File");
  centerd_text_object loadOpFile_txt2("[ A ].  Main         [ C ].  Sub #2");
  centerd_text_object loadOpFile_txt3("[ B ].  Sub #1       [ D ].  Sub #3");
  centerd_text_object loadOpFile_txt4("Valid Entries, Characters A to D");
//***********************************************
  ld_ptr_edit = &loadOpFile_edit;
  ld_ptr_ok_button = &loadOpFile_ok_button;
  ld_ptr_cancel_button = &loadOpFile_cancel_button;

//Attach Objects To The Op-File Change Dialog
  loadOpFile_dialog.add(loadOpFile_panel,          159,    163,    310,  165);
  loadOpFile_dialog.add(loadOpFile_edit,           209,    265,    209,   14);
  loadOpFile_dialog.add(loadOpFile_ok_button,      174,    300,    71,    20);
  loadOpFile_dialog.add(loadOpFile_cancel_button,  383,    300,    70,    20);
  loadOpFile_dialog.add(loadOpFile_txt1,           310,    175,    70,     8);
  loadOpFile_dialog.add(loadOpFile_txt2,           310,    198,    70,     8);
  loadOpFile_dialog.add(loadOpFile_txt3,           310,    214,    70,     8);
  loadOpFile_dialog.add(loadOpFile_txt4,           310,    242,    70,     8);

//***********************************************
// Set Up Menu Objects For Micro-x Help System
//***********************************************
  menu Topics_menu;
  Topics_menu.add("&Introduction",::call_back_m1);
  Topics_menu.add("&Keyboard And Mouse",::call_back_m2);
  Topics_menu.add("&Changing Op-Files",::call_back_m3);
  Topics_menu.add("&Key Bar Usage",::call_back_m4);
  Topics_menu.add("&Operations And Setup",::call_back_m5);
  Topics_menu.add("&Accessing The Editor",::call_back_m6);
  
  menu Help_menu;
  Help_menu.add("&Topics", Topics_menu);
  Help_menu.add("");
  Help_menu.add("&About",call_back_m7);

  menu degui_menu;
  degui_menu.add("&Help", Help_menu);
  menu_object  menu(degui_menu);
//.........................
  panel_raised_object mxAccAbout_object_1;
  button_object mxAccAbout_button("OK",0,true);
  text_object txt1a("Micro-x Accessor System");
  text_object txt2a("GXV Release ( 1A )");
  text_object txt3a("Version 1.5.5");
  text_object txt4a("Designed To Be Used With");
  text_object txt5a("Micro-x Accessor System");
  text_object txt6a("Editor Version 2.2");
  text_object txt7a("And Mxloder Version 2.0");
  text_object txt8a("Copyright (C) August 2002");
  text_object txt9a("By John F. Clark Jr.");

  panel_groove_object mxHelp_panel;
  shadow_box_object mxHelp_box;
  text_object help_title("Micro-x Accessor System's Help Information");
  panel_sunken_object mxHelp_sunken_panel;
  button_object mxHelp_button("EXIT",0,true);
   
// Define Color Schames
   color_scheme new_colrMx1;
   new_colrMx1.set_fore(makecol(240, 240, 240));
   new_colrMx1.set_back(makecol(120, 120, 120));
   help_title.color = &new_colrMx1;
//........................
   color_scheme new_colrMx2;
   new_colrMx2.set_back(makecol(128, 128, 128));
   new_colrMx2.set_select(makecol(0, 160, 0));
   new_colrMx2.set_deselect(makecol(228, 228, 228));
   new_colrMx2.set_fore(makecol(0, 0, 160));
   mxHelp_button.color = &new_colrMx2;
//........................
   color_scheme new_colrMx3;
   new_colrMx3.set_fore(makecol(240, 240, 240));
   new_colrMx3.set_back(makecol(120, 120, 120));
   txt1a.color = &new_colrMx3;
   txt2a.color = &new_colrMx3;
   txt3a.color = &new_colrMx3;
   txt4a.color = &new_colrMx3;
   txt5a.color = &new_colrMx3;
   txt6a.color = &new_colrMx3;
   txt7a.color = &new_colrMx3;
   txt8a.color = &new_colrMx3;
   txt9a.color = &new_colrMx3;
//........................
   color_scheme new_colrMx4;
   new_colrMx4.set_back(makecol(128, 128, 128));
   new_colrMx4.set_select(makecol(0, 160, 0));
   new_colrMx4.set_deselect(makecol(228, 228, 228));
   new_colrMx4.set_fore(makecol(0, 0, 160));
   mxAccAbout_button.color = &new_colrMx4;

// Add Objects to About dialog
  mxAccAbout_dialog.add(mxAccAbout_object_1,199,130,228,228);
  mxAccAbout_dialog.add(mxAccAbout_button,269,320,89,23);
  mxAccAbout_dialog.add(txt1a,223,141,128,8);
  mxAccAbout_dialog.add(txt2a,241,156,104,8);
  mxAccAbout_dialog.add(txt3a,259,172,88,8);
  mxAccAbout_dialog.add(txt4a,217,206,152,8);
  mxAccAbout_dialog.add(txt5a,222,217,184,8);
  mxAccAbout_dialog.add(txt6a,243,230,136,8);
  mxAccAbout_dialog.add(txt7a,222,242,184,8);
  mxAccAbout_dialog.add(txt8a,215,270,184,8);
  mxAccAbout_dialog.add(txt9a,236,282,160,8);

// Add Objects to mxHelp_dialog
  mxHelp_dialog.add(mxHelp_panel,90,22,461,439);
  mxHelp_dialog.add(mxHelp_box,104,32,434,24);
  mxHelp_dialog.add(help_title,152,44,328,8);
  mxHelp_dialog.add(mxHelp_sunken_panel,104,76,434,24);
  mxHelp_dialog.add(mxHelp_button,275,79,83,19);
  mxHelp_dialog.add(Help_text,95,106,451,353);

// Add Objects to main dialog
  mx_acc_dialog.add(object_1,83,27,464,87);
  mx_acc_dialog.add(object_2,104,48,420,41);
  mx_acc_dialog.add(mx_name,375,32,104,8);
  mx_acc_dialog.add(mx3_name,368,94,160,8);
  mx_acc_dialog.add(mx2_name,126,94,248,8);
  mx_acc_dialog.add(mx_list,170,152,290,180);
  mx_acc_dialog.add(object_7,59,152,84,179);
  mx_acc_dialog.add(object_8,485,152,86,179);
  mx_acc_dialog.add(object_9,57,416,517,36);
  mx_acc_dialog.add(object_10,80,422,474,24);
  mx_acc_dialog.add(object_11,67,217,69,23);
  mx_acc_dialog.add(object_12,67,260,69,23);
  mx_acc_dialog.add(object_13,494,302,69,23);
  mx_acc_dialog.add(sepr_1,64,244,74,11);
  mx_acc_dialog.add(sepr_2,64,287,74,11);
  mx_acc_dialog.add(menu, 77,304,69,24);
  mx_acc_dialog.add(object_15,64,158,73,50);
  mx_acc_dialog.add(object_16,491,158,74,50);
  mx_acc_dialog.add(object_18,494,218,69,23);
  mx_acc_dialog.add(object_19,57,354,240,32);
  mx_acc_dialog.add(object_20,334,354,240,32);
  mx_acc_dialog.add(object_21,490,246,75,51);
  mx_acc_dialog.add(mx155_1,106,49,417,39);
  mx_acc_dialog.add(mx_status,81,423,473,23);
  mx_acc_dialog.add(mx_logo,492,247,72,48);
  mx_acc_dialog.add(mx_name4,169,32,184,8);
  mx_acc_dialog.add(mx_barl,65,159,72,49);
  mx_acc_dialog.add(mx_barr,492,159,73,49);

// Define color schames for main dialog
   color_scheme new_colors_n;
   new_colors_n.set_back(makecol(200, 200, 200));
   new_colors_n.set_fore(makecol(0, 0, 120));
   new_colors_n.set_dark_shad(0);
   new_colors_n.set_light_shad(0);
   mx_name.color = &new_colors_n;
//........................
   color_scheme new_colors_n2;
   new_colors_n2.set_back(makecol(200, 200, 200));
   new_colors_n2.set_fore(makecol(0, 0, 120));
   new_colors_n2.set_dark_shad(0);
   new_colors_n2.set_light_shad(0);
   mx2_name.color = &new_colors_n2;
//........................
   color_scheme new_colors_n3;
   new_colors_n3.set_back(makecol(200, 200, 200));
   new_colors_n3.set_fore(makecol(0, 0, 120));
   new_colors_n3.set_dark_shad(0);
   new_colors_n3.set_light_shad(0);
   mx3_name.color = &new_colors_n3;
//........................
   color_scheme new_colors_n4;
   new_colors_n4.set_back(makecol(200, 200, 200));
   new_colors_n4.set_fore(makecol(0, 0, 120));
   new_colors_n4.set_dark_shad(0);
   new_colors_n4.set_light_shad(0);
   mx_name4.color = &new_colors_n4;
//........................
   color_scheme new_colors;
   new_colors.set_back(makecol(200, 200, 200));
   new_colors.set_deselect(makecol(200, 200, 200));
   new_colors.set_fore(makecol(0, 0, 0));
   new_colors.set_dark_shad(makecol(0, 0, 0));
   new_colors.set_light_shad(makecol(0, 0, 0));
   object_1.color = &new_colors;
//........................
   color_scheme new_colors2;
   new_colors2.set_back(makecol(170, 170, 170));
   new_colors2.set_fore(makecol(0, 0, 180));
   new_colors2.set_dark_shad(0);
   new_colors2.set_light_shad(0);
   object_2.color = &new_colors2;
//........................
   color_scheme new_colors7;
   new_colors7.set_back(makecol(170, 170, 170));
   new_colors7.set_fore(makecol(0, 0, 180));
   new_colors7.set_dark_shad(0);
   new_colors7.set_light_shad(0);
   object_7.color = &new_colors7;
//........................
   color_scheme new_colors8;
   new_colors8.set_back(makecol(170, 170, 170));
   new_colors8.set_fore(makecol(0, 0, 180));
   new_colors8.set_dark_shad(0);
   new_colors8.set_light_shad(0);
   object_8.color = &new_colors8;
//........................
   color_scheme new_colors9;
   new_colors9.set_back(makecol(170, 170, 170));
   new_colors9.set_fore(makecol(0, 0, 180));
   new_colors9.set_dark_shad(0);
   new_colors9.set_light_shad(0);
   object_9.color = &new_colors9;
//........................
   color_scheme new_colors10;
   new_colors10.set_back(makecol(170, 170, 170));
   new_colors10.set_fore(makecol(0, 0, 180));
   new_colors10.set_dark_shad(0);
   new_colors10.set_light_shad(0);
   object_10.color = &new_colors10;
//........................
   color_scheme new_colors11;
   new_colors11.set_back(makecol(200, 200, 200));
   new_colors11.set_select(makecol(0, 160, 0));
   new_colors11.set_deselect(makecol(230, 230, 230));
   new_colors11.set_fore(makecol(0, 0, 130));
   object_11.color = &new_colors11;
//........................
   color_scheme new_colors12;
   new_colors12.set_back(makecol(200, 200, 200));
   new_colors12.set_select(makecol(0, 160, 0));
   new_colors12.set_deselect(makecol(230, 230, 230));
   new_colors12.set_fore(makecol(0, 0, 130));
   object_12.color = &new_colors12;
//........................
   color_scheme new_colors13;
   new_colors13.set_back(makecol(200, 200, 200));
   new_colors13.set_select(makecol(0, 160, 0));
   new_colors13.set_deselect(makecol(230, 230, 230));
   new_colors13.set_fore(makecol(0, 0, 130));
   object_13.color = &new_colors13;
//........................
   color_scheme new_colors15;
   new_colors15.set_back(makecol(170, 170, 170));
   new_colors15.set_fore(makecol(0, 0, 0));
   new_colors15.set_dark_shad(0);
   new_colors15.set_light_shad(0);
   object_15.color = &new_colors15;
//........................
   color_scheme new_colors16;
   new_colors16.set_back(makecol(170, 170, 170));
   new_colors16.set_fore(makecol(0, 0, 180));
   new_colors16.set_dark_shad(0);
   new_colors16.set_light_shad(0);
   object_16.color = &new_colors16;
//........................
   color_scheme new_colors18;
   new_colors18.set_back(makecol(128, 128, 128));
   new_colors18.set_select(makecol(0, 160, 0));
   new_colors18.set_deselect(makecol(230, 230, 230));
   new_colors18.set_fore(makecol(0, 0, 130));
   object_18.color = &new_colors18;
//........................
   color_scheme new_colors19;
   new_colors19.set_back(makecol(120, 120, 120));
   new_colors19.set_select(makecol(0, 160, 0));
   new_colors19.set_deselect(makecol(230, 230, 230));
   new_colors19.set_fore(makecol(0, 0, 0));
   object_19.color = &new_colors19;
//........................
   color_scheme new_colors20;
   new_colors20.set_back(makecol(128, 128, 128));
   new_colors20.set_select(makecol(0, 160, 0));
   new_colors20.set_deselect(makecol(230, 230, 230));
   new_colors20.set_fore(makecol(135, 0, 0));
   object_20.color = &new_colors20;
//........................
   color_scheme new_colors21;
   new_colors21.set_back(makecol(170, 170, 170));
   new_colors21.set_dark_shad(1);
   new_colors21.set_light_shad(1);
   object_21.color = &new_colors21;
//........................
   color_scheme new_colors3;
   new_colors3.set_back(makecol(180, 0, 0));
   new_colors3.set_select(makecol(0, 180, 0));
   new_colors3.set_deselect(makecol(200, 200, 200));
   new_colors3.set_fore(makecol(0, 0, 0));
   new_colors3.set_dark_shad(makecol(0, 0, 0));
   new_colors3.set_light_shad(makecol(155, 155, 155));
   mx_list.color = &new_colors3;

// Access Cfg File for CFM Data
   PACKFILE *pack_file_ptr;
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen("MXCFG.CFG", F_READ);
   if (!pack_file_ptr)
   {
     ER_FLAG = 10;
     Err_Handler(ER_FLAG);
   }

// File read operation
   if (pack_file_ptr != NULL)
   {
      if (!pack_fread(cfm_buf, 200, pack_file_ptr))
      {
        ER_FLAG = 10;
        Err_Handler(ER_FLAG);
      }
   }
   
   strcpy(SET_CFM, cfm_buf + 0);
   if(strcmp(SET_CFM, "ON ") != 0)
   {
     if(strcmp(SET_CFM, "OFF") != 0)
     {
       strcpy( SET_CFM, "ON ");
     }
   }
   
   if(pack_file_ptr)
   {
      pack_fclose(pack_file_ptr);
   }
//........................
   sprintf(set_stat1, "Active Operational File = %s", ActiveOpFileName);
   sprintf(set_stat2, "Set Confirmation = %s", SET_CFM);
  
   textout((BITMAP*)datafile[mxstatus].dat, font, set_stat1, 20, 5, makecol(240, 240, 240));
   textout((BITMAP*)datafile[mxstatus].dat, font, set_stat2, 290, 5, makecol(240, 240, 240));
  
// Callback Function Declearations
   object_11.set_key_callback(acc_edit);
   object_11.set_click_callback(acc_edit);

   object_12.set_key_callback(set_cfm);
   object_12.set_click_callback(set_cfm);

   object_13.set_key_callback(mx_prompt);
   object_13.set_click_callback(mx_prompt);

   object_18.set_key_callback(mx_info);
   object_18.set_click_callback(mx_info);

   object_19.set_key_callback(change_op_file);
   object_19.set_click_callback(change_op_file);

   object_20.set_key_callback(prg_close);
   object_20.set_click_callback(prg_close);

   mx_list.set_key_callback(select_prg_exit);
   mx_list.set_dclick_callback(select_prg_exit);

// Micro-x Main Dialog Start Up
   mx_restrt:
   mx_acc_dialog.execute();
   
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
   main_exit = 0;
   prg_close();
   
   while(key[KEY_ENTER]){};
   while(key[KEY_ESC]){};
   clear_keybuf();
   
   if(main_exit == 1)
   {
     main_exit = 0;
     goto mx_restrt;
   }
   return;
 }
//
//----------------------------------------------------------------
// [ Error Message Handler Function For Micro-x Accessor System ]
//----------------------------------------------------------------
void Err_Handler(int ER_FLAG)
{
    int presskey = 0;

    if(ER_FLAG == 1)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Micro-x Accessor Systm Ver. 1.5.5. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("Chain Link Program  !! Error !! In Micro-x Accessor System ...\n\r");
        cprintf("Only Use Mxloder.exe To Run This Program ...\n\r\n\r");
        cprintf("Read the Micro-x documentation files for more detailed information ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        return;
    }
//........
    if(ER_FLAG == 2)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Micro-x Accessor Systm Ver. 1.5.5. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("File Write  !! Error !! ... In Micro-x Accessor System.\n\r");
        cprintf("Cannot Write To MX155LCH.CFG ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
    }
//........
    if(ER_FLAG == 3)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Micro-x Accessor Systm Ver. 1.5.5. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("Program Link ID  !! Error !! ... In Micro-x Accessor System.\n\r");
        cprintf("Only Use Mxloder.exe To Run This Program ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
    }
//........
    if(ER_FLAG == 4)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Micro-x Accessor Systm Ver. 1.5.5. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("Program Load  !! Error !! ... In Micro-x Accessor System.\n\r");
        cprintf("Cannot Load The Micro-x Internal Data File ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        return;
    }
//........
    if(ER_FLAG == 5)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Micro-x Accessor Systm Ver. 1.5.5. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("Display Adapter Access  !! Error !! ... In Micro-x Accessor System.\n\r");
        cprintf("Cannot Setup Display Adapter  ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
    }
//........
    if(ER_FLAG == 6)
    {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       font = (FONT*)datafile[nce_22b].dat;
       degui_fore_color = makecol(0, 0, 0);
       degui_back_color = makecol(160,160, 160);
       degui_select_color = makecol(0, 180, 0);
       degui_deselect_color = makecol(190, 190, 190);
       degui_light_shad_color = makecol(255, 0, 0);
       degui_dark_shad_color = makecol(255, 0, 0);
       degui_alert("Micro-x  File  Buffer   !!  E R R O R  !!",
       "Not Enough Memory To Open Configuration File.",
       "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)datafile[nce_15b].dat;
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
      return;
    }
//........
    if(ER_FLAG == 7)
    {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       font = (FONT*)datafile[nce_22b].dat;
       degui_fore_color = makecol(0, 0, 0);
       degui_back_color = makecol(160,160, 160);
       degui_select_color = makecol(0, 180, 0);
       degui_deselect_color = makecol(190, 190, 190);
       degui_light_shad_color = makecol(255, 0, 0);
       degui_dark_shad_color = makecol(255, 0, 0);
       degui_alert("Micro-x  File  Opening   !!  E R R O R  !!",
       "An Operational File Fail To Open ...",
       "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)datafile[nce_15b].dat;
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       return;
    }
//........
    if(ER_FLAG == 8)
    {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       font = (FONT*)datafile[nce_22b].dat;
       degui_fore_color = makecol(0, 0, 0);
       degui_back_color = makecol(160,160, 160);
       degui_select_color = makecol(0, 180, 0);
       degui_deselect_color = makecol(190, 190, 190);
       degui_light_shad_color = makecol(255, 0, 0);
       degui_dark_shad_color = makecol(255, 0, 0);
       degui_alert("Micro-x  File  Read   !!  E R R O R  !!",
       "Cannot Read From Operational File ...",
       "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)datafile[nce_15b].dat;
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       return;
    }
//........
    if(ER_FLAG == 9)
    {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       font = (FONT*)datafile[nce_22b].dat;
       degui_fore_color = makecol(0, 0, 0);
       degui_back_color = makecol(160,160, 160);
       degui_select_color = makecol(0, 180, 0);
       degui_deselect_color = makecol(190, 190, 190);
       degui_light_shad_color = makecol(255, 0, 0);
       degui_dark_shad_color = makecol(255, 0, 0);
       degui_alert("Micro-x  File  Access   !!  E R R O R  !!",
       "Cannot Read Or Write To The File Mx155lch.cfg ...",
       "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)datafile[nce_15b].dat;
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       return;
    }
//........
    if(ER_FLAG == 10)
    {
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       font = (FONT*)datafile[nce_22b].dat;
       degui_fore_color = makecol(0, 0, 0);
       degui_back_color = makecol(160,160, 160);
       degui_select_color = makecol(0, 180, 0);
       degui_deselect_color = makecol(190, 190, 190);
       degui_light_shad_color = makecol(255, 0, 0);
       degui_dark_shad_color = makecol(255, 0, 0);
       degui_alert("Micro-x  File  Access   !!  E R R O R  !!",
       "Cannot Read Or Write To The File MxCfg.cfg ...",
       "Ckeck Your Micro-x Files, and System Set Up.", "  OK  ", NULL, 0, 0);
       set_default_object_colors(0,235,236,237,238,239,240,241);
       font = (FONT*)datafile[nce_15b].dat;
       while(key[KEY_ENTER]){};
       while(key[KEY_ESC]){};
       clear_keybuf();
       return;
    }
   return;
}
//
//-------------------------
// [ Close Down Function ]
//-------------------------
int close_exit(int exit_flag)
{
    extern char ActiveOpFileId[11];
    extern DATAFILE *datafile;
    char *pth_buf_exit = (char*) alloca(200);

// Keyboard active check
    while(key[KEY_ENTER]){};
    while(key[KEY_ESC]){};
    clear_keybuf();
    
    strcpy((pth_buf_exit + 0), "MAINEXIT60795XMX155ACC");
    strcpy((pth_buf_exit + 180), ActiveOpFileId);
    PACKFILE *pack_file_ptr;
    pack_file_ptr = NULL;
    pack_file_ptr = pack_fopen("MX155LCH.CFG", F_WRITE_NOPACK);
    if ( !pack_file_ptr)
    {
      ER_FLAG = 9;
      Err_Handler(ER_FLAG);
      font = (FONT*)original_font;
      unload_datafile(datafile);
      allegro_exit();
      exit_flag = 9;
      exit(exit_flag);
    }
// File write operation
    if (!pack_fwrite(pth_buf_exit, 200, pack_file_ptr))
    {
     pack_fclose(pack_file_ptr);
     ER_FLAG = 9;
     Err_Handler(ER_FLAG);
     font = (FONT*)original_font;
     unload_datafile(datafile);
     allegro_exit();
     exit_flag = 9;
     exit(exit_flag);
    }
   pack_fclose(pack_file_ptr);
   font = (FONT*)original_font;
   unload_datafile(datafile);
   allegro_exit();
   exit(exit_flag);
}
//
// **************************************************
// --------------------------------------------------
// [ Start Of Micro-x Accessor System Main Program ]
// --------------------------------------------------
// **************************************************
int main(int argc, char **argv)
{
   int a, y, x, t;
   int cnt = 0;
   int h_ln = 0;
   FILE *fp;
   int press_key = 0;
   int help_flag = 0;
   char Itm_1s[] = "#L";
   char Itm_2s[] = "#P";
   char phy_mem[128];
   char vir_mem[128];
   char buf1[11];
   extern char *cmd_pmt;
   extern char *buf;
   extern char c;
   extern char ActiveOpFileName[8];
   extern char ActiveOpFileId[11];
   extern char OpFileLoad[16];
   extern char *ar_ptr[56];
   extern int ER_FLAG;
   extern int main_exit;
   extern int default_fore;
   extern int default_back;
   extern int default_select;
   extern int default_deselect;
   extern int default_light_shad;
   extern int default_dark_shad;
   extern int exit_flag;
   extern char **environ;
   extern DATAFILE *datafile;
   extern FONT *original_font;
   PACKFILE *pack_file_ptr;
//............................
   _fmode = O_BINARY;
   fflush(stdout);
   fflush(stdin);
   
   if (strlen(argv[1]) > 10)
   {
     ER_FLAG = 1;
     Err_Handler(ER_FLAG);
     exit_flag = 1;
     exit(exit_flag);
   }
   if (strlen(argv[1]) == NULL)
   {
     ER_FLAG = 1;
     Err_Handler(ER_FLAG);
     exit_flag = 1;
     exit(exit_flag);
   }
  if ((argc >= 3) || (argc == 0))
  {
     ER_FLAG = 1;
     Err_Handler(ER_FLAG);
     exit_flag = 1;
     exit(exit_flag);
   }
   fp = fopen("accs.tmp", "w");
   fprintf(fp, "%s", argv[1]);
   fclose(fp);
   fp = fopen("accs.tmp", "r");
   fscanf(fp, "%s", buf1);
   fclose(fp);
   remove("accs.tmp");
   
//----------------------------
// Test And Set Chain Link Id
//----------------------------
   ER_FLAG = 99;
   if(strcmp(mx_mainid, buf1) == 0)
   {
     strcpy(ActiveOpFileId, buf1);
     strcpy(ActiveOpFileName, "Main");
     strcpy(OpFileLoad, "ACCMMAIN.CFF");
     strcpy(ActiveOpFileId, mx_mainid);
     ER_FLAG = 0;
   }

   if(strcmp(mx_lod_86id, buf1) == 0)
   {
     strcpy(ActiveOpFileId, buf1);
     strcpy(ActiveOpFileName, "Sub #1");
     strcpy(OpFileLoad, "ACCMSUB1.CFF");
     strcpy(ActiveOpFileId, mx_lod_86id);
     ER_FLAG = 0;
   }

   if(strcmp(mx_lod_87id, buf1) == 0)
   {
     strcpy(ActiveOpFileId, buf1);
     strcpy(ActiveOpFileName, "Sub #2");
     strcpy(OpFileLoad, "ACCMSUB2.CFF");
     strcpy(ActiveOpFileId, mx_lod_87id);
     ER_FLAG = 0;
   }

   if(strcmp(mx_lod_88id, buf1) == 0)
   {
     strcpy(ActiveOpFileId, buf1);
     strcpy(ActiveOpFileName, "Sub #3");
     strcpy(OpFileLoad, "ACCMSUB3.CFF");
     strcpy(ActiveOpFileId, mx_lod_88id);
     ER_FLAG = 0;
   }

   if(ER_FLAG == 99)
   {
     ER_FLAG = 3;
     Err_Handler(ER_FLAG);
     exit_flag = 3;
     exit(exit_flag);
   }

// Get the system's command interpreter stored
  cmd_pmt = getenv("COMSPEC");

// ...........................................
// [ Main Program's Graphics INIT & Startup ]
// ...........................................
//...(Special Notice) No Dos File operations can be used beyond this point.
//...No standard lib C library calls can be made...
//...Use Allegro and Degui Functions only......

//...Allegro and Degui init and startup............   
//...Replace file operations with the Allegro ones only........
   set_config_file("mxsys.cfg");
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();
   gui_mouse_focus = FALSE;

// Load the datafile
   datafile = load_datafile("#");
   if (!datafile)
   {
      ER_FLAG = 4;
      Err_Handler(ER_FLAG);
      exit_flag = 4;
      close_exit(exit_flag);
   }

//...............................................................
// [ Set Up The Graphics Mode And Save Basic Object Colors ]
//...............................................................   
   
   set_color_depth(8);
   if(set_gfx_mode(GFX_VESA1,640,480,0,0) < 0)
   {
    set_color_depth(8);
    if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0) < 0)
    {
      ER_FLAG = 5;
      Err_Handler(ER_FLAG);
      exit_flag = 5;
      close_exit(exit_flag);
    }  
   }
   
// Save default colors
   default_fore = degui_fore_color;
   default_back = degui_back_color;
   default_select = degui_select_color;
   default_deselect = degui_deselect_color;
   default_light_shad = degui_light_shad_color;
   default_dark_shad = degui_dark_shad_color;
   
   set_palette(desktop_palette);
   set_default_object_colors(0,235,236,237,238,239,240,241);
   clear_screen_object  clear_obj;
   clear_to_color(screen, makecol(0, 0, 0));

// Store a copy of the default font, and reset default font
   original_font = (FONT*)font;
   font = (FONT*)datafile[nce_15b].dat;

// Setup File Buffer Memory Space
  buf = (char*) alloca(4800);
  if(!buf)
  {
    ER_FLAG = 6;
    Err_Handler(ER_FLAG);
    exit_flag = 6;
    close_exit(exit_flag);
  }

//..................................
// [ Set File Pointers To Buffer ]
//..................................
   t = 0;
   a = 0;
   x = 0;
   while (x != 28)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_1s);
      t += 1;
      x += 1;
      a = a + 38;
   }
   t = 28;
   a = 1064;
   x = 28;
   while (x != 56)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_2s);
      t += 1;
      x += 1;
      a = a + 128;
   }

// File Opening Operation for active op-file
   pack_file_ptr = NULL;
   pack_file_ptr = pack_fopen(OpFileLoad, F_READ_PACKED);
   if (!pack_file_ptr)
   {
     ER_FLAG = 7;
     Err_Handler(ER_FLAG);
     exit_flag = 7;
     close_exit(exit_flag);
   }

// File Read Operation for active file
   if (!pack_fread(buf, 4800, pack_file_ptr))
   {
    ER_FLAG = 8;
    Err_Handler(ER_FLAG);
    exit_flag = 8;
    close_exit(exit_flag);
   }
   pack_fclose(pack_file_ptr);

// Set Buffer Code For Reading
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }

// Setup screen main dialog wall background.
   show_mouse(NULL);
   rect(screen, 2, 2, 639, 479, makecol(255, 0, 0));
   rect(screen, 3, 3, 638, 478, makecol(255, 0, 0));
   rect(screen, 6, 6, 634, 474, makecol(0, 0, 140));
   rect(screen, 7, 7, 633, 473, makecol(0, 0, 140));
   rectfill(screen, 11, 11, 629, 469, makecol(140, 140, 140));
   cnt = 1;
   h_ln = 632;
   x = 8;
   y = 8;
   while(cnt != 29)
   {
     hline(screen, x, y, h_ln, makecol(0, 0, 140));
     ++y;
     hline(screen, x, y, h_ln, makecol(0, 0, 140));
     --y;
//..........
     y = y + 16;
     hline(screen, x, y, h_ln, 0);
     ++y;
     hline(screen, x, y, h_ln, 0);
     --y;
     y = y + 16;
     ++cnt;
   }
   hline(screen, x, y, h_ln, 0);
   ++y;
   hline(screen, x, y, h_ln, 0);
//..............   
   text_mode(-1);
   font = (FONT*)datafile[nce_15b].dat;
   textout(screen, font, "S E L E C T I O N S", 253, 138, makecol(1, 220, 220));
   textout(screen, font, "S T A T U S", 275, 400, makecol(220, 220, 1));
   show_mouse(screen);
   
   text_mode(makecol(220, 220, 220));
   sprintf(phy_mem, "  Total Amount Of Available Physical Memory = %U bytes  ",_go32_dpmi_remaining_physical_memory());
   sprintf(vir_mem, "  Total Amount Of Available Virtual Memory = %U bytes  ",_go32_dpmi_remaining_virtual_memory());
   textout(screen, font, phy_mem, (640 / 2 - (strlen(phy_mem)/2*7)), 1, makecol(0, 0, 0));
   textout(screen, font, vir_mem, (640 / 2 - (strlen(vir_mem)/2*7)), 466, makecol(0, 0, 0));
   text_mode(-1);

   setup_dialog_objects();
   exit_flag = 0;
   close_exit(exit_flag);
   return(0);
}
//
// *******************************************************
// *******************************************************
// -------------------------------------------------------
// [ End Of Program For MX155.CC Micro-x Accessor System ]
// -------------------------------------------------------
// *******************************************************
// *******************************************************
