#include "stdafx.h"
#include "fork.h"
#include "extern.h"
HANDLE ForkChildProcess(char *cmd, PHANDLE inH, PHANDLE outH, PHANDLE errH,
						BOOL gcc) 
{
	SECURITY_ATTRIBUTES lsa;
	STARTUPINFO si;
	PROCESS_INFORMATION pi; 
	HANDLE ChildIn;
	HANDLE ChildOut;
	HANDLE ChildErr;
	lsa.nLength = sizeof(SECURITY_ATTRIBUTES);
	lsa.lpSecurityDescriptor = NULL;
	lsa.bInheritHandle = TRUE;
	CreatePipe(&ChildIn, inH, &lsa, 0);
	CreatePipe(outH, &ChildOut, &lsa, 0);
	CreatePipe(errH, &ChildErr, &lsa, 0);
	si.cb=sizeof(STARTUPINFO);
	si.lpReserved = NULL;
	si.lpTitle = NULL;
	si.lpDesktop = NULL;
	si.dwX = si.dwY = si.dwYSize = si.dwXSize = 0;
	si.dwFlags = STARTF_USESTDHANDLES |  STARTF_USESHOWWINDOW;
	si.hStdInput = ChildIn;
	si.hStdOutput= ChildOut;
	si.hStdError = ChildErr;
	si.wShowWindow = SW_HIDE;
	si.lpReserved2 = NULL;
	si.cbReserved2 = 0;
	if (gcc)
		CreateProcess(gccpath.GetBuffer(500), cmd, NULL, NULL, TRUE,
			NORMAL_PRIORITY_CLASS, NULL,
			NULL, &si, &pi);
	else
	{
		CreateProcess(makepath.GetBuffer(500), NULL, NULL, NULL, TRUE,
			NORMAL_PRIORITY_CLASS, NULL,
			NULL, &si, &pi);
	}
	CloseHandle(ChildIn);
	CloseHandle(ChildOut);
	CloseHandle(ChildErr);
	return(pi.hProcess);
}
