#include <grx.h>

#define PIXW	3
#define PIXH	4

#define BLUE	1
#define GREEN	32
#define RED	1024

#define LEVELS  32

#define ROWS	4
#define COLS	8

#define BOXW	(LEVELS*PIXW)
#define BOXH	(LEVELS*PIXH)

#define GAPX	((800 - BOXW*COLS) / COLS)
#define GAPY	((600 - BOXH*ROWS) / ROWS)


void drawbox(int x,int y,int base)
{
	int xx,ii,jj;

	for(ii = 0; ii < LEVELS; ii++,y += PIXH) {
	    for(jj = 0,xx = x; jj < LEVELS; jj++,xx += PIXW) {
		GrFilledBox(xx,y,xx+PIXW-1,y+PIXH-1,base+ii*GREEN+jj*BLUE);
	    }
	}
}

void drawrow(int x,int y,int base)
{
	int ii;

	for(ii = 0; ii < COLS; ii++,x += (BOXW+GAPX)) {
	    drawbox(x,y,base+RED*ii);
	}
}

void main(void)
{
	int x,y,ii;

	GrSetMode(GR_width_height_color_graphics,800,600,32768);
	if((GrNumColors() == 32768) && (GrSizeX() == 800) && (GrSizeY() == 600)) {
	    x = GAPX / 2;
	    y = GAPY / 2;
	    for(ii = 0; ii < ROWS; ii++) {
		drawrow(x,y,ii*RED*COLS);
		y += (BOXH + GAPY);
	    }
	    getkey();
	}
	GrClearScreen(GrBlack());
	if((GrNumColors() == 32768) && (GrSizeX() == 800) && (GrSizeY() == 600)) {
	    x = GAPX / 2;
	    y = GAPY / 2;
	    for(ii = 0; ii < ROWS; ii++) {
		drawrow(x,y,ii*RED*COLS);
		y += (BOXH + GAPY);
	    }
	    getkey();
	}
	GrSetMode(GR_default_text);
	exit(0);
}

